<?php 
    $IdUsuario = $this->session->UID;
?>
    <?php if($this->session->flashdata('message_index')){?>
        <div class="alert alert-<?php echo $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            <?php echo $this->session->flashdata('message_index') ?>
        </div>
    <?php } ?>

    <div class="row">
        <input type="hidden" name="Userloged" id="Userloged" value="<?= $IdUsuario ?>" >
        <div class="col-md-8 col-sm-8 col-xs-12">
            <h2><?= $title ?></h2>
        </div>

        <?php if($Nuevas > 0){ ?>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <h4 style="color:red"> Tienes <?= $Nuevas ?> requisicion(es) nuevas para procesar</h4>
            </div>
        <?php } ?>
  
    </div>
    <div class="row">
        <?= form_open('/Seguimientoalmoo/Index/') ?>
        <input type="hidden" name="Page" id="Page" value="<?= $ActualPage ?>" >
        <div class="col-md-2 col-sm-6 col-xs-12">
            <input type="text" id="Folio" name="Folio" class="form-control" placeholder="Folio" value="<?= set_value("Folio") ?>" />
        </div>
            <div class="col-md-2 col-sm-4 col-xs-12">
            <input type="submit" id="btnFilter" class="btn btn-default" style="width:100%" value="Filtrar" />
        </div>
        <div class="col-md-2 col-sm-6 col-xs-12">
            <a href="<?= base_url() ?>Seguimientoalmoo/Index/" class="btn btn-info" style="width:100%">Limpiar</a>
        </div>        
        <?= form_close() ?>
    </div>
    <div class="row" style="margin-top:15px;">
        <div class="table-responsive">
        <table id="tblUsers" class="table table-hover">
        <thead class="thead-style">
        <tr>
            <th>Folio</th>
            <th>Tipo</th>
            <th>Productos</th>
            <th>Almacen</th>
            <th>Feha alm.</th>
            <th></th>
            <th></th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        <?php
            foreach($CabezaRequisiciones as $Movimiento){
                if($Movimiento->tipo == 0){
                    $Producto = "LLANTAS";
                }else{
                    $Producto = "VARIOS";
                }

                $colortipo = "color: #000";
                if($Movimiento->ofnaapoyo == "00" && $Movimiento->status != 9){
                    $colortipo = "color: red";   
                }
        ?>
        <tr>
            <td style="<?= $colortipo ?>"><?= $Movimiento->numero ?></td>
            <td style="<?= $colortipo ?>"><?= $Movimiento->tipo_req ?></td>
            <td style="<?= $colortipo ?>"><?= $Producto ?></td>
            <td style="<?= $colortipo ?>"><?= $Movimiento->almacen ?></td>
            <td style="<?= $colortipo ?>">
                <?php if($Movimiento->fecha_sr2 =='1753-01-01'){ ?>
                   <a class="text-danger"> Sin procesar </a>
                <?php } else {
                    echo $Movimiento->fecha_sr2; 
                }?>
            </td>
            <td>
                <?php if($Movimiento->status ==9){ ?>
                   <a class="text-danger"> Cancelada </a>
                <?php } else {if(VerificarPermisos($IdUsuario, "SeguimientoAlmoo", "Edit" )){ ?>
                    <!-- <a href="<?= base_url() ?>Seguimientoalmoo/Edit/<?= $Movimiento->numero ?>" style="<?= $colortipo ?>">Procesar</a> -->
                    <a href="#" class="editar-documento" folio="<?= $Movimiento->numero ?>" actualpage="<?= $ActualPage ?>" style="<?= $colortipo ?>">Procesar</a>
                    <?php } 
                }?>
            </td>
            <td><a href="#" class="descargar-documento" folio="<?= $Movimiento->numero ?>" style="color: #000">Descargar</a></td>
            <td>
                <?php if(VerificarPermisos($IdUsuario, "SeguimientoAlmoo", "Details")){ ?>
                <a href="<?= base_url() ?>Seguimientoalmoo/Details/<?= $Movimiento->numero.'/'.$ActualPage ?>"  style="<?= $colortipo ?>">Consultar</a>
                <?php } ?>
            </td>  
        </tr>
        <?php } ?>
        </tbody>
    </table>
    <div class="col-md-12 text-center">
    <?php

        $BatchPage = ceil($ActualPage/25);
        $LastPage = $BatchPage*25;
        if($LastPage > $Pages){
            $LastPage = $Pages;
        }

        if($LastPage < 25){
            $InitialPage = 1;
        }else{
            $InitialPage = ($LastPage-25)+1;   
        }

        // $Previous = $ActualPage - 25;
        // $Next = $ActualPage + 25;

        $Previous = $InitialPage - 25;
        $Next = $InitialPage + 25;

        $DisabledPrevious = "";
        $DisabledNext = "";
        if($Previous <= 0){
            $Previous = "";
            $DisabledPrevious = "disabled";
        }

        if($Next > $Pages){
            $Next = "";
            $DisabledNext = "disabled";
        }
    ?>
    <nav>
        <ul class="pagination pagination-sm" style="margin-bottom: 0 !Important;">

            <li>
                <a data-href="1" aria-label="Previous">
                    <span aria-hidden="true">Primero</span>
                </a>
            </li>

            <li class="<?= $DisabledPrevious ?>">
                <a data-href="<?= $Previous ?>" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span>
                </a>
            </li>
            <?php
                // for($i = 1; $i <= $Pages; $i++){
                for($i = $InitialPage; $i <= $LastPage; $i++){
                    $ActiveClass = "";
                    $cursor = "";
                    if($i == $ActualPage){
                        $ActiveClass = "class='active'";
                        $cursor = "cursor: not-allowed;";
                    }
            ?>
                    <li <?= $ActiveClass ?>><a style="<?= $cursor ?>" data-href="<?= $i ?>"><?= $i ?></a></li>
            <?php } ?>
            <li class="<?= $DisabledNext ?>">
                <a data-href="<?= $Next ?>" aria-label="Next">
                    <span aria-hidden="true">&raquo;</span>
                </a>
            </li>

            <li>
                <a data-href="<?= $Pages ?>" aria-label="Previous">
                    <span aria-hidden="true">Ultimo</span>
                </a>
            </li>

        </ul>
        
        <?php
        if($Pages > 0 ){  
        ?>              
            <div class="row">
                <span class="text-muted" style="text-align: center;margin-top: -2 !Important; font-size: 12px">
                   Mostrando pagina <?= $ActualPage ?> de <?= $Pages ?>
                </span>
            </div>
        <?php } ?>

    </nav>
    </div>
</div>
<input type="hidden" id="url" value="<?php echo base_url() ?>">
</div>

<?= form_open_multipart('/Seguimientoalmoo/GenerarPdf', array("id" => "frmGenerarPdf")) ?>
    <input type="hidden" name="FolioRecibo" id="FolioRecibo" >
<?= form_close() ?>

<?= form_open_multipart('/Seguimientoalmoo/Edit', array("id" => "frmEditar")) ?>
    <input type="hidden" name="EditarFolio" id="EditarFolio" >
    <input type="hidden" name="ActualPage" id="ActualPage" >
<?= form_close() ?>

<div class="modal fade" id="iDescargarRecibo" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #484545;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" style="color:#fff;">Descargar documento</h4>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="btnDescargarRecibo">Descargar</button>
      </div>
    </div>
  </div>
</div>

<script>
    $(function()
    {
        $(".descargar-documento").click(function()
        {
            event.preventDefault();
            $("#FolioRecibo").val($(this).attr("folio"));
            $("#iDescargarRecibo").modal("show");
        })

        $("#btnDescargarRecibo").click(function()
        {
            $("#ObservacionesRecibo").val($("#iObservaciones").val());
            $("#frmGenerarPdf").submit();
            $("#iDescargarRecibo").modal("hide");
            bootbox.alert("El documento se descargara en un momento.");
        })

        $(".editar-documento").click(function()
        {
            event.preventDefault();

            // Validamos que el folio no se encuentre bloqueado por otro usuario
            var vFolio = $(this).attr("folio");
            var vActualpage = $(this).attr("actualpage");
            var vUserloged = $("#Userloged").val();
            $("p.loader-gif").text("Verificando bloqueo...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Requisiciones/VerificaBloqueo/',
                dataType: "json",
                data: {
                    FolioRequi: $(this).attr("folio")
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data != null && data.usuarioblq.trim() != "" && data.usuarioblq.trim() != vUserloged)
                    {
                        bootbox.alert({
                            message: "Esta requisicion se encuentra bloqueada por el usuario: " + data.usuarioblq.trim(),
                            callback: function () {
                                setTimeout(function()
                                {
                                    //$(vElement).val("").focus();
                                    //$("#lstDescripcion" + vRow).val("");
                                },100)
                            }
                        })
                    }

                    //Si no tiene bloqueo o el bloqueo es por el mismo usuario
                    if(data != null && (data.usuarioblq.trim() == "" || data.usuarioblq.trim() == vUserloged))
                    {
                        $("#EditarFolio").val(vFolio);
                        $("#ActualPage").val(vActualpage);
                        $("#frmEditar").submit();
                    }
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        })

        $('#Folio').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Requisiciones/AutocompleteFolio/',
                    dataType: "json",
                    data: {
                        term: $("#Folio").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                return false;
            }
        });

    })
</script>


<!-- Este codigo sirve para hacer que el pdf se genere automaticamente despues de haber guardado un folio nuevo
<?php
    if($this->session->flashdata('Folio'))
    {
        $Folio = $this->session->flashdata('Folio');
?>
        <script>
            $("#FolioRecibo").val("<?= $Folio ?>");
            $("#frmGenerarPdfRecibo").submit();
            bootbox.alert("El documento se descargara en un momento.");
        </script>
<?php
    }
?> -->