<?php if($this->session->flashdata('message_edit')){?>
    <div class="alert alert-<?= $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
        <?= $this->session->flashdata('message_create') ?>
    </div>
<?php } ?>
<?= form_open_multipart('/Requisiciones/EditPost', array("id" => "frmEdit")) ?>
<?php
    $FechaHoraOriginal = $Cabeza[0]->fecha_ini;
    $Horaini = substr($FechaHoraOriginal,11,8);
    $FormatoFechaini = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

    if($Cabeza[0]->fecha_compromiso == "0000-00-00")
    {
        $FechaHoraOriginal = $Cabeza[0]->fecha_ini;
    }else{
        $FechaHoraOriginal = $Cabeza[0]->fecha_compromiso;
    }
    $Hora = substr($FechaHoraOriginal,11,8);
    $FormatoFechacompromiso = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

    $Cabeza[0]->tipo_req = set_value("TipoReq") != "" ? set_value("TipoReq") : $Cabeza[0]->tipo_req;
    $Cabeza[0]->observa  = set_value("Observaciones") != "" ? set_value("Observaciones") : $Cabeza[0]->observa;

    if($this->session->Level == 2 || $this->session->Level == 5){
            $Almacenro = "";
    }else{
            $Almacenro = "readonly";
    }

?>

<div class="panel panel-uni">
  <div class="panel-heading">
    <h3 class="panel-title"><?= $title ?></h3>
  </div>

  <div class="panel-body">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12" style="margin-bottom:20px;font-weight:bolder;">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="label-display-name">Requisicion:</label> 
                <label><?= $Cabeza[0]->numero ?></label>
                <input type="hidden" name="hdNumero" id="hdNumero" value="<?= $Cabeza[0]->numero ?>">
                <input type="hidden" name="hdActualPage" id="hdActualPage" value="<?= $actualpage ?>">
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="label-display-name">Fecha/Hora:</label> 
                <label><?= $FormatoFechaini." ".$Horaini ?></label>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="label-display-name">Solicitante:</label> 
                <label><?= $Cabeza[0]->usuario." - ".$Solicitante ?></label>
            </div>        
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 col-sm-3 col-xs-12" style="margin-top: 10px;">
            <input type="hidden" name="TipoReq" id="TipoReq" value="<?= $Cabeza[0]->tipo_req ?>" class="tipo-req">
            <label class="control-label">Tipo de requisicion:</label>
            <?php
                if($Cabeza[0]->tipo_req == "REPOSICION")
                {
                    $Tiporepo = "selected";
                    $Tipovta = "";
                }else{
                    $Tipovta = "selected";
                    $Tiporepo = "";
                }
            ?>
            <select class="form-control" id="slcTipoReq">
                <option value="REPOSICION" <?= $Tiporepo ?> >REPOSICION</option>
                <option value="VENTA" <?= $Tipovta ?> >VENTA</option>
            </select>
        </div>

        <div class="col-md-3 col-sm-3 col-xs-12" style="margin-top: 10px;">
            <input type="hidden" name="TipoPdto" id="TipoPdto" value="<?= $Cabeza[0]->tipo ?>" class="tipo-pdto">
            <label class="control-label">Tipo de producto:</label>
            <?php
                if($Cabeza[0]->tipo == 0)
                {
            ?>
                <select readonly class="form-control" id="slcTipoPdto">
                    <option value="0" selected >LLANTAS</option>
                </select>
            <?php
                }else{
            ?>
                <select readonly class="form-control" id="slcTipoPdto">
                    <option value="1" selected >VARIOS</option>
                </select>
             <?php
                }
            ?>
        </div>

        <div class="col-md-6 col-sm-6 col-xs-12">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Clave almacen:</label>
                <input readonly type="text" id="Clavealmacen" value="<?= $Cabeza[0]->almacen ?>" name="Clavealmacen" max-length="5" class="form-control required-field" placeholder="Clave">
                <input type="hidden" id="hdClavealmacen">
                <input type="hidden" value="<?= $Oficina1 ?>" name="Claveoficina" id="Claveoficina">
                <input type="hidden" value="<?= $Oficina2 ?>" name="Claveoficina2" id="Claveoficina2">
            </div>
            <div class="col-md-8 col-sm-8 col-xs-12">
                <label class="control-label">Nombre almacen:</label>
                <input <?= $Almacenro ?> type="text" id="txbClavealmacen" value="<?= $Almacen ?>" onKeyUp="this.value=this.value.toUpperCase();" name="Nombrealmacen" placeholder="" class="form-control" placeholder="Nombre">
                <input type="hidden" id="hdNombrealmacen">
            </div>
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
    </div>

    <?php
        if($Cabeza[0]->tipo_req == "REPOSICION")
        {
    ?>
        <div class="row" id="tipo_req_vr" style="display:none">
    <?php
        }else{
    ?>
         <div class="row" id="tipo_req_vr">
    <?php
        }
    ?>

        <div class="col-md-4 col-sm-4 col-xs-12">
            <label class="control-label" for="Fechaentrega">Fecha compromiso:</label>
            <input type="text" name="Fechacompromiso" id="Fechacompromiso" value="<?= $FormatoFechacompromiso ?>" placeholder="Fecha compromiso" class="form-control datetimepicker" max-length="10">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-4 col-sm-4 col-xs-12">
            <label class="control-label" for="Cotizacion">Cotizacion:</label>
            <input type="text" name="Cotizacion" id="Cotizacion" value="<?= $Cabeza[0]->cotizacion ?>" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Cotizacion" class="form-control" max-length="100">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-4 col-sm-4 col-xs-12">
            <label class="control-label" for="Ocpedido">OC/Pedido cliente:</label>
            <input type="text" name="Ocpedido" id="Ocpedido" value="<?= $Cabeza[0]->oc_pedidocliente ?>" onKeyUp="this.value=this.value.toUpperCase();" placeholder="OC/Pedido" class="form-control" max-length="100">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

    </div>   

    <div class="row">
        <h4>   Enviar a:</h4>
        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label" for="Tonombre">Nombre:</label>
            <input type="text" name="Tonombre" id="Tonombre" value="<?= $Cabeza[0]->to_nombre ?>" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Nombre" class="form-control required-field" max-length="200">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label" for="Togerente">Supervisor:</label>
            <input type="text" name="Togerente" id="Togerente" value="<?= $Cabeza[0]->gerente ?>" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Supervisor" class="form-control required-field" max-length="30">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-sm-6 col-xs-12">           
                <div class="col-md-4 col-sm-4 col-xs-12">
                    <label class="control-label">Clave cliente:</label>
                    <input readonly type="text" id="Clavecliente" value="<?= $Cabeza[0]->clave_cliente ?>" name="Clavecliente" max-length="6" class="form-control required-field fill" placeholder="Clave">
                    <input type="hidden" id="hdClavecliente">
                </div>
                <div class="col-md-8 col-sm-8 col-xs-12">
                    <label class="control-label">Nombre cliente:</label>
                    <input type="text" id="txbClavecliente" value="<?= $Cabeza[0]->to_empresa ?>" name="Nombrecliente" onKeyUp="this.value=this.value.toUpperCase();" placeholder="" class="form-control" placeholder="Nombre">
                    <input type="hidden" id="hdNombrecliente">
                </div>
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-6 col-sm-6 col-xs-12">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Clave proyecto:</label>
                <input readonly type="text" id="Claveproyecto" value="<?= $Cabeza[0]->clave_proyecto ?>" name="Claveproyecto" max-length="6" class="form-control required-field" placeholder="Clave">
                <input type="hidden" id="hdClaveproyecto">
            </div>
            <div class="col-md-8 col-sm-8 col-xs-12">
                <label class="control-label">Nombre proyecto:</label>
                <input type="text" id="txbClaveproyecto" value="<?= $Cabeza[0]->depto ?>" name="Nombreproyecto" onKeyUp="this.value=this.value.toUpperCase();" placeholder="" class="form-control" placeholder="Nombre">
                <input type="hidden" id="hdNombreproyecto">
            </div>
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label" for="Tonombregerente">Gerente:</label>
            <input type="hidden" name="Usuariogerente" id="Usuariogerente" value="<?= $Cabeza[0]->gerente_proy ?>">
            <input type="hidden" name="Emailgerente" id="Emailgerente">
            <input readonly type="text" name="Nombregerente" id="Nombregerente" value="<?= $Gerenteproy ?>" placeholder="Gerente" class="form-control">
        </div>
        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label" for="Todireccion">Direccion:</label>
            <input type="text" name="Direccion" id="Direccion" value="<?= $Cabeza[0]->to_direcc ?>" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Direccion" class="form-control required-field" max-length="100">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 col-sm-3 col-xs-6">
            <label class="control-label" for="Totelefono">Telefono:</label>
            <input type="text" name="Totelefono" id="Totelefono" value="<?= $Cabeza[0]->to_tel ?>" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Telefono" class="form-control required-field" max-length="15">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
        <div class="col-md-3 col-sm-3 col-xs-6">
            <label class="control-label" for="Togerente">Paqueteria sugerida:</label>
            <input type="text" name="Topaquete" id="Topaquete" value="<?= $Cabeza[0]->to_paquete ?>" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Paqueteria" class="form-control required-field" max-length="30">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
        <div class="col-md-4 col-sm-6 col-xs-12">
              <div class="form-check">
                <input type="checkbox" class="form-check-input" id="chkModifyfile">
                <input type="hidden" name="Adjuntosmodificados" class="adjuntosmodificados">
                <label class="form-check-label" for="chkModifyfile">Cambiar adjuntos</label>
                <label class="control-label">(se eliminaran los anteriores)</label>
              </div>            
            <label class="control-label" for="Archivo">Archivos adjuntos (maximo 10Mb):</label>
            <input type="hidden" name="adjunto[]" id="adjunto[]" class="adjuntos" multiple>
        </div>

    </div>

    <div class="row" style="margin-top:20px;">
        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label text-danger">F2 en Clave o Clave Eq para buscar articulos</label>
        </div>

        <div class="col-md-12 col-sm-12 col-xs-12" style="max-height: 400px;overflow-x: hidden;">
            <table class="table table-bordered table-condensed" id="tDetalle">
                <thead>
                    <tr>
                        <th width="5%">No.</th>
                        <th width="15%">Clave</th>
                        <th width="15%">Clave equivalente</th>
                        <th>Descripcion</th>
                        <th width="15%">Marca</th>
                        <th width="5%">Cantidad</th>
                        <th class="text-center"><span id="sAddRow" class="glyphicon glyphicon-plus" style="font-size:19px;color:#43ac6a;"></span></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $Index = 0;
                        $TotalArticulos = 0;
                        foreach($Detalles as $Detalle){
                            $doscar = substr($Detalle->articulo,0,2);
                            $trescar = substr($Detalle->articulo,0,3);
                            if($doscar =='ZZ' || $trescar =='800')
                            {
                                $partidaro = '';
                            }else{
                                $partidaro = 'readonly';
                            }
                    ?>
                        <tr id="tr<?= $Index ?>" row="<?= $Index ?>" class="active">
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Partida]" class="form-control input-sm" value="<?= $Detalle->partida ?>" row="<?= $Index ?>" id="lstPartida<?= $Index ?>" />
                        </td>
                        <td>
                            <input type="text" name="lstDetalle[<?= $Index ?>][Clavearticulo]" class="form-control input-sm" value="<?= $Detalle->articulo ?>" row="<?= $Index ?>" max-length="16"  placeholder="Articulo" onchange="ChecarArticulo(this)" onkeypress="ChangeToCantidad(this);" onkeyup = "Buscart(event,this)" id="lstClaveArticulo<?= $Index ?>" />
                            <input type="hidden" name="lstDetalle[<?= $Index ?>][Active]" value="true" id="lstActive<?= $Index ?>" />
                        </td>
                        <td>
                            <input type="text" name="lstDetalle[<?= $Index ?>][Clave_eq]" class="form-control input-sm" value="<?= $Detalle->articulo_eq ?>" row="<?= $Index ?>" max-length="20"  placeholder="Clave eq" onchange="ChecarArticuloEq(this)" onkeypress="" onkeyup = "Buscart(event,this)" id="lstClaveEq<?= $Index ?>" />
                        </td>
                        <td>
                            <input <?= $partidaro ?> type="text" name="lstDetalle[<?= $Index ?>][Descripcion]" class="form-control input-sm" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Descripcion" row="<?= $Index ?>" value="<?= $Detalle->descrip ?>" id="lstDescripcion<?= $Index ?>" />
                        </td>
                        <td>
                            <input type="text" name="lstDetalle[<?= $Index ?>][Marca]" class="form-control input-sm" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Marca" row="<?= $Index ?>" value="<?= $Detalle->marca ?>" id="lstMarca<?= $Index ?>" />
                        </td>
                        <td>
                            <input type="text" onchange="AddNewRow(this);" name="lstDetalle[<?= $Index ?>][Cantidad]" class="form-control numeric-field input-sm" row="<?= $Index ?>" placeholder="Cantidad" value="<?= $Detalle->cantidad ?>" id="lstCantidad<?= $Index ?>" />
                        </td>
                        <td align="center"><span onclick="EliminarDetalle(this)" row="<?= $Index ?>" class="glyphicon glyphicon-remove" style="font-size:19px;color:red;margin-top: 9px;"></span></td>
                        </tr>
                    <?php 
                            $Index++;
                            $TotalArticulos += $Detalle->cantidad;
                        } 
                    ?>
                </tbody>
            </table>
        </div>
    
    </div>

    <div class="row">

        <div class="col-md-6 col-sm-6 col-xs-12">

        </div>

        <div class="col-md-6 col-sm-6 col-xs-12">
            <div class="col-md-6 col-sm-6 col-xs-6">

            </div>            

            <div class="col-md-6 col-sm-6 col-xs-6">
                <label class="label-control">Total de articulos:</label>
                <input type="text" value="<?= $TotalArticulos ?>" id="txbTotalArticulos" readonly class="form-control" placeholder="Total de articulos">
            </div>
        </div>

    </div>

    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <label class="label-control">Observaciones:</label>
        </div>
        <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="col-md-12 col-sm-12 col-xs-12">
                <textarea class="form-control" rows="3" name="Observaciones" id="Observaciones"  onKeyUp="this.value=this.value.toUpperCase();" placeholder="Observaciones" required><?=  $Cabeza[0]->observa ?></textarea>
            </div>
        </div>
    </div>

 </div>
</div>

<div class="row" style="margin-top:15px;">
    <div class="col-md-2 col-sm-3 col-xs-6">
        <a href="<?= base_url() ?>Requisiciones/Index/<?= $actualpage ?>" id="btnBack" class="btn btn-default" style="width:100%">Volver</a>
    </div>
    <div class="col-md-offset-8 col-sm-offset-6 col-md-2 col-sm-3 col-xs-6">
        <input class="btn btn-success" id="btnSave" style="float: right;width:100%;'" type="button" value="Guardar">
    </div>
</div>

<!-- Inicia Ventana modal para buscar articulos-->

<div class="modal fade" id="mBuscararticulo" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #4d4dff;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" style="color: #FFF;">Consultar un articulo</h4>
      </div>
        <div class="modal-body">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="label-control">Marca:</label>
                <input type="text" id="Buscarmarca" class="form-control" placeholder="Marca">
            </div>
            <div class="col-md-8 col-sm-8 col-xs-12">
                <label class="label-control">Articulo o producto:</label>
                <input type="text" id="Buscararticulo" class="form-control" placeholder="Descripcion">
            </div>
            <!-- <div class="row"> -->
                <div class="col-md-6 col-sm-6 col-xs-12">
                    <label class="label-control">Clave:</label>
                    <input type="text" id="Claveencontrada" readonly class="form-control" placeholder="Clave">
                    <input type="hidden" id="Itemid">
                </div>
            <!-- </div> -->
            <div class="col-md-6 col-sm-6 col-xs-12">
                <label class="label-control">Clave eq:</label>
                <input type="text" id="Claveeqencontrada" name="Claveeqencontrada" readonly class="form-control" placeholder="Clave eq">
                <input type="hidden" id="Itemeqid">
            </div>            
            <div class="modal-footer" style="margin-top:20px;">
                <div class="row w-100 text-center" style="margin-top:50px;">
                    <button type="button" class="btn btn-default btn-sm" data-dismiss="modal" id="btnRegresar">Regresar</button>
                    <button type="button" class="btn btn-default btn-sm" id="btnLimpiar">Limpiar datos de b&uacute;squeda</button>
                    <button type="button" class="btn btn-success btn-sm" data-dismiss="modal" id="btnEncontrado">Tomar articulo</button>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>

<!-- Finaliza Ventana modal para buscar articulos-->

<?= form_close() ?>

<script>
        $("#chkModifyfile").change(function()
        {
             //bootbox.alert("Valor del chkbox "+$(this).val());
            if( $('#chkModifyfile').is(':checked') )
                {
                    //$("#imagefile").removeAttr("disabled");
                    $(".adjuntos").attr('type', 'file');
                    $("#Adjuntosmodificados, .adjuntosmodificados").val("1");
                }else{
                    $(".adjuntos").attr('type', 'hidden');
                    $("#Adjuntosmodificados, .adjuntosmodificados").val("0");
                }        
        })

    function show5(){
        if (!document.layers&&!document.all&&!document.getElementById)
        return

         var Usuario=$("#Usuario").val();
         var Digital=new Date();
         var hours=Digital.getHours();
         var minutes=Digital.getMinutes();
         var seconds=Digital.getSeconds();
         var vDay = Digital.getDate();
         var vMonth = Digital.getMonth()+1;
         var vYear = Digital.getFullYear();
         vDay = vDay.toString().length == 1 ? "0" + vDay : vDay;

        var dn="PM"
        if (hours<12)
        dn="AM"
        if (hours>12)
        hours=hours-12
        if (hours==0)
        hours=12

         if (minutes<=9)
         minutes="0"+minutes
         if (seconds<=9)
         seconds="0"+seconds

        $("#Date").text("Usuario solicitante: "+Usuario+"           Fecha y hora: " + vDay + "/" + vMonth + "/" + vYear + " " + hours + ":" + minutes + ":" + seconds + " " + dn);
        setTimeout("show5()",1000)
    }


    window.onload=show5

    function Buscart(e,vElement) { 
        // this.value=this.value.toUpperCase();
        tecla = document.all ? e.keyCode : e.which; 
        if(tecla==113){
            var vRow = $(vElement).attr("row");
            $("#Buscararticulo").val("");
            $("#Buscarmarca").val("");
            $("#Claveencontrada").val("");
            $("#Claveeqencontrada").val("");
            $("#mBuscararticulo").modal("show");
            setTimeout(function()
            {
                // $("#Itemid").val($(vElement).attr("id"));
                $("#Itemid").val('lstClaveArticulo'+vRow);
                $("#Itemeqid").val('lstClaveEq'+vRow);
                $("#Buscarmarca").focus();
            },500)
        } else{
            $(vElement).val($(vElement).val().toUpperCase())            
        } 
    } 

    function AsignarFunciones()
    {
        $(".numeric-field").keypress(function(event){
            if($(this).val() == "" && event.charCode == 46){
                return false;
            }
            if($(this).val().split('.').length >= 2 && event.charCode == 46 ){
                return false;
            }
            return event.charCode >= 48 && event.charCode <=57 || event.charCode == 46 || event.charCode == 13;
        })
        $(".just-number").keypress(function(event){
            return event.charCode >= 48 && event.charCode <=57 || event.charCode == 13;
        })

        $("[max-length]").keypress(function()
        {
            //event.preventDefault();
            var vMaxLength = $(this).attr("max-length");
            var vSelectedText = document.getSelection().toString();
            if($(this).val().length >= vMaxLength && vSelectedText.length == 0)
            {
                return false;
            }
        })

        $('.datetimepicker').datepicker({
            format: "dd/mm/yyyy",
            clearBtn: true,
            language: "es",
            orientation: "bottom auto",
            autoclose: true,
            todayHighlight: true
        });
    }

    function ContarDetalles()
    {
        var vTotalRegistros = 0;
        var vTotalArticulos = 0;

        $("#tDetalle > tbody > tr.active").each(function()
        {
            var vRow = $(this).attr("row");
            var vActive = $("#lstActive" + vRow).val();
            if(vActive == "true")
            {
                vTotalRegistros++;
                var vCantidad = parseInt($("#lstCantidad" + vRow).val());
                vTotalArticulos += parseInt(vCantidad);
            }
        })
        vTotalRegistros = vTotalRegistros == 0 ? "" : vTotalRegistros;
        vTotalArticulos = vTotalArticulos == 0 ? "" : vTotalArticulos;
        $("#txbTotalRegistros").val(vTotalRegistros);
        $("#txbTotalArticulos").val(vTotalArticulos);
    }

    function EliminarDetalle(vElement)
    {
        bootbox.confirm({
            message: "El registro quedara eliminado, ¿Desea continuar?",
            callback: function(result)
            {
                if(result)
                {
                    var vRow = $(vElement).attr("row");

                    $("#tr" + vRow).removeClass("active").hide();
                    $("#lstActive"+vRow).val(false);

                    ContarDetalles();
                    setTimeout(function()
                    {
                        $("#tDetalle > tbody > tr:visible").last().find("input").eq(0).focus();
                    },100);
                }
            }
        }); 
    }

    function AddNewRow(vElement)
    {
        var vDateNow = new Date();
        var vAddRow = true;
        var vRowActual = $(vElement).attr("row");
        var vUltimoRow = $("#tDetalle > tbody > tr:visible").last().attr("row");
        if(vRowActual == vUltimoRow && vAddRow)
        {
            var vRow = $(vElement).attr("row");
            //$("#lstActive" + vRow).val(true);
            //$("#tr" + vRow).addClass("active");
            var vCount = $("#tDetalle > tbody > tr").length;
            var vPartida = vCount+1;

            var vNewRow = '<tr id="tr' + vCount + '" row="' + vCount + '" class="active" >\
                                <td>\
                                    <input readonly type="text" name="lstDetalle[' + vCount + '][Partida]" class="form-control input-sm" value="'+ vPartida +'" id="lstPartida' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input type="text" name="lstDetalle[' + vCount + '][Clavearticulo]" class="form-control input-sm" row="' + vCount + '" max-length="16" placeholder="Clave" onchange="ChecarArticulo(this)" onkeypress="ChangeToCantidad(this);" onkeyup = "Buscart(event,this);" id="lstClaveArticulo' + vCount + '" />\
                                    <input type="hidden" name="lstDetalle[' + vCount + '][Active]" value="true" id="lstActive' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input type="text" name="lstDetalle[' + vCount + '][Clave_eq]" class="form-control input-sm" row="' + vCount + '" max-length="20" placeholder="Clave eq" onchange="ChecarArticuloEq(this)" onkeypress="ChangeToCantidad(this);" onkeyup = "Buscart(event,this);" id="lstClaveEq' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input readonly type="text" name="lstDetalle[' + vCount + '][Descripcion]" class="form-control input-sm" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Descripcion" row="' + vCount + '" id="lstDescripcion' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input type="text" name="lstDetalle[' + vCount + '][Marca]" class="form-control input-sm" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Marca" row="' + vCount + '" id="lstMarca' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input onchange="AddNewRow(this);" type="text" name="lstDetalle[' + vCount + '][Cantidad]" class="form-control numeric-field input-sm" row="' + vCount + '" placeholder="Cantidad" value="0" id="lstCantidad' + vCount + '" />\
                                </td>\
                                <td align="center"><span onclick="EliminarDetalle(this)" row="' + vCount + '" class="glyphicon glyphicon-remove" style="font-size:19px;color:red;margin-top: 9px;"></span></td>\
                            </tr>';

            $("#tDetalle > tbody").append(vNewRow);
            $("#tDetalle > tbody > tr:visible").last().find("input").eq(1).focus();
            AsignarFunciones();
            ContarDetalles();

        }else if(vAddRow)
        {
            $("#tDetalle > tbody > tr:visible").last().find("input").eq(1).focus();
        }
        ContarDetalles();
    }

   
    function ChecarArticulo(vElement)
    {
        if($(vElement).val().length > 0)
        {
            // Validamos que no exista previamente en la captura
            var vRepeat = false;
            var vDoscar = $(vElement).val().substring(0, 2);
            var v4car = $(vElement).val().substring(0, 3);
            var vEszz = vDoscar.toUpperCase();

            $("#tDetalle > tbody > tr.active").each(function()
            {
                var vInput = $(this).find("input").eq(1);
                if($(vInput).val() == $(vElement).val() && $(vInput).attr("row") != $(vElement).attr("row"))
                {
                    vRepeat = true;
                }
            })
            
            if(vRepeat && vEszz && v4car != "800") //ZZ Genericos mexico 8000 Generico Colombia
            {
                bootbox.alert({
                    message: "Este producto (" + $(vElement).val() + ") ya existe en la tabla actual.",
                    callback: function () {
                        setTimeout(function()
                        {
                            $(vElement).select().focus();
                        },100)
                    }
                })
                $(".loader-gif").hide();
                return;
            }

            // Tomamos el tipo de producto para validar mas adelante
            vTipoArticuloNum = $("#slcTipoPdto").val();
            if(vTipoArticuloNum=="0")
            {
                vTipoArticulo = "LLANTAS";
            }else{
                vTipoArticulo = "VARIOS";
            }

            // Validamos que el codigo del articulo exista en la tabla articulos y tomamos su descripcion
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Articulos/GetByClave/',
                dataType: "json",
                data: {
                    ClaveArticulo: $(vElement).val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    var vRow = $(vElement).attr("row");
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No existe el articulo con clave: " + $(vElement).val(),
                            callback: function () {
                                setTimeout(function()
                                {
                                    $(vElement).val("").focus();
                                    $("#lstClaveEq" + vRow).val("");
                                    $("#lstDescripcion" + vRow).val("");
                                },100)
                            }
                        })
                    }
                    if(data != null && data.tipo.trim() != vTipoArticulo)
                    {
                        bootbox.alert({
                            message: "El articulo no es del tipo " + vTipoArticulo,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $(vElement).val("").focus();
                                    $("#lstClaveEq" + vRow).val("");
                                    $("#lstDescripcion" + vRow).val("");
                                },100)
                            }
                        })
                    }

                    //Si el articulo existe y el del tipo indicado al principio de la requisicion
                    if(data != null && data.tipo.trim() == vTipoArticulo)
                    {
                        $('#slcTipoPdto').attr("disabled", true);
                        $("#lstClaveEq" + vRow).val(data.clave_eq);
                        $("#lstDescripcion" + vRow).val(data.descrip);
                        $("#lstMarca" + vRow).focus();

                        // Validamos el inicio del codigo del articulo si es 8000 o ZZ se permite editar la descripcion
                        if(vEszz == "ZZ" || v4car == "800")
                        {
                            $("#lstDescripcion" + vRow).removeAttr("readonly");
                            //$("#lstMarca" + vRow).removeAttr("readonly");
                        }
                        if(vEszz != "ZZ" && v4car != "800")
                        {
                            $("#lstDescripcion" + vRow).attr("readonly","readonly");
                            //$("#lstMarca" + vRow).attr("readonly","readonly");
                        }

                    }

                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }
//  Nueva funcion para validar el codigo equivalente
    function ChecarArticuloEq(vElement)
    {
        if($(vElement).val().length > 0)
        {
            // Validamos que no exista previamente en la captura
            var vRepeat = false;
            var vDoscar = $(vElement).val().substring(0, 2);
            var v4car = $(vElement).val().substring(0, 3);
            var vEszz = vDoscar.toUpperCase();

            $("#tDetalle > tbody > tr.active").each(function()
            {
                var vInput = $(this).find("input").eq(3);
                var vInputval = $(vInput).val();

                if($.trim(vInputval) == $(vElement).val() && $(vInput).attr("row") != $(vElement).attr("row"))
                {
                    vRepeat = true;
                }
            })
            
            if(vRepeat && vEszz != "ZZ" && v4car != "800") //ZZ Genericos mexico 800 Generico Colombia
            {
                bootbox.alert({
                    message: "Este producto (" + $(vElement).val() + ") ya existe en la tabla actual.",
                    callback: function () {
                        setTimeout(function()
                        {
                            $(vElement).select().focus();
                        },100)
                    }
                })
                $(".loader-gif").hide();
                return;
            }

            // Tomamos el tipo de producto para validar mas adelante
            vTipoArticuloNum = $("#slcTipoPdto").val();
            if(vTipoArticuloNum=="0")
            {
                vTipoArticulo = "LLANTAS";
            }else{
                vTipoArticulo = "VARIOS";
            }

            // Validamos que el codigo del articulo exista en la tabla articulos y tomamos su descripcion
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Articulos/GetByClaveEq/',
                dataType: "json",
                data: {
                    ClaveArticulo: $(vElement).val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    var vRow = $(vElement).attr("row");
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No existe el articulo con clave: " + $(vElement).val(),
                            callback: function () {
                                setTimeout(function()
                                {
                                    $(vElement).val("").focus();
                                    $("#lstClaveArticulo" + vRow).val("");
                                    $("#lstDescripcion" + vRow).val("");
                                },100)
                            }
                        })
                    }
                    if(data != null && data.tipo.trim() != vTipoArticulo)
                    {
                        bootbox.alert({
                            message: "El articulo no es del tipo " + vTipoArticulo,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $(vElement).val("").focus();
                                    $("#lstClaveArticulo" + vRow).val("");
                                    $("#lstDescripcion" + vRow).val("");
                                },100)
                            }
                        })
                    }

                    //Si el articulo existe y el del tipo indicado al principio de la requisicion
                    if(data != null && data.tipo.trim() == vTipoArticulo)
                    {
                        $('#slcTipoPdto').attr("disabled", true);
                        $("#lstClaveArticulo" + vRow).val(data.clave);
                        $("#lstDescripcion" + vRow).val(data.descrip);
                        $("#lstMarca" + vRow).focus();

                        // Validamos el inicio del codigo del articulo si es 8000 o ZZ se permite editar la descripcion
                        if(vEszz == "ZZ" || v4car == "800")
                        {
                            $("#lstDescripcion" + vRow).removeAttr("readonly");
                        }
                        if(vEszz != "ZZ" && v4car != "800")
                        {
                            $("#lstDescripcion" + vRow).attr("readonly","readonly");
                        }

                    }

                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }
//
    function ChangeToCantidad(vElement)
    {
        if(event.charCode == 13 && $(vElement).val() != "")
        {
            $(vElement).trigger("blur");
        }
    }

    function SelectAlmacen()
    {
        var vFound = false;
        $("#Clavealmacen option").each(function()
        {
            if($(this).val() == $("#txbClavealmacen").val())
            {
                $(this).prop("selected", true);
                $("#Clavealmacen").parent().parent().parent().removeClass("has-error");
                $("#Clavealmacen").parent().removeClass("has-error");
                $("#Clavealmacen").parent().parent().next().hide();
                vFound = true;
            }
        })

        if(!vFound)
        {
            $("#Clavealmacen").val("");
        }
    }

    function SelectCliente()
    {
        var vFound = false;
        $("#Clavecliente option").each(function()
        {
            if($(this).val() == $("#txbClavecliente").val())
            {
                $(".nombre-cliente").val($("#Clavecliente option:selected").text());
                $(this).prop("selected", true);
                $("#Clavecliente").parent().parent().parent().removeClass("has-error");
                $("#Clavecliente").parent().removeClass("has-error");
                $("#Clavecliente").parent().parent().next().hide();
                vFound = true;
            }
        })

        if(!vFound)
        {
            $("#Clavecliente").val("");
            $(".nombre-cliente").val("");
        }
    }

    function SelectProyecto()
    {
        var vFound = false;
        $("#Claveproyecto option").each(function()
        {
            if($(this).val() == $("#txbClaveproyecto").val())
            {

                $(".nombre-proyecto").val($("#Claveproyecto option:selected").text());
                $(this).prop("selected", true);
                $("#Claveproyecto").parent().parent().parent().removeClass("has-error");
                $("#Claveproyecto").parent().removeClass("has-error");
                $("#Claveproyecto").parent().parent().next().hide();
                vFound = true;
            }
        })

        if(!vFound)
        {
            $(".nombre-proyecto").val("");
            $("#Claveproyecto").val("");
        }
    }

    function MuestraGerente()
    {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Proyectos/GetUserByProyecto/',
                dataType: "json",
                data: {
                    ClaveProyecto: $("#Claveproyecto").val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        $("#Nombregerente").val("SIN GERENTE DEFINIDO");                        
                        $("#Usuariogerente").val("");
                        $("#Emailgerente").val("");                          
                    }
                    if(data != null)
                    {
                        $("#Nombregerente").val(data.nombre);
                        $("#Usuariogerente").val(data.UID);
                        $("#Emailgerente").val(data.email);                          
                    }
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
    }

    function AsignaOficina()
    {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Almacenes/GetByClave/',
                dataType: "json",
                data: {
                    ClaveAlmacen: $("#Clavealmacen").val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        $("#Claveoficina").val("00");
                        $("#Claveoficina2").val("00");                        
                    }
                    if(data != null)
                    {
                        $("#Claveoficina2").val(data.ofna2);
                        $("#Claveoficina").val(data.ofna);
                    }
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
    }
    
    function ChecarCliente(vClavecliente)
    {
        if(vClavecliente.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Clientes/GetByClave/',
                dataType: "json",
                data: {
                    ClaveCliente: vClavecliente
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro cliente con la clave: " + vClavecliente,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#Clavecliente").val("").focus();
                                    $("#txbClavecliente").val("");
                                    $("#hdNombrecliente").val("");
                                    $("#hdClavecliente").val("");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClavecliente").val(data.nombre);
                        $("#hdNombrecliente").val(data.nombre);
                        $("#hdClavecliente").val(data.clave);
                    }
                    
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }

    function ChecarCliente(vClavecliente)
    {
        if(vClavecliente.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Clientes/GetByClave/',
                dataType: "json",
                data: {
                    ClaveCliente: vClavecliente
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro cliente con la clave: " + vClavecliente,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#Clavecliente").val("").focus();
                                    $("#txbClavecliente").val("");
                                    $("#hdNombrecliente").val("");
                                    $("#hdClavecliente").val("");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClavecliente").val(data.nombre);
                        $("#hdNombrecliente").val(data.nombre);
                        $("#hdClavecliente").val(data.clave);
                    }
                    
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }

    function ChecarAlmacen(vClavealmacen)
    {
        if(vClavealmacen.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Almacenes/GetByClave/',
                dataType: "json",
                data: {
                    ClaveAlmacen: vClavealmacen
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro almacen con la clave: " + vClavealmacen,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#Clavealmacen").val("").focus();
                                    $("#txbClavealmacen").val("");
                                    $("#hdNombrealmacen").val("");
                                    $("#hdClavealmacen").val("");
                                    $("#Claveoficina").val("00");
                                    $("#Claveoficina2").val("00");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClavealmacen").val(data.nombre);
                        $("#hdNombrealmacen").val(data.nombre);
                        $("#hdClavealmacen").val(data.clave);
                        $("#Claveoficina2").val(data.ofna2);
                        $("#Claveoficina").val(data.ofna);
                    }
                   
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }

    function ChecarProyecto(vClaveproyecto)
    {
        if(vClaveproyecto.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Proyectos/GetByClave/',
                dataType: "json",
                data: {
                    ClaveProyecto: vClaveproyecto
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro el proyecto con la clave: " + vClaveproyecto,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#Claveproyecto").val("").focus();
                                    $("#txbClaveproyecto").val("");
                                    $("#hdNombreproyecto").val("");
                                    $("#hdClaveproyecto").val("");
                                    $("#Nombregerente").val("");
                                    $("#Usuariogerente").val("");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClaveproyecto").val(data.nombre);
                        $("#hdNombreproyecto").val(data.nombre);
                        $("#hdClaveproyecto").val(data.clave);
                        $("#Usuariogerente").val(ui.item.gerente);
                    }
                   
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }

    $(function()
    {
        $("#Claveproyecto").change(function()
        {
            ChecarProyecto($(this).val());
            MuestraGerente();
        })

        $("#Claveproyecto").keypress(function()
        {
            if(event.charCode == 13 || event.charCode == 9)
            {
                $(this).trigger("blur");
                ChecarProyecto($(this).val());
                MuestraGerente();
            }
        })

        $("#Clavealmacen").change(function()
        {
            ChecarAlmacen($(this).val());
            AsignaOficina();
        })

        $("#Clavealmacen").keypress(function()
        {
            if(event.charCode == 13 || event.charCode == 9)
            {
                $(this).trigger("blur");
                ChecarAlmacen($(this).val());
                AsignaOficina();
            }
        })

        $("#Clavecliente").change(function()
        {
            ChecarCliente($(this).val());
        })

        $("#Clavecliente").keypress(function()
        {
            if(event.charCode == 13 || event.charCode == 9)
            {
                $(this).trigger("blur");
                ChecarCliente($(this).val());
            }
        })

        $("#slcTipoReq").change(function()
        {
            $(".tipo-req").val($(this).val());
            if($(this).val() == "VENTA"){
                $('#tipo_req_vr').show();
                $('#Fechacompromiso').addClass("required-field");
                $('#Cotizacion').addClass("required-field");
                $('#Ocpedido').addClass("required-field");              
            }else{
                $('#tipo_req_vr').hide();
                $('#Fechacompromiso').removeClass("required-field");
                $('#Cotizacion').removeClass("required-field");
                $('#Ocpedido').removeClass("required-field");              
            }
        })

//  
        $('#Buscararticulo').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Articulos/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#Buscararticulo").val(),
                        marca: $("#Buscarmarca").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    //
                    success: function (data) {
                        if(data){
                            response($.map(data, function (item) {
                                return {
                                    value: item.value,
                                    label: item.label,
                                    Clave: item.Clave,
                                    Clave_eq: item.Clave_eq,
                                }
                            }));
                        }else{
                            response("");
                        }
                    },
                    //
                    messages: {
                                noResults: "No se encontraron coincidencias.",
                                results: function (count) {
                                    return count + (count > 1 ? ' resultados' : ' resultado ') + ' encontrado(s)';
                                }
                    },
                    //
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#Claveencontrada").val(ui.item.Clave);
                $("#Claveeqencontrada").val(ui.item.Clave_eq);
                return false;
            }
        });

        $( "#Buscararticulo" ).autocomplete("widget").addClass("fixedHeight");
//
        $('#Buscarmarca').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Articulos/AutocompleteMarca/',
                    dataType: "json",
                    data: {
                        term: $("#Buscarmarca").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    //
                    success: function (data) {
                        if(data){
                            response($.map(data, function (item) {
                                return {
                                    value: item.value,
                                    label: item.label,
                                }
                            }));
                        }else{
                            response("");
                        }
                    },
                    //
                    messages: {
                                noResults: "No se encontraron coincidencias.",
                                results: function (count) {
                                    return count + (count > 1 ? ' resultados' : ' resultado ') + ' encontrado(s)';
                                }
                    },
                    //                    
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                // $("#Claveencontrada").val(ui.item.Clave);
                // $("#Claveeqencontrada").val(ui.item.Clave_eq);
                return false;
            }
        });
//

        $("#slcTipoPdto").change(function()
        {
            $(".tipo-pdto").val($(this).val());
        })

        $(".required-field").change(function()
        {
            if($(this).val() != ""){
                $(this).parent().removeClass("has-error");
                $(this).next().hide();
            }
            if($(this).val() == "" && $("#hdTriedSave").val() == "true"){
                $(this).parent().addClass("has-error");
                $(this).next().show();
            }
        })

        $("#sAddRow").click(function()
        {
            var vCount = $("#tDetalle > tbody > tr").length;
            var vPartida = vCount+1;

            var vNewRow = '<tr id="tr' + vCount + '" row="' + vCount + '" class="active" >\
                                <td>\
                                    <input readonly type="text" name="lstDetalle[' + vCount + '][Partida]" class="form-control input-sm" value="'+ vPartida +'" id="lstPartida' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input type="text" name="lstDetalle[' + vCount + '][Clavearticulo]" class="form-control input-sm" row="' + vCount + '" max-length="16" placeholder="Articulo" onchange="ChecarArticulo(this)" onkeypress="ChangeToCantidad(this);" onkeyup = "Buscart(event,this);" id="lstClaveArticulo' + vCount + '" />\
                                    <input type="hidden" name="lstDetalle[' + vCount + '][Active]" value="true" id="lstActive' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input type="text" name="lstDetalle[' + vCount + '][Clave_eq]" class="form-control input-sm" row="' + vCount + '" max-length="20" placeholder="Clave eq" onchange="ChecarArticuloEq(this)" onkeypress="ChangeToCantidad(this);" onkeyup = "Buscart(event,this);" id="lstClaveEq' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input readonly type="text" name="lstDetalle[' + vCount + '][Descripcion]" class="form-control input-sm" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Descripcion" row="' + vCount + '" id="lstDescripcion' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input type="text" name="lstDetalle[' + vCount + '][Marca]" class="form-control input-sm" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Marca" row="' + vCount + '" id="lstMarca' + vCount + '" />\
                                </td>\
                                <td>\
                                    <input onchange="AddNewRow(this);" type="text" name="lstDetalle[' + vCount + '][Cantidad]" class="form-control numeric-field input-sm" row="' + vCount + '" placeholder="Cantidad" value="0" id="lstCantidad' + vCount + '" />\
                                </td>\
                                <td align="center"><span onclick="EliminarDetalle(this)" row="' + vCount + '" class="glyphicon glyphicon-remove" style="font-size:19px;color:red;margin-top: 9px;"></span></td>\
                            </tr>';

            $("#tDetalle > tbody").append(vNewRow);
            $("#tDetalle > tbody > tr").last().find("input").eq(1).focus();
            AsignarFunciones();
            ContarDetalles();
        })

        $("#btnBack").click(function()
        {
            // Quitamos el bloqueo
            var vFolio = $("#hdNumero").val();
            $("p.loader-gif").text("Quitando bloqueo...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Requisiciones/QuitarBloqueo/',
                dataType: "json",
                data: {
                    FolioRequi: vFolio
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        })

        $("#btnEncontrado").click(function()
        {
            var vItemid = "#"+$("#Itemid").val();
            var vItemeqid = "#"+$("#Itemeqid").val();
            $(vItemid).val($("#Claveencontrada").val());
            $(vItemeqid).val($("#Claveeqencontrada").val());
            $(vItemid).trigger("change");
            $(vItemid).focus();
        })

        $("#btnLimpiar").click(function()
        {
            $("#Claveencontrada").val('');
            $("#Claveeqencontrada").val('')
            $("#Buscararticulo").val('').focus();
        })

        $("#btnRegresar").click(function()
        {
            var vItemid = "#"+$("#Itemid").val();
            $(vItemid).focus();
        })

        $("#btnSave").click(function()
        {
            $("#frmEdit").submit();
        })

        $("#frmEdit").submit(function()
        {
            var vSubmit = true;

            $(".required-field").each(function()
            {
                if($(this).val().trim().length == 0)
                {
                    vSubmit = false;
                    $(this).parent().addClass("has-error");
                    if($(this).attr("id") == "Claveproveedor")
                    {
                        $(this).parent().parent().parent().addClass("has-error");
                        $(this).parent().parent().next().show();
                    }
                    $(this).next().show();
                }
            })

            $("#tDetalle > tbody > tr.active").each(function()
            {
                var vRow = $(this).attr("row");
                var vClaveArticulo = $("#lstClaveArticulo" + vRow).val();
                var vNombreArticulo = $("#lstDescripcion" + vRow).val();
                var vCantidad = parseInt($("#lstCantidad" + vRow).val());

                // Si no tiene clave de articulo desactivamos el renglon
                if(vClaveArticulo.length == 0)
                {
                    $("#lstActive"+vRow).val(false);
                }else{

                    // Tiene articulo pero no cantidad no se manda submit
                    if(vCantidad == 0 || isNaN(vCantidad))
                    {
                        vSubmit = false;
                    }

                }
            })

            if(!vSubmit)
            {
                bootbox.alert("Llene todos los campos obligatorios de la tabla y/o formulario para guardar");
            }
            if($("#tDetalle > tbody > tr.active").length == 0 && vSubmit)
            {
                bootbox.alert("Tiene que agregar al menos un articulo para guardar.");
                vSubmit = false;
            }

            if(vSubmit)
            {
                $("p.loader-gif").text("Guardando...");
                $(".loader-gif").show();
            }
            return vSubmit;
        })
        //
        // Codigo para autocompletar el nombre del cliente
        //
        $('#txbClavecliente').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Clientes/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#txbClavecliente").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label,
                                Clave: item.Clave,
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#Clavecliente").val(ui.item.Clave);
                $("#hdClavecliente").val(ui.item.Clave);
                $("#hdNombrecliente").val(ui.item.label);
                return false;
            }
        });
        //
        // Codigo para autocompletar el nombre del almacen
        //
        $('#txbClavealmacen').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Almacenes/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#txbClavealmacen").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label,
                                Clave: item.Clave,
                                Ofna: item.Ofna,
                                Ofna2: item.Ofna2,
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#Clavealmacen").val(ui.item.Clave);
                $("#hdClavealmacen").val(ui.item.Clave);
                $("#Claveoficina2").val(ui.item.Ofna2);
                $("#Claveoficina").val(ui.item.Ofna);
                $("#hdNombrealmacen").val(ui.item.label);
                return false;
            }
        });

        //
        // Codigo para autocompletar el nombre del proyecto
        //
        $('#txbClaveproyecto').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Proyectos/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#txbClaveproyecto").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label,
                                Clave: item.Clave,
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#Claveproyecto").val(ui.item.Clave);
                $("#hdClaveproyecto").val(ui.item.Clave);
                $("#hdNombreproyecto").val(ui.item.label);
                $("#Usuariogerente").val(ui.item.Gerente);
                MuestraGerente();
                return false;
            }
        });
    })
</script>