<?php if($this->session->flashdata('message_edit')){?>
    <div class="alert alert-<?= $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
        <?= $this->session->flashdata('message_create') ?>
    </div>
<?php } ?>
<?= form_open_multipart('/Requisiciones/DesbloqueoPost', array("id" => "frmEdit")) ?>

<div class="panel panel-uni">
  <div class="panel-heading">
    <h3 class="panel-title"><?= $title ?></h3>
  </div>

  <div class="panel-body">
    <h3 class="panel-title">Queda(n) <?= $Bloqueadas ?> requisicion(es) bloqueada(s)</h3>

    <div class="row" style="margin-top:20px;">

        <div class="col-md-12 col-sm-12 col-xs-12" style="max-height: 400px;overflow-x: hidden;">
            <table class="table table-bordered" id="tDetalle">
                <thead>
                    <tr>
                        <th width="10%" >Numero</th>
                        <th width="12%" >Productos</th>
                        <th width="15%" >Tipo</th>
                        <th>Fecha</th>
                        <th width="10%" >Usr. Genero</th>
                        <th>Almacen</th>
                        <th width="10%" >Usr. Bloqueo</th>
                        <th class="text-center"><span id="sSelectAll" class="glyphicon glyphicon-check" style="font-size:19px;color:#43ac6a;"></span></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $Index = 0;
                        foreach($Detalles as $Detalle){
                            if($Detalle->tipo == 0)
                            {
                                $Itempdto="LLANTAS";
                            }else{
                                $Itempdto="VARIOS";
                            }
                    ?>
                        <tr id="tr<?= $Index ?>" row="<?= $Index ?>" class="active">
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Numero]" class="form-control" value="<?= $Detalle->numero ?>" row="<?= $Index ?>" id="lstNumero<?= $Index ?>" />
                            <input type="hidden" name="lstDetalle[<?= $Index ?>][Active]" value="true" id="lstActive<?= $Index ?>" />
                        </td>
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Productos]" class="form-control" value="<?= $Itempdto ?>" row="<?= $Index ?>" id="lstProductos<?= $Index ?>" />
                        </td>
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Tipo]" class="form-control"  row="<?= $Index ?>" value="<?= $Detalle->tipo_req ?>"  id="lstTipo<?= $Index ?>" />
                        </td>
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Fecha]" class="form-control" row="<?= $Index ?>" value="<?= $Detalle->fecha_ini ?>" id="lstFecha<?= $Index ?>" />
                        </td>
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Genero]" class="form-control" row="<?= $Index ?>" value="<?= $Detalle->usuario ?>" id="lstGenero<?= $Index ?>" />
                        </td>
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Almacen]" class="form-control" row="<?= $Index ?>" value="<?= $Detalle->almacen ?>" id="lstAlmacen<?= $Index ?>" />
                        </td>
                        <td>
                            <input readonly type="text" name="lstDetalle[<?= $Index ?>][Bloqueo]" class="form-control" row="<?= $Index ?>" value="<?= $Detalle->usuarioblq ?>" id="lstBloqueo<?= $Index ?>" />
                        </td>
                        <td>
                            <input type="checkbox" onchange="chkDesbloquear(this);" name="lstDetalle[<?= $Index ?>][chkDesbloqueada]" class="form-control" row="<?= $Index ?>" placeholder="" id="lstchkDesbloqueada<?= $Index ?>" />
                            <input type="hidden" name="lstDetalle[<?= $Index ?>][Desbloqueada]" id="lstDesbloqueada<?= $Index ?>" />                            
                        </td>
                        </tr>
                    <?php 
                            $Index++;
                        } 
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</div>

<div class="row" style="margin-top:15px;">

    <div class="col-md-2 col-sm-3 col-xs-6">
        <a href="<?= base_url() ?>" id="btnBack" class="btn btn-default" style="width:100%">Volver</a>
    </div>

    <div class="col-md-offset-8 col-sm-offset-6 col-md-2 col-sm-3 col-xs-6">
        <input class="btn btn-success" id="btnSave" style="float: right;width:100%;'" type="button" value="Desbloquear">
    </div>

</div>

<?= form_close() ?>

<script>

    function chkDesbloquear(vElement)
    {
        var vRow = $(vElement).attr("row");
        if($(vElement).is(':checked'))
        {
            $("#lstDesbloqueada"+vRow).val(true);
        }else{
            $("#lstDesbloqueada"+vRow).val(false);
        }
    }


    $(function()
    {

        $("#sSelectAll").click(function()
        {
            $("#tDetalle > tbody > tr.active").each(function()
            {
                var vRow = $(this).attr("row");

                if(!$("#lstchkDesbloqueada" + vRow ).prop("checked"))
                {
                    $("#lstchkDesbloqueada" + vRow).prop("checked", true);
                    $("#lstDesbloqueada"+vRow).val(true);
                }
            })
        })
        
        $(".required-field").change(function()
        {
            if($(this).val() != ""){
                $(this).parent().removeClass("has-error");
                $(this).next().hide();
            }
            if($(this).val() == "" && $("#hdTriedSave").val() == "true"){
                $(this).parent().addClass("has-error");
                $(this).next().show();
            }
        })

        $("#btnSave").click(function()
        {
            $("#frmEdit").submit();
        })

        $("#frmEdit").submit(function()
        {
            var vSubmit = true;

            $(".required-field").each(function()
            {
                if($(this).val().trim().length == 0)
                {
                    vSubmit = false;
                    $(this).parent().addClass("has-error");
                    if($(this).attr("id") == "Claveproveedor")
                    {
                        $(this).parent().parent().parent().addClass("has-error");
                        $(this).parent().parent().next().show();
                    }
                    $(this).next().show();
                }
            })

            if(!vSubmit)
            {
                bootbox.alert("Llene todos los campos obligatorios de la tabla y/o formulario para guardar");
            }

            if($("#tDetalle > tbody > tr.active").length == 0 && vSubmit)
            {
                bootbox.alert("Tiene que desbloquear al menos una requisicion para guardar.");
                vSubmit = false;
            }

            if(vSubmit)
            {
                $("p.loader-gif").text("Guardando...");
                $(".loader-gif").show();
            }
            return vSubmit;
        })
    })
</script>