<?php if($this->session->flashdata('message_create')){?>
    <div class="alert alert-<?= $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
        <?= $this->session->flashdata('message_create') ?>
    </div>
<?php } ?>
<div class="panel panel-uni">
  <div class="panel-heading">
    <h3 class="panel-title"><?= $title ?></h3>
  </div>
  <div class="panel-body">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <label class="control-label">Oficina Inicial:</label>
             <div class="row">
                <div class="col-md-2 col-sm-2 col-xs-4">
                    <input type="text" id="ClaveoficinaI" value="<?= $Claveoficinaprimero ?>" name="ClaveoficinaI" max-length="2" class="form-control" placeholder="Clave">
                    <input type="hidden" id="hdClaveoficinaI">
                </div>
                <div class="col-md-10 col-sm-10 col-xs-8">
                    <input type="text" id="txbClaveoficinaI" value="<?= $Nombreoficinaprimero ?>" placeholder="Oficina inicial" class="form-control">
                    <input type="hidden" id="hdNombreoficinaI">
                </div>
            </div>
        </div>

        <div class="col-md-12 col-sm-12 col-xs-12">
            <label class="control-label">Oficina Final:</label>
             <div class="row">
                <div class="col-md-2 col-sm-2 col-xs-4">
                    <input type="text" id="ClaveoficinaF" value="<?= $Claveoficinaultimo ?>" name="ClaveoficinaF" max-length="2" class="form-control" placeholder="Clave">
                    <input type="hidden" id="hdClaveoficinaF">
                </div>
                <div class="col-md-10 col-sm-10 col-xs-8">
                    <input type="text" id="txbClaveoficinaF" value="<?= $Nombreoficinaultimo ?>" placeholder="Oficina final" class="form-control">
                    <input type="hidden" id="hdNombroficinaF">
                </div>
            </div>
        </div>
        
            <div class="col-md-12 col-sm-12 col-xs-12">
                <label class="control-label">Almacen Inicial:</label>
                 <div class="row">
                    <div class="col-md-2 col-sm-2 col-xs-4">
                        <input type="text" id="ClavealmacenI" value="<?= $Clavealmacenprimero ?>" name="ClavealmacenI" max-length="5" class="form-control fill" placeholder="Clave">
                        <input type="hidden" id="hdClavealmacenI">
                    </div>
                    <div class="col-md-10 col-sm-10 col-xs-8">
                        <input type="text" id="txbClavealmacenI" value="<?= $Nombrealmacenprimero ?>" placeholder="Almacen inicial" class="form-control">
                        <input type="hidden" id="hdNombrealmacenI">
                    </div>
                </div>
            </div>

            <div class="col-md-12 col-sm-12 col-xs-12">
                <label class="control-label">Almacen Final:</label>
                 <div class="row">
                    <div class="col-md-2 col-sm-2 col-xs-4">
                        <input type="text" id="ClavealmacenF" value="<?= $Clavealmacenultimo ?>" name="ClavealmacenF" max-length="5" class="form-control fill" placeholder="Clave">
                        <input type="hidden" id="hdClavealmacenF">
                    </div>
                    <div class="col-md-10 col-sm-10 col-xs-8">
                        <input type="text" id="txbClavealmacenF" value="<?= $Nombrealmacenultimo ?>" placeholder="Almacen final" class="form-control">
                        <input type="hidden" id="hdNombrealmacenF">
                    </div>
                </div>
            </div>

        <div class="col-md-2 col-sm-2 col-xs-12">
            <label class="control-label" for="FechaF">Fecha inicial:</label>
            <input type="text" name="FechaI" id="FechaI" value="<?= $Fechadefault ?>" placeholder="Fecha" class="form-control datetimepicker required-field" max-length="10">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-2 col-sm-2 col-xs-12">
            <label class="control-label" for="FechaF">Fecha final:</label>
            <input type="text" name="FechaF" id="FechaF" value="<?= $Fechadefault ?>" placeholder="Fecha" class="form-control datetimepicker required-field" max-length="10">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

    </div>
  </div>
</div>
        
<div class="row" style="margin-top:15px;">
    <div class="col-md-offset-8 col-sm-offset-6 col-md-2 col-sm-3 col-xs-6">
        <button class="btn btn-primary" id="iDescargarPdfReportePensur">Descargar pdf</button>
    </div>
    <div class="col-md-2 col-sm-3 col-xs-6">
        <button class="btn btn-success" id="iDescargarExcelReportePensur">Descargar excel</button>
    </div>
</div>

<?= form_open_multipart('/Reportes/ExcelReportePensur', array("id" => "frmDescargarExcelReportePensur")) ?>
    <input type="hidden" name="ClavealmacenI" class="clave-almaceni" value="<?= $Clavealmacenprimero ?>">
    <input type="hidden" name="ClavealmacenF" class="clave-almacenf" value="<?= $Clavealmacenultimo ?>">
    <input type="hidden" name="ClaveoficinaI" class="clave-oficinai" value="<?= $Claveoficinaprimero ?>">
    <input type="hidden" name="ClaveoficinaF" class="clave-oficinaf" value="<?= $Claveoficinaultimo ?>">
    <input type="hidden" name="FechaInicial" class="dato-fechai" value="<?= $Fechadefault ?>">
    <input type="hidden" name="FechaFinal" class="dato-fechaf" value="<?= $Fechadefault ?>">
<?= form_close() ?>

<?= form_open_multipart('/Reportes/PdfReportePensur', array("id" => "frmDescargarPdfReportePensur")) ?>
    <input type="hidden" name="ClavealmacenI" class="clave-almaceni" value="<?= $Clavealmacenprimero ?>">
    <input type="hidden" name="ClavealmacenF" class="clave-almacenf" value="<?= $Clavealmacenultimo ?>">
    <input type="hidden" name="ClaveoficinaI" class="clave-oficinai" value="<?= $Claveoficinaprimero ?>">
    <input type="hidden" name="ClaveoficinaF" class="clave-oficinaf" value="<?= $Claveoficinaultimo ?>">
    <input type="hidden" name="FechaInicial" class="dato-fechai" value="<?= $Fechadefault ?>">
    <input type="hidden" name="FechaFinal" class="dato-fechaf" value="<?= $Fechadefault ?>">
<?= form_close() ?>

<script>
    // Validar almacenes
    function ChecarAlmacenI(vClaveAlmaceni)
    {
        if(vClaveAlmaceni.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Almacenes/GetByClave/',
                dataType: "json",
                data: {
                    ClaveAlmacen: vClaveAlmaceni
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro almacen con la clave: " + vClaveAlmaceni,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#ClavealmacenI").val("").focus();
                                    $("#txbClavealmacenI").val("");
                                    $("#hdNombrealmacenI").val("");
                                    $("#hdClavealmacenI").val("");
                                    $(".clave-almaceni").val("");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClavealmacenI").val(data.nombre);
                        $("#hdNombrealmacenI").val(data.nombre);
                        $("#hdClavealmacenI").val(data.clave);
                        $(".clave-almaceni").val(data.clave);
                    }
                    
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }

    // Validar almacenes
    function ChecarAlmacenF(vClaveAlmacenf)
    {
        if(vClaveAlmacenf.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Almacenes/GetByClave/',
                dataType: "json",
                data: {
                    ClaveAlmacen: vClaveAlmacenf
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro almacen con la clave: " + vClaveAlmacenf,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#ClavealmacenF").val("").focus();
                                    $("#txbClavealmacenF").val("");
                                    $("#hdNombrealmacenF").val("");
                                    $("#hdClavealmacenF").val("");
                                    $(".clave-almacenf").val("");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClavealmacenF").val(data.nombre);
                        $("#hdNombrealmacenF").val(data.nombre);
                        $("#hdClavealmacenF").val(data.clave);
                        $(".clave-almacenf").val(data.clave);
                    }
                    
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }
    // Validar oficinas
    function ChecarOficinaI(vClaveOficinai)
    {
        if(vClaveOficinai.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Oficinas/GetByClave/',
                dataType: "json",
                data: {
                    ClaveOficina: vClaveOficinai
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro oficina con la clave: " + vClaveOficinai,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#ClaveoficinaI").val("").focus();
                                    $("#txbClaveoficinaI").val("");
                                    $("#hdNombreoficinaI").val("");
                                    $("#hdClaveoficinaI").val("");
                                    $(".clave-oficinai").val("");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClaveoficinaI").val(data.nombre);
                        $("#hdNombreoficinaI").val(data.nombre);
                        $("#hdClaveoficinaI").val(data.clave);
                        $(".clave-oficinai").val(data.clave);
                    }
                    
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }

    function ChecarOficinaF(vClaveOficinaf)
    {
        if(vClaveOficinaf.length > 0)
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
            $.ajax({
                url: $("#url").val() + '/Oficinas/GetByClave/',
                dataType: "json",
                data: {
                    ClaveOficina: vClaveOficinaf
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No se encontro oficina con la clave: " + vClaveOficinaf,
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#ClaveoficinaF").val("").focus();
                                    $("#txbClaveoficinaF").val("");
                                    $("#hdNombreoficinaF").val("");
                                    $("#hdClaveoficinaF").val("");
                                    $(".clave-oficinaf").val("");
                                },100)
                            }
                        });
                    }
                    if(data != null)
                    {
                        $("#txbClaveoficinaF").val(data.nombre);
                        $("#hdNombreoficinaF").val(data.nombre);
                        $("#hdClaveoficinaF").val(data.clave);
                        $(".clave-oficinaf").val(data.clave);
                    }
                    
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        }
    }


    $(function()
    {
        //
        // Codigo para autocompletar el almacen inicial por nombre
        //
        $('#txbClavealmacenI').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Almacenes/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#txbClavealmacenI").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label,
                                Clave: item.Clave,
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#ClavealmacenI").val(ui.item.Clave);
                $(".clave-almaceni").val(ui.item.Clave);
                $("#hdClavealmacenI").val(ui.item.Clave);
                $("#hdNombrealmacenI").val(ui.item.label);
                return false;
            }
        });
        //
        // Codigo para autocompletar el almacen final por nombre
        //
        $('#txbClavealmacenF').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Almacenes/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#txbClavealmacenF").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label,
                                Clave: item.Clave,
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#ClavealmacenF").val(ui.item.Clave);
                $(".clave-almacenf").val(ui.item.Clave);
                $("#hdClavealmacenF").val(ui.item.Clave);
                $("#hdNombrealmacenF").val(ui.item.label);
                return false;
            }
        });
        //
        // Codigo para autocompletar la oficina inicial por nombre
        //
        $('#txbClaveoficinaI').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Oficinas/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#txbClaveoficinaI").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label,
                                Clave: item.Clave,
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#ClaveoficinaI").val(ui.item.Clave);
                $(".clave-oficinai").val(ui.item.Clave);
                $("#hdClaveoficinaI").val(ui.item.Clave);
                $("#hdNombreoficinaI").val(ui.item.label);
                return false;
            }
        });
        //
        // Codigo para autocompletar la oficina final por nombre
        //
        $('#txbClaveoficinaF').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Oficinas/AutocompleteNombre/',
                    dataType: "json",
                    data: {
                        term: $("#txbClaveoficinaF").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label,
                                Clave: item.Clave,
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                $("#ClaveoficinaF").val(ui.item.Clave);
                $(".clave-oficinaf").val(ui.item.Clave);
                $("#hdClaveoficinaF").val(ui.item.Clave);
                $("#hdNombreoficinaF").val(ui.item.label);
                return false;
            }
        });


        $("#ClavealmacenI").change(function()
        {
            ChecarAlmacenI($(this).val());
        })

        $("#ClavealmacenI").keypress(function()
        {
            if(event.charCode == 13 || event.charCode == 9)
            {
                $(this).trigger("blur");
                ChecarAlmacenI($(this).val());
            }
        })

        $("#ClavealmacenF").change(function()
        {
            ChecarAlmacenF($(this).val());
        })

        $("#ClavealmacenF").keypress(function()
        {
            if(event.charCode == 13 || event.charCode == 9)
            {
                $(this).trigger("blur");
                ChecarAlmacenF($(this).val());
            }
        })

        $("#FechaI").change(function()
        {
            $(".dato-fechai").val($(this).val());
        })

        $("#FechaF").change(function()
        {
            $(".dato-fechaf").val($(this).val());
        })

        $("#ClaveoficinaI").change(function()
        {
            ChecarOficinaI($(this).val());
        })

        $("#ClaveoficinaI").keypress(function()
        {
            if(event.charCode == 13 || event.charCode == 9)
            {
                $(this).trigger("blur");
                ChecarOficinaI($(this).val());
            }
        })

        $("#ClaveoficinaF").change(function()
        {
            ChecarOficinaF($(this).val());
        })

        $("#ClaveoficinaF").keypress(function()
        {
            if(event.charCode == 13 || event.charCode == 9)
            {
                $(this).trigger("blur");
                ChecarOficinaF($(this).val());
            }
        })

        $("#iDescargarPdfReportePensur").click(function()
        {
            //
            // Validamos campos vacios y fechas
            //
            $("#hdTriedSave").val("true");
            var vSubmit = true;
            $(".required-field").each(function()
            {
                if($(this).val().trim().length == 0)
                {
                    vSubmit = false;
                    $(this).parent().addClass("has-error");
                    $(this).next().show();
                }
            })

            //
            // Validamos los almacenes y oficinas
            //
            if($("#ClavealmacenI").val() == "")
            {
                bootbox.alert("Tiene que seleccionar un almacen inicial para poder descargar el reporte.");
                return;
            }
            if($("#ClavealmacenF").val() == "")
            {
                bootbox.alert("Tiene que seleccionar un almacen final para poder descargar el reporte.");
                return;
            }
            if($("#ClavealmacenF").val() < $("#ClavealmacenI").val())
            {
                bootbox.alert("La clave del almacen final debe ser igual o posterior al almacen inicial.");
                return;
            }

            if($("#ClaveoficinaI").val() == "")
            {
                bootbox.alert("Tiene que seleccionar una oficina inicial para poder descargar el reporte.");
                return;
            }
            if($("#ClaveoficinaF").val() == "")
            {
                bootbox.alert("Tiene que seleccionar una oficina final para poder descargar el reporte.");
                return;
            }
            if($("#ClaveoficinaF").val() < $("#ClaveoficinaI").val())
            {
                bootbox.alert("La clave del oficina final debe ser igual o posterior a la oficina inicial.");
                return;
            }

            $("#frmDescargarPdfReportePensur").submit();
            bootbox.alert("El documento se descargara en un momento.");
        })

        $("#iDescargarExcelReportePensur").click(function()
        {
            //
            // Validamos campos vacios y fechas
            //
            $("#hdTriedSave").val("true");
            var vSubmit = true;
            $(".required-field").each(function()
            {
                if($(this).val().trim().length == 0)
                {
                    vSubmit = false;
                    $(this).parent().addClass("has-error");
                    $(this).next().show();
                }
            })

            //
            // Validamos los almacenes y oficinas
            //
            if($("#ClavealmacenI").val() == "")
            {
                bootbox.alert("Tiene que seleccionar un almacen inicial para poder descargar el reporte.");
                return;
            }
            if($("#ClavealmacenF").val() == "")
            {
                bootbox.alert("Tiene que seleccionar un almacen final para poder descargar el reporte.");
                return;
            }
            if($("#ClavealmacenF").val() < $("#ClavealmacenI").val())
            {
                bootbox.alert("La clave del almacen final debe ser igual o posterior al almacen inicial.");
                return;
            }

            if($("#ClaveoficinaI").val() == "")
            {
                bootbox.alert("Tiene que seleccionar una oficina inicial para poder descargar el reporte.");
                return;
            }
            if($("#ClaveoficinaF").val() == "")
            {
                bootbox.alert("Tiene que seleccionar una oficina final para poder descargar el reporte.");
                return;
            }
            if($("#ClaveoficinaF").val() < $("#ClaveoficinaI").val())
            {
                bootbox.alert("La clave del oficina final debe ser igual o posterior a la oficina inicial.");
                return;
            }

            $("#frmDescargarExcelReportePensur").submit();
            bootbox.alert("El documento se descargara en un momento.");
        })
    })
</script>