<?php 
    $IdUsuario = $this->session->UID;
?>
    <?php if($this->session->flashdata('message_index')){?>
        <div class="alert alert-<?php echo $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            <?php echo $this->session->flashdata('message_index') ?>
        </div>
    <?php } ?>

    <div class="row">
        <div class="col-md-8 col-sm-8 col-xs-12">
            <h2><?= $title ?></h2>
        </div>
        <?php if(VerificarPermisos($IdUsuario, "Misreqoo", "Create")){ ?>
        <div class="col-md-4 col-sm-4 col-xs-12">
            <a href="<?= base_url() ?>Requisiciones/Create/" class="btn btn-success" style="float: right;margin-top:24px;">Crear requisicion</a>
        </div>
        <?php } ?>
    </div>
    <div class="row">
        <?= form_open('/Misreqoo/Index/') ?>
        <input type="hidden" name="Page" id="Page" value="<?= $ActualPage ?>" >
        <div class="col-md-2 col-sm-6 col-xs-12">
            <input type="text" id="Folio" name="Folio" class="form-control" placeholder="Folio" value="<?= set_value("Folio") ?>" />
        </div>
            <div class="col-md-2 col-sm-4 col-xs-12">
            <input type="submit" id="btnFilter" class="btn btn-default" style="width:100%" value="Filtrar" />
        </div>
        <div class="col-md-2 col-sm-6 col-xs-12">
            <a href="<?= base_url() ?>Misreqoo/Index/" class="btn btn-info" style="width:100%">Limpiar</a>
        </div>        
        <?= form_close() ?>
    </div>
    <div class="row" style="margin-top:15px;">
        <div class="table-responsive">
        <table id="tblUsers" class="table table-hover">
        <thead class="thead-style">
        <tr>
            <th>Folio</th>
            <th>Tipo</th>
            <th>Feha alm.</th>
            <th></th>
            <th></th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        <?php
            foreach($CabezaRequisiciones as $Movimiento){
        ?>
        <tr>
            <td><?= $Movimiento->numero ?></td>
            <td><?= $Movimiento->tipo_req ?></td>
            <td>
                <?php if($Movimiento->fecha_sr2 =='1753-01-01'){ ?>
                   <a class="text-danger"> Sin procesar </a>
                <?php } else {
                    echo $Movimiento->fecha_sr2; 
                }?>
            </td>
            <td>
                <?php if($Movimiento->status ==9){ ?>
                   <a class="text-danger"> Cancelada </a>
                <?php } else {if(VerificarPermisos($IdUsuario, "Misreqoo", "Edit" )){ ?>
                    <a href="<?= base_url() ?>Misreqoo/Edit/<?= $Movimiento->numero ?>" style="color: #000">Procesar</a>
                    <?php } 
                }?>
            </td>
            <!-- <td><a href="#" class="descargar-documento" folio="<?= $Movimiento->numero ?>" style="color: #000">Descargar</a></td> -->
            <td>
                <?php if(VerificarPermisos($IdUsuario, "Misreqoo", "Details")){ ?>
                <a href="<?= base_url() ?>Misreqoo/Details/<?= $Movimiento->numero ?>" style="color: #000">Consultar</a>
                <?php } ?>
            </td>  
        </tr>
        <?php } ?>
        </tbody>
    </table>
    <?php
        $Previous = $ActualPage - 1;
        $Next = $ActualPage + 1;
        $DisabledPrevious = "";
        $DisabledNext = "";
        if($Previous <= 0){
            $Previous = "";
            $DisabledPrevious = "disabled";
        }

        if($Next > $Pages){
            $Next = "";
            $DisabledNext = "disabled";
        }
    ?>
    <nav>
        <ul class="pagination pagination-sm">
            <li class="<?= $DisabledPrevious ?>">
                <a data-href="<?= $Previous ?>" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span>
                </a>
            </li>
            <?php
                for($i = 1; $i <= $Pages; $i++){
                    $ActiveClass = "";
                    $cursor = "";
                    if($i == $ActualPage){
                        $ActiveClass = "class='active'";
                        $cursor = "cursor: not-allowed;";
                    }
            ?>
                    <li <?= $ActiveClass ?>><a style="<?= $cursor ?>" data-href="<?= $i ?>"><?= $i ?></a></li>
            <?php } ?>
            <li class="<?= $DisabledNext ?>">
                <a data-href="<?= $Next ?>" aria-label="Next">
                    <span aria-hidden="true">&raquo;</span>
                </a>
            </li>
        </ul>
    </nav>
</div>
<input type="hidden" id="url" value="<?php echo base_url() ?>">
</div>

<?= form_open_multipart('/Misreqoo/GenerarPdf', array("id" => "frmGenerarPdf")) ?>
    <input type="hidden" name="FolioRecibo" id="FolioRecibo" >
<?= form_close() ?>

<div class="modal fade" id="iDescargarRecibo" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #484545;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" style="color:#fff;">Descargar documento</h4>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="btnDescargarRecibo">Descargar</button>
      </div>
    </div>
  </div>
</div>

<script>
    $(function()
    {
        $(".descargar-documento").click(function()
        {
            event.preventDefault();
            $("#FolioRecibo").val($(this).attr("folio"));
            $("#iDescargarRecibo").modal("show");
        })

        $("#btnDescargarRecibo").click(function()
        {
            $("#ObservacionesRecibo").val($("#iObservaciones").val());
            $("#frmGenerarPdf").submit();
            $("#iDescargarRecibo").modal("hide");
            bootbox.alert("El documento se descargara en un momento.");
        })

        $('#Folio').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Requisiciones/AutocompleteFolio/',
                    dataType: "json",
                    data: {
                        term: $("#Folio").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                return false;
            }
        });

    })
</script>


<!-- Este codigo sirve para hacer que el pdf se genere automaticamente despues de haber guardado un folio nuevo
<?php
    if($this->session->flashdata('Folio'))
    {
        $Folio = $this->session->flashdata('Folio');
?>
        <script>
            $("#FolioRecibo").val("<?= $Folio ?>");
            $("#frmGenerarPdfRecibo").submit();
            bootbox.alert("El documento se descargara en un momento.");
        </script>
<?php
    }
?> -->