<?php if($this->session->flashdata('message_details')){?>
    <div class="alert alert-<?= $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
        <?= $this->session->flashdata('message_details') ?>
    </div>
<?php } ?>

<div class="panel panel-uni">
  <div class="panel-heading">
    <h3 class="panel-title">Consultar mis requisiciones a otras oficinas</h3>
  </div>
  <div class="panel-body">
    <div class="row">
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Requisicion:</label> 
            <label><?= $numero ?></label>
            <?php if($Cabeza[0]->status ==9){?>
                <label class="text-danger"> CANCELADA </label>
            <?php } ?>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Fecha:</label> 
            <label><?= $Cabeza[0]->fecha_ini ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Solicitante:</label> 
            <label><?= $Cabeza[0]->usuario."-".$Solicitante ?></label>
        </div>        
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Tipo req:</label> 
            <label><?= $Cabeza[0]->tipo_req ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Tipo prod:</label> 
            <label><?= $Tipopdto ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Almacen:</label> 
            <label><?= $Cabeza[0]->almacen."-".$Almacen ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">A nombre de:</label> 
            <label><?= $Cabeza[0]->to_nombre ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Supervisor:</label> 
            <label><?= $Cabeza[0]->gerente ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Empresa/cliente:</label> 
            <label><?= $Cabeza[0]->to_empresa ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Proyecto:</label> 
            <label><?= $Cabeza[0]->depto ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Gerente proy:</label> 
            <label><?= $Cabeza[0]->gerente_proy."-".$Gerenteproy ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Direccion:</label> 
            <label><?= $Cabeza[0]->to_direcc ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Telefono:</label> 
            <label><?= $Cabeza[0]->to_tel ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">Paqueteria:</label> 
            <label><?= $Cabeza[0]->to_paquete ?></label>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">F. Autorizada:</label> 
            <label><?= $Cabeza[0]->revision_gte ?></label>
        </div>

        <div class="col-md-3 col-sm-6 col-xs-12">
            <label class="label-display-name">F. Almacen:</label>
            <?php if($Cabeza[0]->fecha_sr2 != '1753-01-01 00:00:00' ){ ?>
                <label><?= $Cabeza[0]->fecha_sr2 ?></label>
            <?php }?>
        </div>

    </div>
    
    <div class="row">
        <div class="col-md-offset-2 col-sm-offset-2 col-md-8 col-sm-8 col-xs-12">
            <h4>Partidas en apoyo de la requisicion</h4>
            <div class="table-responsive" style="max-height: 400px;overflow-x: hidden;">
                <table id="tblBoletos" class="table table-hover table-scroll">
                    <thead class="thead-style">
                        <tr>
                            <th>No</th>
                            <th>Clave</th>
                            <th>Descripcion</th>
                            <th>Marca</th>
                            <th>Ofna</th>
                            <th>Cantidad</th>
                            <th>Surtido</th>
                            <th>Pendiente</th>
                            <th>Autorizada</th>
                            <th class="text-center"><span class="glyphicon glyphicon-th-list" style="font-size:15px;color:#43ac6a;"></span></th>
                        </tr>
                    </thead>
                    <tbody class="boletos">
                    <?php
                        foreach($Detalles as $Item){
                         if($Item->apoyo != "00")
                         { 
                            //
                            // Armamos el string con el detalle del surtido
                            //
                            $StringSurtido="";
                            $CantidadSurtida = 0;
                            $CantidadPendiente = 0;
                            foreach($Surtidoreq as $Surtidopartida){
                                 if($Item->partida == $Surtidopartida->partida)
                                 { 
                                    $FechaHoraOriginal =$Surtidopartida->fecha_e;
                                    $FormatoFechaprt = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);
                                    $tmpFecha = $FormatoFechaprt;

                                    $tmpSurtido = $Surtidopartida->surtido;
                                    $CantidadSurtida = $CantidadSurtida + $tmpSurtido;
                                    $tmpGuia = $Surtidopartida->guia_e;
                                    $tmpPaqueteria = $Surtidopartida->paqueteria;
                                    $tmpUnico = $Surtidopartida->unico;
                                    $StringSurtido = $StringSurtido.",".$tmpFecha."~".$tmpSurtido."~".$tmpGuia."~".$tmpPaqueteria."~".$tmpUnico;
                                 }
                            }
                            $CantidadPendiente = $Item->cantapoy - $CantidadSurtida;                            
                    ?>
                        <tr>
                            <td><input type="hidden" value="<?= $Item->partida ?>" id="lstPartida<?= $Item->partida ?>" /> <?= $Item->partida ?></td>
                            <td><input type="hidden" value="<?= $Item->articulo ?>" id="lstClaveArticulo<?= $Item->partida ?>" /> <?= $Item->articulo ?></td>
                            <td><input type="hidden" value="<?= $StringSurtido ?>" id="lstAcumulado<?= $Item->partida ?>" /> <?= $Item->descrip ?></td>
                            <td><?= $Item->marca ?></td>
                            <td><?= $Item->apoyo ?></td>
                            <td><?= $Item->cantapoy ?></td>
                            <td><?= $CantidadSurtida ?></td>
                            <td><?= $CantidadPendiente ?></td>
                             <?php
                             if($Item->autorizada){
                             ?>
                                <td align="center"><span class="glyphicon glyphicon-check" style="font-size:14px;color:black;margin-top: 3px;"></span></td>
                            <?php
                            }else{
                            ?>
                                <td align="center"><span class="glyphicon glyphicon-unchecked" style="font-size:14px;color:black;margin-top: 3px;"></span></td>
                            <?php
                            }
                            ?>
                            <td align="center"><span onclick="Consultarsurtido(this)" row="<?= $Item->partida ?>" class="glyphicon glyphicon-option-horizontal" style="font-size:15px;color:#43ac6a;margin-top: 9px;"></span></td>
                        </tr>
                    <?php }} ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
    
<!--     Este codigo muestra el historial de la bitacora de la requisicion, descomentar en caso de que se desee visualizar    
    <div class="row">
        <div class="col-md-offset-2 col-sm-offset-2 col-md-8 col-sm-8 col-xs-12">
            <h4>Historial</h4>
            <div class="table-responsive">
                <table id="tblHistorial" class="table table-hover">
                    <thead class="thead-style">
                        <tr>
                            <th>Usuario</th>
                            <th style="width:140px;">Fecha</th>
                            <th>Comentario</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        foreach($BitacoraMovimientos as $BitacoraMovimiento){
                    ?>
                        <tr>
                            <td><?= $BitacoraMovimiento->Usuario->UID."-".$BitacoraMovimiento->Usuario->Name ?></td>
                            <td><?= $BitacoraMovimiento->log_fecha ?></td>
                            <td><?= $BitacoraMovimiento->log_evento ?></td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
 -->
 
  </div>
</div>

 
<div class="row" style="margin-top:15px;">
    <div class="col-md-2 col-sm-2 col-xs-12">
        <a href="<?= base_url() ?>Misreqoo" class="btn btn-default" style="width:100%">Volver</a>
    </div>

    <?php
        if($Adjuntos){
    ?>
        <div class="col-md-offset-4 col-sm-offset-2 col-md-2 col-sm-2 col-xs-12">
            <a class="btn btn-info" style="float:right;width:100%" id="btnAdjuntos">Ver adjuntos</a>
        </div>
    <?php
    }
    ?>


<!-- Descomentar estas lineas si se permitira que el gerente pueda cancelar requisiciones completas
     <?php
        if($Cabeza[0]->status == 1){
    ?>
        <div class="col-md-offset-2 col-sm-offset-4 col-md-2 col-sm-2 col-xs-12">
            <a class="btn btn-danger" style="float:right;width:100%" id="btnCancelar">Cancelar</a>
        </div>
    <?php
    }
    ?>
 -->
 
</div>

<?= form_open_multipart('/Misreqoo/Cancel', array("id" => "frmDelete")) ?>
    <input type="hidden" name="Folio" id="Folio" value="<?= $numero ?>">
    <input type="hidden" name="AutorizadoPor" id="AutorizadoPor" value="">
<?php echo form_close() ?>


<!-- Modal para autorizaciones -->
<div class="modal fade" id="mAutorizacion" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #4d4dff;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" style="color: #FFF;">Autorización</h4>
      </div>
      <div class="modal-body">
        <div class="row">
            <div class="col-md-4 col-sm-6 col-xs-12">
                <label class="label-control" for="txbUsuario">Usuario:</label>
                <input type="text" id="txbUsuario" class="form-control" placeholder="Usuario" max-length="4">
            </div>
            <div class="col-md-8 col-sm-6 col-xs-12">
                <label class="label-control" for="txbContrasena">Contraseña:</label>
                <input type="password" id="txbContrasena" class="form-control" placeholder="Contraseña">
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-primary" id="btnAutorizar">Autorizar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal para adjuntos -->
<div class="modal fade" id="mAdjuntos" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #4d4dff;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" style="color: #FFF;">Archivos adjuntos</h4>
      </div>
      <div class="modal-body">
            <div class="table-responsive">
                <table id="tblHistorial" class="table table-hover">
                    <thead class="thead-style">
                        <tr>
                            <th>Archivo</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        foreach($Adjuntos as $Adjunto){
                    ?>
                        <tr>
                            <td><a href="<?= base_url().$Adjunto->urlfile ?>" target="_blank"><?= $Adjunto->nombre ?></a></td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" id="btnCerrarAdjuntos" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal para detalles de surtido -->
    <div class="modal fade bd-example-modal-lg" id="iCaptura" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header" id="Divtitulo" style="background-color: #484545;">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="Titulodetalle" style="color:#fff;"></h4>
          </div>
          <div class="modal-dialog modal-lg">
            <div class="row" style="margin-top:20px;">
                <div class="col-lg-offset-1 col-md-offset-1 col-md-10 col-sm-10 col-xs-10" style="max-height: 400px;overflow-x: hidden;">
                    <table class="table table-bordered text-centered" id="tDetalles" style="margin-left: 10px;">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Surtido</th>
                                <th>Guia</th>
                                <th>Paqueteria</th>                                
                             </tr>
                        </thead>
                        <tbody>
                            <tr id="trd0" row="0">
                                <td>
                                    <input readonly type="text" name="lstSurtido[0][Fecha]" class="form-control datetimepicker" max-length="10" row="0" placeholder="Fecha" id="lstFecha0" />
                                    <input type="hidden" name="lstSurtido[0][Active]" value="true" id="lstSurtidoActive0" />
                                </td>
                                <td>
                                    <input readonly type="text" name="lstSurtido[0][Surtido]" class="form-control numeric-field" max-length="6" row="0" placeholder="Surt" id="lstSurtido0" />
                                </td>
                                <td>
                                    <input readonly type="text" name="lstSurtido[0][Guia]" class="form-control" max-length="12" row="0" placeholder="Guia" id="lstGuia0" />
                                </td>
                                <td>
                                    <input readonly type="text" name="lstSurtido[0][Paqueteria]" class="form-control" max-length="30" row="0" placeholder="Paqueteria" id="lstPaqueteria0" />
                                    <input type="hidden" name="lstSurtido[0][Random]" value="000" id="lstRandom0" />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
          </div>
          <div class="modal-footer">
            <!-- <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button> -->
            <button type="button" class="btn btn-primary" id="btnCerrar">Cerrar</button>
          </div>
        </div>
      </div>
    </div>


<script>
//
    function Consultarsurtido(vElement)
    {
        var vRow = $(vElement).attr("row");
        var vActive = $("#lstActive" + vRow).val();
        var vPartida = $("#lstPartida" + vRow).val();
        var vArticulo = $("#lstClaveArticulo" + vRow).val();

        $('#Divtitulo h4:first').html("Partida: "+vPartida+" Articulo: "+vArticulo);

        // Eliminamos los registros de la tabla tDetalles

        var n=$("#tDetalles > tbody > tr").length;
        for(i=n;i>-1;i--)
        {
            $("#tDetalles tbody tr:eq('"+i+"')").remove();
        };

        // Creamos la tabla con los  registros del req_surt o inicializamos un renglon vacio

        var vSurtidoString = $("#lstAcumulado" + vRow).val();
        var vArraySurtido = vSurtidoString.split(",");
        var vCount = 0;
        var vNewRow ='';
        var vFecha ='';
        var vSurtido ='';
        var vGuia ='';
        var vPaqueteria ='';
        var vRandom = 0;

        if (vSurtidoString !="" && vArraySurtido.length > 0)
        {
            $.each( vArraySurtido, function( index, value ){
                if(value !="")
                {
                    var vArrayRegistro = value.split("~");

                    $.each( vArrayRegistro, function( ind, valor ){
                        //bootbox.alert("Indice: "+ind+" Valor:"+valor);
                        switch (ind) {
                            case 0:
                                vFecha = valor;
                                break;
                            case 1:
                                vSurtido = valor;
                                break;
                            case 2:
                                vGuia = valor;
                                break;
                            case 3:
                                vPaqueteria = valor;
                                break;
                            case 4:
                                vRandom = valor;
                                break;                            
                        }                        
                    });

                    vCount = $("#tDetalles > tbody > tr").length;
                    vNewRow = '<tr id="trd' + vCount + '" row="' + vCount + '">\
                                        <td>\
                                            <input readonly type="text" name="lstSurtido[' + vCount + '][Fecha]" class="form-control datetimepicker"  max-length="10" row="' + vCount + '" placeholder="Fecha" id="lstFecha' + vCount + '" />\
                                        </td>\
                                        <td>\
                                            <input readonly type="text" name="lstSurtido[' + vCount + '][Surtido]" class="form-control numeric-field"  max-length="6" row="' + vCount + '" placeholder="Surt" id="lstSurtido' + vCount + '" />\
                                        </td>\
                                        <td>\
                                            <input readonly type="text" name="lstSurtido[' + vCount + '][Guia]" class="form-control"  max-length="12" row="' + vCount + '" placeholder="Guia" id="lstGuia' + vCount + '" />\
                                        </td>\
                                        <td>\
                                            <input readonly type="text" name="lstSurtido[' + vCount + '][Paqueteria]" class="form-control"  max-length="30" row="' + vCount + '" placeholder="Paqueteria" id="lstPaqueteria' + vCount + '" />\
                                            <input type="hidden" name="lstSurtido[' + vCount + '][Random]" value="'+vRandom+'" id="lstRandom' + vCount + '" />\
                                        </td>\
                                    </tr>';

                    $("#tDetalles > tbody").append(vNewRow);
                    //AsignarFunciones();
                    //
                    // Asignar los valores a cada columna tomandolos del arreglo
                    //
                    $("#lstFecha"+vCount).val(vFecha);
                    $("#lstSurtido"+vCount).val(vSurtido); 
                    $("#lstGuia"+vCount).val(vGuia);
                    $("#lstPaqueteria"+vCount).val(vPaqueteria);  
                }
            });
        }
        $("#iCaptura").modal("show");
    }
//
    var vAutorizado = false;
    $(function()
    {
//
        $("#btnCerrar").click(function(){
            $("#iCaptura").modal("hide");
        })
//        
        $("#txbUsuario").keypress(function()
        {
            if(event.charCode == 13)
            {
                $("#txbContrasena").focus();
            }
        })

        $("#txbContrasena").keypress(function()
        {
            if(event.charCode == 13)
            {
                $("#btnAutorizar").trigger("click");
            }
        })

        $("#btnCancelar").click(function()
        {
            //
            // Antes de cancelar validar si la requisicion tiene ya articulos surtidos
            //
            bootbox.confirm({
                message: "El folio se cancelara, ¿Desea continuar?",
                callback: function(result)
                {
                    if(result)
                    {
                        $("#mAutorizacion").modal("show");
                        setTimeout(function()
                        {
                            $("#txbUsuario").focus();
                        },500)
                    }
                }
            }); 
        })

        $("#btnAdjuntos").click(function()
        {
            $("#mAdjuntos").modal("show");
        })

        $("#btnAutorizar").click(function()
        {
            $("p.loader-gif").text("Verificando...");
            $(".loader-gif").show();
             $.ajax({
                url: $("#url").val() + '/Users/VerificarAutorizacion/',
                dataType: "json",
                data: {
                    Usuario: $("#txbUsuario").val(),
                    Contrasena: $("#txbContrasena").val(),
                    Controlador: "Requisiciones",
                    Accion: "Delete"
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data.length == 0)
                    {
                        vAutorizado = true;
                        $("#mAutorizacion").modal("hide");
                        $("#AutorizadoPor").val($("#txbUsuario").val());
                        $("#frmDelete").submit();

                    }else
                    {
                        bootbox.alert(data);
                        $(".loader-gif").hide();
                    }
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
        })

        $("#frmDelete").submit(function()
        {
            return vAutorizado;
        })

    })
</script>
