<?php 
    $IdUsuario = $this->session->UID;
?>
    <?php if($this->session->flashdata('message_index')){?>
        <div class="alert alert-<?php echo $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            <?php echo $this->session->flashdata('message_index') ?>
        </div>
    <?php } ?>

    <div class="row">
        <input type="hidden" name="Userloged" id="Userloged" value="<?= $IdUsuario ?>" >
        <div class="col-md-8 col-sm-8 col-xs-12">
            <h2><?= $title ?></h2>
        </div>
    </div>
    <div class="row">
        <?= form_open('/Consultaxfolio/Index/') ?>
        <input type="hidden" name="Page" id="Page" value="<?= $ActualPage ?>" >
        <div class="col-md-2 col-sm-6 col-xs-12">
            <input type="text" id="Folio" name="Folio" class="form-control" placeholder="Folio" value="<?= set_value("Folio") ?>" />
        </div>
            <div class="col-md-2 col-sm-4 col-xs-12">
            <input type="submit" id="btnFilter" class="btn btn-default" style="width:100%" value="Mostrar en lista" />
        </div>
        <div class="col-md-2 col-sm-6 col-xs-12">
            <a href="<?= base_url() ?>Consultaxfolio/Index/" class="btn btn-info" style="width:100%">Limpiar</a>
        </div>        
        <?= form_close() ?>
    </div>
    <div class="row" style="margin-top:15px;">
        <div class="table-responsive">
        <table id="tblUsers" class="table table-hover">
        <thead class="thead-style">
        <tr>
            <th>Folio</th>
            <th>Tipo</th>
            <th>Productos</th>
            <th>Almacen</th>
            <th>Fecha</th>
            <th>Procesado por:</th>
            <th></th>
            <th></th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        <?php
            foreach($CabezaRequisiciones as $Movimiento){
                if($Movimiento->tipo == 0){
                    $Producto = "LLANTAS";
                }else{
                    $Producto = "VARIOS";
                }
                switch ($Movimiento->status) {
                    case 1:
                        $Modoestado ="";
                        if($Movimiento->revision_gte !="0000-00-00 00:00:00"){
                            $Modoestado ="Autorizacion gerente";
                        }
                        break;
                    case 2:
                        $Modoestado ="Almacen";
                        break;
                    case 3:
                        $Modoestado ="Almacen/Compras";
                        break;
                    default:
                        $Modoestado ="";
                        break;
                }                
        ?>
        <tr>
            <td><?= $Movimiento->numero ?></td>
            <td><?= $Movimiento->tipo_req ?></td>
            <td><?= $Producto ?></td>
            <td><?= $Movimiento->almacen ?></td>
            <td><?= $Movimiento->fecha_ini ?></td>
            <td><?= $Modoestado ?></td>
            <td>
                <?php if($Movimiento->status ==9){ ?>
                   <a class="text-danger"> Cancelada </a>
                <?php }?>
            </td>
            <td><a href="#" class="descargar-documento" folio="<?= $Movimiento->numero ?>" style="color: #000">Descargar</a></td>
            <td>
                <?php if(VerificarPermisos($IdUsuario, "Consultaxfolio", "Details")){ ?>
                <a href="<?= base_url() ?>Consultaxfolio/Details/<?= $Movimiento->numero.'/'.$ActualPage ?>" style="color: #000">Detalles</a>
                <?php } ?>
            </td>  
        </tr>
        <?php } ?>
        </tbody>
    </table>
    <?php
        $Previous = $ActualPage - 1;
        $Next = $ActualPage + 1;
        $DisabledPrevious = "";
        $DisabledNext = "";
        if($Previous <= 0){
            $Previous = "";
            $DisabledPrevious = "disabled";
        }

        if($Next > $Pages){
            $Next = "";
            $DisabledNext = "disabled";
        }
    ?>
    <nav>
        <ul class="pagination pagination-sm">
            <li class="<?= $DisabledPrevious ?>">
                <a data-href="<?= $Previous ?>" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span>
                </a>
            </li>
            <?php
                for($i = 1; $i <= $Pages; $i++){
                    $ActiveClass = "";
                    $cursor = "";
                    if($i == $ActualPage){
                        $ActiveClass = "class='active'";
                        $cursor = "cursor: not-allowed;";
                    }
            ?>
                    <li <?= $ActiveClass ?>><a style="<?= $cursor ?>" data-href="<?= $i ?>"><?= $i ?></a></li>
            <?php } ?>
            <li class="<?= $DisabledNext ?>">
                <a data-href="<?= $Next ?>" aria-label="Next">
                    <span aria-hidden="true">&raquo;</span>
                </a>
            </li>
        </ul>
    </nav>
</div>
<input type="hidden" id="url" value="<?php echo base_url() ?>">
</div>

<?= form_open_multipart('/Consultaxfolio/GenerarPdf', array("id" => "frmGenerarPdf")) ?>
    <input type="hidden" name="FolioRecibo" id="FolioRecibo" >
<?= form_close() ?>

<div class="modal fade" id="iDescargarRecibo" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #484545;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" style="color:#fff;">Descargar documento</h4>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="btnDescargarRecibo">Descargar</button>
      </div>
    </div>
  </div>
</div>

<script>
    $(function()
    {
        $(".descargar-documento").click(function()
        {
            event.preventDefault();
            $("#FolioRecibo").val($(this).attr("folio"));
            $("#iDescargarRecibo").modal("show");
        })

        $("#btnDescargarRecibo").click(function()
        {
            $("#ObservacionesRecibo").val($("#iObservaciones").val());
            $("#frmGenerarPdf").submit();
            $("#iDescargarRecibo").modal("hide");
            bootbox.alert("El documento se descargara en un momento.");
        })

        $('#Folio').autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: $("#url").val() + '/Consultaxfolio/AutocompleteFolio/',
                    dataType: "json",
                    data: {
                        term: $("#Folio").val()
                    },
                    type: "GET",
                    contentType: 'application/json; charset=utf-8',
                    success: function (data) {
                        response($.map(data, function (item) {
                            return {
                                value: item.value,
                                label: item.label
                            }
                        }));
                    },
                    error: function (error) {
                        alert(error.responseText);
                    }
                });
            },
            select: function (event, ui) {
                $(this).val(ui.item.label);
                return false;
            }
        });

    })
</script>