<?php if($this->session->flashdata('message_create')){?>
    <div class="alert alert-<?= $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
        <?= $this->session->flashdata('message_create') ?>
    </div>
<?php } ?>
<?= form_open_multipart('/Articulos/ImportarArticulosPost', array("id" => "frmCreate", "enctype" => "multipart/form-data")) ?>

<div class="panel panel-uni">
  <div class="panel-heading">
    <h3 class="panel-title">Importar articulos</h3>
  </div>
  <div class="panel-body">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">

            <p>
                Este proceso admite importar los articulos desde un archivo de Excel. Este archivo debe contener las siguientes 5 columnas con sus encabezados:            </p>
            <p>
                *Columna A: Clave del articulo con 16 caracteres maximo (la clave no debe contener espacios al inicio o al final)
            </p>
            <p>
                *Columna B: Descripcion del articulo con 80 caracteres maximo
            </p>
            <p>
                *Columna C: Marca del articulo con 30 caracteres maximo
            </p>
            <p>
                *Columna D: Unidad de medida con 10 caracteres maximo
            </p>
            <p>
                *Columna E: Clave de la categoria con 5 caracteres maximo. Asegurese de que todas las categorias esten registradas en el sistema
                 para que los articulos puedan tomar correctamente el tipo (VARIOS O LLANTAS)
            </p>
            <p>
                *Columna F: Clave equivalente del articulo con 20 caracteres maximo (la clave no debe contener espacios al inicio o al final)
            </p>
            <p>
                *En ningun caso estos campos deben contener caracteres reservados como comillas simples, comillas dobles, asi como los caracteres:
                %, &, /, \, /n                
            </p>
            <p>
                Se actualizara la informacion de los articulos que ya existan y se agregaran los nuevos.
            </p>

        </div>

        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label" for="Archivo">Archivo excel:</label>
            <input type="file" accept=".xls,.xlsx" name="Archivo" id="Archivo" class="form-control required-field">
            <input type="hidden" name="hdControl" id="hdControl" value="000">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

    </div>
  </div>
</div>
        
    <div class="row" style="margin-top:15px;">
        <div class="col-md-offset-10 col-sm-offset-9 col-xs-offset-6 col-md-2 col-sm-3 col-xs-6">
            <button type="button" id="btnSave" class="btn btn-success" style="float: right;width:100%;">Importar articulos</button>
        </div>
    </div>
<?= form_close() ?>
<script>

    $(function()
    {

        $("#btnSave").click(function()
        {
            $("#frmCreate").submit();    
        })

        $("#frmCreate").submit(function()
        {
            $("#hdTriedSave").val("true");
            var vSubmit = true;
            $(".required-field").each(function()
            {
                if($(this).val().trim().length == 0)
                {
                    vSubmit = false;
                    $(this).parent().addClass("has-error");
                    $(this).next().show();
                }
            })
            if(vSubmit)
            {
                $("p.loader-gif").text("Espere, importando articulos...");
                $(".loader-gif").show();
            }
            return vSubmit;
        })
    })
</script>