<?php if($this->session->flashdata('message_edit')){?>
    <div class="alert alert-<?= $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
        <?= $this->session->flashdata('message_edit') ?>
    </div>
<?php } ?>
<?= form_open_multipart('/Articulos/EditPost', array("id" => "frmEdit")) ?>
<?php
    $Articulo->descrip = set_value("Nombre") != "" ? set_value("Nombre") : $Articulo->descrip;
    $Articulo->marca = set_value("Marca") != "" ? set_value("Marca") : $Articulo->marca;
    $Articulo->umed = set_value("Umed") != "" ? set_value("Umed") : $Articulo->umed;
    $Articulo->tipo = set_value("Tipo") != "" ? set_value("Tipo") : $Articulo->tipo;
    $Articulo->categoria = set_value("Clavecategoria") != "" ? set_value("Clavecategoria") : $Articulo->categoria;
?>
<input type="hidden" name="Clave" id="Clave" value="<?= $Articulo->clave ?>">
<div class="panel panel-uni">
  <div class="panel-heading">
    <h3 class="panel-title">Editar articulo</h3>
  </div>
  <div class="panel-body">
    <div class="row">
        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Clave">Clave:</label>
            <input type="text" value="<?= $Articulo->clave ?>" placeholder="Clave" class="form-control" disabled>
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Claveeq">Clave equivalente:</label>
            <input type="text" value="<?= $Articulo->clave_eq ?>" placeholder="Clave eq" class="form-control" disabled>
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Nombre">Nombre:</label>
            <input type="text" name="Nombre" id="Nombre" value="<?= $Articulo->descrip ?>" placeholder="Nombre" class="form-control required-field" max-length="80">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Marca">Marca:</label>
            <input type="text" name="Marca" id="Marca" value="<?= $Articulo->marca ?>" placeholder="Marca" class="form-control required-field" max-length="30">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Umed">Unidad de medida:</label>
            <input type="text" name="Umed" id="Umed" value="<?= $Articulo->umed ?>" placeholder="Umed" class="form-control required-field" max-length="10">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label" for="txbClavecategoria">Categoria:</label>
             <div class="row">
                <div class="col-md-4 col-sm-4 col-xs-4">
                    <input type="text" id="txbClavecategoria" max-length="5" value="<?= $Articulo->categoria ?>" class="form-control required-field fill" placeholder="Clave">
                </div>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <?php
                        $Options = array(
                            "" => "Seleccionar opción"
                        );
                        foreach($Categorias as $Categoria)
                        {
                            $Options[$Categoria->clave] = $Categoria->nombre;
                        }
                    ?>
                    <?= form_dropdown(array('name' => 'Clavecategoria','id' => 'Clavecategoria', 'class' => 'form-control required-field'),$Options, $Articulo->categoria) ?>
                </div>
            </div>
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-2 col-sm-2 col-xs-12">
            <label class="control-label" for="Tipo">Tipo:</label>
            <input readonly type="text" name="Tipo" id="Tipo" value="<?= $Articulo->tipo ?>" placeholder="Tipo" class="form-control" max-length="10">
        </div>

    </div>
     <div class="audit-fields" style="margin-top: 15px;">
        <div class="row">
            <div class="col-md-6 col-sm-6 col-xs-12">
                <label>Creado por: <?= $Createdby ?></label>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-12">
                <label>Fecha de creación: <?= $Articulo->CreatedDate ?></label>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 col-sm-6 col-xs-12">
                <label>Modificado por: <?= $Updatedby ?></label>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-12">
                <label>Fecha de modificación: <?= $Articulo->UpdatedDate ?></label>
            </div>
        </div>
    </div>
  </div>
</div>
        
    <div class="row" style="margin-top:15px;">
        <div class="col-md-2 col-sm-3 col-xs-6">
            <a href="<?= base_url() ?>Articulos" class="btn btn-default" style="width:100%;">Volver</a>
        </div>
        <div class="col-md-offset-8 col-sm-offset-6 col-md-2 col-sm-3 col-xs-6">
            <?php echo form_submit(array("value" => "Guardar", "class" => "btn btn-success", 'style' => 'float: right;width:100%;')) ?>
        </div>
    </div>
<?php echo form_close() ?>


<script>

    function SelectCategoria()
    {
        var vFound = false;
        $("#Clavecategoria option").each(function()
        {
            if($(this).val() == $("#txbClavecategoria").val())
            {
                $(this).prop("selected", true);
                $("#Clavecategoria").parent().parent().parent().removeClass("has-error");
                $("#Clavecategoria").parent().removeClass("has-error");
                $("#Clavecategoria").parent().parent().next().hide();
                vFound = true;
            }
        })
        if(!vFound)
        {
            $("#Clavecategoria").val("");
        }
    }

    $(function()
    {

        $("#txbClavecategoria").keypress(function(event)
        {
            if(event.charCode == 13)
            {
                SelectCategoria();
            }
        })

        $("#txbClavecategoria").change(function()
        {
            $.ajax({
                url: $("#url").val() + '/Categorias/GetByClave/',
                dataType: "json",
                data: {
                    ClaveCategoria: $(this).val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No existe la categoria con clave: " + $(this).val(),
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#txbClavecategoria").val("").focus();
                                    $("#Tipo").val("");
                                },100)
                            }
                        })
                    }
                    if(data != null)
                    {
                        $("#Tipo").val(data.tipo);
                    }
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });
            SelectCategoria();
        })

        $("#Clavecategoria").change(function()
        {
            $("#txbClavecategoria").val($(this).val());
            $.ajax({
                url: $("#url").val() + '/Categorias/GetByClave/',
                dataType: "json",
                data: {
                    ClaveCategoria: $(this).val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No existe la categoria con clave: " + $(this).val(),
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#txbClavecategoria").val("").focus();
                                    $("#Tipo").val("");
                                },100)
                            }
                        })
                    }
                    if(data != null)
                    {
                        $("#Tipo").val(data.tipo);
                    }
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });        
        })    

        $("#frmEdit").submit(function()
        {
            $("#hdTriedSave").val("true");
            var vSubmit = true;
            $(".required-field").each(function()
            {
                if($(this).val().trim().length == 0)
                {
                    vSubmit = false;
                    $(this).parent().addClass("has-error");
                    $(this).next().show();
                }
            })

            if(vSubmit)
                $(".loader-gif").show();
            return vSubmit;
        })
    })
</script>