<?php if($this->session->flashdata('message_create')){?>
    <div class="alert alert-<?= $this->session->flashdata('class') ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
        <?= $this->session->flashdata('message_create') ?>
    </div>
<?php } ?>
<?= form_open_multipart('/Articulos/CreatePost', array("id" => "frmCreate")) ?>

<div class="panel panel-uni">
  <div class="panel-heading">
    <h3 class="panel-title">Crear nuevo articulo</h3>
  </div>
  <div class="panel-body">
    <div class="row">
        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Clave">Clave:</label>
            <input type="text" name="Clave" id="Clave" value="<?= set_value("Clave") ?>" placeholder="Clave" class="form-control required-field" max-length="16">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Claveeq">Clave equivalente:</label>
            <input type="text" name="Claveeq" id="Claveeq" value="<?= set_value("Claveeq") ?>" placeholder="Clave eq" class="form-control required-field" max-length="20">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Nombre">Nombre:</label>
            <input type="text" name="Nombre" id="Nombre" value="<?= set_value("Nombre") ?>" placeholder="Nombre" class="form-control required-field" max-length="80">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Marca">Marca:</label>
            <input type="text" name="Marca" id="Marca" value="<?= set_value("Marca") ?>" placeholder="Marca" class="form-control required-field" max-length="30">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-4 col-sm-6 col-xs-12">
            <label class="control-label" for="Umed">Unidad de medida:</label>
            <input type="text" name="Umed" id="Umed" value="<?= set_value("Umed") ?>" placeholder="Umed" class="form-control required-field" max-length="10">
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-6 col-sm-6 col-xs-12">
            <label class="control-label" for="txbClavecategoria">Categoria:</label>
             <div class="row">
                <div class="col-md-4 col-sm-4 col-xs-4">
                    <input type="text" id="txbClavecategoria" max-length="5" value="<?= set_value("Clavecategoria") ?>" class="form-control required-field fill" placeholder="Clave">
                </div>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <?php
                        $Options = array(
                            "" => "Seleccionar opción"
                        );
                        foreach($Categorias as $Categoria)
                        {
                            $Options[$Categoria->clave] = $Categoria->nombre;
                        }
                    ?>
                    <?= form_dropdown(array('name' => 'Clavecategoria','id' => 'Clavecategoria', 'class' => 'form-control required-field'),$Options, set_value("Clavecategoria")) ?>
                </div>
            </div>
            <label class="control-label" style="display:none;">Este campo es obligatorio</label>
        </div>

        <div class="col-md-2 col-sm-2 col-xs-12">
            <label class="control-label" for="Tipo">Tipo:</label>
            <input readonly type="text" name="Tipo" id="Tipo" value="<?= set_value("Tipo") ?>" placeholder="Tipo" class="form-control" max-length="10">
        </div>

    </div>
  </div>
</div>
        
    <div class="row" style="margin-top:15px;">
        <div class="col-md-2 col-sm-3 col-xs-6">
            <a href="<?= base_url() ?>Articulos" class="btn btn-default" style="width:100%;">Volver</a>
        </div>
        <div class="col-md-offset-8 col-sm-offset-6 col-md-2 col-sm-3 col-xs-6">
            <?php echo form_submit(array("value" => "Guardar", "class" => "btn btn-success", 'style' => 'float: right;width:100%;')) ?>
        </div>
    </div>
<?php echo form_close() ?>


<script>

    function SelectCategoria()
    {
        var vFound = false;
        $("#Clavecategoria option").each(function()
        {
            if($(this).val() == $("#txbClavecategoria").val())
            {
                $(this).prop("selected", true);
                $("#Clavecategoria").parent().parent().parent().removeClass("has-error");
                $("#Clavecategoria").parent().removeClass("has-error");
                $("#Clavecategoria").parent().parent().next().hide();
                vFound = true;
            }
        })
        if(!vFound)
        {
            $("#Clavecategoria").val("");
        }
    }

    $(function()
    {

        $("#txbClavecategoria").keypress(function(event)
        {
            if(event.charCode == 13)
            {
                SelectCategoria();
            }
        })

        $("#txbClavecategoria").change(function()
        {
            SelectCategoria();
            $.ajax({
                url: $("#url").val() + '/Categorias/GetByClave/',
                dataType: "json",
                data: {
                    ClaveCategoria: $(this).val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No existe la categoria con clave: " + $(this).val(),
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#txbClavecategoria").val("").focus();
                                    $("#Tipo").val("");
                                },100)
                            }
                        })
                    }
                    if(data != null)
                    {
                        $("#Tipo").val(data.tipo);
                    }
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });           
        })

        $("#Clavecategoria").change(function()
        {
            $("#txbClavecategoria").val($(this).val());
            $.ajax({
                url: $("#url").val() + '/Categorias/GetByClave/',
                dataType: "json",
                data: {
                    ClaveCategoria: $(this).val()
                },
                type: "GET",
                contentType: 'application/json; charset=utf-8',
                success: function (data) {
                    if(data == null)
                    {
                        bootbox.alert({
                            message: "No existe la categoria con clave: " + $(this).val(),
                            callback: function () {
                                setTimeout(function()
                                {
                                    $("#txbClavecategoria").val("").focus();
                                    $("#Tipo").val("");
                                },100)
                            }
                        })
                    }
                    if(data != null)
                    {
                        $("#Tipo").val(data.tipo);
                    }
                    $(".loader-gif").hide();
                },
                error: function (error) {
                    bootbox.alert(error.responseText);
                }
            });        
        })    

        $("#frmCreate").submit(function()
        {
            $("#hdTriedSave").val("true");
            var vSubmit = true;

            $(".required-field").each(function()
            {
                if($(this).val().trim().length == 0)
                {
                    vSubmit = false;
                    $(this).parent().addClass("has-error");
                    $(this).next().show();
                }
            })
            if(vSubmit)
                $(".loader-gif").show();
            return vSubmit;
        })
    })
</script>