<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Seg_oc_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($DetalleOc){
        return $this->db->insert('seg_oc',$DetalleOc);
    }

    function Update($DetalleOc){
        $this->db->where('numero', $DetalleOc['numero']);
        $this->db->where('partida', $DetalleOc['partida']);
        return $this->db->update('seg_oc', $DetalleOc);
    }

    function BorrarPorFolioPartida($Folio,$Partida)
    {
        $this->db->where('numero', $Folio);
        $this->db->where('partida', $Partida);
        $this->db->delete('seg_oc');
    }

    function ObtenerListaPorFolioPartida($Folio,$Partida)
    {
        $this->db->select('*');
        //$this->db->like('numero', $Folio);
        //$this->db->like('partida', $Partida);
        $this->db->where('numero', $Folio);
        $this->db->where('partida', $Partida);
        $this->db->order_by('fecha');
        $Query = $this->db->get('seg_oc');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['fecha'] = $row->fecha;
                $new_row['factura'] = $row->factura;
                $new_row['comentario'] = $row->comentario;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function ObtenerDatosFactura($Folio,$Partida){
        $this->db->select('*');
        $this->db->from('seg_oc');
        $this->db->where('numero', $Folio);
        $this->db->where('partida', $Partida);
        $this->db->where('factura <>', '');
        $this->db->limit(1);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function GetLastComment($Folio,$Partida){
        $this->db->select('*');
        $this->db->from('seg_oc');
        $this->db->where('numero', $Folio);
        $this->db->where('partida', $Partida);
        $this->db->where('comentario <>', '');
        $this->db->order_by("fecha", "DESC");
        $this->db->limit(1);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

}
?>