<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Req_soo_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($DetalleSoo){
        return $this->db->insert('req_soo',$DetalleSoo);
    }

    function Update($DetalleSoo){
        $this->db->where('numero', $DetalleSoo['numero']);
        $this->db->where('partida', $DetalleSoo['partida']);
        return $this->db->update('req_soo', $DetalleSoo);
    }

    function BorrarPorFolio($Folio)
    {
        $this->db->where('numero', $Folio);
        $this->db->delete('req_soo');
    }

    function ObtenerListaPorFolio($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_soo');
        $this->db->where('numero', $Folio);
        $this->db->order_by("fecha_e", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaParaReporteEnvios($Folio,$FechaI,$FechaF)
    {
        $this->db->select('*');
        $this->db->from('req_soo');
        $this->db->where('numero', $Folio);
        $this->db->where('fecha_e >=', $FechaI);
        $this->db->where('fecha_e <=', $FechaF);
        $this->db->order_by("partida,fecha_e", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerFechaPorFolioPartida($Folio,$Partida)
    {
        $this->db->select('*');
        $this->db->from('req_soo');
        $this->db->where('numero', $Folio);
        $this->db->where('partida', $Partida);
        $this->db->order_by("fecha_e", "DESC");
        $this->db->limit(1);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function ObtenerSurtidoRequisicionPartida($Folio,$Partida)
    {
        $Sooido = 0;

        $this->db->select_sum('surtido');
        $this->db->from('req_soo');
        $this->db->where('numero', $Folio);
        $this->db->where('partida', $Partida);
        $Query = $this->db->get();
        $Result = $Query->row();
        $Surtido = $Result ? intval($Result->surtido) : 0;

        return $Surtido;
    }

    function ObtenerUltimaGuiaFechaEmb($Numeroreq,$Partida)
    {
        $this->db->select('*');
        $this->db->from('req_soo');
        $this->db->where('numero', $Numeroreq);
        $this->db->where('partida', $Partida);
        $this->db->order_by("fecha_e", "DESC");

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }
}
?>