<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Req_order_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($DetalleRequisicion){
        return $this->db->insert('req_order',$DetalleRequisicion);
    }

    function Update($DetalleRequisicion){
        $this->db->where('numero', $DetalleRequisicion['numero']);
        $this->db->where('partida', $DetalleRequisicion['partida']);
        return $this->db->update('req_order', $DetalleRequisicion);
    }

    function BorrarPorFolio($Folio)
    {
        $this->db->where('numero', $Folio);
        $this->db->delete('req_order');
    }

    function ObtenerListaPorFolio($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_order');
        $this->db->where('numero', $Folio);
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioPartida($Folio,$Partida)
    {
        $this->db->select('*');
        $this->db->from('req_order');
        $this->db->where('numero', $Folio);
        $this->db->where('partida', $Partida);
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function ObtenerCompradorPorFolio($Folio)
    {
        $this->db->select('usuario');
        $this->db->from('req_order');
        $this->db->where('numero', $Folio);
        $this->db->limit(1);
        $Query = $this->db->get();
        $Result = $Query->row();
        $Comprador = $Result ? $Result->usuario : "";
        return $Comprador;
    }

}
?>