<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Req_head_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($CabezaRequisicion){
        return $this->db->insert('req_head',$CabezaRequisicion);
        $this->db->query('UNLOCK TABLES');
    }

    function Update($CabezaRequisicion){
        $this->db->where('numero', $CabezaRequisicion['numero']);
        return $this->db->update('req_head', $CabezaRequisicion);
    }

    function Bloquear(){
        $this->db->query('LOCK TABLE req_head WRITE');
    }

    function Desbloquear(){
        $this->db->query('UNLOCK TABLES');
    }

    function ObtenerUltimoFolio()
    {
        $this->db->select('max(convert(numero,signed)) as maxnum');
        $this->db->from('req_head');
        $Query = $this->db->get();
        $Result = $Query->row();
        $Folio = $Result ? intval($Result->maxnum) + 1 : 1;
        return $Folio;
    }

    function GetAll($Page, $Folio, $UID){
        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        if($UID=='0091'){
            $this->db->where('req_head.usuario = "0091" or req_head.usuario = "65"');
        }else{
            $this->db->where('req_head.usuario', $UID);
        }
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        //$this->db->order_by("req_head.fecha_ini", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPages($Page, $Folio, $UID){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        $this->db->where('req_head.usuario', $UID);
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        //$this->db->order_by("req_head.fecha_ini", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function GetAllcxf($Page, $Folio){
        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('req_head.numero', $Folio);
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPagescxf($Page, $Folio){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('req_head.numero', $Folio);
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function GetAllGte($Page, $Folio, $Fechai, $Fechaf, $Almacen, $UID){
        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        $this->db->where('req_head.gerente_proy', $UID);
        if($Fechai !='' && $Fechai !=null && $Fechai != '1753-01-01 00:00:00'){
            $this->db->where('req_head.fecha_sr2 >= ', $Fechai);
            $this->db->where('req_head.fecha_sr2 <= ', $Fechaf);
        }        
        if($Almacen !=''){
            $this->db->where('req_head.almacen', $Almacen);
        }
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPagesGte($Page, $Folio, $Fechai, $Fechaf, $Almacen, $UID){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        $this->db->where('req_head.gerente_proy', $UID);
        if($Fechai !='' && $Fechai !=null && $Fechai != '1753-01-01 00:00:00'){
            $this->db->where('req_head.fecha_sr2 >= ', $Fechai);
            $this->db->where('req_head.fecha_sr2 <= ', $Fechaf);
        }        
        if($Almacen !=''){
            $this->db->where('req_head.almacen', $Almacen);
        }
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function GetAllAlm($Page, $Folio, $Oficina){
        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        $this->db->where('req_head.ofna', $Oficina);
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPagesAlm($Page, $Folio, $Oficina){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        $this->db->where('req_head.ofna', $Oficina);
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function GetAllCom($Page, $Folio, $Oficina){
        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        $this->db->where('req_head.ofna', $Oficina);
        $this->db->where('req_head.status', 3);
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPagesCom($Page, $Folio, $Oficina){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->like('req_head.numero', $Folio);
        $this->db->where('req_head.ofna', $Oficina);
        $this->db->where('req_head.status', 3);
        $this->db->group_by('req_head.numero');
        $this->db->order_by("CAST(numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function GetAllAlmoo($Page, $Folio, $Oficina){

        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('distinct(req_deta.numero) as numero ,MAX(req_deta.fecha_e) as fecha_e, req_head.tipo, req_head.almacen, req_head.status, req_head.fecha_sr2, req_head.tipo_req, req_head.apoyo as ofnaapoyo');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->like('req_deta.numero', $Folio);
        $this->db->where('req_deta.apoyo', $Oficina);
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPagesAlmoo($Page, $Folio, $Oficina){
        $this->db->select('distinct(req_deta.numero) as numero ,MAX(req_deta.fecha_e) as fecha_e, req_head.tipo, req_head.almacen, req_head.status, req_head.fecha_sr2, req_head.tipo_req, req_head.apoyo as ofnaapoyo');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->like('req_deta.numero', $Folio);
        $this->db->where('req_deta.apoyo', $Oficina);
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function GetAllComoo($Page, $Folio, $Oficina){

        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('distinct(req_deta.numero) as numero ,MAX(req_deta.fecha_e) as fecha_e, req_head.status, req_head.fecha_sr2, req_head.fecha_sr3, req_head.almacen, req_head.tipo_req as tipo');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->like('req_deta.numero', $Folio);
        $this->db->where('req_deta.apoyo', $Oficina);
        $this->db->where('req_deta.cntcompapy >', 0);
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPagesComoo($Page, $Folio, $Oficina){
        $this->db->select('distinct(req_deta.numero) as numero ,MAX(req_deta.fecha_e) as fecha_e, req_head.status, , req_head.fecha_sr3, req_head.fecha_sr3, req_head.almacen, req_head.tipo_req as tipo');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->like('req_deta.numero', $Folio);
        $this->db->where('req_deta.apoyo', $Oficina);
        $this->db->where('req_deta.cntcompapy >', 0);
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }
//
    function GetAllMisreqoo($Page, $Folio, $Fechai, $Fechaf, $Almacen, $Oficina){

        $PerPage = 20;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('distinct(req_deta.numero) as numero , req_deta.apoyo, req_head.status, req_head.fecha_sr2, req_head.ofna, req_head.tipo_req, req_head.almacen');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->like('req_deta.numero', $Folio);
        $this->db->where('req_head.ofna', $Oficina);
        if($Fechai !='' && $Fechai !=null && $Fechai != '1753-01-01 00:00:00'){
            $this->db->where('req_head.fecha_sr2 >= ', $Fechai);
            $this->db->where('req_head.fecha_sr2 <= ', $Fechaf);
        }        
        if($Almacen !=''){
            $this->db->where('req_head.almacen', $Almacen);
        }
        $this->db->where('req_deta.apoyo <>', "00");
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPagesMisreqoo($Page, $Folio, $Fechai, $Fechaf, $Almacen, $Oficina){
        $this->db->select('distinct(req_deta.numero) as numero , req_deta.apoyo, req_head.status, req_head.fecha_sr2, req_head.ofna, req_head.tipo_req, req_head.almacen');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->like('req_deta.numero', $Folio);
        $this->db->where('req_head.ofna', $Oficina);
        if($Fechai !='' && $Fechai !=null && $Fechai != '1753-01-01 00:00:00'){
            $this->db->where('req_head.fecha_sr2 >= ', $Fechai);
            $this->db->where('req_head.fecha_sr2 <= ', $Fechaf);
        }        
        if($Almacen !=''){
            $this->db->where('req_head.almacen', $Almacen);
        }
        $this->db->where('req_deta.apoyo <>', "00");
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/20;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }
//
    function SearchByFolio($Folio){
        $this->db->select('*');
        $this->db->like('numero', $Folio);
        $this->db->group_by('numero');
        $this->db->limit(10);
        $Query = $this->db->get('req_head');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->numero;
                $new_row['value'] = $row->numero;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function ObtenerCabezaPorFolio($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('numero', $Folio);

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function GetByFolio($Folio){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('numero', $Folio);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function ReporteRequisiciones($Tiporep,$ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaInicial,$FechaFinal){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('almacen >=', $ClaveAlmacenI);
        $this->db->where('almacen <=', $ClaveAlmacenF);
        $this->db->where('ofna >=', $ClaveOficinaI);
        $this->db->where('ofna <=', $ClaveOficinaF);
        $this->db->where('fecha_ini >=', $FechaInicial);
        $this->db->where('fecha_ini <=', $FechaFinal);

        switch ($Tiporep) {
            case 1:
                $this->db->where('status', 1);
                $this->db->where('tipo_req', 'REPOSICION'); 
                $this->db->where('revision_gte', '0000-00-00 00:00:00'); 
                break;
            case 2:
                $this->db->where('status', 1);
                $this->db->where('(tipo_req="VENTA" or (tipo_req="REPOSICION" and revision_gte<>"0000-00-00 00:00:00"))'); 
                break;
            case 3:
                $this->db->where('status', 2);
                break;
            case 4:
                $this->db->where('status', 3);
                break;
            case 5:
                break;
        }

/*        if($TipoEstatus !=0){
            $this->db->where('status', $TipoEstatus); 
            if($Autorizadas){
                $this->db->where('revision_gte <>', '0000-00-00 00:00:00'); 
            }else{
                $this->db->where('revision_gte', '0000-00-00 00:00:00');
            }
        }*/
        
        $Query = $this->db->get();
        return $Query->result();
    }

    function ReporteCompras($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaInicial,$FechaFinal){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('almacen >=', $ClaveAlmacenI);
        $this->db->where('almacen <=', $ClaveAlmacenF);
        $this->db->where('ofna >=', $ClaveOficinaI);
        $this->db->where('ofna <=', $ClaveOficinaF);
        $this->db->where('fecha_sr3 >=', $FechaInicial);
        $this->db->where('fecha_sr3 <=', $FechaFinal);

        $Query = $this->db->get();
        return $Query->result();
    }

    function ReportePensur($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaInicial,$FechaFinal){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('almacen >=', $ClaveAlmacenI);
        $this->db->where('almacen <=', $ClaveAlmacenF);
        $this->db->where('ofna >=', $ClaveOficinaI);
        $this->db->where('ofna <=', $ClaveOficinaF);
        $this->db->where('fecha_ini >=', $FechaInicial);
        $this->db->where('fecha_ini <=', $FechaFinal);

        $Query = $this->db->get();
        return $Query->result();
    }

    function ReportePeninf($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaInicial,$FechaFinal){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('almacen >=', $ClaveAlmacenI);
        $this->db->where('almacen <=', $ClaveAlmacenF);
        $this->db->where('ofna >=', $ClaveOficinaI);
        $this->db->where('ofna <=', $ClaveOficinaF);
        $this->db->where('fecha_ini >=', $FechaInicial);
        $this->db->where('fecha_ini <=', $FechaFinal);

        $Query = $this->db->get();
        return $Query->result();
    }

    function ReportePensureo($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaInicial,$FechaFinal){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('almacen >=', $ClaveAlmacenI);
        $this->db->where('almacen <=', $ClaveAlmacenF);
        $this->db->where('apoyo >=', $ClaveOficinaI);
        $this->db->where('apoyo <=', $ClaveOficinaF);
        $this->db->where('fecha_sr2 >=', $FechaInicial);
        $this->db->where('fecha_sr2 <=', $FechaFinal);

        $Query = $this->db->get();
        return $Query->result();
    }

    function GetNewAlm($Oficina){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('req_head.ofna', $Oficina);
        $this->db->where('req_head.fecha_sr2 <=', '1975-01-01');
        $this->db->where('req_head.status <>', 9);
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Nuevas = $RegisterNumber;
        return $Nuevas;
    }

    function GetNewAlmoo($Oficina){
        $this->db->select('distinct(req_deta.numero) as numero ,MAX(req_deta.fecha_e) as fecha_e, req_head.status, req_head.fecha_sr2, req_head.tipo_req, req_head.apoyo as ofnaapoyo');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->where('req_deta.apoyo', $Oficina);
        $this->db->where('req_head.apoyo', "00");
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Nuevas = $RegisterNumber;
        return $Nuevas;
    }

    // function GetNewCom($Oficina){
    //     $this->db->select('*');
    //     $this->db->from('req_head');
    //     $this->db->where('req_head.ofna', $Oficina);
    //     $this->db->where('req_head.fecha_sr3 <=', '1975-01-01');
    //     $this->db->where('req_head.status', 3);
    //     $Query = $this->db->get();
    //     $RegisterNumber = $Query->num_rows();
    //     $Nuevas = $RegisterNumber;
    //     return $Nuevas;
    // }

    function GetNewCom($Oficina){
        $this->db->select('distinct(req_deta.numero) as numero ,MAX(req_deta.fecha_e) as fecha_e, req_head.status, req_head.fecha_sr2, req_head.fecha_sr3, req_head.tipo_req as tipo');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->where('req_head.status', 3);
        $this->db->where('req_head.ofna', $Oficina);
        $this->db->where('req_head.fecha_sr3 <=', '1975-01-01');
        $this->db->where('req_deta.cancelada', 0);
        $this->db->where('req_deta.autorizada', true);
        $this->db->where('req_deta.compras', 1);
        // $this->db->where('req_head.fecha_entrega_real <', '1975-01-01');
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Nuevas = $RegisterNumber;
        return $Nuevas;

    }


    function GetNewComoo($Oficina){
        $this->db->select('distinct(req_deta.numero) as numero ,MAX(req_deta.fecha_e) as fecha_e, req_head.status, req_head.fecha_sr2, req_head.fecha_sr3, req_head.tipo_req as tipo');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->where('req_deta.apoyo', $Oficina);
        $this->db->where('req_deta.cntcompapy >', 0);
        $this->db->where('req_head.fecha_sr3 <=', '1975-01-01');
        $this->db->group_by('req_deta.numero');
        $this->db->order_by("CAST(req_deta.numero AS SIGNED)", "DESC");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Nuevas = $RegisterNumber;
        return $Nuevas;
    }

    function GetNewGte($Gerente){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('req_head.gerente_proy', $Gerente);
        $this->db->where('req_head.tipo_req', "REPOSICION");
        $this->db->where('req_head.revision_gte <=', '1975-01-01');
        $this->db->where('req_head.status <>', 9);
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Nuevas = $RegisterNumber;
        return $Nuevas;
    }

    function ReporteEnvios($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaInicial,$FechaFinal){
        //$this->db->select('distinct(req_surt.numero) as requisicion, req_surt.fecha_e, req_head.*');
        $this->db->select('distinct(req_surt.numero) as requisicion, req_head.*');
        $this->db->from('req_surt');
        $this->db->join("req_head", "req_surt.numero = req_head.numero");
        $this->db->where('req_head.almacen >=', $ClaveAlmacenI);
        $this->db->where('req_head.almacen <=', $ClaveAlmacenF);
        $this->db->where('req_head.ofna >=', $ClaveOficinaI);
        $this->db->where('req_head.ofna <=', $ClaveOficinaF);
        $this->db->where('req_surt.fecha_e >=', $FechaInicial);
        $this->db->where('req_surt.fecha_e <=', $FechaFinal);
        $this->db->order_by("CAST(req_surt.numero AS SIGNED)");

        $Query = $this->db->get();
        return $Query->result();
    }

    function ReporteEnvioseo($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaInicial,$FechaFinal){
        //$this->db->select('distinct(req_soo.numero) as requisicion, req_soo.fecha_e, req_head.*');
        $this->db->select('distinct(req_soo.numero) as requisicion, req_head.*');
        $this->db->from('req_soo');
        $this->db->join("req_head", "req_soo.numero = req_head.numero");
        $this->db->where('req_head.almacen >=', $ClaveAlmacenI);
        $this->db->where('req_head.almacen <=', $ClaveAlmacenF);
        $this->db->where('req_head.ofna >=', $ClaveOficinaI);
        $this->db->where('req_head.ofna <=', $ClaveOficinaF);
        $this->db->where('req_soo.fecha_e >=', $FechaInicial);
        $this->db->where('req_soo.fecha_e <=', $FechaFinal);
        $this->db->order_by("CAST(req_soo.numero AS SIGNED)");

        $Query = $this->db->get();
        return $Query->result();
    }

    function ObtenerListaBloqueadas(){
        $this->db->select('*');
        $this->db->from('req_head');
        $this->db->where('usuarioblq <>', '');
        $this->db->where('status <>', 9);
        $this->db->order_by("Fecha_ini");
        $Query = $this->db->get();
        return $Query->result();
    }

}
?>