<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Req_deta_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($DetalleRequisicion){
        return $this->db->insert('req_deta',$DetalleRequisicion);
    }

    function Update($DetalleRequisicion){
        $this->db->where('numero', $DetalleRequisicion['numero']);
        $this->db->where('partida', $DetalleRequisicion['partida']);
        return $this->db->update('req_deta', $DetalleRequisicion);
    }


    function BorrarPorFolio($Folio)
    {
        $this->db->where('numero', $Folio);
        $this->db->delete('req_deta');
    }

    function ObtenerListaPorFolio($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioAutorizadasNocanceladas($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('cancelada', 0);
        $this->db->where('autorizada', 1);
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioCompras($Folio,$TipoReporteN)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('(compras=1 or compapy=1)');
        if($TipoReporteN ==1){
            $this->db->where('apoyo', "00");
        }
        if($TipoReporteN ==2){
            $this->db->where('apoyo <>', "00");
        }
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioAutorizadas($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('autorizada', true);
        $this->db->where('cancelada', 0);
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioAutorizadasoo($Folio,$Oficinaapy)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('apoyo', $Oficinaapy);
        $this->db->where('autorizada', true);
        $this->db->where('cancelada', 0);
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioAutorizadasNocanceladasoo($Folio,$Oficinaapy)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('apoyo', $Oficinaapy);
        $this->db->where('cancelapy', 0);
        $this->db->where('autorizada', 1);
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioAutorizadasVerificandoCompras($Folio,$Tiporeq)
    {
        $this->db->select('req_deta.*, req_order.pend_orig as encompras, req_order.status1');
        $this->db->from('req_deta');
        $this->db->join("req_order", "req_deta.numero = req_order.numero and req_deta.partida = req_order.partida", "left");
        $this->db->where('req_deta.numero', $Folio);
        if($Tiporeq == 'REPOSICION'){
            $this->db->where('req_deta.autorizada', true);
        }
        //$this->db->where('req_deta.cancelada', 0);
        $this->db->order_by("req_deta.partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPorFolioParacompras($Folio)
    {
        $this->db->select('req_deta.partida as prt, req_deta.articulo as art, req_deta.articulo_eq as art_eq, req_deta.descrip, req_deta.marca, req_deta.cantcomp, req_order.*');
        $this->db->from('req_deta');
        $this->db->join("req_order", "req_deta.numero = req_order.numero and req_deta.partida = req_order.partida","left");
        $this->db->where('req_deta.numero', $Folio);
        $this->db->where('req_deta.autorizada', true);
        $this->db->where('req_deta.cancelada', 0);
        $this->db->where('req_deta.compras', 1);
        $this->db->order_by("req_deta.partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        if($Result){
            return $Result;
        }else{
            $this->db->select('req_deta.partida, req_deta.articulo, req_deta.descrip, req_deta.marca, req_deta.cantcomp, 0 as pend_orig, "" as tip_solic, "" as orden, "" as proveedor, "" as fecha_pp, "" as eta_prov, "" as eta_real, "COMPRAS" as status1, "" as observa');
            $this->db->from('req_deta');
            $this->db->where('req_deta.numero', $Folio);
            $this->db->where('req_deta.autorizada', true);
            $this->db->where('req_deta.cancelada', 0);
            $this->db->where('req_deta.compras', 1);
            $this->db->order_by("req_deta.partida", "ASC");
            $Query = $this->db->get();
            $Result = $Query->result();
            return $Result;
        }
    }
//
    function ObtenerListaPorFolioParacomprasoo($Folio, $Oficinaapy)
    {
        $this->db->select('req_deta.partida as prt, req_deta.articulo as art, req_deta.articulo_eq as art_eq, req_deta.descrip, req_deta.marca, cntcompapy, req_order.*');        
        $this->db->from('req_deta');
        $this->db->join("req_order", "req_deta.numero = req_order.numero and req_deta.partida = req_order.partida","left");
        $this->db->where('req_deta.numero', $Folio);
        $this->db->where('req_deta.apoyo', $Oficinaapy);
        $this->db->where('req_deta.autorizada', true);
        $this->db->where('req_deta.cancelada', 0);
        $this->db->where('req_deta.compapy', 1);
        $this->db->where('req_deta.cntcompapy >', 0);
        $this->db->order_by("req_deta.partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        if($Result){
            return $Result;
        }else{
            $this->db->select('req_deta.partida, req_deta.articulo, req_deta.descrip, req_deta.marca, req_deta.cntcompapy, 0 as pend_orig, "" as tip_solic, "" as orden, "" as proveedor, "" as fecha_pp, "" as eta_prov, "" as eta_real, "COMPRAS" as status1, "" as observa');
            $this->db->from('req_deta');
            $this->db->where('req_deta.numero', $Folio);
            $this->db->where('req_deta.apoyo', $Oficinaapy);
            $this->db->where('req_deta.autorizada', true);
            $this->db->where('req_deta.cancelada', 0);
            $this->db->where('req_deta.compapy', 1);
            $this->db->order_by("req_deta.partida", "ASC");
            $Query = $this->db->get();
            $Result = $Query->result();
            return $Result;
        }
    }
//
    function ObtenerPartidasPendientesPorFolio($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('Folio', $Folio);
        $this->db->where('Active', true);
        $this->db->order_by("Partida", "ASC");

        $Query = $this->db->get();
        return $Query->result_array();
    }

    function ObtenerListaPorFolioParaCancelar($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('cancelada', 0);

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerDescipYmarcaEnvios($Numeroreq,$Partida)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Numeroreq);
        $this->db->where('partida', $Partida);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function ObtenerListaPendientesSurtir($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('cancelada', 0);
        $this->db->where('autorizada', 1);
        $this->db->where('surtido < cantidad');
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerListaPendientesSurtireo($Folio)
    {
        $this->db->select('*');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('cancelapy', 0);
        $this->db->where('autorizada', 1);
        $this->db->where('surtapoyo < cantapoy');
        $this->db->order_by("partida", "ASC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerResumenPendientesRequisicion($Folio)
    {
        $Cantidad = 0;
        $Surtido = 0;

        $this->db->select_sum('cantidad');
        $this->db->from('req_deta');
        $this->db->where('numero', $Folio);
        $this->db->where('cancelada', 0);
        $Query = $this->db->get();
        $Result = $Query->row();
        $Cantidad = $Result ? intval($Result->cantidad) : 0;

        $this->db->select_sum('surtido');
        $this->db->from('req_surt');
        $this->db->where('numero', $Folio);
        $Query = $this->db->get();
        $Result = $Query->row();
        $Surtido = $Result ? intval($Result->surtido) : 0;

        $Pendientes = $Cantidad-$Surtido;

        return $Pendientes;
    }

    function ObtenerSeguimientoOCFechaReq($Fechaisql, $Fechafsql, $Estadopartida, $Claveusuario, $Folio, $Cliente, $Usuarios, $Partidas)
    {
        $this->db->select('req_deta.*, req_head.numero, req_head.almacen, req_head.usuario, req_head.to_empresa, req_head.oc_pedidocliente, req_head.fecha_compromiso, req_head.fecha_ini, usuarios.Name, DATEDIFF(req_deta.fecha_entrega_real, req_head.fecha_ini) as Entregamenosini, DATEDIFF(req_deta.fecha_e, req_head.fecha_ini) as Enviomenosini, DATEDIFF(NOW(), req_head.fecha_ini) as Hoymenosini, DATEDIFF(req_head.fecha_compromiso, NOW()) as Compmenoshoy, DATEDIFF(req_deta.fecha_entrega_real, NOW()) as Entregamenoshoy, DATEDIFF(req_head.fecha_compromiso, req_deta.fecha_entrega_real) as Compmenosentrega');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->join("usuarios", "req_head.usuario = usuarios.UID");
        if($Folio !=""){
            $this->db->where('req_deta.numero', $Folio);
        }
        if($Cliente !=""){
            $this->db->like('req_head.to_empresa', $Cliente);
        }
        switch ($Partidas) {
           case 0:
                break;
            case 1:
                $this->db->where('req_deta.surtido = 0 AND req_deta.cantidad > 0 AND req_deta.cancelada = 0');
                break;
            case 2:
                $this->db->where('req_deta.surtido >0 AND req_deta.surtido < req_deta.cantidad AND req_deta.cancelada = 0');
                break;
            case 3:
                $this->db->where('req_deta.cancelada = 0 AND (req_deta.surtido >= req_deta.cantidad OR (req_deta.surtido = 0 AND req_deta.cantidad = 0))' );
                break;
            case 4:
                $this->db->where('req_deta.cancelada', 1);
                break;
            case 5:
                $this->db->where('req_deta.cancelada = 0 AND  req_deta.cantidad > 0 AND (req_deta.surtido = 0 or req_deta.surtido < req_deta.cantidad)');
                break;
           default:
             break;
         }
        if (!in_array("TODO", $Claveusuario)) {
            $this->db->where('req_head.usuario IN ('.$Usuarios.')');
        }
        $this->db->where('req_head.fecha_compromiso >= ', '1970-01-01');        
        $this->db->where('req_head.fecha_ini >= ', $Fechaisql);
        $this->db->where('req_head.fecha_ini <= ', $Fechafsql);
        $this->db->order_by("req_head.fecha_ini", "DESC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerSeguimientoOCFechaEnt($Fechaisql, $Fechafsql, $Estadopartida, $Claveusuario, $Folio, $Cliente, $Usuarios, $Partidas)
    {
        $this->db->select('req_deta.*, req_head.numero, req_head.almacen, req_head.usuario, req_head.to_empresa, req_head.oc_pedidocliente, req_head.fecha_compromiso, req_head.fecha_ini, usuarios.Name, DATEDIFF(req_deta.fecha_entrega_real, req_head.fecha_ini) as Entregamenosini, DATEDIFF(req_deta.fecha_e, req_head.fecha_ini) as Enviomenosini, DATEDIFF(NOW(), req_head.fecha_ini) as Hoymenosini, DATEDIFF(req_head.fecha_compromiso, NOW()) as Compmenoshoy, DATEDIFF(req_deta.fecha_entrega_real, NOW()) as Entregamenoshoy, DATEDIFF(req_head.fecha_compromiso, req_deta.fecha_entrega_real) as Compmenosentrega');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->join("usuarios", "req_head.usuario = usuarios.UID");
        //$this->db->join("seg_oc", "req_deta.numero = seg_oc.numero AND req_deta.partida = seg_oc.partida");
        if($Folio !=""){
            $this->db->where('req_deta.numero', $Folio);
        }
        if($Cliente !=""){
            $this->db->like('req_head.to_empresa', $Cliente);
        }
        switch ($Partidas) {
           case 0:
                break;
            case 1:
                $this->db->where('req_deta.surtido = 0 AND req_deta.cantidad > 0 AND req_deta.cancelada = 0');
                break;
            case 2:
                $this->db->where('req_deta.surtido >0 AND req_deta.surtido < req_deta.cantidad AND req_deta.cancelada = 0');
                break;
            case 3:
                $this->db->where('req_deta.cancelada = 0 AND (req_deta.surtido >= req_deta.cantidad OR (req_deta.surtido = 0 AND req_deta.cantidad = 0))' );
                break;
            case 4:
                $this->db->where('req_deta.cancelada', 1);
                break;
            case 5:
                $this->db->where('req_deta.cancelada = 0 AND  req_deta.cantidad > 0 AND (req_deta.surtido = 0 or req_deta.surtido < req_deta.cantidad)');
                break;
           default:
             break;
         }
        if (!in_array("TODO", $Claveusuario)) {
            $this->db->where('req_head.usuario IN ('.$Usuarios.')');
        }
        $this->db->where('req_head.fecha_compromiso >= ', '1970-01-01');        
        $this->db->where('req_deta.fecha_entrega_real >= ', $Fechaisql);
        $this->db->where('req_deta.fecha_entrega_real <= ', $Fechafsql);
        $this->db->order_by("req_deta.fecha_entrega_real", "DESC");

        $Query = $this->db->get();
        $Result = $Query->result();
        return $Result;
    }

    function ObtenerFechaIniDefault()
    {
        $this->db->select('req_deta.*, req_head.fecha_ini');
        $this->db->from('req_deta');
        $this->db->join("req_head", "req_deta.numero = req_head.numero");
        $this->db->where('req_deta.cancelada = 0');
        $this->db->where('req_deta.surtido < req_deta.cantidad');
        $this->db->order_by("req_head.fecha_ini", "ASC");
        $this->db->limit(1);


        $Query = $this->db->get();
        $Result = $Query->row();
        $Fechaini = $Result ? $Result->fecha_ini : '';

        return $Fechaini;
    }
}
?>