<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Oficinas_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($Oficina){
        return $this->db->insert('oficinas',$Oficina);
    }

    function Update($Oficina){
        $this->db->where('Clave', $Oficina['Clave']);
        return $this->db->update('oficinas', $Oficina);
    }

    function GetByClave($Clave){
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function CheckIfExists($Clave)
    {
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function GetList(){
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->where('Active', true);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetAll($Page, $Clave, $Nombre){
        $PerPage = 10;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->like('Clave', $Clave);
        $this->db->like('Nombre', $Nombre);
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "ASC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPages($Page, $Clave, $Nombre){
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->like('Clave', $Clave);
        $this->db->like('Nombre', $Nombre);
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "desc");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/10;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function SearchByClave($Clave){
        $this->db->select('*');
        $this->db->like('clave', $Clave);
        $this->db->where('Active', true);
        $this->db->limit(10);
        $Query = $this->db->get('oficinas');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->clave;
                $new_row['value'] = $row->clave;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function SearchByNombre($Nombre){
        $this->db->select('*');
        $this->db->like('nombre', $Nombre);
        $this->db->where('Active', true);
        $this->db->limit(10);
        $Query = $this->db->get('oficinas');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->nombre;
                $new_row['value'] = $row->nombre;
                $new_row['Clave'] = $row->clave;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function GetNombreByClave($Clave){
        $this->db->select('Nombre');
        $this->db->from('oficinas');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row('Nombre');
        return $Result;
    }

    function ObtenerPrimero(){
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->order_by("clave", "asc");
        $this->db->limit(1);
        
        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }
    function ObtenerUltimo(){
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->order_by("clave", "desc");
        $this->db->limit(1);
        
        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function GetAllToExport(){
        $this->db->select('*');
        $this->db->from('oficinas');
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "ASC");
        $Query = $this->db->get();
        return $Query->result();
    }
  
}
?>