<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Articulos_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($Articulo){
        return $this->db->insert('articulos',$Articulo);
    }

    function Update($Articulo){
        $this->db->where('Clave', $Articulo['clave']);
        return $this->db->update('articulos', $Articulo);
    }

    function GetByClave($Clave){
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function GetByClaveEq($Clave){
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->where('Clave_eq', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function CheckIfExists($Clave)
    {
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function CheckIfExistsEq($Clave)
    {
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->where('Clave_eq', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function GetList(){
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->where('Active', true);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetAll($Page, $Clave, $descrip){
        $PerPage = 10;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->like('Clave', $Clave);
        $this->db->like('descrip', $descrip);
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "ASC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPages($Page, $Clave, $descrip){
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->like('Clave', $Clave);
        $this->db->like('descrip', $descrip);
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "desc");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/10;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function SearchByClave($Clave){
        $this->db->select('*');
        $this->db->like('Clave', $Clave);
        $this->db->where('Active', true);
        $this->db->limit(10);
        $Query = $this->db->get('articulos');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->clave;
                $new_row['value'] = $row->clave;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function SearchByNombre($descrip,$marca){
        $this->db->select('*');
        $this->db->like('descrip', $descrip);
        if(strlen($marca) > 0){
            $this->db->like('marca', $marca);
        }
        $this->db->where('Active', true);
        $this->db->limit(200);
        $Query = $this->db->get('articulos');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->descrip;
                $new_row['value'] = $row->descrip;
                $new_row['Clave'] = $row->clave;
                $new_row['Clave_eq'] = $row->clave_eq;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function SearchMarca($marca){
        $this->db->select('distinct(marca)');
        $this->db->like('marca', $marca);
        $this->db->where('Active', true);
        $this->db->limit(200);
        $Query = $this->db->get('articulos');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->marca;
                $new_row['value'] = $row->marca;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function GetdescripByClave($Clave){
        $this->db->select('descrip');
        $this->db->from('articulos');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row('descrip');
        return $Result;
    }

    function GetAllToExport(){
        $this->db->select('*');
        $this->db->from('articulos');
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "ASC");
        $Query = $this->db->get();
        return $Query->result();
    }

}
?>