<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Almacenes_model extends CI_Model {
    function __construct(){
        parent::__construct();
    }

    function Create($Almacen){
        return $this->db->insert('almacenes',$Almacen);
    }

    function Update($Almacen){
        $this->db->where('Clave', $Almacen['Clave']);
        return $this->db->update('almacenes', $Almacen);
    }

    function GetByClave($Clave){
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function CheckIfExists($Clave)
    {
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->where('Clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function GetList(){
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->where('Active', true);
        $this->db->order_by("nombre", "ASC");
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetAll($Page, $Clave, $Nombre){
        $PerPage = 10;
        $limit2 = $Page * $PerPage;
        $Start = $limit2 - $PerPage;
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->like('Clave', $Clave);
        $this->db->like('Nombre', $Nombre);
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "ASC");
        $this->db->limit($PerPage, $Start);
        $Query = $this->db->get();
        return $Query->result();
    }

    function GetPages($Page, $Clave, $Nombre){
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->like('Clave', $Clave);
        $this->db->like('Nombre', $Nombre);
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "desc");
        $Query = $this->db->get();
        $RegisterNumber = $Query->num_rows();
        $Pages = $RegisterNumber/10;
        $arrPages = explode('.',$Pages);
        $Pages = $arrPages[0];
        if(count($arrPages) > 1){
            $Pages = $Pages + 1;
        }
        return $Pages;
    }

    function SearchByClave($Clave){
        $this->db->select('*');
        $this->db->like('Clave', $Clave);
        $this->db->where('Active', true);
        $this->db->limit(10);
        $Query = $this->db->get('almacenes');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->clave;
                $new_row['value'] = $row->clave;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function SearchByNombre($Nombre){
        $this->db->select('*');
        $this->db->like('Nombre', $Nombre);
        $this->db->where('Active', true);
        $this->db->limit(10);
        $Query = $this->db->get('almacenes');
        if($Query->num_rows() > 0){
            foreach ($Query->result() as $row){
                $new_row['label'] = $row->nombre;
                $new_row['value'] = $row->nombre;
                $new_row['Clave'] = $row->clave;
                $new_row['Ofna'] = $row->ofna;
                $new_row['Ofna2'] = $row->ofna2;
                $row_set[] = $new_row;
            }
            return $row_set;
        }
    }

    function GetNombreByClave($Clave){
        $this->db->select('nombre');
        $this->db->from('almacenes');
        $this->db->where('clave', $Clave);

        $Query = $this->db->get();
        $Result = $Query->row('nombre');
        return $Result;
    }

    function ObtenerPrimero(){
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->order_by("clave", "asc");
        $this->db->limit(1);
        
        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }
    function ObtenerUltimo(){
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->order_by("clave", "desc");
        $this->db->limit(1);
        
        $Query = $this->db->get();
        $Result = $Query->row();
        return $Result;
    }

    function GetAllToExport(){
        $this->db->select('*');
        $this->db->from('almacenes');
        $this->db->where('Active', true);
        $this->db->order_by("Clave", "ASC");
        $Query = $this->db->get();
        return $Query->result();
    }

}
?>