<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SeguimientoOc extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index()
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoOc", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Page = 1;
        $Filtrofecha = "0";
        $Folio = "";
        $Cliente = "";
        // Obtenemos la fecha de la requisicion con partidas pendientes mas antigua
        $FechaItmp = $this->Req_deta_model->ObtenerFechaIniDefault();
        // Si no regresa una fecha se toma la fecha actual
        if($FechaItmp == '' || empty($FechaItmp)){
            $FechaI = $TodayDate;
        }else{ // Si es fecha valida la convertimos a fecha reconocida
            $FechaI = substr($FechaItmp,8,2)."/".substr($FechaItmp,5,2)."/".substr($FechaItmp,0,4);
        }

        $FechaF = $TodayDate;
        $Fechaisql = "0000-00-00";
        $Fechafsql = "0000-00-00";
        $Estadopartida = ["ABIERTAS/PARCIALES" => 5,];
        $Claveusuario = ["TODOS" => "TODO",];
        $Partidas = 0;
        $Usuarios = "";
        $Mostrarxls =0;
        $Botonexport ="0";

        if($this->input->post()){
            $Filtrofecha = $this->input->post("Filtrofecha");
            $Botonexport = $this->input->post("Botonexport");

            $FechaI = $this->input->post("FechaI");
            $Fechaisql = substr($FechaI,6,4)."-".substr($FechaI,3,2)."-".substr($FechaI,0,2);
            $FechaF = $this->input->post("FechaF");
            $Fechafsql = substr($FechaF,6,4)."-".substr($FechaF,3,2)."-".substr($FechaF,0,2);

            $Estadopartida = $this->input->post('Estadopartida');
            $Claveusuario = $this->input->post('Claveusuario');
            $Folio = $this->input->post('Folio');
            $Cliente = $this->input->post('Cliente');
        }

        if(empty($Estadopartida)) {
            $Partidas = 0;
        }else{
            foreach ($Estadopartida as $estadop){
                $Partidas = $estadop;
            }
        }

        if(empty($Claveusuario)) {
            $Usuarios = "TODO";
        }else{
            foreach ($Claveusuario as $usuariox){
                $Usuarios .= "'".$usuariox."',";
            }
            if(strlen(trim($Usuarios)) > 0){
                $Usuarios = substr($Usuarios, 0, strlen($Usuarios)-1); 
            }
        }

        if($Filtrofecha == "0"){
            $Opt1chk = "checked";
            $Opt2chk = '';
            $Detalles = $this->Req_deta_model->ObtenerSeguimientoOCFechaReq($Fechaisql, $Fechafsql, $Estadopartida, $Claveusuario, $Folio, $Cliente, $Usuarios, $Partidas);
        }else{
            $Opt2chk = "checked";
            $Opt1chk = '';
            $Detalles = $this->Req_deta_model->ObtenerSeguimientoOCFechaEnt($Fechaisql, $Fechafsql, $Estadopartida, $Claveusuario, $Folio, $Cliente, $Usuarios, $Partidas);
        }
        foreach($Detalles as $Item)
        {
            $Item->datosfactura = $this->Seg_oc_model->ObtenerDatosFactura($Item->numero,$Item->partida);
            $Item->lastcomment = $this->Seg_oc_model->GetLastComment($Item->numero,$Item->partida);
        }
        //
        // Validamos si la consulta trajo registros para habilitar la exportacion
        //
        if($Detalles){
            $Mostrarxls = 1;
            //
            // Si venia la orden de exportar armamos y exportamos el archivo de excel
            //
            if($Botonexport == "1"){
                $this->load->library('Excel');     
                $this->excel->setActiveSheetIndex(0);
                $this->excel->getActiveSheet()->setTitle("Control OC");
                $this->excel->getActiveSheet()->setCellValue('A1', 'Almacen');
                $this->excel->getActiveSheet()->setCellValue('B1', 'Cliente');
                $this->excel->getActiveSheet()->setCellValue('C1', 'Requi');
                $this->excel->getActiveSheet()->setCellValue('D1', 'Pedido');
                $this->excel->getActiveSheet()->setCellValue('E1', 'Articulo');
                $this->excel->getActiveSheet()->setCellValue('F1', 'Articulo Eq.');
                $this->excel->getActiveSheet()->setCellValue('G1', 'Descripcion');
                $this->excel->getActiveSheet()->setCellValue('H1', 'Cantidad');
                $this->excel->getActiveSheet()->setCellValue('I1', 'Surtido');
                $this->excel->getActiveSheet()->setCellValue('J1', 'Pendiente');
                $this->excel->getActiveSheet()->setCellValue('K1', 'F. Req.');
                // $this->excel->getActiveSheet()->setCellValue('L1', 'F. Auto.');
                $this->excel->getActiveSheet()->setCellValue('L1', 'F.E.A');
                $this->excel->getActiveSheet()->setCellValue('M1', 'F.E.R');
                $this->excel->getActiveSheet()->setCellValue('N1', 'F. Comp.');
                $this->excel->getActiveSheet()->setCellValue('O1', 'Edo.Part.');
                $this->excel->getActiveSheet()->setCellValue('P1', 'Dias tr.');
                $this->excel->getActiveSheet()->setCellValue('Q1', 'Solicitante');
                $this->excel->getActiveSheet()->setCellValue('R1', 'Fecha');
                $this->excel->getActiveSheet()->setCellValue('S1', 'Factura');
                $this->excel->getActiveSheet()->setCellValue('T1', 'Ultimo comentario');
                
                $this->excel->getActiveSheet()->getStyle('A1:T1')->getFont()->setSize(12);
                $this->excel->getActiveSheet()->getStyle('A1:T1')->getFont()->setBold(true);
                $this->excel->getActiveSheet()->getStyle('A1:T1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFE8E5E5');

                $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
                $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('35');
                $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('10');
                $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('15');
                $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('15');
                $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('15');
                $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('55');
                $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('10');
                $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('10');
                $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('10');
                $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('12');
                // $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('12');
                $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('12');
                $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('12');
                $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('12');
                $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('12');
                $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('10');
                $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('20');
                $this->excel->getActiveSheet()->getColumnDimension('R')->setWidth('12');
                $this->excel->getActiveSheet()->getColumnDimension('S')->setWidth('20');
                $this->excel->getActiveSheet()->getColumnDimension('T')->setWidth('40');
                //
                // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
                //
                $row = 2;
                foreach($Detalles as $Item) {
                    //
                    // Validamos informacion para mostrarla en las columnas tal como se ve en la consulta por pantalla
                    //
                    $Diastr = 0;
                    $Estadoprt="";

                    if ($Item->cancelada == 1){
                        $Estadoprt="CANCELADA";
                    }else{
                        if ($Item->surtido == 0 && $Item->cantidad == 0 ){
                            $Estadoprt="CERRADA";
                        }else{
                            if ($Item->surtido == 0 && $Item->cantidad > 0 ){
                                $Estadoprt="ABIERTA";
                            }else{
                                if ($Item->surtido >= $Item->cantidad){
                                    $Estadoprt="CERRADA";
                                }else{
                                    $Estadoprt="PARCIAL";
                                }
                            }
                        }
                    }

                    if(isset($Item->datosfactura)){
                        $FechaHoraOriginal = $Item->datosfactura->fecha;
                        $Horaini = substr($FechaHoraOriginal,11,8);
                        $Fechafactura = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);
                        $Factura = $Item->datosfactura->factura;
                    }else{
                        $Fechafactura = "";
                        $Factura = "";
                    }

                    if(isset($Item->lastcomment)){
                        $FechaHoraOriginal = $Item->lastcomment->fecha;
                        //$Horaini = substr($FechaHoraOriginal,11,8);
                        $Datecomment = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);
                        $Comment = $Item->lastcomment->comentario;
                    }else{
                        $Datecomment = "";
                        $Comment = "";
                    }

                    if($Item->fecha_e=="1753-01-01"){
                        $Fecha_e = "";
                    }else{
                        $Fecha_e = $Item->fecha_e;
                    }

                    $hoy_tmp=date("Y-m-d");
                    $hoy = date_create_from_format('Y-m-d', $hoy_tmp);
                    $Fechareqini = date_create_from_format('Y-m-d', $Item->fecha_ini);
                    $Fechabase = date_create_from_format('Y-m-d', '1753-01-01');
                    $Fechaenvio = date_create_from_format('Y-m-d', $Item->fecha_e);
                    $Fechacompromiso = date_create_from_format('Y-m-d', $Item->fecha_compromiso);
                    $Fechaentrega = date_create_from_format('Y-m-d H:i:s', $Item->fecha_entrega_real);

                    if(!is_null($Item->almacen)){

                        if($Estadoprt=="CERRADA"){
                            if($Fechaentrega > $Fechabase){
                                $Diastr = $Item->Compmenosentrega;
                            }else{
                                $Diastr = $Item->Compmenoshoy;
                            }   
                        }else{
                            if($Fechacompromiso > $Fechabase && $Fechaentrega <= $Fechabase){
                                $Diastr = $Item->Compmenoshoy;
                            }else{
                                if($Fechaentrega > $Fechabase && $Fechacompromiso <= $Fechabase){
                                    $Diastr = $Item->Entregamenoshoy;
                                }else{
                                    $Diastr = $Item->Compmenosentrega;
                                }
                            }
                        }

                    }

                    $FechaHoraOriginal = $Item->fecha_entrega_real;
                    $Horaini = substr($FechaHoraOriginal,11,8);
                    $FormatoFechaentrega = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

                    $FechaHoraOriginal = $Fecha_e;
                    $Horaini = substr($FechaHoraOriginal,11,8);
                    $FormatoFecha_e = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

                    $FechaHoraOriginal = $Item->fecha_ini;
                    $Horaini = substr($FechaHoraOriginal,11,8);
                    $FormatoFecha_ini = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

                    $FechaHoraOriginal = $Item->fecha_compromiso;
                    $Horaini = substr($FechaHoraOriginal,11,8);
                    $FormatoFecha_compromiso = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

                    // $FechaHoraOriginal = $Item->revision_gte;
                    // $Horaini = substr($FechaHoraOriginal,11,8);
                    // $FormatoFecha_auto = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

                    $color = "E2E2E2"; 
                    if ($Estadoprt=="ABIERTA" || $Estadoprt=="PARCIAL") {
                        if($Diastr >= 5 && $Diastr <= 7){
                          $color = "FFE633";
                        }elseif($Diastr <= 4){
                          $color = "FE8484";
                        }
                    }

                    $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->almacen, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->to_empresa, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->numero, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->oc_pedidocliente, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item->cantidad, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item->surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item->cantidad-$Item->surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $FormatoFecha_ini, PHPExcel_Cell_DataType::TYPE_STRING);

                    // $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $FormatoFecha_auto, PHPExcel_Cell_DataType::TYPE_STRING);

                    $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $FormatoFecha_e, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $FormatoFechaentrega, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $FormatoFecha_compromiso, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $Estadoprt, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $Diastr, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Item->Name, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('R'.$row, $Fechafactura, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('S'.$row, $Factura, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('T'.$row, $Datecomment.' - '.$Comment, PHPExcel_Cell_DataType::TYPE_STRING);

                    $this->excel->getActiveSheet()->getStyle('A'.$row.':T'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB($color);

                    $row++;
                }
                 
                $filename='ControlOC.xls'; //save our workbook as this file name
                header('Content-Type: application/vnd.ms-excel'); //mime type
                header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
                header('Cache-Control: max-age=0'); //no cache
                             
                //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
                //if you want to save it as .XLSX Excel 2007 format
                $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
                //force user to download the Excel file without writing it to server's HD
                $objWriter->save('php://output');
            }
        }

        $Data['title'] = "Seguimiento a ordenes de compra";
        $Data['Detalles'] = $Detalles;
        $Data["Compradores"] = $this->Users_model->ObtenerListaUsuariosOc();
        $Data['Filtrofecha'] = $Filtrofecha;
        $Data['FechaI'] = $FechaI;
        $Data['FechaF'] = $FechaF;
        $Data['Opt1chk'] = $Opt1chk;
        $Data['Opt2chk'] = $Opt2chk;
        $Data['Folio'] = $Folio;
        $Data['Cliente'] = $Cliente;
        $Data['Filtropartida'] =$Partidas;
        $Data['Listausuarios'] =$Usuarios;
        $Data['Estadopartida'] = $Estadopartida;
        $Data['Claveusuario'] = $Claveusuario;
        $Data['Mostrarxls'] = $Mostrarxls;
        $Data['Botonexport'] = $Botonexport;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Seguimientooc/Index', $Data);
        // $this->load->view('layouts/footer');
    }

    function ExcelOrdenesCompra()
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoOc", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        if($this->input->post())
        {
            $TodayDate = unix_to_human(time(), TRUE, 'us');
            $TodayDate = date("d/m/Y");
            $Filtrofecha = $this->input->post("ExportFiltrofecha");
            $FechaI = $this->input->post("ExportFechaI");
            $Fechaisql = substr($FechaI,6,4)."-".substr($FechaI,3,2)."-".substr($FechaI,0,2);
            $FechaF = $this->input->post("ExportFechaF");
            $Fechafsql = substr($FechaF,6,4)."-".substr($FechaF,3,2)."-".substr($FechaF,0,2);
            $Estadopartida = $this->input->post('ExportEstadopartida');
            $Claveusuario = $this->input->post('ExportClaveusuario');
            $Folio = $this->input->post('ExportFolio');
            $Cliente = $this->input->post('ExportCliente');

            if(empty($Estadopartida)) {
                $Partidas = 0;
            }else{
                foreach ($Estadopartida as $estadop){
                    $Partidas = $estadop;
                }
            }

            if(empty($Claveusuario)) {
                $Usuarios = "TODO";
            }else{
                foreach ($Claveusuario as $usuariox){
                    $Usuarios .= "'".$usuariox."',";
                }
                if(strlen(trim($Usuarios)) > 0){
                    $Usuarios = substr($Usuarios, 0, strlen($Usuarios)-1); 
                }
            }

            if($Filtrofecha == "0"){
                $Detalles = $this->Req_deta_model->ObtenerSeguimientoOCFechaReq($Fechaisql, $Fechafsql, $Estadopartida, $Claveusuario, $Folio, $Cliente, $Usuarios, $Partidas);
            }else{
                $Detalles = $this->Req_deta_model->ObtenerSeguimientoOCFechaEnt($Fechaisql, $Fechafsql, $Estadopartida, $Claveusuario, $Folio, $Cliente, $Usuarios, $Partidas);
            }
            foreach($Detalles as $Item)
            {
                $Item->datosfactura = $this->Seg_oc_model->ObtenerDatosFactura($Item->numero,$Item->partida);
            }

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Control OC");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Tipo');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Cliente');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Requi');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Pedido');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Solicito');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Cantidad');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Surtido');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Pedido');
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('20');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Detalles as $Item) {
                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->tipo_req, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->to_empresa, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->numero, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->oc_pedidocliente, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item->cantidad, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item->surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item->cantidad-$Item->surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                $row++;
            }
             
            $filename='ControlOC.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    
    function AutocompleteFolio(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Req_head_model->SearchByFolio($term);
        echo json_encode($result);
    }

    function GuardarFecha(){
        $requisicion = $this->input->get("Requisicion");
        $partida = $this->input->get("Partida");
        $fechatmp = $this->input->get("Fechaentrega");
        if($fechatmp !=""){
            $FechaExplode = explode("/", $fechatmp);
            $fechaentrega = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);
            $fechaentrega = $fechaentrega->format("Y-m-d");
        }else{
            $fechaentrega = NULL;
        }
        $DetalleRequisiciones = array(
            "numero" => $requisicion,
            "partida" => $partida,
            "fecha_entrega_real" => $fechaentrega,
        );
        $result = $this->Req_deta_model->Update($DetalleRequisiciones);
        echo json_encode($result);
    }

    function ObtenerComentarios(){
        $requisicion = $this->input->get("Requisicion");
        $partida = $this->input->get("Partida");
        $result = $this->Seg_oc_model->ObtenerListaPorFolioPartida($requisicion,$partida);
        echo json_encode($result);
    }

    function GuardarTips(){
        if( isset($_GET['Requisicion']) )
        {
            $requisicion = $this->input->get("Requisicion");
            $partida = $this->input->get("Partida");
            $articulo = $this->input->get("Articulo");
            $articuloeq = $this->input->get("Articuloeq");
            if (is_null($articuloeq))
            {
                $articuloeq = "";
            }
            $detalletips = $this->input->get("Detalletips");
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            //
            // Eliminamos los comentarios anteriores de la requi + partida
            //
            $resultdelete = $this->Seg_oc_model->BorrarPorFolioPartida($requisicion,$partida);

            //
            // Barremos el arreglo y creamos los nuevos registros
            //
            if($detalletips){
                foreach($detalletips as $Item)
                {
                    if($Item[0] !='')
                    {
                        $tFechatmp =  $Item[0];
                        $FechaExplode = explode("/", $tFechatmp);
                        $tFecha = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);
                        $tFactura =  $Item[1];
                        $tComentario =  $Item[2];

                        $ComentarioAguardar = array(
                            "numero" => $requisicion,
                            "partida" => $partida,
                            "articulo" => $articulo,
                            "articulo_eq" => $articuloeq,
                            //"fecha_elab" => $TodayDate,
                            "fecha" => $tFecha->format("Y-m-d"),
                            "factura" =>  $tFactura,
                            "comentario" => $tComentario,
                            "usuario" => $this->session->UID,
                            "tipo" => "C"
                        );
                        $result = $this->Seg_oc_model->Create($ComentarioAguardar);
                    }
                }
            }

        }

        $result = true;
        echo json_encode($result);
    }
}