<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Seguimientogte extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index($Startpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoGte", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($Startpage != null && $Startpage > 0){
            $Page = $Startpage;
        }else{
            $Page = 1;
        }

        $Fecha_default = date_create("1753-01-01");
        $TodayDate = date_format($Fecha_default,"d/m/Y");

        $Folio = "";
        $Almacen = "";
        $Filtrofecha = $TodayDate;

        if($this->input->post()){
            $Folio = $this->input->post('Folio');
            $Almacen = $this->input->post('Almacen');
            $Filtrovista = $this->input->post("Filtrofecha");
            if(!empty($Filtrovista)){
                $Filtrofecha = $Filtrovista;
            }else{
                $Filtrofecha = $TodayDate;
            }
            $Page = $this->input->post("Page");
        }
        set_value("Folio");
        $FechaI = $Filtrofecha;
        $Fechaisql = substr($FechaI,6,4)."-".substr($FechaI,3,2)."-".substr($FechaI,0,2)." 00:00:00";
        $Fechafsql = substr($FechaI,6,4)."-".substr($FechaI,3,2)."-".substr($FechaI,0,2)." 23:59:59";

        $Pages = $this->Req_head_model->GetPagesGte($Page, $Folio, $Fechaisql, $Fechafsql, $Almacen, $this->session->UID);
        if( $Pages <= 1){
            $Page = 1;
        }

        $CabezaRequisiciones = $this->Req_head_model->GetAllGte($Page, $Folio, $Fechaisql, $Fechafsql, $Almacen, $this->session->UID);
        $Nuevasgte = $this->Req_head_model->GetNewGte($this->session->UID);
        $Data['title'] = "Autorizacion por gerente";
        $Data['CabezaRequisiciones'] = $CabezaRequisiciones;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $Data['Nuevas'] = $Nuevasgte;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Seguimientogte/Index', $Data);
        $this->load->view('layouts/footer');
    }
    
    function Details($numero = null, $actualpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoGte", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $BitacoraMovimientos = $this->Req_logs_model->ObtenerListaPorFolio($numero);

        foreach($BitacoraMovimientos as $Bitacora)
        {
            $Bitacora->Usuario = $this->Users_model->GetByUserName($Bitacora->log_usuario);
        }

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        $Adjuntos = $this->Req_adjuntosurl_model->ObtenerListaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 
        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Data["Solicitante"] = $Solicitanterec->Name;
        $Data["Emailsol"] = $Solicitanterec->email;
        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['BitacoraMovimientos'] = $BitacoraMovimientos;
        $Data['title'] = "Consulta de autorizaciones de requisiciones";
        $Data['numero'] = $numero;
        $Data['actualpage'] = $actualpage;
        $Data['Tipopdto'] = $Tipopdto;
        $Data['Observaciones'] = $Observaciones;
        $Data['Cabeza'] = $Cabeza;
        $Data["Detalles"] = $Detalles;
        $Data["Adjuntos"] = $Adjuntos;
        $Data["Surtidoreq"] = $this->Req_surt_model->ObtenerListaPorFolio($numero);
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Seguimientogte/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit()
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoGte", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $numero = $this->input->post("EditarFolio");
        $actualpage = $this->input->post("ActualPage");
        $LoggedUserId = $this->session->UID;

        // Bloqueamos la requisicion
        $CabezaRequisiciones = array(
            "numero" => $numero,
            "usuarioblq" => $LoggedUserId
        );

        $result = $this->Req_head_model->Update($CabezaRequisiciones);

        //Obtenemos la informacion de la cabeza de la requi
        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy);
                
        $Almacenes = $this->Almacenes_model->GetList();
        $Clientes = $this->Clientes_model->GetList();
        $Proyectos = $this->Proyectos_model->GetList();

        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data['Almacenes'] = $Almacenes;
        $Data['Clientes'] = $Clientes;
        $Data['Proyectos'] = $Proyectos;

        $Data["Solicitante"] = $Solicitanterec->Name;
        $Data["Emailsol"] = $Solicitanterec->email;
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['title'] = "Autorizar requisicion";
        $Data['numero'] = $numero;
        $Data['actualpage'] = $actualpage;
        $Data["Cabeza"] = $Cabeza;
        $Data["Detalles"] = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Seguimientogte/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "SeguimientoGte", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Folio = $this->input->post("hdNumero");
            $ActualPage = $this->input->post("hdActualPage");
            if(!VerificarBloqueoUsuarioFolio($this->session->UID, $Folio )){
                $this->session->set_flashdata('logged-message', 'Error: no se pudo guardar debido a que otro usuario tiene bloqueada la requisicion.');
                redirect("");
            }
            //
            // Obtener datos de la requisicion
            // Codigo agregado en marzo 2023
            $Datosrequi = $this->Req_head_model->GetByFolio($Folio);
            switch ($Datosrequi->status) {
                case 1:
                    $Estadorequi ="Nueva";
                    break;
                case 2:
                    $Estadorequi ="Almacen";
                    break;
                case 3:
                    $Estadorequi ="Almacen/Compras";
                    break;
                default:
                    $Estadorequi ="";
                    break;
            }
            $Nombrecliente = $this->Clientes_model->GetNombreByClave($Datosrequi->clave_cliente);
            $Nombreusuario = $this->Users_model->GetName($Datosrequi->usuario);

            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Tiporeq = $this->input->post("TipoReq");
            $Tipopdto = $this->input->post("TipoPdto");
            $Clavealmacen = $this->input->post("Clavealmacen");
            $Claveoficina = $this->input->post("Claveoficina");
            $Nombrealmacen = $this->input->post("Clavealmacen");
            $Emailsol = $this->input->post("hdEmailsol");

            if($Tiporeq == "VENTA")
            {
                $Cotizacion = $this->input->post("Cotizacion");
                $Ocpedido = $this->input->post("Ocpedido");
                $Fechacomptmp= $this->input->post("Fechacompromiso");
                $FechaExplode = explode("/", $Fechacomptmp);
                $Fechacompromiso = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);
            }else{
                $Cotizacion = "";
                $Ocpedido = "";
                $Fechacompromiso = new DateTime("0000-00-00");
            }

            $Tonombre = $this->input->post("Tonombre");
            $Togerente = $this->input->post("Togerente");
            $Clavecliente = $this->input->post("Clavecliente");
            $Nombrecliente = $this->input->post("Nombrecliente");
            $Claveproyecto = $this->input->post("Claveproyecto");
            $Nombreproyecto = $this->input->post("Nombreproyecto");
            $Nombregerente = $this->input->post("Nombregerente");
            $Direccion = $this->input->post("Direccion");
            $Telefono = $this->input->post("Totelefono");
            $Paqueteria = $this->input->post("Topaquete");
            $Gerenteproy = $this->input->post("Usuariogerente");
            $Emailgerente = $this->input->post("Emailgerente");
            //
            // Tomamos los correos de los responsables de almacen de la oficina
            //
            $Oficinaactual = $this->session->Oficina;
            $Datosoficina = $this->Oficinas_model->GetByClave($Oficinaactual);
            $Emailalmacenistas = $this->Users_model->ObtenerMailsAlmacenPorOficina($Oficinaactual);
            if($Emailalmacenistas)
            {
                $Cadenaalm = "";
                foreach($Emailalmacenistas as $Almacenista)
                {
                    $Cadenaalm = $Cadenaalm.trim($Almacenista->email).",";
                }
                $Emailalm = substr($Cadenaalm,0,-1);
            }else{
                $Emailalm = "cotaemilio@hotmail.com";
            }

            $Detalle = $this->input->post("lstDetalle");
            $Observaciones = $this->input->post("Observaciones");

            $TotalMovimientosAgregados = 0;

//
            // Si cambiaron los adjuntos
            if ($this->input->post("Adjuntosmodificados")=='1'){

                //Eliminamos los registros anteriores del req_adjuntosurl
                $result = $this->Req_adjuntosurl_model->BorrarPorFolio($Folio);

                //Barremos el arreglo, cargamos los archivos y guardamos los nuevos registros
                foreach($_FILES["adjunto"]['tmp_name'] as $key => $tmp_name)
                {
                    //Validamos que el archivo exista
                    if($_FILES["adjunto"]["name"][$key])
                    {
                        // Validamos que no mida mas de 200kb (mover este dato a 10mb en server de produccion)
                        if($_FILES["adjunto"]["size"][$key] <= 200000)
                        {
                            $filename = $_FILES["adjunto"]["name"][$key]; //Obtenemos el nombre original del archivo
                            $source = $_FILES["adjunto"]["tmp_name"][$key]; //Obtenemos un nombre temporal del archivo
                            $tipo = $_FILES["adjunto"]["type"][$key]; //Obtenemos un nombre temporal del archivo
                            
                            $directorio = 'adjuntos/'; //Declaramos un  variable con la ruta donde guardaremos los archivos
                                                
                            $dir=opendir($directorio); //Abrimos el directorio de destino
                            $destino = $directorio.'/'.$filename; //Indicamos la ruta de destino, así como el nombre del archivo
                            
                            //Movemos y validamos que el archivo se haya cargado correctamente
                            //El primer campo es el origen y el segundo el destino
                            //Grabamos el registro en la tabla con los url de los archivos
                            if(move_uploaded_file($source, $destino)) { 
                                $DetalleAdjuntos = array(
                                    "numero" => $Folio,
                                    "nombre" => $filename,
                                    "urlfile" => $destino,
                                    "tipo" => $tipo
                                );
                                $result = $this->Req_adjuntosurl_model->Create($DetalleAdjuntos);
                            }
                            closedir($dir); //Cerramos el directorio de destino
                        }
                    }
                }
            }
            // actualizamos los registros del detalle
            $TotalMovimientosAgregados = 0;
            $TotalAutorizadas = 0;
            $TotalNoautorizadas = 0;
            $TotalCanceladas = 0;
            $CantModificadas = 0;
            $Detallesitems = "";
            foreach($Detalle as $Item)
            {
                if($Item["Active"] == "true" || $Item["Active"] == 1)
                {    
                    if($Item["Autorizada"] == "true" || $Item["Autorizada"] == 1)
                    {
                        $Itemautorizado = true;
                    }else{
                        $Itemautorizado = false;   
                    }
                    $DetalleSeguimientogte = array(
                        "numero" => $Folio,
                        "partida" => $Item["Partida"],
                        "articulo" => $Item["Clavearticulo"],
                        "cantidad" => $Item["Cantidad"],
                        "autorizada" => $Itemautorizado,
                        "cancelada" => $Item["Cancelada"]
                    );

                    $TotalMovimientosAgregados++;

                    if( $Item["Cancelada"] != 1 && ($Item["Autorizada"] == "true" || $Item["Autorizada"] == 1) ){
                        $Itemestatus = "AUTORIZADA";
                        $TotalAutorizadas++;
                    }else{
                        $Itemestatus = "NO AUTORIZADA";
                        $TotalNoautorizadas++;
                    }
                    if($Item["Cancelada"] == 1){
                        $Itemestatus = "CANCELADA";
                        $TotalCanceladas++;
                    }
                    if($Item["Cantidad"] != $Item["Cantidadoriginal"]){
                        $Itemmodificada = "Si";
                        $CantModificadas++;
                    }else{
                        $Itemmodificada = "";
                    }

                    $result = $this->Req_deta_model->Update($DetalleSeguimientogte);
                    //
                    // Armamos las td de la tabla html que se enviara por correo
                    //
                    //$Detallesitems =  $Detallesitems."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Cantidad"]. "</td> <td style='text-align: center;'>" .$Itemmodificada. "</td>  <td style='text-align: center;'>" .$Itemestatus. "</td> </tr>";
                    $Detallesitems =  $Detallesitems."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Clave_eq"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Cantidad"]. "</td> <td style='text-align: center;'>" .$Itemmodificada. "</td>  <td style='text-align: center;'>" .$Itemestatus. "</td> </tr>";
                }
            }

            //modificar Cabeza de requisiciones a proveedrores solo si hubo alguna autorizacion, cancelacion o cambio de cantidad
            //if($TotalAutorizadas !=0 || $TotalCanceladas !=0 || $CantModificadas !=0 || $TotalNoautorizadas !=0){
            if($TotalAutorizadas !=0 || $TotalCanceladas !=0 || $CantModificadas !=0){
                // Si cancelan todas las partidas la requi toma el estatus 9 de cancelada
                if($TotalMovimientosAgregados == $TotalCanceladas)
                {
                    $Estatus = 9;
                }else{
                    $Estatus = 1;
                }

                $CabezaSeguimientogte = array(
                    "numero" => $Folio,
                    "status" => $Estatus,
                    "revision_gte" => $TodayDate,
                    "usuarioblq" => "",
                    "Updatedby" => $LoggedUserId,
                    "Updateddate" => $TodayDate
                );
                $result = $this->Req_head_model->Update($CabezaSeguimientogte);

                //Agregar movimiento a bitacora
                $BitacoraMovimiento = array(
                    "log_ofna" => $Claveoficina,
                    "log_usuario" => $LoggedUserId,
                    "log_fecha" => $TodayDate,
                    "log_evento" => "GERENTE REVISO LA REQUISICION ".$Folio." CON ".$TotalAutorizadas." PARTIDAS AUTORIZADAS / ".$TotalCanceladas." CANCELADAS / ".$CantModificadas." MODIFICADAS.",
                    "numero" => $Folio,
                );
                $result = $this->Req_logs_model->Create($BitacoraMovimiento);

                if($TotalAutorizadas > 0)
                {
                    // SI HUBO AL MENOS 1 PARTIDA AUTORIZADA
                    // ENVIAR CORREO ELECTRONICO PARA AVISAR AL ALMACEN QUE TIENE UNA NUEVA REQUISICION
                    // Se arma el cuerpo del correo (mensaje)
                    $cabeza = '
                       <html>
                       <head>
                         <title>Aviso de nueva requisicion</title>
                       </head>
                       <body>
                         <p> TIENE UNA NUEVA REQUISICION POR PROCESAR </p>
                         <p> Numero de requisicion: <b>'.$Folio.'</b></p>
                         <p> Fecha  de autorizacion: <b>'.$TodayDate.'</b></p>
                         <p> Estado: '.$Estadorequi.' <br/>
                             Solicitante: '.$Nombreusuario.' <br/>
                             Cliente: '.$Nombrecliente.' </p>';                     

                    $pie = '<p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                       </body>
                       </html>
                       ';

                    // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                    $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                    $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                    // Solicitamos que en caso de errores estos se muestren en pantalla
                    // ini_set( 'display_errors', 1 );
                    // error_reporting( E_ALL );
                    ini_set( 'display_errors', 0 );
                    error_reporting( 0 );
                    // Definimos la cuenta que aparecera como remitente
                    $from = "adminrequi@kaltire.com";
                    // Cuenta de correo del destintario
                    $to = $Emailalm;
                    //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                    if (!empty($to)){
                        // Asunto del correo
                        $subject = "Nueva requisicion: ".$Folio." autorizada.";
                        // Se concatenan las 3 variables  del mensaje
                        $message = $cabeza.$pie;
                        // Se concatenan las cabeceras con el from
                        $headers = $cabeceras;
                        // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                        @mail($to,$subject,$message, $headers);

                        //Codigo para ver como queda el html antes de enviarlo por correo
                        // $Titulo = 'Autogte_'.$Folio.'.html';
                        // $archivo = fopen($Titulo,'w');
                        // $contenido = $message;
                        // fputs($archivo,$contenido);
                        // fclose($archivo);

                    }
                }

                //ENVIAR CORREO ELECTRONICO AL USUARIO QUE GENERO LA REQUISICION PARA INFORMARLE DE LA AUTORIZACION Y/O CAMBIOS
                // Se arma el cuerpo del correo (mensaje) en 3 variables usando un modelo de tabla html
                $cabeza = '
                   <html>
                   <head>
                     <title>Aviso de autorizacion</title>
                   </head>
                   <body>
                    <p> Requisicion revisada: '.$Folio.'</p>
                    <p> Estado: '.$Estadorequi.' <br/>
                         Solicitante: '.$Nombreusuario.' <br/>
                         Cliente: '.$Nombrecliente.' <br/> <br/>                 

                         Partidas autorizadas: '.$TotalAutorizadas.'<br/>
                         Partidas no autorizadas: '.$TotalNoautorizadas.'<br/>
                         Partidas canceladas : '.$TotalCanceladas.'<br/>
                         Partidas con cantidad modificada: '.$CantModificadas.'<br/> 
                    </p>
                     <table>
                       <tr>
                         <th> Partida </th> <th> Articulo </th> <th> Articulo_eq </th> <th> Descripcion </th> <th> Cantidad </th>  <th> Modif. </th> <th> Estado </th>
                       </tr>';

                // El detalle de los items se formo en la rutina de grabacion de los registros en la variable $Detallesitems
                           
                $pie = '
                     </table>
                     <p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                   </body>
                   </html>
                   ';

                // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                // Solicitamos que en caso de errores estos se muestren en pantalla
                // ini_set( 'display_errors', 1 );
                // error_reporting( E_ALL );
                ini_set( 'display_errors', 0 );
                error_reporting( 0 );
                // Definimos la cuenta que aparecera como remitente
                $from = "adminrequi@kaltire.com";
                // Cuenta de correo del destintario
                $to = $Emailsol;
                //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                if (!empty($to)){
                    // Asunto del correo
                    $subject = "Aviso de autorizacion de requisicion: ".$Folio;
                    // Se concatenan las 3 variables  del mensaje
                    $message = $cabeza.$Detallesitems.$pie;
                    // Se concatenan las cabeceras con el from
                    $headers = $cabeceras;
                    // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                    @mail($to,$subject,$message, $headers);

                        //Codigo para ver como queda el html antes de enviarlo por correo
                        // $Titulo = 'Modifgte_'.$Folio.'.html';
                        // $archivo = fopen($Titulo,'w');
                        // $contenido = $message;
                        // fputs($archivo,$contenido);
                        // fclose($archivo);

                }
                // Se muestra el baner con la leyenda del registro guardado y correo enviado                
                $this->session->set_flashdata('Folio', $Folio);
                $this->session->set_flashdata('message_index', 'Se guardaron los cambios en la requisicion con el folio: '.$Folio);
                $this->session->set_flashdata('class', 'success');
                redirect("Seguimientogte/Index/".$ActualPage);
            }else{
                $CabezaSeguimientogte = array(
                    "numero" => $Folio,
                    "usuarioblq" => ""
                );
                $result = $this->Req_head_model->Update($CabezaSeguimientogte);
            }

        }
    }

    function Cancel()
    {
        if($this->input->post()){
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Claveoficina = $this->session->Oficina;
            $Folio = $this->input->post("Folio");
            $Emailsol = $this->input->post("hdEmailsol");
            $Cabeza = $this->Req_head_model->GetByFolio($Folio);

            switch ($Cabeza->status) {
                case 1:
                    $Estadorequi ="Nueva";
                    break;
                case 2:
                    $Estadorequi ="Almacen";
                    break;
                case 3:
                    $Estadorequi ="Almacen/Compras";
                    break;
                default:
                    $Estadorequi ="";
                    break;
            }
            $Nombrecliente = $this->Clientes_model->GetNombreByClave($Cabeza->clave_cliente);
            $Nombreusuario = $this->Users_model->GetName($Cabeza->usuario);
            $para = $this->Users_model->GetEmail($Cabeza->usuario);

            //
            // Cancelar el head de la requisicion
            //
            $CancelarCabeza = array(
                "numero" => $Folio,
                "status" => 9,
                "Active" => false,
                "DeletedBy" => $LoggedUserId,
                "DeletedDate" => $TodayDate
            );

            $result = $this->Req_head_model->Update($CancelarCabeza);

            //
            // Cancelar el detail de la requisicion
            //
            $Detalles = $this->Req_deta_model->ObtenerListaPorFolioParaCancelar($Folio);              
            foreach($Detalles as $Item)
            {
                $CancelarDetalles = array(
                    "numero" => $Item->numero,
                    "partida" => $Item->partida,
                    "cantidad" => 0,
                    "cancelada" => 1,
                    "observa" => "CANCELADA"
                );

                $result = $this->Req_deta_model->Update($CancelarDetalles);
            }

            //Agregar movimiento a bitacora
            $AutorizadoPor = $this->input->post("AutorizadoPor");
            $UsuarioAutorizacion = $this->Users_model->GetByUserName($AutorizadoPor);
            $BitacoraMovimiento = array(
                "log_ofna" => $Claveoficina,
                "log_usuario" => $LoggedUserId,
                "log_fecha" => $TodayDate,
                "log_evento" => "SE CANCELO LA REQUISICION ".$Folio." AUTORIZADO POR ".$AutorizadoPor."-".$UsuarioAutorizacion->Name,
                "numero" => $Folio,
            );
            $result = $this->Req_logs_model->Create($BitacoraMovimiento);

            //
            // Codigo para enviar el correo electronico con el aviso de cancelacion
            //
            
            // Se guarda el asunto del correo en una variable
            $titulo = 'Aviso de cancelacion de requisicion por gerente';
            //
            // Se arma el cuerpo del correo (mensaje) en 3 variables usando un modelo de tabla html
            // para facilitar su comprension se usa una variable para la cabeza, otra para el cuerpo, aunque en este
            // ejemplo de Kaltire Requi solo se usa un renglon, esta variable de enmedio se puede usar en una rutina
            // de iteracion y generar varios renglones, se cierra la tabla html con la 3er variable.
            //
            $mensaje1 = '
               <html>
               <head>
                 <title>Aviso de cancelacion requisicion</title>
               </head>
               <body>
                 <p>Se le informa que el gerente '.$UsuarioAutorizacion->Name.' cancelo la requisicion siguiente:</p>
                 <p> Estado: CANCELADA <br/>
                     Solicitante: '.$Nombreusuario.' <br/>
                     Cliente: '.$Nombrecliente.' </p>                                      
                 <table>
                   <tr>
                     <th> Numero </th> <th> Fecha de cancelacion </th>
                   </tr>
                   <tr>';

            $mensaje2 =  "<td>" .$Folio. "</td> <td>" .$TodayDate. "</td>";
                       
            $mensaje3 = '
                   </tr>
                 </table>
               </body>
               </html>
               ';
            // Se concatenan las 3 variables 
            $mensaje = $mensaje1.$mensaje2.$mensaje3;
            // Para enviar un correo HTML, debe establecerse la cabecera Content-type
            $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
            $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
            // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro

            // ini_set( 'display_errors', 1 );
            // error_reporting( E_ALL );
            ini_set( 'display_errors', 0 );
            error_reporting( 0 );

            if (!empty($para)){
                @mail($para, $titulo, $mensaje, $cabeceras);
                    //Codigo para ver como queda el html antes de enviarlo por correo
                    // $Titulo = 'CancelRQgte_'.$Folio.'.html';
                    // $archivo = fopen($Titulo,'w');
                    // $contenido = $mensaje;
                    // fputs($archivo,$contenido);
                    // fclose($archivo);                
            }
            // Termina codigo envio de mail            

            $this->session->set_flashdata('message_index', 'Se cancelo exitosamente la requisicion con folio '.$Folio.' .');
            $this->session->set_flashdata('class', 'success');
            redirect("Seguimientogte/");
        }
    }

    function AutocompleteFolio(){
        $term = strtolower($this->input->get("term"));
        $Sorteo = $this->session->Sorteo;
        $result = $this->Req_head_model->SearchByFolio($term);
        echo json_encode($result);
    }

    function GenerarPdf() {
        $this->load->library('Pdf');
        $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('CONTROL DE REQUISICIONES');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "REQUISICION", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 0, 0), $lc = array(0, 0, 0));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage();

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));

        $numero = $this->input->post("FolioRecibo");

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 

        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Solicitantenom= $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Gerenteproynom = $Gerenteproyrec->Name;
        }else{
            $Gerenteproynom = "";
        }

        $Observaciones = count($Cabeza) > 0 ? $Cabeza[0]->observa : "";

        $FechaHoraOriginal = $Cabeza[0]->fecha_ini;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechaelab = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4)." ".$Hora;

        $FechaHoraOriginal = $Cabeza[0]->fecha_compromiso;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechacomp = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));

        //$pdf->SetFontSize(11);
        if($Cabeza[0]->status ==9){
            $pdf->SetFont('Helvetica', 'B', 14, '', true);
            $pdf->Write(5,"C A N C E L A D A", $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        }
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Requisicion: ".$numero." Tipo: ".$Tipopdto."      Almacen destino: ".$Cabeza[0]->almacen, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->SetFont('Helvetica', '', 11, '', true);
        $pdf->Write(5,"Fecha: ". $FormatoFechaelab, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);
        $pdf->SetFontSize(9);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"Cotizacion: ".$Cabeza[0]->cotizacion, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"OC/Pedido cliente: ".$Cabeza[0]->oc_pedidocliente, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Pedido por: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Solicitante: ".$Solicitantenom, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Gerente/Supervisor: ".$Gerenteproynom, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Enviar a: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Nombre: ".$Cabeza[0]->to_nombre, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Proyecto: ".$Cabeza[0]->depto, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"Empresa: ".$Cabeza[0]->to_empresa, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Direccion: ".$Cabeza[0]->to_direcc, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Telefono: ".$Cabeza[0]->to_tel, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Paqueteria sugerida: ".$Cabeza[0]->to_paquete, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES: ".substr($Cabeza[0]->observa,0,255), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        //$pdf->Line(10,93,205,93);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
       
        $pdf->SetFontSize(8);
        //$header = array('Partida','Articulo','Descripcion','Marca','Cantidad');
        $header = array('Prt','Articulo','Articulo eq.','Descripcion','Marca','Cant.');
        
        $pdf->SetFillColor(77, 77, 255);
        $pdf->SetTextColor(255);
        $pdf->SetDrawColor(0, 0, 0);
        $pdf->SetLineWidth(0.3);
        $pdf->SetFont('', 'B');
       
        $w = array(12, 30, 100, 30, 15);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $pdf->Ln();
        
        $pdf->SetFillColor(224, 235, 255);
        $pdf->SetTextColor(0);
        $pdf->SetFont('');
       
        $fill = 0;
        $TotalArticulos = 0;
        foreach($Detalles as $Item) {
            $pdf->Cell($w[0], 6, $Item->partida, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[1], 6, $Item->articulo, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[2], 6, $Item->articulo_eq, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[3], 6, substr($Item->descrip,0,45), 'LR', 0, 'L', $fill);
            $pdf->Cell($w[4], 6, $Item->marca, 'LR', 0, 'L', $fill);
            $pdf->Cell($w[5], 6, $Item->cantidad, 'LR', 0, 'C', $fill);
            $pdf->Ln();
            $fill=!$fill;
            $TotalArticulos+= $Item->cantidad;
        }
        // Línea de cierre
        $pdf->Cell(array_sum($w),0,'','T');

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES:", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,$Observaciones, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);

        $nombre_archivo = utf8_decode("Requisicion_".$numero.".pdf");
        $pdf->Output($nombre_archivo, 'D');
    }

}