<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SeguimientoAlmoo extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index($Startpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoAlmoo", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($Startpage != null && $Startpage > 0){
            $Page = $Startpage;
        }else{
            $Page = 1;
        }
        $Folio = "";
        if($this->input->post()){
            $Folio = $this->input->post('Folio');
            $Page = $this->input->post("Page");
        }
        set_value("Folio");
        $Pages = $this->Req_head_model->GetPagesAlmoo($Page, $Folio, $this->session->Oficina);
        if( $Pages <= 1){
            $Page = 1;
        }

        $CabezaRequisiciones = $this->Req_head_model->GetAllAlmoo($Page, $Folio, $this->session->Oficina);
        $Nuevas = $this->Req_head_model->GetNewAlmoo($this->session->Oficina);
        $Data['title'] = "Seguimiento otras oficinas";
        $Data['CabezaRequisiciones'] = $CabezaRequisiciones;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $Data['Nuevas'] = $Nuevas;        
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Seguimientoalmoo/Index', $Data);
        $this->load->view('layouts/footer');
    }
    
    function Details($numero = null, $actualpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoAlmoo", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $BitacoraMovimientos = $this->Req_logs_model->ObtenerListaPorFolio($numero);

        foreach($BitacoraMovimientos as $Bitacora)
        {
            $Bitacora->Usuario = $this->Users_model->GetByUserName($Bitacora->log_usuario);
        }

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        $Adjuntos = $this->Req_adjuntosurl_model->ObtenerListaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 
        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Data["Solicitante"] = $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['BitacoraMovimientos'] = $BitacoraMovimientos;
        $Data['title'] = "Consulta requisiciones otras oficinas";
        $Data['numero'] = $numero;
        $Data['actualpage'] = $actualpage;
        $Data['Tipopdto'] = $Tipopdto;
        $Data['Observaciones'] = $Observaciones;
        $Data['Cabeza'] = $Cabeza;
        $Data["Detalles"] = $Detalles;
        $Data["Adjuntos"] = $Adjuntos;
        $Data["Surtidoreq"] = $this->Req_soo_model->ObtenerListaPorFolio($numero);
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Seguimientoalmoo/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit()
    {
        if(!VerificarPermisos($this->session->UID, "SeguimientoAlmoo", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $numero = $this->input->post("EditarFolio");
        $actualpage = $this->input->post("ActualPage");
        $LoggedUserId = $this->session->UID;

        // Bloqueamos la requisicion
        $CabezaRequisiciones = array(
            "numero" => $numero,
            "usuarioblq" => $LoggedUserId
        );

        $result = $this->Req_head_model->Update($CabezaRequisiciones);

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy);
                
        $Almacenes = $this->Almacenes_model->GetList();
        $Clientes = $this->Clientes_model->GetList();
        $Proyectos = $this->Proyectos_model->GetList();

        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data['Almacenes'] = $Almacenes;
        $Data['Clientes'] = $Clientes;
        $Data['Proyectos'] = $Proyectos;

        $Data["Solicitante"] = $Solicitanterec->Name;
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['title'] = "Seguimiento otras oficinas";
        $Data['numero'] = $numero;
        $Data['actualpage'] = $actualpage;
        $Data["Cabeza"] = $Cabeza;
        $Data["Detalles"] = $this->Req_deta_model->ObtenerListaPorFolioAutorizadasoo($numero,$this->session->Oficina);
        $Data["Surtidoreq"] = $this->Req_soo_model->ObtenerListaPorFolio($numero);
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Seguimientoalmoo/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "SeguimientoAlmoo", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Folio = $this->input->post("hdNumero");
            $ActualPage = $this->input->post("hdActualPage");
            if(!VerificarBloqueoUsuarioFolio($this->session->UID, $Folio )){
                $this->session->set_flashdata('logged-message', 'Error: no se pudo guardar debido a que otro usuario tiene bloqueada la requisicion.');
                redirect("");
            }
            //
            // Obtener datos de la requisicion
            // Codigo agregado en marzo 2023
            $Datosrequi = $this->Req_head_model->GetByFolio($Folio);
            switch ($Datosrequi->status) {
                case 1:
                    $Estadorequi ="Nueva";
                    break;
                case 2:
                    $Estadorequi ="Almacen";
                    break;
                case 3:
                    $Estadorequi ="Almacen/Compras";
                    break;
                default:
                    $Estadorequi ="";
                    break;
            }
            $Nombrecliente = $this->Clientes_model->GetNombreByClave($Datosrequi->clave_cliente);
            $Nombreusuario = $this->Users_model->GetName($Datosrequi->usuario);

            //
            // Tomar datos de la oficina actual y correos electronicos
            //
            $Claveoficina = $this->session->Oficina;            
            $Oficinaactual = $this->session->Oficina;
            $Datosoficina = $this->Oficinas_model->GetByClave($Oficinaactual);
            $Emailcompradores = $this->Users_model->ObtenerMailsCompradoresPorOficina($Oficinaactual);
            if($Emailcompradores)
            {
                $Cadenacom = "";
                foreach($Emailcompradores as $Comprador)
                {
                    $Cadenacom = $Cadenacom.trim($Comprador->email).",";
                }
                $Emailcom = substr($Cadenacom,0,-1);
            }else{
                $Emailcom = "cotaemilio@hotmail.com";
            }
            //
            // Tomar datos de la oficina que solicito el apoyo y correos electronicos
            //            
            $Claveoficinaapy = $this->input->post("Claveoficina");
            $Datosoficinaapy = $this->Oficinas_model->GetByClave($Claveoficinaapy);
            $Emailalm = $this->Users_model->ObtenerMailsAlmacenPorOficina($Claveoficinaapy);
            if($Emailalm)
            {
                $Cadenacom = "";
                foreach($Emailalm as $Almacenista)
                {
                    $Cadenacom = $Cadenacom.trim($Almacenista->email).",";
                }
                $Emailalmapy = substr($Cadenacom,0,-1);
            }else{
                $Emailalmapy = "cotaemilio@hotmail.com";
            }

            $Emailsol = $this->input->post("hdEmailsol");
            //
            // Valor de los checkbox para saber que correos enviar
            //
            $Mailconfirma = $this->input->post("chkConfir");
            $Mailenvios = $this->input->post("chkEnvios");
            $Mailcompras = $this->input->post("chkCompra");

            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Fechainialmacen= $this->input->post("Fechaalm");

            $Detalle = $this->input->post("lstDetalle");
            $Observaciones = $this->input->post("Observaciones");

            $TotalMovimientosAgregados = 0;

            //modificar el req_head para poner la oficina de apoyo

                $CabezaSeguimientoalm = array(
                    "numero" => $Folio,
                    "apoyo" =>  $this->session->Oficina,
                    "usuarioblq" => ""
                );
                $result = $this->Req_head_model->Update($CabezaSeguimientoalm);
            //
            // Eliminamos los registros anteriores del surtido de partidas
            //
            $delresult = $this->Req_soo_model->BorrarPorFolio($Folio);

            // actualizamos los registros del detalle
            $TotalMovimientosCompras = 0;
            $Hubosurtido = false;
            $Detallessurtido = "";
            $Detallescompras = "";
            foreach($Detalle as $Item)
            {
                $PartidaCompras = false;
                if($Item["Active"] == "true" || $Item["Active"] == 1)
                {    

                    //
                    // Tomamos los registros del surtido de partidas
                    //
                    $Detallesurtido = preg_split("/[,]+/", $Item["Acumulado"]);
                    $tSurtido = 0;

                    foreach ($Detallesurtido as $Registro) {
                        $uFecha=new Datetime('0000-00-00');
                        if($Registro != "")
                        {
                            $Detalleseparado = preg_split("/[~]+/", $Registro);

                            $nSurtido = $Detalleseparado[1];
                            $cGuia = $Detalleseparado[2];
                            $Fechaorig= $Detalleseparado[0];
                            $FechaExplode = explode("/", $Fechaorig);
                            $dFecha = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);
                            $cPaqueteria = $Detalleseparado[3];
                            $cUnico =$Detalleseparado[4];

                            $articuloeq = $Item["Clave_eq"];
                            if (is_null($articuloeq))
                            {
                                $articuloeq = "";
                            }

                            $SurtidoAguardar = array(
                                "numero" => $Folio,
                                "partida" => $Item["Partida"],
                                "articulo" => $Item["Clavearticulo"],
                                "articulo_eq" => $articuloeq,
                                "surtido" => $nSurtido,
                                "guia_e" => $cGuia,
                                "fecha_e" =>  $dFecha->format("Y-m-d"),
                                "paqueteria" => $cPaqueteria,
                                "unico" => $cUnico
                            );
                            $result = $this->Req_soo_model->Create($SurtidoAguardar);
                            $tSurtido += $nSurtido;
                            if($dFecha > $uFecha){
                                $uFecha = $dFecha;
                            }
                            //Armamos la td del detalle de surtidos
                            //$Detallessurtido =  $Detallessurtido."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$nSurtido. "</td> <td style='text-align: center;'>" .$cGuia. "</td>  <td style='text-align: center;'>" .$cPaqueteria. "</td> <td style='text-align: center;'>" .$Fechaorig. "</td> </tr>";
                            $Detallessurtido =  $Detallessurtido."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Clave_eq"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$nSurtido. "</td> <td style='text-align: center;'>" .strtoupper($cGuia). "</td>  <td style='text-align: center;'>" .strtoupper($cPaqueteria). "</td> <td style='text-align: center;'>" .$Fechaorig. "</td> </tr>";
                            $Hubosurtido = true;                            
                        }  

                        $DetalleSeguimientoalm = array(
                            "numero" => $Folio,
                            "partida" => $Item["Partida"],
                            "articulo" => $Item["Clavearticulo"],
                            "surtapoyo" => $tSurtido,
                            "compapy" => $Item["Paracompras"],
                            "cntcompapy" => $Item["Cantcomp"],
                            "observapoy" => $Item["Observa"]
                        );

                        // Validar las partidas para compras
                        if($Item["Cantcomp"] != "0"){
                            $PartidaCompras = true;
                        }
                    }
                    // Si la partida tenia articulos para compras incrementar el contador
                    if($PartidaCompras){
                        //$Detallescompras =  $Detallescompras."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Cantcomp"]. "</td> </tr>";
                        $Detallescompras =  $Detallescompras."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Clave_eq"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Cantcomp"]. "</td> </tr>";
                        $TotalMovimientosCompras++;
                    }

                    $TotalMovimientosAgregados++;
                    $result = $this->Req_deta_model->Update($DetalleSeguimientoalm);
                }
                //modificar el req_head solo si la requisicion lleva articulos para compra
                //se pone el status en 3

                if($TotalMovimientosCompras >0)
                {
                    $CabezaSeguimientoalm = array(
                        "numero" => $Folio,
                        "status" => 3,
                        "usuarioblq" => ""
                    );

                    $result = $this->Req_head_model->Update($CabezaSeguimientoalm);
                }else{
                    $CabezaSeguimientogte = array(
                        "numero" => $Folio,
                        "usuarioblq" => ""
                    );
                    $result = $this->Req_head_model->Update($CabezaSeguimientogte);
                }

            }

            //Agregar movimiento a bitacora
            $BitacoraMovimiento = array(
                "log_ofna" => $Claveoficina,
                "log_usuario" => $LoggedUserId,
                "log_fecha" => $TodayDate,
                "log_evento" => "SE PROCESO LA REQUISICION (OTRAS OFICINAS) ".$Folio." CON ".$TotalMovimientosCompras." PARTIDAS PARA COMPRAS",
                "numero" => $Folio,
            );
            $result = $this->Req_logs_model->Create($BitacoraMovimiento);

            // actualizamos los registros cancelados del detalle 
            $TotalCanceladas = 0;
            $Detallescanc = "";
            foreach($Detalle as $Item)
            {
                if($Item["Active"] == "true" || $Item["Active"] == 1)
                {
                    if($Item["Cancelada"] == 1){
                        $Itemestatus = "CANCELADA";
                        $TotalCanceladas++;

                        $DetalleSeguimientocanc = array(
                            "numero" => $Folio,
                            "partida" => $Item["Partida"],
                            "articulo" => $Item["Clavearticulo"],
                            "observapoy" => "CANCELADA",
                            "cancelapy" => $Item["Cancelada"]
                        );

                        $result = $this->Req_deta_model->Update($DetalleSeguimientocanc);
                        //$Detallescanc =  $Detallescanc."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Pedidooriginal"]. " <td style='text-align: center;'>" .$Itemestatus. "</td> </tr>";
                        $Detallescanc =  $Detallescanc."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Clave_eq"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Pedidooriginal"]. " <td style='text-align: center;'>" .$Itemestatus. "</td> </tr>";
                    }
                }
            }

            //Agregar movimiento a bitacora si hubo canceladas
            if($TotalCanceladas > 0)
            {
                $BitacoraMovimiento = array(
                    "log_ofna" => $Claveoficina,
                    "log_usuario" => $LoggedUserId,
                    "log_fecha" => $TodayDate,
                    "log_evento" => "EL ALMACEN DE LA OFICINA ".$Claveoficina." CANCELO ".$TotalCanceladas." PARTIDA(S) SOLICITADA(S) EN APOYO DE LA REQUISICION ".$Folio,
                    "numero" => $Folio,
                );
                $result = $this->Req_logs_model->Create($BitacoraMovimiento);
            }

            //ENVIAR CORREO ELECTRONICO AL ALMACEN QUE SOLICITO EL APOYO SI ES QUE HUBO PARTIDAS CANCELADAS
            if($TotalCanceladas > 0)
            {
                $cabeza = '
                   <html>
                   <head>
                     <title>Aviso de partidas de apoyo canceladas por almacen</title>
                   </head>
                   <body>
                     <p> El almacen de la oficina: <b>'.$Datosoficina->nombre.'</b></p>
                     <p> Le avisa que se cancelaron '.$TotalCanceladas.' partida(s) de la requisicion de apoyo: <b>'.$Folio.'</b></p>
                     <p> Estado: '.$Estadorequi.' <br/>
                         Solicitante: '.$Nombreusuario.' <br/>
                         Cliente: '.$Nombrecliente.' </p>                                          
                     <p> Detalle de partidas de apoyo canceladas:</p>
                     <table>
                       <tr>
                         <th> Partida </th> <th> Articulo </th> <th> Articulo_eq </th> <th> Descripcion </th> <th> Cantidad </th> <th> Estado </th>
                       </tr>';

                // El detalle de los items se formo en la rutina de grabacion de los registros en la variable $Detallescanc
                           
                $pie = '
                     </table>
                     <p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                   </body>
                   </html>
                   ';

                // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                // Solicitamos que en caso de errores estos se muestren en pantalla
                // ini_set( 'display_errors', 1 );
                // error_reporting( E_ALL );
                ini_set( 'display_errors', 0 );
                error_reporting( 0 );
                // Definimos la cuenta que aparecera como remitente
                $from = "adminrequi@kaltire.com";
                // Cuenta de correo del destintario
                $to = $Emailalmapy;
                //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                if (!empty($to)){
                    // Asunto del correo
                    $subject = "Aviso de partidas canceladas de la requisicion de apoyo: ".$Folio;
                    // Se concatenan las 3 variables  del mensaje
                    $message = $cabeza.$Detallescanc.$pie;
                    // Se concatenan las cabeceras con el from
                    $headers = $cabeceras;
                    // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                    @mail($to,$subject,$message, $headers);
                }
            }
            //

            // ENVIAR CORREO ELECTRONICO CON EL DETALLE DE ENVIOS SI MARCARON LA CASILLA
            if($Mailenvios == "1" && $Hubosurtido){
                // Se arma el cuerpo del correo (mensaje) en 3 variables usando un modelo de tabla html
                $cabeza = '
                   <html>
                   <head>
                     <title>Actualizacion de envios</title>
                   </head>
                   <body>
                     <p> El almacen de la oficina: <b>'.$Datosoficina->nombre.'</b></p>
                     <p> Ha realizado los siguientes envios en APOYO de la requisicion: <b>'.$Folio.'</b></p>
                     <p> Estado: '.$Estadorequi.' <br/>
                         Solicitante: '.$Nombreusuario.' <br/>
                         Cliente: '.$Nombrecliente.' </p>                                                               
                     <table>
                       <tr>
                         <th> Partida </th> <th> Articulo </th> <th> Articulo_eq </th> <th> Descripcion </th> <th> Surtido </th>  <th> Guia </th> <th> Paqueteria </th> <th> Fecha </th>
                       </tr>';

                // El detalle de los items se formo en la rutina de grabacion de los registros en la variable $Detallessurtido
                           
                $pie = '
                     </table>
                     <p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                   </body>
                   </html>
                   ';

                // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
                // Para agregar con copia 
                $cabeceras .= 'Cc: martin_gamez@kaltire.com' . "\r\n";
                // Para agregar con copia olculta
                $cabeceras .= "Bcc: cotaemilio@hotmail.com\r\n"; 

                // Solicitamos que en caso de errores estos se muestren en pantalla
                // ini_set( 'display_errors', 1 );
                // error_reporting( E_ALL );
                ini_set( 'display_errors', 0 );
                error_reporting( 0 );
                // Definimos la cuenta que aparecera como remitente
                $from = "adminrequi@kaltire.com";
                // Cuenta de correo del destintario
                $to = $Emailalmapy;
                //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                 if (!empty($to)){
                    // Asunto del correo
                    $subject = "Actualizacion de envios en apoyo de la requisicion: ".$Folio;
                    // Se concatenan las 3 variables  del mensaje
                    $message = $cabeza.$Detallessurtido.$pie;
                    // Se concatenan las cabeceras con el from
                    $headers = $cabeceras;
                    // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                    @mail($to,$subject,$message, $headers);
                }
            }        

            // ENVIAR CORREO ELECTRONICO CON EL AVISO A COMPRAS SI MARCARON LA CASILLA Y HUBO PARTIDAS PARA COMPRA
            if($Mailcompras == "1" && $TotalMovimientosCompras > 0){
                // Se arma el cuerpo del correo (mensaje) en 3 variables usando un modelo de tabla html
                $cabeza = '
                   <html>
                   <head>
                     <title>Actualizacion de envios</title>
                   </head>
                   <body>
                     <p> El almacen de la oficina: <b>'.$Datosoficina->nombre.'</b></p>
                     <p> Le informa que la requisicion no.: <b>'.$Folio.'</b></p>
                     <p> Estado: '.$Estadorequi.' <br/>
                         Solicitante: '.$Nombreusuario.' <br/>
                         Cliente: '.$Nombrecliente.' </p>                                                               
                     <p> Contiene partidas en apoyo para ser procesadas por el area de compras </p>
                     <table>
                       <tr>
                         <th> Partida </th> <th> Articulo </th> <th> Articulo_eq </th> <th> Descripcion </th> <th> Cantidad </th>
                       </tr>';

                $pie = '
                     </table>
                     <p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                   </body>
                   </html>
                   ';

                // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                // Solicitamos que en caso de errores estos se muestren en pantalla
                // ini_set( 'display_errors', 1 );
                // error_reporting( E_ALL );
                ini_set( 'display_errors', 0 );
                error_reporting( 0 );
                // Definimos la cuenta que aparecera como remitente
                $from = "adminrequi@kaltire.com";
                // Cuenta de correo del destintario
                $to = $Emailcom;
                //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                // Asunto del correo
                if (!empty($to)){
                    $subject = "Requisicion: ".$Folio." a compras en apoyo.";
                    // Se concatenan las 3 variables  del mensaje
                    $message = $cabeza.$Detallescompras.$pie;
                    // Se concatenan las cabeceras con el from
                    $headers = $cabeceras;
                    // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                    @mail($to,$subject,$message, $headers);
                }
            }   

            // ENVIAR CORREO ELECTRONICO CON LA CONFIRMACION DEL ALMACEN SI MARCARON LA CASILLA
            if($Mailconfirma == "1"){
                // Se arma el cuerpo del correo (mensaje)
                $cabeza = '
                   <html>
                   <head>
                     <title>Confirmacion de recibido</title>
                   </head>
                   <body>
                     <p> El almacen de la oficina: <b>'.$Datosoficina->nombre.'</b></p>
                     <p> Confirma de recibida la requisicion en APOYO no.: <b>'.$Folio.'</b></p>
                     <p> Estado: '.$Estadorequi.' <br/>
                         Solicitante: '.$Nombreusuario.' <br/>
                         Cliente: '.$Nombrecliente.' </p>                                                               
                     <p> Se inicia su procesamiento. </p>';

                $pie = '<p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                   </body>
                   </html>
                   ';

                // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                // Solicitamos que en caso de errores estos se muestren en pantalla
                // ini_set( 'display_errors', 1 );
                // error_reporting( E_ALL );
                ini_set( 'display_errors', 0 );
                error_reporting( 0 );
                // Definimos la cuenta que aparecera como remitente
                $from = "adminrequi@kaltire.com";
                // Cuenta de correo del destintario
                $to = $Emailalmapy;
                //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                // Asunto del correo
                if (!empty($to)){
                    $subject = "Requisicion de apoyo : ".$Folio." recibida.";
                    // Se concatenan las 3 variables  del mensaje
                    $message = $cabeza.$pie;
                    // Se concatenan las cabeceras con el from
                    $headers = $cabeceras;
                    // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                    @mail($to,$subject,$message, $headers);
                }
            }
//

            $this->session->set_flashdata('Folio', $Folio);
            $this->session->set_flashdata('message_index', 'Se guardo exitosamente la requisicion de otras oficinas con el folio: '.$Folio);
            $this->session->set_flashdata('class', 'success');
            redirect("Seguimientoalmoo/Index/".$ActualPage);
        }
    }

    function Cancel()
    {
        $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
        redirect("");
        
        // if($this->input->post()){
        //     $TodayDate = unix_to_human(time(), TRUE, 'mx');
        //     $LoggedUserId = $this->session->UID;
        //     $Folio = $this->input->post("Folio");
        //     $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($Folio);
        //     //
        //     // Cancelar el head de la requisicion
        //     //
        //     foreach($Cabeza as $ItemC)
        //     {
        //         $CancelarCabeza = array(
        //             "numero" => $ItemC->numero,
        //             "status" => 9,
        //             "Active" => false,
        //             "DeletedBy" => $LoggedUserId,
        //             "DeletedDate" => $TodayDate
        //         );

        //         $result = $this->Req_head_model->Update($CancelarCabeza);
        //     }

        //     //
        //     // Cancelar el detail de la requisicion
        //     //
        //     $Detalles = $this->Req_deta_model->ObtenerListaPorFolioParaCancelar($Folio);              
        //     foreach($Detalles as $Item)
        //     {
        //         $CancelarDetalles = array(
        //             "numero" => $Item->numero,
        //             "partida" => $Item->partida,
        //             "cantidad" => 0,
        //             "cancelada" => 1,
        //             "observa" => "CANCELADA"
        //         );

        //         $result = $this->Req_deta_model->Update($CancelarDetalles);
        //     }

        //     //Agregar movimiento a bitacora
        //     $AutorizadoPor = $this->input->post("AutorizadoPor");
        //     $UsuarioAutorizacion = $this->Users_model->GetByUserName($AutorizadoPor);
        //     $BitacoraMovimiento = array(
        //         "log_ofna" => $Claveoficina,
        //         "log_usuario" => $LoggedUserId,
        //         "log_fecha" => $TodayDate,
        //         "log_evento" => "SE CANCELO LA REQUISICION ".$Folio." AUTORIZADO POR ".$AutorizadoPor."-".$UsuarioAutorizacion->Name,
        //         "numero" => $Folio,
        //     );
        //     $result = $this->Req_logs_model->Create($BitacoraMovimiento);

        //     $this->session->set_flashdata('message_index', 'Se cancelo exitosamente la requisicion con folio '.$Folio.' .');
        //     $this->session->set_flashdata('class', 'success');
        //     redirect("Seguimientoalmoo/");
        // }
    }

    function AutocompleteFolio(){
        $term = strtolower($this->input->get("term"));
        $Sorteo = $this->session->Sorteo;
        $result = $this->Req_head_model->SearchByFolio($term);
        echo json_encode($result);
    }

    function GenerarPdf() {
        $this->load->library('Pdf');
        $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('CONTROL DE REQUISICIONES');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "REQUISICION", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 0, 0), $lc = array(0, 0, 0));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage();

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));

        $numero = $this->input->post("FolioRecibo");

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolioAutorizadasNocanceladasoo($numero,$this->session->Oficina);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 

        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Solicitantenom= $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Gerenteproynom = $Gerenteproyrec->Name;
        }else{
            $Gerenteproynom = "";
        }

        $Observaciones = count($Cabeza) > 0 ? $Cabeza[0]->observa : "";

        $FechaHoraOriginal = $Cabeza[0]->fecha_ini;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechaelab = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4)." ".$Hora;

        $FechaHoraOriginal = $Cabeza[0]->fecha_compromiso;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechacomp = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));

        //$pdf->SetFontSize(11);
        if($Cabeza[0]->status ==9){
            $pdf->SetFont('Helvetica', 'B', 14, '', true);
            $pdf->Write(5,"C A N C E L A D A", $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        }
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Requisicion: ".$numero." Tipo: ".$Tipopdto."      Almacen destino: ".$Cabeza[0]->almacen, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->SetFont('Helvetica', '', 11, '', true);
        $pdf->Write(5,"Fecha: ". $FormatoFechaelab, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);
        $pdf->SetFontSize(9);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"Fecha compromiso: ".$FormatoFechacomp."            Cotizacion: ".$Cabeza[0]->cotizacion, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"OC/Pedido cliente: ".$Cabeza[0]->oc_pedidocliente, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Pedido por: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Solicitante: ".$Solicitantenom, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Gerente/Supervisor: ".$Gerenteproynom, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Enviar a: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Nombre: ".$Cabeza[0]->to_nombre, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Proyecto: ".$Cabeza[0]->depto, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"Empresa: ".$Cabeza[0]->to_empresa, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Direccion: ".$Cabeza[0]->to_direcc, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Telefono: ".$Cabeza[0]->to_tel, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Paqueteria sugerida: ".$Cabeza[0]->to_paquete, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES: ".substr($Cabeza[0]->observa,0,255), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        //$pdf->Write(5,substr($Cabeza[0]->observa,81,100), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
       
        $pdf->SetFontSize(8);
        //$header = array('Articulo','Descripcion','Marca','Cant.','Surt.','Guia emb.','Fecha emb.','Pend.','Fecha est.');
        //$header = array('Articulo','Descripcion','Cant.','Surt.','Guia emb.','Fecha emb.','Pend.','Paqueteria');
        $header = array('Articulo','Art. Eq.','Descripcion','Cant.','Surt.','Guia emb.','Fecha emb.','Pend.','Paqueteria');

        $pdf->SetFillColor(77, 77, 255);
        $pdf->SetTextColor(255);
        $pdf->SetDrawColor(0, 0, 0);
        $pdf->SetLineWidth(0.3);
        $pdf->SetFont('', 'B');
       
        //$w = array(20,60,15,12,12,20,20,12,20);
        //$w = array(20,60,12,12,20,20,12,35);
        $w = array(22,26,52,10,10,18,18,10,25);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $pdf->Ln();
        
        $pdf->SetFillColor(224, 235, 255);
        $pdf->SetTextColor(0);
        $pdf->SetFont('');
       
        $fill = 0;
        $TotalArticulos = 0;
        foreach($Detalles as $Item) {
            // Leemos de la tabla req_surt los datos de la ultima guia y fecha de embarque
            $Fechaembarque = "";
            $Guiaembarque = "";
            $Paqembarque = "";
            $Datosembarque = $this->Req_soo_model->ObtenerUltimaGuiaFechaEmb($Item->numero,$Item->partida);

            if($Datosembarque){
                $Paqembarque = $Datosembarque->paqueteria;
                $Guiaembarque = $Datosembarque->guia_e;
                // Convertimos las fechas al formato DD/MM/AAAA
                $FechaHoraOriginal = $Datosembarque->fecha_e;
                if($FechaHoraOriginal != "0000-00-00"){
                    $Fechaembarque = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4)." ".$Hora;
                }else{
                    $Fechaembarque = "";
                }
            }

            $FechaHoraOriginal = $Item->fecha_est;
            if($FechaHoraOriginal != "1753-01-01"){
                $Fechaestimada = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4)." ".$Hora;
            }else{
                $Fechaestimada = "";
            }

            $pdf->Cell($w[0], 6, $Item->articulo, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[1], 6, $Item->articulo_eq, 'LR', 0, 'L', $fill);
            $pdf->Cell($w[2], 6, substr($Item->descrip,0,32), 'LR', 0, 'L', $fill);
            $pdf->Cell($w[3], 6, $Item->cantapoy, 'LR', 0, 'R', $fill);
            $pdf->Cell($w[4], 6, $Item->surtapoyo, 'LR', 0, 'R', $fill);
            $pdf->Cell($w[5], 6, $Guiaembarque, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[6], 6, $Fechaembarque, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[7], 6, $Item->cantapoy-$Item->surtapoyo, 'LR', 0, 'R', $fill);
            $pdf->Cell($w[8], 6, substr($Paqembarque,0,10), 'LR', 0, 'C', $fill);
            $pdf->Ln();
            $fill=!$fill;
            $TotalArticulos+= $Item->cantidad;
        }
        // Línea de cierre
        $pdf->Cell(array_sum($w),0,'','T');

/*        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES:", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,$Observaciones, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);*/

        $nombre_archivo = utf8_decode("Requisicion_".$numero.".pdf");
        $pdf->Output($nombre_archivo, 'D');
    }
}