<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Requisiciones extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index($Startpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($Startpage != null && $Startpage > 0){
            $Page = $Startpage;
        }else{
            $Page = 1;
        }
        $Folio = "";
        if($this->input->post()){
            $Folio = $this->input->post('Folio');
            $Page = $this->input->post("Page");
        }
        set_value("Folio");
        $Pages = $this->Req_head_model->GetPages($Page, $Folio, $this->session->UID);
        if( $Pages <= 1){
            $Page = 1;
        }

        $CabezaRequisiciones = $this->Req_head_model->GetAll($Page, $Folio, $this->session->UID);
        $Data['title'] = "Requisiciones";
        $Data['CabezaRequisiciones'] = $CabezaRequisiciones;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Requisiciones/Index', $Data);
        $this->load->view('layouts/footer');
    }

//
// Funcion Create
//
    function Create($actualpage = null){
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        // Tomamos el nombre del almacen del usuario
        $Usrnomalmacen = $this->Almacenes_model->GetNombreByClave($this->session->Almacen);

        $Almacenes = $this->Almacenes_model->GetList();
    	$Parametros = $this->Parametros_model->GetUnique();
        $Clientes = $this->Clientes_model->GetList();
        $Proyectos = $this->Proyectos_model->GetList();
        $Datoalm = $this->Almacenes_model->GetByClave($this->session->Almacen);

        $Data['Almacenes'] = $Almacenes;
        $Data['Clientes'] = $Clientes;
        $Data['Proyectos'] = $Proyectos;
        $Data['Usralmacen'] = $this->session->Almacen;
        $Data['Usrlevel'] = $this->session->Level;
        $Data['Usrnomalmacen'] = $Usrnomalmacen;
        $Data['Oficina1'] = $Datoalm->ofna;
        $Data['Oficina2'] = $Datoalm->ofna2;
        $Data['actualpage'] = $actualpage;
        $Data['title'] = "Crear requisicion";
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Requisiciones/Create', $Data);
        $this->load->view('layouts/footer');
    }


//
// Funcion CreatePost
//
    function CreatePost(){
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Tiporeq = $this->input->post("TipoReq");
            $Tipopdto = $this->input->post("TipoPdto");
            $Clavealmacen = $this->input->post("Clavealmacen");
            $Nombrealmacen = $this->input->post("Clavealmacen");
            $ActualPage = $this->input->post("hdActualPage");

            if($Tiporeq == "VENTA")
            {
                $Claveoficina = $this->input->post("Claveoficina2");
                $Cotizacion = strtoupper($this->input->post("Cotizacion"));
                $Ocpedido = strtoupper($this->input->post("Ocpedido"));
                $Fechacomptmp= $this->input->post("Fechacompromiso");
                $FechaExplode = explode("/", $Fechacomptmp);
                $Fechacompromiso = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);
            }else{
                $Claveoficina = $this->input->post("Claveoficina");
                $Cotizacion = "";
                $Ocpedido = "";
                $Fechacompromiso = new DateTime("0000-00-00");
            }

            $Tonombre = strtoupper($this->input->post("Tonombre"));
            $Togerente = strtoupper($this->input->post("Togerente"));
            $Clavecliente = $this->input->post("Clavecliente");
            $Nombrecliente = strtoupper($this->input->post("Nombrecliente"));
            $Claveproyecto = $this->input->post("Claveproyecto");
            $Nombreproyecto = strtoupper($this->input->post("Nombreproyecto"));
            $Nombregerente = strtoupper($this->input->post("Nombregerente"));
            $Direccion = strtoupper($this->input->post("Direccion"));
            $Telefono = strtoupper($this->input->post("Totelefono"));
            $Paqueteria = strtoupper($this->input->post("Topaquete"));
            $Gerenteproy = strtoupper($this->input->post("Usuariogerente"));
            $Emailgerente = strtolower($this->input->post("Emailgerente"));
            $Emailalm = "";
            //
            // Tomamos los correos de los responsables de almacen de la oficina para las requi de tipo VENTA
            //
            //$Oficinaactual = $this->session->Oficina;
            $Oficinaactual = $Claveoficina;
            $Datosoficina = $this->Oficinas_model->GetByClave($Oficinaactual);
            $Emailalmacenistas = $this->Users_model->ObtenerMailsAlmacenPorOficina($Oficinaactual);

            if($Emailalmacenistas)
            {
                $Cadenaalm = "";
                foreach($Emailalmacenistas as $Almacenista)
                {
                    $Cadenaalm = $Cadenaalm.trim(strtolower($Almacenista->email)).",";
                }
                $Emailalm = substr($Cadenaalm,0,-1);
            }else{
                $Emailalm = "cotaemilio@hotmail.com";
            }            

            $Detalle = $this->input->post("lstDetalle");
            $Observaciones = strtoupper($this->input->post("Observaciones"));

            // Bloqueamos la tabla req_head
            $this->Req_head_model->Bloquear();

            // Tomamos el folio siguiente de requisiciones
            $Folio = $this->Req_head_model->ObtenerUltimoFolio();

            //Agregar el registro a la tabla Cabeza de requisiciones
            $CabezaRequisiciones = array(
                "tipo" => $Tipopdto,
                "numero" => $Folio,
                "almacen" => $Clavealmacen,
                "fecha_ini" => $TodayDate,
                "usuario" => $LoggedUserId,
                "to_nombre" => $Tonombre,
                "to_direcc" => $Direccion,
                "to_tel" => $Telefono,
                "to_paquete" => $Paqueteria,
                "gerente" => $Togerente,
                "depto" => $Nombreproyecto,
                "clave_proyecto" => $Claveproyecto,
                "t_neces" => "1",
                "t_pedido" => "1",
                "status" => "1",
                "fecha_sr1" => $TodayDate,
                "fecha_fin" => "1753-01-01",
                "fecha_sr2" => "1753-01-01",
                "fecha_sr3" => "1753-01-01",
                "observa" => $Observaciones,
                "fecha_comp" => "1753-01-01",
                "to_empresa" => $Nombrecliente,
                "clave_cliente" => $Clavecliente,
                "ofna" => $Claveoficina,
                "apoyo" => "00",
                "fecha_compromiso" => $Fechacompromiso->format("Y-m-d"),
                "oc_pedidocliente" => $Ocpedido,
                "tipo_req" => $Tiporeq,
                "cotizacion" => $Cotizacion,
                "gerente_proy" => $Gerenteproy,
                "Active" => true,
                "Createdby" => $LoggedUserId,
                "Createddate" => $TodayDate,
                "Updatedby" => $LoggedUserId,
                "Updateddate" => $TodayDate
            );

            $result = $this->Req_head_model->Create($CabezaRequisiciones);

            // desbloqueamos la tabla req_head
            $this->Req_head_model->Desbloquear();


            // Guardamos los archivos adjuntos
            foreach($_FILES["adjunto"]['tmp_name'] as $key => $tmp_name)
            {
                //Validamos que el archivo exista
                if($_FILES["adjunto"]["name"][$key])
                {
                    // Validamos que no mida mas de 10MB
                    if($_FILES["adjunto"]["size"][$key] <= 10000000)
                    {
                        $filename = $_FILES["adjunto"]["name"][$key]; //Obtenemos el nombre original del archivo
                        $source = $_FILES["adjunto"]["tmp_name"][$key]; //Obtenemos un nombre temporal del archivo
                        $tipo = $_FILES["adjunto"]["type"][$key]; //Obtenemos el tipo del archivo
                        
                        $directorio = 'adjuntos/'; //Declaramos un  variable con la ruta donde guardaremos los archivos
                                            
                        $dir=opendir($directorio); //Abrimos el directorio de destino
                        $destino = $directorio.'/'.$filename; //Indicamos la ruta de destino, así como el nombre del archivo
                        
                        //Movemos y validamos que el archivo se haya cargado correctamente
                        //El primer campo es el origen y el segundo el destino
                        //Grabamos el registro en la tabla con los url de los archivos
                        if(move_uploaded_file($source, $destino)) { 
                            $DetalleAdjuntos = array(
                                "numero" => $Folio,
                                "nombre" => $filename,
                                "urlfile" => $destino,
                                "tipo" => $tipo
                            );
                            $result = $this->Req_adjuntosurl_model->Create($DetalleAdjuntos);
                        }
                        closedir($dir); //Cerramos el directorio de destino
                    }
                }
            }

            // Grabamos el detalle de partidas
            $Partida=1;
            $TotalMovimientosAgregados = 0;
            // Si es reposicion las partidas no salen autorizadas de origen
            if($Tiporeq == "REPOSICION"){
                $Autopart = false;
            }else{
                // Si es venta las partidas ya debe ir autorizadas
                $Autopart = true;
            }
            foreach($Detalle as $Item)
            {
                if($Item["Active"] == "true" || $Item["Active"] == 1)
                {             	

                    $DetalleRequisiciones = array(
                   		"numero" => $Folio,
                        "partida" => $Partida,
		                "articulo" => strtoupper($Item["Clavearticulo"]),
                        "articulo_eq" => strtoupper($Item["Clave_eq"]),
                        "descrip" => strtoupper($Item["Descripcion"]),
                        "marca" => strtoupper($Item["Marca"]),
                        "cantidad" => $Item["Cantidad"],
                        "autorizada" => $Autopart,
                        "fecha_e" => "1753-01-01",
                        "fecha_est" => "1753-01-01",
                        "apoyo" => "00"
		            );

		            $result = $this->Req_deta_model->Create($DetalleRequisiciones);
                    $Partida++;
                    $TotalMovimientosAgregados++;

                }
            }

            //Agregar movimiento a bitacora
            $Logs = array(
                "log_ofna" => $Claveoficina,
                "log_usuario" => $LoggedUserId,
                "log_fecha" => $TodayDate,
                "log_evento" => "SE CREO LA REQUISICION ".$Folio." CON ".$TotalMovimientosAgregados." REGISTROS.",
                "numero" => $Folio,
            );
            $result = $this->Req_logs_model->Create($Logs);

            //ENVIAR CORREO ELECTRONICO

            // Se arma el cuerpo del correo (mensaje) en 3 variables usando un modelo de tabla html
            // para facilitar su comprension se usa una variable para la cabeza, otra para el cuerpo, aunque en este
            // ejemplo de Kaltire Requi solo se usa un renglon, esta variable de enmedio se puede usar en una rutina
            // de iteracion y generar varios renglones, se cierra la tabla html con la 3er variable.
            if($Tiporeq == "REPOSICION"){
                $mensaje1 = '
                   <html>
                   <head>
                     <title>Aviso de nueva requisicion</title>
                   </head>
                   <body>
                     <p>TIENE UNA NUEVA REQUISICION TIPO REPOSICION PARA AUTORIZAR</p>
                     <table>
                       <tr>
                         <th> Numero </th> <th> Fecha </th>
                       </tr>';
            }else{
                $mensaje1 = '
                   <html>
                   <head>
                     <title>Aviso de nueva requisicion</title>
                   </head>
                   <body>
                     <p>TIENE UNA NUEVA REQUISICION TIPO VENTA PARA LA CONSULTA DEL GERENTE Y PROCESAMIENTO DEL ALMACEN</p>
                     <table>
                       <tr>
                         <th> Numero </th> <th> Fecha </th>
                       </tr>';                
            }

            $mensaje2 =  "<tr>
                            <td style='text-align: center;'>" .$Folio. "</td> <td style='text-align: center;'>" .$TodayDate. "</td>
                          </tr>";
                       
            $mensaje3 = '
                 </table>
                 <p> Estado: NUEVA <br/>
                     Solicitante: '.$this->session->Name.' <br/>
                     Cliente: '.$Nombrecliente.' </p>

                 <p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
               </body>
               </html>
               ';

            // Para enviar un correo HTML, debe establecerse la cabecera Content-type
            $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
            $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

            // Solicitamos que en caso de errores estos se muestren en pantalla
            // ini_set( 'display_errors', 1 );
            // error_reporting( E_ALL );
            ini_set( 'display_errors', 0 );
            error_reporting( 0 );
            // Definimos la cuenta que aparecera como remitente
            $from = "adminrequi@kaltire.com";
            // Cuenta de correo del destintario si es reposicion al gerente, si es venta al gerente y al almacen
            if($Tiporeq == "REPOSICION"){
                $to = $Emailgerente;
            }else{
                $to = $Emailgerente.",".$Emailalm;
            }
            
            // Si el correo electronico no esta vacio
            if (!empty($to)){
                // Asunto del correo
                if($Tiporeq == "REPOSICION"){
                    $subject = "Nueva requisicion de reposicion para autorizacion: ".$Folio;
                }else{
                    $subject = "Nueva requisicion de tipo VENTA: ".$Folio;
                }
                // Se concatenan las 3 variables  del mensaje
                $message = $mensaje1.$mensaje2.$mensaje3;
                // Se concatenan las cabeceras con el from
                $headers = $cabeceras;
                //$headers = $cabeceras."From:" . $from;
                // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                @mail($to,$subject,$message, $headers);

                // Codigo para ver como queda el html antes de enviarlo por correo
                // $Titulo = 'Requi_'.$Folio.'.html';
                // $archivo = fopen($Titulo,'w');
                // $contenido = $message;
                // fputs($archivo,$contenido);
                // fclose($archivo);

                // Se muestra el baner con la leyenda del registro guardado y correo enviado
                $this->session->set_flashdata('Folio', $Folio);
                $this->session->set_flashdata('message_index', 'Se guardo exitosamente la requisicion con el folio: '.$Folio.' correo enviado a: '.$to);
                $this->session->set_flashdata('class', 'success');
                redirect("Requisiciones/Index/".$ActualPage);
            }else{    
                // Se muestra el baner con la leyenda del registro guardado y correo no enviado
                $this->session->set_flashdata('Folio', $Folio);
                $this->session->set_flashdata('message_index', 'Se guardo la requisicion con el folio: '.$Folio.' pero no se pudo enviar correo, revise la direccion de email.');
                $this->session->set_flashdata('class', 'danger');
                redirect("Requisiciones/Index/".$ActualPage);
            }
        }
    }
    
    function Details($numero = null, $actualpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $BitacoraMovimientos = $this->Req_logs_model->ObtenerListaPorFolio($numero);

        foreach($BitacoraMovimientos as $Bitacora)
        {
            $Bitacora->Usuario = $this->Users_model->GetByUserName($Bitacora->log_usuario);
        }

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        $Adjuntos = $this->Req_adjuntosurl_model->ObtenerListaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 
        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Data["Solicitante"] = $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['BitacoraMovimientos'] = $BitacoraMovimientos;
        $Data['title'] = "Detalles de requisiciones";
        $Data['numero'] = $numero;
        $Data['actualpage'] = $actualpage;
        $Data['Tipopdto'] = $Tipopdto;
        $Data['Observaciones'] = $Observaciones;
        $Data['Cabeza'] = $Cabeza;
        $Data["Detalles"] = $Detalles;
        $Data["Adjuntos"] = $Adjuntos;
        $Data["Surtidoreq"] = $this->Req_surt_model->ObtenerListaPorFolio($numero);
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Requisiciones/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit()
    {
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $numero = $this->input->post("EditarFolio");
        $actualpage = $this->input->post("ActualPage");
        $LoggedUserId = $this->session->UID;

        // Bloqueamos la requisicion
        $CabezaRequisiciones = array(
            "numero" => $numero,
            "usuarioblq" => $LoggedUserId
        );

        $result = $this->Req_head_model->Update($CabezaRequisiciones);

        //Obtenemos la informacion de la cabeza de la requi
        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy);

        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data["Solicitante"] = $Solicitanterec->Name;
        $Data['title'] = "Editar requisicion";
        $Data['numero'] = $numero;
        $Data["Cabeza"] = $Cabeza;
        $Data["Detalles"] = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        $Data['Oficina1'] = $Almacenrec->ofna;
        $Data['Oficina2'] = $Almacenrec->ofna2;        
        $Data['actualpage'] = $actualpage;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Requisiciones/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        if($this->input->post()){
            $Folio = $this->input->post("hdNumero");
            $ActualPage = $this->input->post("hdActualPage");
            if(!VerificarBloqueoUsuarioFolio($this->session->UID, $Folio )){
                $this->session->set_flashdata('logged-message', 'Error: no se pudo guardar debido a que otro usuario tiene bloqueada la requisicion.');
                redirect("");
            }

            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            
            $Tiporeq = $this->input->post("TipoReq");
            $Tipopdto = $this->input->post("TipoPdto");
            $Clavealmacen = $this->input->post("Clavealmacen");
            $Nombrealmacen = $this->input->post("Clavealmacen");

            if($Tiporeq == "VENTA")
            {
                $Claveoficina = $this->input->post("Claveoficina2");
                $Cotizacion = strtoupper($this->input->post("Cotizacion"));
                $Ocpedido = strtoupper($this->input->post("Ocpedido"));
                $Fechacomptmp= $this->input->post("Fechacompromiso");
                $FechaExplode = explode("/", $Fechacomptmp);
                $Fechacompromiso = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);
            }else{
                $Claveoficina = $this->input->post("Claveoficina");
                $Cotizacion = "";
                $Ocpedido = "";
                $Fechacompromiso = new DateTime("0000-00-00");
            }

            $Tonombre = strtoupper($this->input->post("Tonombre"));
            $Togerente = strtoupper($this->input->post("Togerente"));
            $Clavecliente = $this->input->post("Clavecliente");
            $Nombrecliente = strtoupper($this->input->post("Nombrecliente"));
            $Claveproyecto = $this->input->post("Claveproyecto");
            $Nombreproyecto = strtoupper($this->input->post("Nombreproyecto"));
            $Nombregerente = strtoupper($this->input->post("Nombregerente"));
            $Direccion = strtoupper($this->input->post("Direccion"));
            $Telefono = strtoupper($this->input->post("Totelefono"));
            $Paqueteria = strtoupper($this->input->post("Topaquete"));
            $Gerenteproy = strtoupper($this->input->post("Usuariogerente"));
            $Emailgerente = strtolower($this->input->post("Emailgerente"));
            $Emailalm = "";

            $Detalle = $this->input->post("lstDetalle");
            $Observaciones = $this->input->post("Observaciones");

            $TotalMovimientosAgregados = 0;

//
            // Si cambiaron los adjuntos
            if ($this->input->post("Adjuntosmodificados")=='1'){

                //Eliminamos los registros anteriores del req_adjuntosurl
                $result = $this->Req_adjuntosurl_model->BorrarPorFolio($Folio);

                //Barremos el arreglo, cargamos los archivos y guardamos los nuevos registros
                foreach($_FILES["adjunto"]['tmp_name'] as $key => $tmp_name)
                {
                    //Validamos que el archivo exista
                    if($_FILES["adjunto"]["name"][$key])
                    {
                        // Validamos que no mida mas de 10MB
                        if($_FILES["adjunto"]["size"][$key] <= 10000000)
                        {
                            $filename = $_FILES["adjunto"]["name"][$key]; //Obtenemos el nombre original del archivo
                            $source = $_FILES["adjunto"]["tmp_name"][$key]; //Obtenemos un nombre temporal del archivo
                            $tipo = $_FILES["adjunto"]["type"][$key]; //Obtenemos un nombre temporal del archivo
                            
                            $directorio = 'adjuntos/'; //Declaramos un  variable con la ruta donde guardaremos los archivos
                                                
                            $dir=opendir($directorio); //Abrimos el directorio de destino
                            $destino = $directorio.'/'.$filename; //Indicamos la ruta de destino, así como el nombre del archivo
                            
                            //Movemos y validamos que el archivo se haya cargado correctamente
                            //El primer campo es el origen y el segundo el destino
                            //Grabamos el registro en la tabla con los url de los archivos
                            if(move_uploaded_file($source, $destino)) { 
                                $DetalleAdjuntos = array(
                                    "numero" => $Folio,
                                    "nombre" => $filename,
                                    "urlfile" => $destino,
                                    "tipo" => $tipo
                                );
                                $result = $this->Req_adjuntosurl_model->Create($DetalleAdjuntos);
                            }
                            closedir($dir); //Cerramos el directorio de destino
                        }
                    }
                }
            }
//
            //modificar Cabeza de requisiciones a proveedrores

            $CabezaRequisiciones = array(
                "numero" => $Folio,
                "almacen" => $Clavealmacen,
                //"fecha_ini" => $TodayDate,
                "usuario" => $LoggedUserId,
                "to_nombre" => $Tonombre,
                "to_direcc" => $Direccion,
                "to_tel" => $Telefono,
                "to_paquete" => $Paqueteria,
                "gerente" => $Togerente,
                "depto" => $Nombreproyecto,
                "clave_proyecto" => $Claveproyecto,
                "t_neces" => "1",
                "t_pedido" => "1",
                "status" => "1",
                "fecha_sr1" => $TodayDate,
                "fecha_fin" => "1753-01-01",
                "fecha_sr2" => "1753-01-01",
                "fecha_sr3" => "1753-01-01",
                "observa" => $Observaciones,
                "fecha_comp" => "1753-01-01",
                "to_empresa" => $Nombrecliente,
                "clave_cliente" => $Clavecliente,
                "ofna" => $Claveoficina,
                "apoyo" => "00",
                "fecha_compromiso" => $Fechacompromiso->format("Y-m-d"),
                "oc_pedidocliente" => $Ocpedido,
                "tipo_req" => $Tiporeq,
                "cotizacion" => $Cotizacion,
                "gerente_proy" => $Gerenteproy,
                "Active" => true,
                "usuarioblq" => "",
                "Updatedby" => $LoggedUserId,
                "Updateddate" => $TodayDate
            );

            $result = $this->Req_head_model->Update($CabezaRequisiciones);

            // eliminamos los registros anteriores del detaller
            $result = $this->Req_deta_model->BorrarPorFolio($Folio);

            // agregamos los nuevos registros del detalle
            $Partida=1;
            $TotalMovimientosAgregados = 0;
            // Si es reposicion las partidas no salen autorizadas de origen
            if($Tiporeq == "REPOSICION"){
                $Autopart = false;
            }else{
                // Si es venta las partidas ya debe ir autorizadas
                $Autopart = true;
            }            
            foreach($Detalle as $Item)
            {
                if($Item["Active"] == "true" || $Item["Active"] == 1)
                {               

                    $DetalleRequisiciones = array(
                        "numero" => $Folio,
                        "partida" => $Partida,
                        "articulo" => strtoupper($Item["Clavearticulo"]),
                        "articulo_eq" => strtoupper($Item["Clave_eq"]),
                        "descrip" => strtoupper($Item["Descripcion"]),
                        "marca" => strtoupper($Item["Marca"]),
                        "cantidad" => $Item["Cantidad"],
                        "autorizada" => $Autopart,
                        "fecha_e" => "1753-01-01",
                        "fecha_est" => "1753-01-01",
                        "apoyo" => "00"
                    );

                    $result = $this->Req_deta_model->Create($DetalleRequisiciones);
                    $Partida++;
                    $TotalMovimientosAgregados++;

                }
            }

            //Agregar movimiento a bitacora
            $BitacoraMovimiento = array(
                "log_ofna" => $Claveoficina,
                "log_usuario" => $LoggedUserId,
                "log_fecha" => $TodayDate,
                "log_evento" => "SE MODIFICO LA REQUISICION ".$Folio." CON ".$TotalMovimientosAgregados." REGISTROS.",
                "numero" => $Folio,
            );

            $result = $this->Req_logs_model->Create($BitacoraMovimiento);

            $this->session->set_flashdata('Folio', $Folio);
            $this->session->set_flashdata('message_index', 'Se modifico exitosamente la requisicion con el folio: '.$Folio);
            $this->session->set_flashdata('class', 'success');
            redirect("Requisiciones/Index/".$ActualPage);
        }
    }

    function Cancel()
    {
        if($this->input->post()){
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Folio = $this->input->post("Folio");
            $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($Folio);
            $Claveoficina = "00";
            //
            // Cancelar el head de la requisicion
            //
            foreach($Cabeza as $ItemC)
            {
                $Claveoficina = $ItemC->ofna;
                $CancelarCabeza = array(
                    "numero" => $ItemC->numero,
                    "status" => 9,
                    "Active" => false,
                    "DeletedBy" => $LoggedUserId,
                    "DeletedDate" => $TodayDate
                );

                $result = $this->Req_head_model->Update($CancelarCabeza);
            }

            //
            // Cancelar el detail de la requisicion
            //
            $Detalles = $this->Req_deta_model->ObtenerListaPorFolioParaCancelar($Folio);              
            foreach($Detalles as $Item)
            {
                $CancelarDetalles = array(
                    "numero" => $Item->numero,
                    "partida" => $Item->partida,
                    "cantidad" => 0,
                    "cancelada" => 1,
                    "observa" => "CANCELADA"
                );

                $result = $this->Req_deta_model->Update($CancelarDetalles);
            }

            //
            // Cancelar los registros del req_order de la requisicion
            //
/*            $Detalles = $this->Req_order_model->ObtenerListaPorFolioParaCancelar($Folio);              
            foreach($Detalles as $Item)
            {
                $CancelarDetalles = array(
                    "numero" => $Item->numero,
                    "partida" => $Item->partida,
                    "pend_orig" => 0,
                    "status1" => "CANCELADO"
                );

                $result = $this->Req_order_model->Update($CancelarDetalles);
            }*/

            //Agregar movimiento a bitacora
            $AutorizadoPor = $this->input->post("AutorizadoPor");
            $UsuarioAutorizacion = $this->Users_model->GetByUserName($AutorizadoPor);
            $BitacoraMovimiento = array(
                "log_ofna" => $Claveoficina,
                "log_usuario" => $LoggedUserId,
                "log_fecha" => $TodayDate,
                "log_evento" => "SE CANCELO LA REQUISICION ".$Folio." AUTORIZADO POR ".$AutorizadoPor."-".$UsuarioAutorizacion->Name,
                "numero" => $Folio,
            );
            $result = $this->Req_logs_model->Create($BitacoraMovimiento);

            $this->session->set_flashdata('message_index', 'Se cancelo exitosamente la requisicion con folio '.$Folio.' .');
            $this->session->set_flashdata('class', 'success');
            redirect("Requisiciones/");
        }
    }

    function AutocompleteFolio(){
        $term = strtolower($this->input->get("term"));
        $Sorteo = $this->session->Sorteo;
        $result = $this->Req_head_model->SearchByFolio($term);
        echo json_encode($result);
    }

    function VerificaBloqueo(){
        $Folio = $this->input->get("FolioRequi");
        $result = $this->Req_head_model->GetByFolio($Folio);
        echo json_encode($result);
    }

    function QuitarBloqueo(){
        $numero = $this->input->get("FolioRequi");
        // desbloqueamos la requisicion
        $CabezaRequisiciones = array(
            "numero" => $numero,
            "usuarioblq" => ""
        );
        $result = $this->Req_head_model->Update($CabezaRequisiciones);
        echo json_encode($result);
    }

    function GenerarPdf() {
        $this->load->library('Pdf');
        $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('CONTROL DE REQUISICIONES');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "REQUISICION", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 0, 0), $lc = array(0, 0, 0));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage();

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));

        $numero = $this->input->post("FolioRecibo");

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 

        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Solicitantenom= $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Gerenteproynom = $Gerenteproyrec->Name;
        }else{
            $Gerenteproynom = "";
        }

        $Observaciones = count($Cabeza) > 0 ? $Cabeza[0]->observa : "";

        $FechaHoraOriginal = $Cabeza[0]->fecha_ini;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechaelab = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4)." ".$Hora;

        $FechaHoraOriginal = $Cabeza[0]->fecha_compromiso;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechacomp = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));

        //$pdf->SetFontSize(11);
        if($Cabeza[0]->status ==9){
            $pdf->SetFont('Helvetica', 'B', 14, '', true);
            $pdf->Write(5,"C A N C E L A D A", $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        }
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Requisicion: ".$numero." Tipo: ".$Tipopdto."      Almacen destino: ".$Cabeza[0]->almacen, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->SetFont('Helvetica', '', 11, '', true);
        $pdf->Write(5,"Fecha: ". $FormatoFechaelab, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);
        $pdf->SetFontSize(9);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"Fecha compromiso: ".$FormatoFechacomp."            Cotizacion: ".$Cabeza[0]->cotizacion, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"OC/Pedido cliente: ".$Cabeza[0]->oc_pedidocliente, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Pedido por: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Solicitante: ".$Solicitantenom, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Gerente/Supervisor: ".$Cabeza[0]->gerente, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Enviar a: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Nombre: ".$Cabeza[0]->to_nombre, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Proyecto: ".$Cabeza[0]->depto, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"Empresa: ".$Cabeza[0]->to_empresa, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Direccion: ".substr($Cabeza[0]->to_direcc,0,90), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Telefono: ".$Cabeza[0]->to_tel, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Paqueteria sugerida: ".$Cabeza[0]->to_paquete, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES: ".substr($Cabeza[0]->observa,0,255), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        //$pdf->Write(5,"URL: ".base_url(), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
       
        $pdf->SetFontSize(8);
        $header = array('Prt','Articulo','Articulo eq.','Descripcion','Marca','Cant.');
        
        $pdf->SetFillColor(77, 77, 255);
        $pdf->SetTextColor(255);
        $pdf->SetDrawColor(0, 0, 0);
        $pdf->SetLineWidth(0.3);
        $pdf->SetFont('', 'B');
       
        $w = array(8, 29, 31, 85, 20, 14);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $pdf->Ln();
        
        $pdf->SetFillColor(224, 235, 255);
        $pdf->SetTextColor(0);
        $pdf->SetFont('');
       
        $fill = 0;
        $TotalArticulos = 0;
        foreach($Detalles as $Item) {
            $pdf->Cell($w[0], 6, $Item->partida, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[1], 6, $Item->articulo, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[2], 6, $Item->articulo_eq, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[3], 6, substr($Item->descrip,0,45), 'LR', 0, 'L', $fill);
            $pdf->Cell($w[4], 6, $Item->marca, 'LR', 0, 'L', $fill);
            $pdf->Cell($w[5], 6, $Item->cantidad, 'LR', 0, 'C', $fill);
            $pdf->Ln();
            $fill=!$fill;
            $TotalArticulos+= $Item->cantidad;
        }
        // Línea de cierre
        $pdf->Cell(array_sum($w),0,'','T');

/*        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES:", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,$Observaciones, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);*/

        $nombre_archivo = utf8_decode("Requisicion_".$numero.".pdf");
        $pdf->Output($nombre_archivo, 'D');
    }

    function Desbloqueo()
    {
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Desbloquear")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
        $Detalles = $this->Req_head_model->ObtenerListaBloqueadas();
        $Bloqueadas = count($Detalles);

        $Data['title'] = "Desbloquear requisiciones";
        $Data["Detalles"] = $Detalles;
        $Data["Bloqueadas"] = $Bloqueadas;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Requisiciones/Desbloqueo', $Data);
        $this->load->view('layouts/footer');
    }

    function DesbloqueoPost()
    {
        if(!VerificarPermisos($this->session->UID, "Requisiciones", "Desbloquear")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }        

        if($this->input->post())
        {
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Detalle = $this->input->post("lstDetalle");

            foreach($Detalle as $Item)
            {
                    if($Item["Desbloqueada"] == "true" || $Item["Desbloqueada"] == 1)
                    {
                        $CabezaDesbloqueo = array(
                            "numero" => $Item["Numero"],
                            "usuarioblq" => ""
                        );
                        $result = $this->Req_head_model->Update($CabezaDesbloqueo);
                    }
            }

            $this->session->set_flashdata('message_create', 'Se desbloquearon las requisiciones seleccionadas.');
            $this->session->set_flashdata('class', 'success');
            redirect("Requisiciones/Desbloqueo");
        }

        // $Data['title'] = "Desbloquear requisiciones";
        // $Data["Detalles"] = $this->Req_head_model->ObtenerListaBloqueadas();
        // $this->load->view('layouts/_menu', $Data);
        // $this->load->view('Requisiciones/Desbloqueo', $Data);
        // $this->load->view('layouts/footer');

    }
}