<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reportes extends CI_Controller {
    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");
        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }
    //
    // Reporte de requisiciones
    //
    function ReporteRequisiciones()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReporteRequisiciones")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte de requisiciones";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reporterequisiciones', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelReporteRequisiciones()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
            
            $Titulo = $this->input->post("Title");
            $TipoReporte = $this->input->post("TipoReporte");
            $Autorizadas = true;

            switch ($TipoReporte) {
                case 'Pendientes sin autorizar':
                    $Tiporep = 1;
                    break;
                case 'Autorizadas sin procesar':
                    $Tiporep = 2;
                    break;
                case 'En proceso solo de almacen':
                    $Tiporep = 3;
                    break;
                case 'En proceso de almacen y compras':
                    $Tiporep = 4;
                    break;
                case 'Todas':
                    $Tiporep = 5;
                    break;
            }
           
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Movimientos = $this->Req_head_model->ReporteRequisiciones($Tiporep,$ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Requisiciones");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Numero');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Tipo');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Creada');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Autorizada');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Solicito');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Empresa');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Gerente');
            $this->excel->getActiveSheet()->setCellValue('J1', 'Proyecto');
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('30');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Movimientos as $Item) {

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }


                // if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                //     $date = date_create($Item->fecha_ini);
                //     $Fechareq=$date->getTimestamp(); // se obtiene la fecha unix
                //     $Fechareq = strtotime($Item->fecha_ini);
                // }else{
                //     $Fechareq='';
                // }

                // if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                //     $date = date_create($Item->revision_gte);
                //     $Fechagte=$date->getTimestamp(); // se obtiene la fecha unix
                // }else{
                //     $Fechagte='';
                // }

                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->numero, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->tipo, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->almacen, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                // if (is_int($Fechareq))   // se valida que sea entero lo que nos indica que trae fecha unix
                // {
                //     $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, PHPExcel_Shared_Date::PHPToExcel( $Fechareq ) , PHPExcel_Cell_DataType::TYPE_NUMERIC);
                //     $this->excel->getActiveSheet()->getStyle('D'.$row)->getNumberFormat()->setFormatCode('dd/mm/yyyy');
                // }else{                  // de lo contrario se escribe la variable vacia en formato string
                //     $this->excel->getActiveSheet()->setCellValue('D'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                // }
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);
                // if (is_int($Fechagte))   // se valida que sea entero lo que nos indica que trae fecha unix
                // {
                //     $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, PHPExcel_Shared_Date::PHPToExcel( $Fechagte ) , PHPExcel_Cell_DataType::TYPE_NUMERIC);
                //     $this->excel->getActiveSheet()->getStyle('E'.$row)->getNumberFormat()->setFormatCode('dd/mm/yyyy');
                // }else{                  // de lo contrario se escribe la variable vacia en formato string
                //     $this->excel->getActiveSheet()->setCellValue('E'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);
                // }
                $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->usuario, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item->to_empresa, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item->to_nombre, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item->gerente, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item->depto, PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
             
            $filename='ReporteRequisiciones.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReporteRequisiciones() {
        $this->load->library('Pdf');
        $pdf = new Pdf('P', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage();

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
        
        $Titulo = $this->input->post("Title");
        $TipoReporte = $this->input->post("TipoReporte");
        $Autorizadas = true;

        switch ($TipoReporte) {
            case 'Pendientes sin autorizar':
                $Tiporep = 1;
                break;
            case 'Autorizadas sin procesar':
                $Tiporep = 2;
                break;
            case 'En proceso solo de almacen':
                $Tiporep = 3;
                break;
            case 'En proceso de almacen y compras':
                $Tiporep = 4;
                break;
            case 'Todas':
                $Tiporep = 5;
                break;
        }

/*        switch ($TipoReporte) {
            case 'Pendientes sin autorizar':
                $TipoEstatus = 1;
                $Autorizadas = false;
                break;
            case 'Autorizadas sin procesar':
                $TipoEstatus = 1;
                break;
            case 'En proceso solo de almacen':
                $TipoEstatus = 2;
                break;
            case 'En proceso de almacen y compras':
                $TipoEstatus = 3;
                break;
            case 'Todas':
                $TipoEstatus = 0;
                break;
        }*/
       
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Movimientos = $this->Req_head_model->ReporteRequisiciones($Tiporep,$ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=33;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=34;

            foreach($Movimientos as $Item) {

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                // if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                //     $date = date_create($Item->fecha_ini);
                //     $Fechareq=date_format($date, 'd/m/Y'); 
                // }else{
                //     $Fechareq='';
                // }

                // if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                //     $date = date_create($Item->revision_gte);
                //     $Fechagte=date_format($date, 'd/m/Y');
                // }else{
                //     $Fechagte='';
                // }

                if ($AcumulaRenglones > $MaximoRenglones){
                    $pdf->SetFontSize(10);
                    $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                    $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                    $pdf->Write(5,"Requisiciones ".$Titulo, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                    $pdf->SetFontSize(9);
                    $pdf->Write(5,"De la oficina: ".$ClaveOficinaI." a la oficina: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                    $pdf->SetFontSize(8);
                    $header = array('Num','Tipo','Alm','Creada','Autorizada','Solicito','Empresa','Nombre','Gerente','Proyecto');
                    
                    $pdf->SetFillColor(77, 77, 255);
                    $pdf->SetTextColor(255);
                    $pdf->SetDrawColor(0, 0, 0);
                    $pdf->SetLineWidth(0.3);
                    $pdf->SetFont('', 'B');
                   
                    $w = array(8, 8, 12, 20, 20, 12, 30, 29, 29, 29);
                    $num_headers = count($header);
                    
                    for($i = 0; $i < $num_headers; ++$i) {
                        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                    }

                    $pdf->Ln();
                    
                    $pdf->SetFillColor(224, 235, 255);
                    $pdf->SetTextColor(0);
                    $pdf->SetFont('');
                    $AcumulaRenglones=0;
                }
                $pdf->Cell($w[0], 6, $Item->numero, 0, 0, '', 0);
                $pdf->Cell($w[1], 6, $Item->tipo, 0, 0, 'C', 0);
                $pdf->Cell($w[2], 6, $Item->almacen, 0, 0, '', 0);
                $pdf->Cell($w[3], 6, $Fechareq, 0, 0, '', 0);
                $pdf->Cell($w[4], 6, $Fechagte, 0, 0, '', 0);
                $pdf->Cell($w[5], 6, $Item->usuario, 0, 0, 'C', 0);
                $pdf->Cell($w[6], 6, substr(replacecharsp($Item->to_empresa),0,15), 0, 0, '', 0);
                $pdf->Cell($w[7], 6, substr(replacecharsp($Item->to_nombre),0,15), 0, 0, '', 0);
                $pdf->Cell($w[8], 6, substr(replacecharsp($Item->gerente),0,15), 0, 0, '', 0);
                $pdf->Cell($w[9], 6, substr(replacecharsp($Item->depto),0,17), 0, 0, '', 0);
                $AcumulaRenglones++;
                $pdf->Ln();
            }
            $nombre_archivo = utf8_decode("ReporteRequisiciones.pdf");
            $pdf->Output($nombre_archivo, 'D');

    }
    //
    // Reporte de compras
    //
    function ReporteCompras()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReporteCompras")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte de compras";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reportecompras', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelReporteCompras()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
            
            $Titulo = $this->input->post("Title");
            $TipoReporte = $this->input->post("TipoReporte");
            $Autorizadas = true;
            $TipoReporteN = 0;

            switch ($TipoReporte) {
                case 'Compras locales':
                    $TipoReporteN = 1;
                    break;
                case 'Compras de apoyo':
                    $TipoReporteN = 2;
                    break;
                case 'Todas':
                    $TipoReporteN = 3;
                    break;
            }
           
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReporteCompras($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Compras");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'F. Req.');
            $this->excel->getActiveSheet()->setCellValue('B1', 'F. Aut.');
            $this->excel->getActiveSheet()->setCellValue('C1', 'F. Recep.');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('E1', 'No. Req.');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Solic.');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Prt');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Articulo');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Articulo Eq.');
            $this->excel->getActiveSheet()->setCellValue('J1', 'Marca');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('L1', 'Cant.');
            $this->excel->getActiveSheet()->setCellValue('M1', 'T. Sol.');
            $this->excel->getActiveSheet()->setCellValue('N1', 'Comprador');
            $this->excel->getActiveSheet()->setCellValue('O1', 'Proveedor');
            $this->excel->getActiveSheet()->setCellValue('P1', 'Orden');
            $this->excel->getActiveSheet()->setCellValue('Q1', 'Fecha PP');
            $this->excel->getActiveSheet()->setCellValue('R1', 'Apy');
            $this->excel->getActiveSheet()->setCellValue('S1', 'Estatus');
            $this->excel->getActiveSheet()->setCellValue('T1', 'ETA Prov');
            $this->excel->getActiveSheet()->setCellValue('U1', 'ETA Real');
            $this->excel->getActiveSheet()->setCellValue('V1', 'Observaciones');
            $this->excel->getActiveSheet()->setCellValue('W1', 'F. Alm.');
            $this->excel->getActiveSheet()->setCellValue('X1', 'F. Com.');
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('U1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('U1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('V1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('V1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('W1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('W1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('X1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('X1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('30');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('30');
            $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('30');
            $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('R')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('S')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('T')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('U')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('V')->setWidth('30');
            $this->excel->getActiveSheet()->getColumnDimension('W')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('X')->setWidth('12');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            // En las fechas usamos el getTimestamp para obtener la fecha unix y asi poder usarla en la celda de Excel
            // esto para poder darle formato de fecha y que pueda ser manejada como tal en el Xls, de lo contrario 
            // solo se manda como cadena de texto.
            //
            $row = 2;
            foreach($Requisiciones as $Item) {
                $Numeroreq = $Item->numero;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                if($Item->fecha_sr2 !== '0000-00-00 00:00:00' && $Item->fecha_sr2 !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_sr2);
                    $Fechaalm=date_format($date, 'd/m/Y');
                }else{
                    $Fechaalm='';
                }

                if($Item->fecha_sr3 !== '0000-00-00 00:00:00' && $Item->fecha_sr3 !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_sr3);
                    $Fechacom2xls=date_format($date, 'd/m/Y');
                }else{
                    $Fechacom2xls='';
                }

                $date = date_create($Item->fecha_sr3);
                $Fechacom = $date->getTimestamp();

                $Usrsolicita = $Item->usuario;
                $Details = $this->Req_deta_model->ObtenerListaPorFolioCompras($Numeroreq, $TipoReporteN);
                foreach($Details as $Item2) {

                    $Ordercant=0;
                    $Ordertsol="";
                    $Ordercomp="";
                    $Orderprov="";
                    $Orderorden="";
                    $Orderfecha="";
                    $Orderstatus1="";
                    $Orderobserva="";
                    $Fechaetaprov="";
                    $Fechaetareal="";

                    $OrderDetails = $this->Req_order_model->ObtenerListaPorFolioPartida($Numeroreq,$Item2->partida);
                    if($OrderDetails){
                        $Ordercant=$OrderDetails->pend_orig;
                        $Ordertsol=$OrderDetails->tip_solic;
                        $Ordercomp=$OrderDetails->comprador;
                        $Orderprov=$OrderDetails->proveedor;
                        $Orderorden=$OrderDetails->orden;
                        $Orderstatus1=$OrderDetails->status1;
                        $Orderobserva=$OrderDetails->observa;
                        if($OrderDetails->fecha_pp>'1753-01-01'){
                            $date = date_create($OrderDetails->fecha_pp);
                            $Orderfecha=$date->getTimestamp();
                        }else{
                            $Orderfecha=""; 
                        }
                        if($OrderDetails->eta_prov>'1753-01-01'){
                            $date = date_create($OrderDetails->eta_prov);
                            $Fechaetaprov=$date->getTimestamp();
                        }else{
                            $Fechaetaprov="";
                        }
                        if($OrderDetails->eta_real>'1753-01-01'){
                            $date = date_create($OrderDetails->eta_real);
                            $Fechaetareal=$date->getTimestamp();
                        }else{
                            $Fechaetareal="";
                        }
                    }
                    
                    $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);

                    if (is_int($Fechacom))
                    {
                        $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, PHPExcel_Shared_Date::PHPToExcel( $Fechacom ) , PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->getStyle('C'.$row)->getNumberFormat()->setFormatCode('dd/mm/yyyy');
                    }else{
                        $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Fechacom, PHPExcel_Cell_DataType::TYPE_STRING);
                    }
                    $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Almacenreq."-".$Almacennom, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Usrsolicita, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item2->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                    // $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, '', PHPExcel_Cell_DataType::TYPE_STRING);
                    
                    $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item2->marca, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Item2->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Ordercant, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Ordertsol, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $Ordercomp, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $Orderprov, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $Orderorden, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    if (is_int($Orderfecha))
                    {
                        $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, PHPExcel_Shared_Date::PHPToExcel( $Orderfecha ) , PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->getStyle('Q'.$row)->getNumberFormat()->setFormatCode('dd/mm/yyyy');
                    }else{
                        $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Orderfecha, PHPExcel_Cell_DataType::TYPE_STRING);
                    }
                    $this->excel->getActiveSheet()->setCellValueExplicit('R'.$row, $Item2->apoyo, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('S'.$row, $Orderstatus1, PHPExcel_Cell_DataType::TYPE_STRING);
                    if (is_int($Fechaetaprov))
                    {
                        $this->excel->getActiveSheet()->setCellValueExplicit('T'.$row, PHPExcel_Shared_Date::PHPToExcel( $Fechaetaprov ) , PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->getStyle('T'.$row)->getNumberFormat()->setFormatCode('dd/mm/yyyy');
                    }else{
                        $this->excel->getActiveSheet()->setCellValueExplicit('T'.$row, $Fechaetaprov, PHPExcel_Cell_DataType::TYPE_STRING);
                    }
                    if (is_int($Fechaetareal))
                    {
                        $this->excel->getActiveSheet()->setCellValueExplicit('U'.$row, PHPExcel_Shared_Date::PHPToExcel( $Fechaetareal ) , PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->getStyle('U'.$row)->getNumberFormat()->setFormatCode('dd/mm/yyyy');
                    }else{
                        $this->excel->getActiveSheet()->setCellValueExplicit('U'.$row, $Fechaetareal, PHPExcel_Cell_DataType::TYPE_STRING);
                    }
                    $this->excel->getActiveSheet()->setCellValueExplicit('V'.$row, $Orderobserva, PHPExcel_Cell_DataType::TYPE_STRING);

                    $this->excel->getActiveSheet()->setCellValueExplicit('W'.$row, $Fechaalm, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('X'.$row, $Fechacom2xls, PHPExcel_Cell_DataType::TYPE_STRING);

                    $row++;
                }

            }
             
            $filename='ReporteCompras.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReporteCompras() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
        
        $Titulo = $this->input->post("Title");
        $TipoReporte = $this->input->post("TipoReporte");
        $TipoReporteN = 0;

        switch ($TipoReporte) {
            case 'Compras locales':
                $TipoReporteN = 1;
                break;
            case 'Compras de apoyo':
                $TipoReporteN = 2;
                break;
            case 'Todas':
                $TipoReporteN = 3;
                break;
        }
       
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Requisiciones = $this->Req_head_model->ReporteCompras($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=19;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=20;

        foreach($Requisiciones as $Item) {
            $Numeroreq = $Item->numero;
            $Almacenreq = $Item->almacen;
            $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
            $date = date_create($Item->fecha_sr3);
            $Fechacom=date_format($date, 'd/m/Y');

            if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
            }else{
                $Fechareq='';
            }

            if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                $date = date_create($Item->revision_gte);
                $Fechagte=date_format($date, 'd/m/Y');
            }else{
                $Fechagte='';
            }

            $Usrsolicita = $Item->usuario;
            $Details = $this->Req_deta_model->ObtenerListaPorFolioCompras($Numeroreq, $TipoReporteN);
            foreach($Details as $Item2) {
                if ($AcumulaRenglones > $MaximoRenglones){
                    $pdf->SetFontSize(10);
                    $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                    $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                    $pdf->Write(5,"Tipo de compras: ".$Titulo, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                    $pdf->SetFontSize(9);
                    $pdf->Write(5,"De la oficina: ".$ClaveOficinaI." a la oficina: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                    $pdf->SetFontSize(7);

                    //$header = array('F. Req','F. Recep','Almacen','Req.','Sol.','Prt','Articulo','Articulo eq','Marca','Descripcion','Cnt','T. sol.','Comprador','Proveedor','Orden','F. PP','Apy','Estatus','ETA Prov','ETA Real','Observa');

                    $header = array('F. Req','F. Aut','F. Recep','Almacen','Req.','Sol.','Prt','Articulo','Marca','Descripcion','Cnt','T. sol.','Comprador','Proveedor','Orden','F. PP','Apy','Estatus','ETA Prov','ETA Real','Observa');
                    
                    $pdf->SetFillColor(77, 77, 255);
                    $pdf->SetTextColor(255);
                    $pdf->SetDrawColor(0, 0, 0);
                    $pdf->SetLineWidth(0.3);
                    $pdf->SetFont('', 'B');
                   
                    $w = array(15, 15, 15, 15, 10, 8, 7, 19, 10, 22, 9, 10, 14, 14, 10, 15, 8, 14, 15, 15, 22);
                    $num_headers = count($header);
                    
                    for($i = 0; $i < $num_headers; ++$i) {
                        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                    }

                    $pdf->Ln();
                    
                    $pdf->SetFillColor(224, 235, 255);
                    $pdf->SetTextColor(0);
                    $pdf->SetFont('');
                    $AcumulaRenglones=0;
                }
            
                $Ordercant=0;
                $Ordertsol="";
                $Ordercomp="";
                $Orderprov="";
                $Orderorden="";
                $Orderfecha="";
                $Orderstatus1="";
                $Orderobserva="";
                $Fechaetaprov="";
                $Fechaetareal="";

                $OrderDetails = $this->Req_order_model->ObtenerListaPorFolioPartida($Numeroreq,$Item2->partida);
                if($OrderDetails){
                    $Ordercant=$OrderDetails->pend_orig;
                    $Ordertsol=$OrderDetails->tip_solic;
                    $Ordercomp=$OrderDetails->comprador;
                    $Orderprov=$OrderDetails->proveedor;
                    $Orderorden=$OrderDetails->orden;
                    $Orderstatus1=$OrderDetails->status1;
                    $Orderobserva=$OrderDetails->observa;
                    if($OrderDetails->fecha_pp>'1753-01-01'){
                        $date = date_create($OrderDetails->fecha_pp);
                        $Orderfecha=date_format($date, 'd/m/Y');
                    }else{
                        $Orderfecha=""; 
                    }
                    if($OrderDetails->eta_prov>'1753-01-01'){
                        $date = date_create($OrderDetails->eta_prov);
                        $Fechaetaprov=date_format($date, 'd/m/Y');
                    }else{
                        $Fechaetaprov="";
                    }
                    if($OrderDetails->eta_real>'1753-01-01'){
                        $date = date_create($OrderDetails->eta_real);
                        $Fechaetareal=date_format($date, 'd/m/Y');
                    }else{
                        $Fechaetareal="";
                    }
                }

                $pdf->Cell($w[0], 6, $Fechareq, 0, 0, '', 0);
                $pdf->Cell($w[1], 6, $Fechagte, 0, 0, '', 0);
                $pdf->Cell($w[2], 6, $Fechacom, 0, 0, 'C', 0);
                $pdf->Cell($w[3], 6, $Almacenreq." ".substr($Almacennom,0,4), 0, 0, '', 0);
                $pdf->Cell($w[4], 6, $Numeroreq, 0, 0, 'C', 0);
                $pdf->Cell($w[5], 6, $Usrsolicita, 0, 0, 'C', 0);
                $pdf->Cell($w[6], 6, $Item2->partida, 0, 0, 'C', 0);
                $pdf->Cell($w[7], 6, $Item2->articulo, 0, 0, 'C', 0);
                // $pdf->Cell($w[7], 6, substr($Item2->articulo_eq,0,8), 0, 0, 'C', 0);
                // $pdf->Cell($w[7], 6, '', 0, 0, 'C', 0);
                $pdf->Cell($w[8], 6, substr($Item2->marca,0,5), 0, 0, '', 0);                
                $pdf->Cell($w[9], 6, substr(replacecharsp($Item2->descrip),0,10), 0, 0, '', 0);
                $pdf->Cell($w[10], 6, $Ordercant, 0, 0, 'C', 0);
                $pdf->Cell($w[11], 6, substr($Ordertsol,0,5), 0, 0, '', 0);
                $pdf->Cell($w[12], 6, substr($Ordercomp,0,8), 0, 0, '', 0);
                $pdf->Cell($w[13], 6, substr($Orderprov,0,8), 0, 0, 'C', 0);
                $pdf->Cell($w[14], 6, $Orderorden, 0, 0, '', 0);
                $pdf->Cell($w[15], 6, substr($Orderfecha,0,10), 0, 0, '', 0);
                $pdf->Cell($w[16], 6, $Item2->apoyo, 0, 0, 'C', 0);
                $pdf->Cell($w[17], 6, substr($Orderstatus1,0,8), 0, 0, '', 0);
                $pdf->Cell($w[18], 6, $Fechaetaprov, 0, 0, '', 0);
                $pdf->Cell($w[19], 6, $Fechaetareal, 0, 0, '', 0);
                $pdf->Cell($w[20], 6, substr($Orderobserva,0,15), 0, 0, '', 0);

                $AcumulaRenglones++;
                $pdf->Ln();
            }
        }
        $nombre_archivo = utf8_decode("ReporteCompras.pdf");
        $pdf->Output($nombre_archivo, 'D');

    }
    //
    // Reporte de envios
    //
    function ReporteEnvios()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReporteEnvios")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte de envios";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reporteenvios', $Data);
        $this->load->view('layouts/footer');
    }

//****************** CODIGO PARA GENERAR EL REPORTE DE ENVIOS EN CSV
    function CsvReporteEnvios()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                   
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReporteEnvios($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            $csv_end = chr(13);  
            $csv_sep = "|";  
            $Titulo = "ReporteEnvios.csv";
            $archivo = fopen($Titulo,'w');

            $csv="Almacen|No. Req|Fecha|Usr|Empresa|Nombre|Direccion|Telefono|Prt|Articulo|Descripcion|Cant.|Fecha E.|Surt.|Guia E.|Paqueteria|Observaciones".$csv_end;

            fputs($archivo,$csv);

            $Requiproc = "";

            foreach($Requisiciones as $Item) {
                $Numeroreq = $Item->requisicion;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
                $Fechareq = $Item->fecha_ini;
                $Usrsolicita = $Item->usuario;
                $Empresareq = $Item->to_empresa;
                $Nombrereq = $Item->to_nombre;
                $Direccreq = $Item->to_direcc;
                $Telreq = $Item->to_tel;

                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
                $date = date_create($Item->fecha_sr3);
                $Fechacom=date_format($date, 'd/m/Y');

                $Usrsolicita = $Item->usuario;
                $Details = $this->Req_surt_model->ObtenerListaParaReporteEnvios($Numeroreq,$FechaI,$FechaF);
                if($Requiproc != $Numeroreq)
                {
                    $Requiproc = $Numeroreq;
                    foreach($Details as $Item2) {

                        $Det_descrip="";
                        $Det_cant=0;

                        $OrderDetails = $this->Req_deta_model->ObtenerDescipYmarcaEnvios($Numeroreq,$Item2->partida);
                        if($OrderDetails){
                            $Det_descrip=$OrderDetails->descrip;
                            $Det_cant=$OrderDetails->cantidad;
                            $Det_observa=$OrderDetails->observa;
                        }

                        $date = date_create($Item2->fecha_e);
                        $Fechaenv=date_format($date, 'd/m/Y');

                        $csv=$Almacenreq.$csv_sep.
                        $Numeroreq.$csv_sep.
                        $Fechareq.$csv_sep.
                        $Usrsolicita.$csv_sep.
                        $Empresareq.$csv_sep.
                        $Nombrereq.$csv_sep.
                        $Direccreq.$csv_sep.
                        $Telreq.$csv_sep.
                        $Item2->partida.$csv_sep.
                        $Item2->articulo.
                        //$Item2->articulo_eq.
                        ''.
                        $Det_descrip.$csv_sep.
                        $Det_cant.$csv_sep.
                        $Fechaenv.$csv_sep.
                        $Item2->surtido.$csv_sep.
                        $Item2->guia_e.$csv_sep.
                        $Item2->paqueteria.$csv_sep.
                        $Det_observa.
                        $csv_end;

                        fputs($archivo,$csv);

                        //$this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Almacenreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        //$this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        //$this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        //$this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Usrsolicita, PHPExcel_Cell_DataType::TYPE_STRING);

/*                        $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Empresareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Nombrereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Direccreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Telreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Det_descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Det_cant, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Fechaenv, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $Item2->surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $Item2->guia_e, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $Item2->paqueteria, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Det_observa, PHPExcel_Cell_DataType::TYPE_STRING);*/
                    }
                }
            }
            fclose($archivo);

            $basefichero = basename($Titulo);
            header( "Content-Type: application/octet-stream");
            header( "Content-Length: ".filesize($Titulo));
            header( "Content-Disposition: attachment; filename=".$basefichero."");
            readfile($Titulo);            

        }
    }
//***************************** FIN DE CODIGO DE ENVIOS POR CSV

    function ExcelReporteEnvios()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                   
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReporteEnvios($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Envios");
            //set cell A1 content with some text        

            $this->excel->getActiveSheet()->setCellValue('A1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('B1', 'No. Req.');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Fecha');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Autorizada');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Usr');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Empresa');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Direccion');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Telefono');
            $this->excel->getActiveSheet()->setCellValue('J1', 'Prt');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Articulo');
            $this->excel->getActiveSheet()->setCellValue('L1', 'Articulo Eq.');

            $this->excel->getActiveSheet()->setCellValue('M1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('N1', 'Cant.');
            $this->excel->getActiveSheet()->setCellValue('O1', 'Fecha E.');
            $this->excel->getActiveSheet()->setCellValue('P1', 'Surt.');
            $this->excel->getActiveSheet()->setCellValue('Q1', 'Guia E.');
            $this->excel->getActiveSheet()->setCellValue('R1', 'Paqueteria');
            $this->excel->getActiveSheet()->setCellValue('S1', 'Observaciones');
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('R')->setWidth('50');
            $this->excel->getActiveSheet()->getColumnDimension('S')->setWidth('14');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            $Requiproc = "";

            foreach($Requisiciones as $Item) {
                $Numeroreq = $Item->requisicion;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
                $Fechareq = $Item->fecha_ini;
                $Usrsolicita = $Item->usuario;
                $Empresareq = $Item->to_empresa;
                $Nombrereq = $Item->to_nombre;
                $Direccreq = $Item->to_direcc;
                $Telreq = $Item->to_tel;

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                $date = date_create($Item->fecha_sr3);
                $Fechacom=date_format($date, 'd/m/Y');

                $Usrsolicita = $Item->usuario;
                $Details = $this->Req_surt_model->ObtenerListaParaReporteEnvios($Numeroreq,$FechaI,$FechaF);
                if($Requiproc != $Numeroreq)
                {
                    $Requiproc = $Numeroreq;
                    foreach($Details as $Item2) {

                        $Det_descrip="";
                        $Det_cant=0;

                        $OrderDetails = $this->Req_deta_model->ObtenerDescipYmarcaEnvios($Numeroreq,$Item2->partida);
                        if($OrderDetails){
                            $Det_descrip=$OrderDetails->descrip;
                            $Det_cant=$OrderDetails->cantidad;
                            $Det_observa=$OrderDetails->observa;
                        }

                        $date = date_create($Item2->fecha_e);
                        $Fechaenv=date_format($date, 'd/m/Y');

                        $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Almacenreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Usrsolicita, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Empresareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Nombrereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Direccreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Telreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Item2->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                        // $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, '', PHPExcel_Cell_DataType::TYPE_STRING);
                        
                        $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Det_descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $Det_cant, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $Fechaenv, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $Item2->surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Item2->guia_e, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('R'.$row, $Item2->paqueteria, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('S'.$row, $Det_observa, PHPExcel_Cell_DataType::TYPE_STRING);

                        $row++;
                    }
                }

            }
             
            $filename='ReporteEnvios.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReporteEnvios() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
               
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Requisiciones = $this->Req_head_model->ReporteEnvios($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=19;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=20;
        $Requiproc ="";

        foreach($Requisiciones as $Item) {
            $Numeroreq = $Item->requisicion;
            $Almacenreq = $Item->almacen;
            $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
            $Fechareq = $Item->fecha_ini;
            $Usrsolicita = $Item->usuario;
            $Empresareq = replacecharsp($Item->to_empresa);
            $Nombrereq = replacecharsp($Item->to_nombre);
            $Direccreq = replacecharsp($Item->to_direcc);
            $Telreq = $Item->to_tel;

            if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
            }else{
                $Fechareq='';
            }

            if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                $date = date_create($Item->revision_gte);
                $Fechagte=date_format($date, 'd/m/Y');
            }else{
                $Fechagte='';
            }

            $date = date_create($Item->fecha_sr3);
            $Fechacom=date_format($date, 'd/m/Y');
            $Usrsolicita = $Item->usuario;
            if($Requiproc != $Numeroreq)
            {
                $Requiproc = $Numeroreq;
                $Details = $this->Req_surt_model->ObtenerListaParaReporteEnvios($Numeroreq,$FechaI,$FechaF);
                foreach($Details as $Item2) {
                    if ($AcumulaRenglones > $MaximoRenglones){
                        $pdf->SetFontSize(10);
                        $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                        $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                        $pdf->Write(5,"REPORTE DE ENVIOS", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                        $pdf->SetFontSize(9);
                        $pdf->Write(5,"De la oficina: ".$ClaveOficinaI." a la oficina: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                        $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                        $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                        $pdf->SetFontSize(7);
                        //$header = array('Almacen','No.Req.','Fecha','Usr','Empresa','Nombre','Direccion','Telefono','Prt','Articulo','Descripcion','Cant.','Fecha E.','Surt.','Guia E.','Paqueteria');
                        $header = array('Alm.','Req.','Fecha','Autorizada','Usr','Empresa','Nombre','Direccion','Telefono','Prt','Articulo', 'Articulo Eq','Descripcion','Cant.','Fecha E.','Surt.','Guia E.','Paqueteria');
                        
                        $pdf->SetFillColor(77, 77, 255);
                        $pdf->SetTextColor(255);
                        $pdf->SetDrawColor(0, 0, 0);
                        $pdf->SetLineWidth(0.3);
                        $pdf->SetFont('', 'B');
                       
                        //$w = array(12, 10, 15, 10, 30, 30, 30, 15, 10, 15, 25, 10, 15, 10, 20, 25);
                        $w = array(10, 9, 15, 15, 8, 24, 24, 25, 15, 10, 21, 21, 22, 10, 15, 10, 16, 16);
                        $num_headers = count($header);
                        
                        for($i = 0; $i < $num_headers; ++$i) {
                            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                        }

                        $pdf->Ln();
                        
                        $pdf->SetFillColor(224, 235, 255);
                        $pdf->SetTextColor(0);
                        $pdf->SetFont('');
                        $AcumulaRenglones=0;
                    }
                
                    $Det_descrip="";
                    $Det_cant=0;

                    $OrderDetails = $this->Req_deta_model->ObtenerDescipYmarcaEnvios($Numeroreq,$Item2->partida);
                    if($OrderDetails){
                        $Det_descrip=replacecharsp($OrderDetails->descrip);
                        $Det_cant=$OrderDetails->cantidad;
                    }

                    $date = date_create($Item2->fecha_e);
                    $Fechaenv=date_format($date, 'd/m/Y');

                    $pdf->Cell($w[0], 6, $Almacenreq, 0, 0, '', 0);
                    $pdf->Cell($w[1], 6, $Numeroreq, 0, 0, 'C', 0);
                    $pdf->Cell($w[2], 6, $Fechareq, 0, 0, '', 0);
                    $pdf->Cell($w[3], 6, $Fechagte, 0, 0, '', 0);
                    $pdf->Cell($w[4], 6, $Usrsolicita, 0, 0, 'C', 0);
                    $pdf->Cell($w[5], 6, substr($Empresareq,0,14), 0, 0, 'L', 0);
                    $pdf->Cell($w[6], 6, substr($Nombrereq,0,14), 0, 0, 'L', 0);
                    $pdf->Cell($w[7], 6, substr($Direccreq,0,14), 0, 0, 'L', 0);
                    $pdf->Cell($w[8], 6, $Telreq, 0, 0, 'C', 0);
                    $pdf->Cell($w[9], 6, $Item2->partida, 0, 0, 'C', 0);
                    $pdf->Cell($w[10], 6, $Item2->articulo, 0, 0, 'C', 0);
                    $pdf->Cell($w[11], 6, substr($Item2->articulo_eq,0,16), 0, 0, 'C', 0);
                    // $pdf->Cell($w[10], 6, '', 0, 0, 'C', 0);
                    $pdf->Cell($w[12], 6, substr($Det_descrip,0,13), 0, 0, '', 0);
                    $pdf->Cell($w[13], 6, $Det_cant, 0, 0, 'R', 0);
                    $pdf->Cell($w[14], 6, $Fechaenv, 0, 0, '', 0);
                    $pdf->Cell($w[15], 6, $Item2->surtido, 0, 0, 'R', 0);
                    $pdf->Cell($w[16], 6, $Item2->guia_e, 0, 0, '', 0);
                    $pdf->Cell($w[17], 6, substr(replacecharsp($Item2->paqueteria),0,12), 0, 0, 'L', 0);

                    $AcumulaRenglones++;
                    $pdf->Ln();
                }
            }
        }
        $nombre_archivo = utf8_decode("ReporteEnvios.pdf");
        $pdf->Output($nombre_archivo, 'D');

    }
    //
    // Reporte de pendientes de surtir normal
    //
    function ReportePensur()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReportePensur")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte pendientes de surtir";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reportepensur', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelReportePensur()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                   
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReportePensur($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Envios");
            //set cell A1 content with some text        

            $this->excel->getActiveSheet()->setCellValue('A1', 'Tipo');
            $this->excel->getActiveSheet()->setCellValue('B1', 'No. Req.');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Fecha');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Autorizada');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Prt');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Articulo');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Articulo Eq.');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('J1', 'Cant.');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Surt.');
            $this->excel->getActiveSheet()->setCellValue('L1', 'Pend.');
            $this->excel->getActiveSheet()->setCellValue('M1', 'Usr');
            $this->excel->getActiveSheet()->setCellValue('N1', 'Empresa');
            $this->excel->getActiveSheet()->setCellValue('O1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('P1', 'Direccion');
            $this->excel->getActiveSheet()->setCellValue('Q1', 'Telefono');
            $this->excel->getActiveSheet()->setCellValue('R1', 'Paqueteria');
            $this->excel->getActiveSheet()->setCellValue('S1', 'Gerente');
            $this->excel->getActiveSheet()->setCellValue('T1', 'Observaciones');
            
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('8');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('9');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('12');

            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('9');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('3');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('16');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('20');

            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('77');
            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('5');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('5');
            $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('6');
            $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('3');
            $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('41');
            $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('34');
            $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('56');
            $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('11');
            $this->excel->getActiveSheet()->getColumnDimension('R')->setWidth('13');
            $this->excel->getActiveSheet()->getColumnDimension('S')->setWidth('27');
            $this->excel->getActiveSheet()->getColumnDimension('T')->setWidth('100');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Requisiciones as $Item) {
                if($Item->tipo==0){
                    $Tiporeq = "LLANTAS";
                }else{
                    $Tiporeq = "VARIOS";
                }

                $Numeroreq = $Item->numero;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
                $Fechareq = $Item->fecha_ini;
                $Usrsolicita = $Item->usuario;
                $Empresareq = $Item->to_empresa;
                $Nombrereq = $Item->to_nombre;
                $Direccreq = $Item->to_direcc;
                $Telreq = $Item->to_tel;
                $Paquetereq = $Item->to_paquete;
                $Gerentereq = $Item->gerente;
                $Observareq = $Item->observa;

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                $date = date_create($Item->fecha_sr3);
                $Fechacom=date_format($date, 'd/m/Y');

                $Details = $this->Req_deta_model->ObtenerListaPendientesSurtir($Numeroreq);
                foreach($Details as $Item2) {
                    //
                    // Obtenemos el total de piezas surtidas de la requisicion y partida
                    //                    
                    $Surtido = $this->Req_surt_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                    //
                    if ($Item2->cantidad > $Surtido){
                        $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Tiporeq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);

                        $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Almacenreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item2->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                        // $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, '', PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item2->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item2->cantidad, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Item2->cantidad-$Surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Usrsolicita, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $Empresareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $Nombrereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $Direccreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Telreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('R'.$row, $Paquetereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('S'.$row, $Gerentereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('T'.$row, $Observareq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $row++;
                    }
                }

            }
             
            $filename='ReportePendientesSurtir.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReportePensur() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
               
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Requisiciones = $this->Req_head_model->ReportePensur($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=19;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=20;

        foreach($Requisiciones as $Item) {

            if($Item->tipo==0){
                $Tiporeq = "LLANTAS";
            }else{
                $Tiporeq = "VARIOS";
            }

            $Numeroreq = $Item->numero;
            $Almacenreq = $Item->almacen;
            $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
            $Fechareq = $Item->fecha_ini;
            $Usrsolicita = $Item->usuario;
            $Empresareq =replacecharsp($Item->to_empresa);
            $Nombrereq = replacecharsp($Item->to_nombre);
            $Direccreq = replacecharsp($Item->to_direcc);
            $Telreq = $Item->to_tel;
            $Paquetereq = replacecharsp($Item->to_paquete);
            $Gerentereq = replacecharsp($Item->gerente);
            $Observareq = replacecharsp($Item->observa);

            if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
            }else{
                $Fechareq='';
            }

            if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                $date = date_create($Item->revision_gte);
                $Fechagte=date_format($date, 'd/m/Y');
            }else{
                $Fechagte='';
            }

            $date = date_create($Item->fecha_sr3);
            $Fechacom=date_format($date, 'd/m/Y');

            $Usrsolicita = $Item->usuario;
            $Details = $this->Req_deta_model->ObtenerListaPendientesSurtir($Numeroreq);
            foreach($Details as $Item2) {
                if ($AcumulaRenglones > $MaximoRenglones){
                    $pdf->SetFontSize(10);
                    $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                    $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                    $pdf->Write(5,"PENDIENTES DE SURTIR", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                    $pdf->SetFontSize(9);
                    $pdf->Write(5,"De la oficina: ".$ClaveOficinaI." a la oficina: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                    $pdf->SetFontSize(7);

                    //$header = array('Tipo','No.Req.','Fecha','Alm.','Prt','Articulo','Articulo Eq.','Descripcion','Cant.','Surt','Pend','Usr','Empresa','Nombre','Direccion','Paqueteria','Gerente','Observaciones');
                    $header = array('Tipo','No.Req.','Fecha','Autorizada','Alm.','Prt','Articulo','Descripcion','Cant.','Surt','Pend','Usr','Empresa','Nombre','Direccion','Paqueteria','Gerente','Observaciones');
                    
                    $pdf->SetFillColor(77, 77, 255);
                    $pdf->SetTextColor(255);
                    $pdf->SetDrawColor(0, 0, 0);
                    $pdf->SetLineWidth(0.3);
                    $pdf->SetFont('', 'B');
                   
                    //$w = array(10, 10, 15, 10, 7, 16, 25, 9, 9, 9, 7, 25, 25, 25, 25, 29, 30);
                    $w = array(10, 10, 15, 15, 10, 7, 16, 25, 9, 9, 9, 7, 22, 22, 22, 22, 26, 27);
                    $num_headers = count($header);
                    
                    for($i = 0; $i < $num_headers; ++$i) {
                        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                    }

                    $pdf->Ln();
                    
                    $pdf->SetFillColor(224, 235, 255);
                    $pdf->SetTextColor(0);
                    $pdf->SetFont('');
                    $AcumulaRenglones=0;
                }
                //
                // Obtenemos el total de piezas surtidas de la requisicion y partida
                //
                $Surtido = $this->Req_surt_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                //         
                if ($Item2->cantidad > $Surtido){
                    $pdf->Cell($w[0], 6, $Tiporeq, 0, 0, 'C', 0);
                    $pdf->Cell($w[1], 6, $Numeroreq, 0, 0, 'C', 0);
                    $pdf->Cell($w[2], 6, $Fechareq, 0, 0, 'C', 0);
                    $pdf->Cell($w[3], 6, $Fechagte, 0, 0, 'C', 0);

                    $pdf->Cell($w[4], 6, $Almacenreq, 0, 0, '', 0);
                    $pdf->Cell($w[5], 6, $Item2->partida, 0, 0, 'C', 0);
                    $pdf->Cell($w[6], 6, $Item2->articulo, 0, 0, 'L', 0);
                    //$pdf->Cell($w[6], 6, $Item2->articulo_eq, 0, 0, 'L', 0);
                    // $pdf->Cell($w[6], 6, '', 0, 0, 'L', 0);
                    // $pdf->Cell($w[7], 6, substr($Item2->descrip,0,15), 0, 0, '', 0);
                    $pdf->Cell($w[7], 6, substr(replacecharsp($Item2->descrip),0,15), 0, 0, '', 0);
                    $pdf->Cell($w[8], 6, $Item2->cantidad, 0, 0, 'C', 0);
                    $pdf->Cell($w[9], 6, $Surtido, 0, 0, 'C', 0);
                    $pdf->Cell($w[10], 6, $Item2->cantidad-$Surtido, 0, 0, 'C', 0);
                    $pdf->Cell($w[11], 6, $Usrsolicita, 0, 0, '', 0);
                    $pdf->Cell($w[12], 6, substr($Empresareq,0,14), 0, 0, 'L', 0);
                    $pdf->Cell($w[13], 6, substr($Nombrereq,0,13), 0, 0, 'L', 0);
                    $pdf->Cell($w[14], 6, substr($Direccreq,0,13), 0, 0, 'L', 0);
                    $pdf->Cell($w[15], 6, substr($Paquetereq,0,12), 0, 0, 'L', 0);
                    $pdf->Cell($w[16], 6, substr($Gerentereq,0,13), 0, 0, 'L', 0);
                    $pdf->Cell($w[17], 6, substr($Observareq,0,15), 0, 0, 'L', 0);
                    $AcumulaRenglones++;
                    $pdf->Ln();
                }
                
            }
        }
        $nombre_archivo = utf8_decode("ReportePendientesSurtir.pdf");
        $pdf->Output($nombre_archivo, 'D');

    }

    //
    // Reporte de pendientes de informar
    //
    function ReportePeninf()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReportePeninf")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte pendientes de informar";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reportepeninf', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelReportePeninf()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                   
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReportePeninf($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Envios");
            //set cell A1 content with some text        

            $this->excel->getActiveSheet()->setCellValue('A1', 'Tipo');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Usr');
            $this->excel->getActiveSheet()->setCellValue('C1', 'No. Req.');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Fecha');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Autorizada');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Prt');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Articulo');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Articulo Eq.');

            $this->excel->getActiveSheet()->setCellValue('J1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Cant.');
            $this->excel->getActiveSheet()->setCellValue('L1', 'Surt.');
            $this->excel->getActiveSheet()->setCellValue('M1', 'Pend.');
            $this->excel->getActiveSheet()->setCellValue('N1', 'Estatus');
            $this->excel->getActiveSheet()->setCellValue('O1', 'Orden');
            $this->excel->getActiveSheet()->setCellValue('P1', 'ETA Prov');
            $this->excel->getActiveSheet()->setCellValue('Q1', 'ETA Real');
            $this->excel->getActiveSheet()->setCellValue('R1', 'Observaciones');
            
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('8');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('9');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('20');

            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('77');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('R')->setWidth('100');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Requisiciones as $Item) {
                if($Item->tipo==0){
                    $Tiporeq = "LLANTAS";
                }else{
                    $Tiporeq = "VARIOS";
                }

                $Numeroreq = $Item->numero;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
                $Fechareq = $Item->fecha_ini;
                $Usrsolicita = $Item->usuario;
                $Empresareq = $Item->to_empresa;
                $Nombrereq = $Item->to_nombre;
                $Direccreq = $Item->to_direcc;
                $Telreq = $Item->to_tel;
                $Paquetereq = $Item->to_paquete;
                $Gerentereq = $Item->gerente;
                $Observareq = $Item->observa;

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                $date = date_create($Item->fecha_sr3);
                $Fechacom=date_format($date, 'd/m/Y');

                $Details = $this->Req_deta_model->ObtenerListaPendientesSurtir($Numeroreq);
                foreach($Details as $Item2) {
                    //
                    // Obtenemos el total de piezas surtidas de la requisicion y partida
                    //                    
                    $Surtido = $this->Req_surt_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                    //
                    // Ponemos los valores default vacios de los campos del registro de compras
                    //
                    $ComEstatus='';
                    $ComOrden='';
                    $ComEtaprov='';
                    $ComEtareal='';
                    $ComObserva='';

                    //
                    // Buscamos si hay datos de la informacion de la tabla Orders de compras
                    //
                    $Orders = $this->Req_order_model->ObtenerListaPorFolioPartida($Numeroreq, $Item2->partida);
                    //
                    // Si encontramos se reemplazan los valores deafult
                    //
                    if($Orders){
                        $ComEstatus=$Orders->status1;
                        $ComOrden=$Orders->orden;
                        $date = date_create($Orders->eta_prov);
                        $ComEtaprov=date_format($date, 'd/m/Y');
                        $date = date_create($Orders->eta_real);
                        $ComEtareal=date_format($date, 'd/m/Y');
                        $ComObserva=$Orders->observa;                    
                    }

                    $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Tiporeq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Usrsolicita, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);

                    $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Almacenreq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item2->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                    // $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, '', PHPExcel_Cell_DataType::TYPE_STRING);

                    $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item2->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Item2->cantidad, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Item2->cantidad-$Surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $ComEstatus, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $ComOrden, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $ComEtaprov, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $ComEtareal, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('R'.$row, $ComObserva, PHPExcel_Cell_DataType::TYPE_STRING);

                    $row++;
                }

            }
             
            $filename='ReportePendientesInformar.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReportePeninf() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
               
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Requisiciones = $this->Req_head_model->ReportePeninf($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=19;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=20;

        foreach($Requisiciones as $Item) {

            if($Item->tipo==0){
                $Tiporeq = "LLANTAS";
            }else{
                $Tiporeq = "VARIOS";
            }

            $Numeroreq = $Item->numero;
            $Almacenreq = $Item->almacen;
            $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
            $Fechareq = $Item->fecha_ini;
            $Usrsolicita = $Item->usuario;
            $Empresareq = replacecharsp($Item->to_empresa);
            $Nombrereq = replacecharsp($Item->to_nombre);
            $Direccreq = replacecharsp($Item->to_direcc);
            $Telreq = $Item->to_tel;
            $Paquetereq = replacecharsp($Item->to_paquete);
            $Gerentereq = replacecharsp($Item->gerente);
            $Observareq = replacecharsp($Item->observa);

            if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
            }else{
                $Fechareq='';
            }

            if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                $date = date_create($Item->revision_gte);
                $Fechagte=date_format($date, 'd/m/Y');
            }else{
                $Fechagte='';
            }

            $date = date_create($Item->fecha_sr3);
            $Fechacom=date_format($date, 'd/m/Y');

            $Usrsolicita = $Item->usuario;
            $Details = $this->Req_deta_model->ObtenerListaPendientesSurtir($Numeroreq);
            foreach($Details as $Item2) {
                if ($AcumulaRenglones > $MaximoRenglones){
                    $pdf->SetFontSize(10);
                    $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                    $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                    $pdf->Write(5,"PENDIENTES DE INFORMAR", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                    $pdf->SetFontSize(9);
                    $pdf->Write(5,"De la oficina: ".$ClaveOficinaI." a la oficina: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                    $pdf->SetFontSize(7);

                    // $header = array('Tipo','Usr','No.Req.','Fecha','Alm.','Prt','Articulo','Articulo Eq.','Descripcion','Cant.','Surt','Pend','Estatus','Orden','ETA Prov','ETA Real','Observaciones');
                    $header = array('Tipo','Usr','No.Req.','Fecha','Autorizada','Alm.','Prt','Articulo','Descripcion','Cant.','Surt','Pend','Estatus','Orden','ETA Prov','ETA Real','Observaciones');
                    
                    $pdf->SetFillColor(77, 77, 255);
                    $pdf->SetTextColor(255);
                    $pdf->SetDrawColor(0, 0, 0);
                    $pdf->SetLineWidth(0.3);
                    $pdf->SetFont('', 'B');
                   
                    // $w = array(10, 8, 12, 15, 10, 7, 12, 15, 26, 10, 10, 10, 21, 15, 15, 15, 45);
                    $w = array(10, 8, 12, 15, 15, 10, 7, 12, 26, 10, 10, 10, 21, 15, 15, 15, 45);
                    $num_headers = count($header);
                    
                    for($i = 0; $i < $num_headers; ++$i) {
                        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                    }

                    $pdf->Ln();
                    
                    $pdf->SetFillColor(224, 235, 255);
                    $pdf->SetTextColor(0);
                    $pdf->SetFont('');
                    $AcumulaRenglones=0;
                }
                //
                // Obtenemos el total de piezas surtidas de la requisicion y partida
                //
                $Surtido = $this->Req_surt_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                //
                // Ponemos los valores default vacios de los campos del registro de compras
                //
                $ComEstatus='';
                $ComOrden='';
                $ComEtaprov='';
                $ComEtareal='';
                $ComObserva='';

                //
                // Buscamos si hay datos de la informacion de la tabla Orders de compras
                //
                $Orders = $this->Req_order_model->ObtenerListaPorFolioPartida($Numeroreq, $Item2->partida);
                //
                // Si encontramos se reemplazan los valores deafult
                //
                if($Orders){
                    $ComEstatus=$Orders->status1;
                    $ComOrden=$Orders->orden;
                    $date = date_create($Orders->eta_prov);
                    $ComEtaprov=date_format($date, 'd/m/Y');
                    $date = date_create($Orders->eta_real);
                    $ComEtareal=date_format($date, 'd/m/Y');
                    $ComObserva=replacecharsp($Orders->observa);                    
                }

                $pdf->Cell($w[0], 6, $Tiporeq, 0, 0, 'C', 0);
                $pdf->Cell($w[1], 6, $Usrsolicita, 0, 0, 'C', 0);
                $pdf->Cell($w[2], 6, $Numeroreq, 0, 0, 'C', 0);
                $pdf->Cell($w[3], 6, $Fechareq, 0, 0, 'C', 0);
                $pdf->Cell($w[4], 6, $Fechagte, 0, 0, 'C', 0);
                $pdf->Cell($w[5], 6, $Almacenreq, 0, 0, 'C', 0);
                $pdf->Cell($w[6], 6, $Item2->partida, 0, 0, 'C', 0);
                $pdf->Cell($w[7], 6, $Item2->articulo, 0, 0, 'C', 0);
                //$pdf->Cell($w[7], 6, $Item2->articulo_eq, 0, 0, 'C', 0);
                // $pdf->Cell($w[7], 6, '', 0, 0, 'C', 0);

                $pdf->Cell($w[8], 6, substr(replacecharsp($Item2->descrip),0,15), 0, 0, '', 0);
                $pdf->Cell($w[9], 6, $Item2->cantidad, 0, 0, 'C', 0);
                $pdf->Cell($w[10], 6, $Surtido, 0, 0, 'C', 0);
                $pdf->Cell($w[11], 6, $Item2->cantidad-$Surtido, 0, 0, 'C', 0);
                $pdf->Cell($w[12], 6, $ComEstatus, 0, 0, 'C', 0);
                $pdf->Cell($w[13], 6, $ComOrden, 0, 0, 'C', 0);
                $pdf->Cell($w[14], 6, $ComEtaprov, 0, 0, 'C', 0);
                $pdf->Cell($w[15], 6, $ComEtareal, 0, 0, 'C', 0);
                $pdf->Cell($w[16], 6, $ComObserva, 0, 0, '', 0);
                
                $AcumulaRenglones++;
                $pdf->Ln();
            }
        }
        $nombre_archivo = utf8_decode("ReportePendientesInformar.pdf");
        $pdf->Output($nombre_archivo, 'D');
    }

    //
    // Reporte articulos y estatus de requisiciones
    //

    function ReporteArtest()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReporteArtest")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte articulos y estatus de requisiciones";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reporteartest', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelReporteArtest()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                   
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReportePensur($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Envios");
            //set cell A1 content with some text        

            $this->excel->getActiveSheet()->setCellValue('A1', 'Fecha');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Autorizada');

            $this->excel->getActiveSheet()->setCellValue('C1', 'No. Req.');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Proyecto');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Solicita');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Prt');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Articulo');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Articulo Eq.');

            $this->excel->getActiveSheet()->setCellValue('J1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Cant.');
            $this->excel->getActiveSheet()->setCellValue('L1', 'Surt.');
            $this->excel->getActiveSheet()->setCellValue('M1', 'Pend.');
            $this->excel->getActiveSheet()->setCellValue('N1', 'Fecha env.');
            $this->excel->getActiveSheet()->setCellValue('O1', 'ETA Prov');
            $this->excel->getActiveSheet()->setCellValue('P1', 'Estatus compras');
            $this->excel->getActiveSheet()->setCellValue('Q1', 'Estatus req.');
        
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('12');

            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('33');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('16');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('20');

            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('77');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('20');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Requisiciones as $Item) {
                if($Item->tipo==0){
                    $Tiporeq = "LLANTAS";
                }else{
                    $Tiporeq = "VARIOS";
                }

                $Numeroreq = $Item->numero;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
                $Fechareq = $Item->fecha_ini;
                $Usrsolicita = $Item->usuario;
                $Usuarionom = $this->Users_model->GetName($Usrsolicita);
                $Proyectoreq = $Item->depto;
                $Empresareq = $Item->to_empresa;
                $Nombrereq = $Item->to_nombre;
                $Direccreq = $Item->to_direcc;
                $Telreq = $Item->to_tel;
                $Paquetereq = $Item->to_paquete;
                $Gerentereq = $Item->gerente;
                $Observareq = $Item->observa;

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                $date = date_create($Item->fecha_sr3);
                $Fechacom=date_format($date, 'd/m/Y');
                //
                // Si la req esta en estatus 9 es cancelada, de lo contrario el valor default es CERRADA
                // Se validara si aun tiene surtidos pendientes para declararla aun abierta
                //
                if($Item->status == 9){
                    $Estatusreq='CANCELADA';
                }else{
                    $Estatusreq='CERRADA';
                    //
                    // Verificamos si la requisicion aun tiene partidas pendientes por surtir
                    //                    
                    $Surtidopendiente = $this->Req_deta_model->ObtenerResumenPendientesRequisicion($Numeroreq);
                    if($Surtidopendiente > 0){
                       $Estatusreq='ABIERTA'; 
                    }
                }

                $Details = $this->Req_deta_model->ObtenerListaPendientesSurtir($Numeroreq);
                foreach($Details as $Item2) {
                    //
                    // Obtenemos el total de piezas surtidas de la requisicion y partida
                    //
                    $Surtidosurt = $this->Req_surt_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                    //
                    // Ponemos los valores default vacios de los campos del registro de compras
                    //
                    $ComEstatus='';
                    $ComEtaprov='';
                    $Fechaenvio='';

                    //
                    // Buscamos si hay datos de la informacion de la tabla Orders de compras
                    //
                    $Orders = $this->Req_order_model->ObtenerListaPorFolioPartida($Numeroreq, $Item2->partida);
                    //
                    // Si encontramos se reemplazan los valores deafult
                    //
                    if($Orders){
                        $ComEstatus=$Orders->status1;
                        $ComOrden=$Orders->orden;
                        $date = date_create($Orders->eta_prov);
                        $ComEtaprov=date_format($date, 'd/m/Y');
                        $date = date_create($Orders->eta_real);
                        $ComEtareal=date_format($date, 'd/m/Y');
                        $ComObserva=$Orders->observa;                    
                    }
                    //
                    // Buscar y obtener fecha de envio de la partida del req_surt
                    //
                    $Surtido = $this->Req_surt_model->ObtenerFechaPorFolioPartida($Numeroreq, $Item2->partida);
                    //
                    // Si encontramos se reemplazan los valores deafult
                    //
                    if($Surtido){
                        $date = date_create($Surtido->fecha_e);
                        $Fechaenvio=date_format($date, 'd/m/Y');
                    }

                    $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);

                    $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Almacenreq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Proyectoreq, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Usuarionom, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item2->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                    // $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, '', PHPExcel_Cell_DataType::TYPE_STRING);

                    $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item2->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Item2->cantidad, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Surtidosurt, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Item2->cantidad-$Surtidosurt, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                    $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $Fechaenvio, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $ComEtaprov, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $ComEstatus, PHPExcel_Cell_DataType::TYPE_STRING);
                    $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Estatusreq, PHPExcel_Cell_DataType::TYPE_STRING);

                    $row++;
                }

            }
             
            $filename='ReporteArticulosEstatus.xls'; 
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0'); 
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReporteArtest() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
               
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Requisiciones = $this->Req_head_model->ReportePensur($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=19;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=20;

        foreach($Requisiciones as $Item) {

            if($Item->tipo==0){
                $Tiporeq = "LLANTAS";
            }else{
                $Tiporeq = "VARIOS";
            }

            $Numeroreq = $Item->numero;
            $Almacenreq = $Item->almacen;
            $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
            $Fechareq = $Item->fecha_ini;
            $Usrsolicita = $Item->usuario;
            $Usuarionom = $this->Users_model->GetName($Usrsolicita);
            $Proyectoreq = replacecharsp($Item->depto);
            $Empresareq = replacecharsp($Item->to_empresa);
            $Nombrereq = replacecharsp($Item->to_nombre);
            $Direccreq = replacecharsp($Item->to_direcc);
            $Telreq = $Item->to_tel;
            $Paquetereq = replacecharsp($Item->to_paquete);
            $Gerentereq = replacecharsp($Item->gerente);
            $Observareq = replacecharsp($Item->observa);

            if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
            }else{
                $Fechareq='';
            }

            if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                $date = date_create($Item->revision_gte);
                $Fechagte=date_format($date, 'd/m/Y');
            }else{
                $Fechagte='';
            }

            $date = date_create($Item->fecha_sr3);
            $Fechacom=date_format($date, 'd/m/Y');

            //
            // Si la req esta en estatus 9 es cancelada, de lo contrario el valor default es CERRADA
            // Se validara si aun tiene surtidos pendientes para declararla aun abierta
            //
            if($Item->status == 9){
                $Estatusreq='CANCELADA';
            }else{
                $Estatusreq='CERRADA';
                $Surtidopendiente = $this->Req_deta_model->ObtenerResumenPendientesRequisicion($Numeroreq);
                if($Surtidopendiente > 0){
                   $Estatusreq='ABIERTA'; 
                }
            }

            $Usrsolicita = $Item->usuario;
            $Details = $this->Req_deta_model->ObtenerListaPendientesSurtir($Numeroreq);
            foreach($Details as $Item2) {
                if ($AcumulaRenglones > $MaximoRenglones){
                    $pdf->SetFontSize(10);
                    $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                    $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                    $pdf->Write(5,"ARTICULOS Y ESTATUS DE REQUISICIONES", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                    $pdf->SetFontSize(9);
                    $pdf->Write(5,"De la oficina: ".$ClaveOficinaI." a la oficina: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                    $pdf->SetFontSize(7);

                    // $header = array('Fecha','Req.','Alm.','Proyecto','Solicita','Prt','Articulo','Articulo Eq.','Descripcion','Cant.','Surt','Pend','Fecha env.','ETA Prov','Estatus comp','Estatus req');
                    $header = array('Fecha','Autorizada','Req.','Alm.','Proyecto','Solicita','Prt','Articulo','Descripcion','Cant.','Surt','Pend','Fecha env.','ETA Prov','Estatus comp','Estatus req');
                    
                    $pdf->SetFillColor(77, 77, 255);
                    $pdf->SetTextColor(255);
                    $pdf->SetDrawColor(0, 0, 0);
                    $pdf->SetLineWidth(0.3);
                    $pdf->SetFont('', 'B');
                   
                    // $w = array(15, 10, 12, 31, 27, 7, 21, 25, 28, 10, 10, 10, 15, 15, 19, 16);
                    $w = array(15, 15, 10, 12, 31, 27, 7, 21, 28, 10, 10, 10, 15, 15, 19, 16);
                    $num_headers = count($header);
                    
                    for($i = 0; $i < $num_headers; ++$i) {
                        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                    }

                    $pdf->Ln();
                    
                    $pdf->SetFillColor(224, 235, 255);
                    $pdf->SetTextColor(0);
                    $pdf->SetFont('');
                    $AcumulaRenglones=0;
                }
                //
                // Obtenemos el total de piezas surtidas de la requisicion y partida
                //                
                $Surtidosurt = $this->Req_surt_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                //
                // Ponemos los valores default vacios de los campos de estatus de compra, estatus requisicion
                // y fecha de envio, los cuales se llenaran despues su existen los valores obtenidos en los
                // queries correspondientes
                //
                $ComEstatus='';
                $ComEtaprov='';
                $Fechaenvio='';

                //
                // Buscamos si hay datos de la informacion de la tabla Orders de compras
                //
                $Orders = $this->Req_order_model->ObtenerListaPorFolioPartida($Numeroreq, $Item2->partida);
                //
                // Si encontramos se reemplazan los valores default
                //
                if($Orders){
                    $ComEstatus=$Orders->status1;
                    $date = date_create($Orders->eta_prov);
                    $ComEtaprov=date_format($date, 'd/m/Y');
                }
                //
                // Buscar y obtener fecha de envio de la partida del req_surt
                //
                $Surtido = $this->Req_surt_model->ObtenerFechaPorFolioPartida($Numeroreq, $Item2->partida);
                //
                // Si encontramos se reemplazan los valores deafult
                //
                if($Surtido){
                    $date = date_create($Surtido->fecha_e);
                    $Fechaenvio=date_format($date, 'd/m/Y');
                }

                $pdf->Cell($w[0], 6, $Fechareq, 0, 0, 'C', 0);
                $pdf->Cell($w[1], 6, $Fechagte, 0, 0, 'C', 0);
                $pdf->Cell($w[2], 6, $Numeroreq, 0, 0, 'C', 0);
                $pdf->Cell($w[3], 6, $Almacenreq, 0, 0, 'C', 0);
                $pdf->Cell($w[4], 6, substr($Proyectoreq,0,17), 0, 0, 'L', 0);
                $pdf->Cell($w[5], 6, substr($Usuarionom,0,14), 0, 0, 'L', 0);
                $pdf->Cell($w[6], 6, $Item2->partida, 0, 0, 'C', 0);
                $pdf->Cell($w[7], 6, $Item2->articulo, 0, 0, 'L', 0);
                //$pdf->Cell($w[7], 6, $Item2->articulo_eq, 0, 0, 'L', 0);
                // $pdf->Cell($w[7], 6, '', 0, 0, 'L', 0);
                $pdf->Cell($w[8], 6, substr(replacecharsp($Item2->descrip),0,15), 0, 0, '', 0);
                $pdf->Cell($w[9], 6, $Item2->cantidad, 0, 0, 'C', 0);
                $pdf->Cell($w[10], 6, $Surtidosurt, 0, 0, 'C', 0);
                $pdf->Cell($w[11], 6, $Item2->cantidad-$Surtidosurt, 0, 0, 'C', 0);
                $pdf->Cell($w[12], 6, $Fechaenvio, 0, 0, 'C', 0);
                $pdf->Cell($w[13], 6, $ComEtaprov, 0, 0, 'C', 0);
                $pdf->Cell($w[14], 6, $ComEstatus, 0, 0, 'L', 0);
                $pdf->Cell($w[15], 6, $Estatusreq, 0, 0, 'C', 0);
                
                $AcumulaRenglones++;
                $pdf->Ln();
            }
        }
        $nombre_archivo = utf8_decode("ReporteArticulosEstatus.pdf");
        $pdf->Output($nombre_archivo, 'D');
    }
    //
    // Reporte de envios
    //
    function ReporteEnvioseo()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReporteEnvioseo")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $ClaveOficinaapyPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaapyUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaapyPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaapyUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Claveoficinaapyprimero'] = $ClaveOficinaapyPrimero;
        $Data['Claveoficinaapyultimo'] = $ClaveOficinaapyUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Nombreoficinaapyprimero'] = $NombreOficinaapyPrimero;
        $Data['Nombreoficinaapyultimo'] = $NombreOficinaapyUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte de envios entre oficinas";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reporteenvioseo', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelReporteEnvioseo()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                   
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $ClaveOficinaapyI = $this->input->post("ClaveoficinaapyI");
            $ClaveOficinaapyF = $this->input->post("ClaveoficinaapyF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReporteEnvioseo($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Envios");
            //Establecemos los nombres de las columnas

            $this->excel->getActiveSheet()->setCellValue('A1', 'Of1');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Of2');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('D1', 'No.Req.');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Fecha');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Autorizada');

            $this->excel->getActiveSheet()->setCellValue('G1', 'Usr');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Empresa');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('J1', 'Telef');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Prt');
            $this->excel->getActiveSheet()->setCellValue('L1', 'Articulo');
            $this->excel->getActiveSheet()->setCellValue('M1', 'Articulo Eq.');

            $this->excel->getActiveSheet()->setCellValue('N1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('O1', 'Cant.');
            $this->excel->getActiveSheet()->setCellValue('P1', 'Fecha E.');
            $this->excel->getActiveSheet()->setCellValue('Q1', 'Surt.');
            $this->excel->getActiveSheet()->setCellValue('R1', 'Pend.');
            $this->excel->getActiveSheet()->setCellValue('S1', 'Guia E.');
            $this->excel->getActiveSheet()->setCellValue('T1', 'Paqueteria');
            //Establecemos el tamaño de la letra a 12 y la ponemos negrita
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('4');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('4');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('12');

            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('4');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('42');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('40');
            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('4');
            $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('16');
            $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('20');

            $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('70');
            $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('6');
            $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('6');
            $this->excel->getActiveSheet()->getColumnDimension('R')->setWidth('6');
            $this->excel->getActiveSheet()->getColumnDimension('S')->setWidth('15');
            $this->excel->getActiveSheet()->getColumnDimension('T')->setWidth('30');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            $Requiproc = "";

            foreach($Requisiciones as $Item) {
                $Numeroreq = $Item->requisicion;
                $Of1 = $Item->ofna;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
                $Fechareq = $Item->fecha_ini;
                $Usrsolicita = $Item->usuario;
                $Empresareq = $Item->to_empresa;
                $Nombrereq = $Item->to_nombre;
                $Direccreq = $Item->to_direcc;
                $Telreq = $Item->to_tel;

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                $date = date_create($Item->fecha_sr3);
                $Fechacom=date_format($date, 'd/m/Y');

                if($Requiproc != $Numeroreq)
                {
                    $Requiproc = $Numeroreq;
                    $Usrsolicita = $Item->usuario;
                    $Details = $this->Req_soo_model->ObtenerListaParaReporteEnvios($Numeroreq,$FechaI,$FechaF);
                    foreach($Details as $Item2) {

                        $Det_descrip="";
                        $Det_cant=0;

                        $OrderDetails = $this->Req_deta_model->ObtenerDescipYmarcaEnvios($Numeroreq,$Item2->partida);
                        if($OrderDetails){
                            $Det_descrip=$OrderDetails->descrip;
                            $Det_cant=$OrderDetails->cantapoy;
                            $Of2=$OrderDetails->apoyo;
                        }
                        //
                        // Validar que la oficina de apoyo se encuentre dentro del rango establecido por el usuario
                        // de lo contrario se ignora el registro
                        //
                        if($Of2 >= $ClaveOficinaapyI && $Of2 <= $ClaveOficinaapyF){
                            //
                            // Obtenemos el total de piezas surtidas de la requisicion y partida
                            //
                            $Surtido = $this->Req_soo_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                            //         
                            $date = date_create($Item2->fecha_e);
                            $Fechaenv=date_format($date, 'd/m/Y');

                            $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Of1, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Of2, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Almacenreq, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);

                            $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Usrsolicita, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Empresareq, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Nombrereq, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Telreq, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Item2->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                            // $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, '', PHPExcel_Cell_DataType::TYPE_STRING);

                            $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $Det_descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $Det_cant, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                            $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $Fechaenv, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Item2->surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                            $this->excel->getActiveSheet()->setCellValueExplicit('R'.$row, $Det_cant-$Surtido, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                            $this->excel->getActiveSheet()->setCellValueExplicit('S'.$row, $Item2->guia_e, PHPExcel_Cell_DataType::TYPE_STRING);
                            $this->excel->getActiveSheet()->setCellValueExplicit('T'.$row, $Item2->paqueteria, PHPExcel_Cell_DataType::TYPE_STRING);

                            $row++;
                        }
                    }
                }
            }
             
            $filename='ReporteEnviosEO.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReporteEnvioseo() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
               
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $ClaveOficinaapyI = $this->input->post("ClaveoficinaapyI");
        $ClaveOficinaapyF = $this->input->post("ClaveoficinaapyF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Requisiciones = $this->Req_head_model->ReporteEnvioseo($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=18;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=19;
        $Requiproc = "";

        foreach($Requisiciones as $Item) {
            $Numeroreq = $Item->requisicion;
            $Of1 = $Item->ofna;
            $Almacenreq = $Item->almacen;
            $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
            $Fechareq = $Item->fecha_ini;
            $Usrsolicita = $Item->usuario;
            $Empresareq = replacecharsp($Item->to_empresa);
            $Nombrereq = replacecharsp($Item->to_nombre);
            $Direccreq = replacecharsp($Item->to_direcc);
            $Telreq = $Item->to_tel;

            if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
            }else{
                $Fechareq='';
            }

            if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                $date = date_create($Item->revision_gte);
                $Fechagte=date_format($date, 'd/m/Y');
            }else{
                $Fechagte='';
            }

            $date = date_create($Item->fecha_sr3);
            $Fechacom=date_format($date, 'd/m/Y');
            if($Requiproc != $Numeroreq)
            {
                $Requiproc = $Numeroreq;
                $Usrsolicita = $Item->usuario;
                $Details = $this->Req_soo_model->ObtenerListaParaReporteEnvios($Numeroreq,$FechaI,$FechaF);
                foreach($Details as $Item2) {
                    if ($AcumulaRenglones > $MaximoRenglones){
                        $pdf->SetFontSize(10);
                        $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                        $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                        $pdf->Write(5,"REPORTE DE ENVIOS ENTRE OFICINAS", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                        $pdf->SetFontSize(9);
                        $pdf->Write(5,"De la oficina solicitante: ".$ClaveOficinaI." a la oficina solicitante: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                        $pdf->Write(5,"De la oficina de apoyo: ".$ClaveOficinaapyI." a la oficina de apoyo: ".$ClaveOficinaapyF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                        $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                        $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                        $pdf->SetFontSize(7);
                        //$header = array('Of1','Of2','Almacen','No.Req.','Fecha','Usr','Empresa','Nombre','Telefono','Prt','Articulo','Descripcion','Cant.','Fecha E.','Surt.','Pend.','Guia E.','Paqueteria');
                        $header = array('Of1','Of2','Almacen','No.Req.','Fecha','Autorizada','Usr','Empresa','Nombre','Telefono','Prt','Articulo','Descripcion','Cant.','Fecha E.','Surt.','Pend.','Guia E.','Paqueteria');
                        
                        $pdf->SetFillColor(77, 77, 255);
                        $pdf->SetTextColor(255);
                        $pdf->SetDrawColor(0, 0, 0);
                        $pdf->SetLineWidth(0.3);
                        $pdf->SetFont('', 'B');
                       
                        // $w = array(7, 7, 12, 10, 15, 8, 21, 21, 15, 15, 20, 20, 21, 10, 15, 10, 10, 18, 18);
                        $w = array(7, 7, 12, 10, 15, 15, 8, 21, 21, 15, 15, 20, 21, 10, 15, 10, 10, 18, 18);
                        $num_headers = count($header);
                        
                        for($i = 0; $i < $num_headers; ++$i) {
                            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                        }

                        $pdf->Ln();
                        
                        $pdf->SetFillColor(224, 235, 255);
                        $pdf->SetTextColor(0);
                        $pdf->SetFont('');
                        $AcumulaRenglones=0;
                    }
                
                    $Det_descrip="";
                    $Det_cant=0;

                    $OrderDetails = $this->Req_deta_model->ObtenerDescipYmarcaEnvios($Numeroreq,$Item2->partida);
                    if($OrderDetails){
                        $Det_descrip=replacecharsp($OrderDetails->descrip);
                        $Det_cant=$OrderDetails->cantapoy;
                        $Of2=$OrderDetails->apoyo;
                    }
                    //
                    // Validar que la oficina de apoyo se cencuentre dentro del rango establecido por el usuario
                    // de lo contrario se ignora el registro
                    //
                    if($Of2 >= $ClaveOficinaapyI && $Of2 <= $ClaveOficinaapyF){
                        //
                        // Obtenemos el total de piezas surtidas de la requisicion y partida
                        //
                        $Surtido = $this->Req_soo_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                        //         

                        $date = date_create($Item2->fecha_e);
                        $Fechaenv=date_format($date, 'd/m/Y');

                        $pdf->Cell($w[0], 6, $Of1, 0, 0, '', 0);
                        $pdf->Cell($w[1], 6, $Of2, 0, 0, '', 0);
                        $pdf->Cell($w[2], 6, $Almacenreq, 0, 0, '', 0);
                        $pdf->Cell($w[3], 6, $Numeroreq, 0, 0, 'C', 0);
                        $pdf->Cell($w[4], 6, $Fechareq, 0, 0, '', 0);
                        $pdf->Cell($w[5], 6, $Fechagte, 0, 0, '', 0);

                        $pdf->Cell($w[6], 6, $Usrsolicita, 0, 0, 'C', 0);
                        $pdf->Cell($w[7], 6, substr($Empresareq,0,11), 0, 0, 'L', 0);
                        $pdf->Cell($w[8], 6, substr($Nombrereq,0,11), 0, 0, 'L', 0);
                        $pdf->Cell($w[9], 6, $Telreq, 0, 0, 'C', 0);
                        $pdf->Cell($w[10], 6, $Item2->partida, 0, 0, 'C', 0);
                        $pdf->Cell($w[11], 6, $Item2->articulo, 0, 0, 'C', 0);
                        //$pdf->Cell($w[11], 6, $Item2->articulo_eq, 0, 0, 'C', 0);
                        // $pdf->Cell($w[11], 6, '', 0, 0, 'C', 0);

                        $pdf->Cell($w[12], 6, substr($Det_descrip,0,11), 0, 0, '', 0);
                        $pdf->Cell($w[13], 6, $Det_cant, 0, 0, 'R', 0);
                        $pdf->Cell($w[14], 6, $Fechaenv, 0, 0, '', 0);
                        $pdf->Cell($w[15], 6, $Item2->surtido, 0, 0, 'R', 0);
                        $pdf->Cell($w[16], 6, $Det_cant-$Surtido, 0, 0, 'R', 0);
                        $pdf->Cell($w[17], 6, replacecharsp($Item2->guia_e), 0, 0, '', 0);
                        $pdf->Cell($w[18], 6, substr(replacecharsp($Item2->paqueteria),0,9), 0, 0, 'L', 0);

                        $AcumulaRenglones++;
                        $pdf->Ln();
                    }
                }
            }
        }
        $nombre_archivo = utf8_decode("ReporteEnviosEO.pdf");
        $pdf->Output($nombre_archivo, 'D');

    }

    //
    // Reporte de pendientes de surtir otras oficinas
    //
    function ReportePensuroo()
    {
        if(!VerificarPermisos($this->session->UID, "Reportes", "ReportePensuroo")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Almacenactual = $this->session->Almacen;
        $Almacenes = $this->Almacenes_model->GetList();
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //
        $ClaveAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->clave;
        $ClaveAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->clave;
        $NombreAlmacenPrimero = $this->Almacenes_model->ObtenerPrimero()->nombre;
        $NombreAlmacenUltimo = $this->Almacenes_model->ObtenerUltimo()->nombre;

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Almacenes'] = $Almacenes;
        $Data['Oficinas'] = $Oficinas;
        $Data['Clavealmacenprimero'] = $ClaveAlmacenPrimero;
        $Data['Clavealmacenultimo'] = $ClaveAlmacenUltimo;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombrealmacenprimero'] = $NombreAlmacenPrimero;
        $Data['Nombrealmacenultimo'] = $NombreAlmacenUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Almacenactual'] = $Almacenactual;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Reporte pendientes de surtir otras ofnas.";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Reportes/Reportepensuroo', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelReportePensuroo()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                   
            $ClaveAlmacenI = $this->input->post("ClavealmacenI");
            $ClaveAlmacenF = $this->input->post("ClavealmacenF");
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Requisiciones = $this->Req_head_model->ReportePensureo($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Pendientes EO");
            //set cell A1 content with some text        

            $this->excel->getActiveSheet()->setCellValue('A1', 'Tipo');
            $this->excel->getActiveSheet()->setCellValue('B1', 'No. Req.');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Fecha');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Autorizada');

            $this->excel->getActiveSheet()->setCellValue('E1', 'Almacen');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Prt');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Articulo');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Articulo Eq.');

            $this->excel->getActiveSheet()->setCellValue('I1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('J1', 'Cant.');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Surt.');
            $this->excel->getActiveSheet()->setCellValue('L1', 'Pend.');
            $this->excel->getActiveSheet()->setCellValue('M1', 'Usr');
            $this->excel->getActiveSheet()->setCellValue('N1', 'Empresa');
            $this->excel->getActiveSheet()->setCellValue('O1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('P1', 'Direccion');
            $this->excel->getActiveSheet()->setCellValue('Q1', 'Telefono');
            $this->excel->getActiveSheet()->setCellValue('R1', 'Paqueteria');
            $this->excel->getActiveSheet()->setCellValue('S1', 'Gerente');
            $this->excel->getActiveSheet()->setCellValue('T1', 'Observaciones');
            
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('S1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('T1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('8');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('9');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('12');

            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('9');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('3');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('16');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('20');

            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('77');
            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('5');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('5');
            $this->excel->getActiveSheet()->getColumnDimension('L')->setWidth('6');
            $this->excel->getActiveSheet()->getColumnDimension('M')->setWidth('3');
            $this->excel->getActiveSheet()->getColumnDimension('N')->setWidth('41');
            $this->excel->getActiveSheet()->getColumnDimension('O')->setWidth('34');
            $this->excel->getActiveSheet()->getColumnDimension('P')->setWidth('56');
            $this->excel->getActiveSheet()->getColumnDimension('Q')->setWidth('11');
            $this->excel->getActiveSheet()->getColumnDimension('R')->setWidth('13');
            $this->excel->getActiveSheet()->getColumnDimension('S')->setWidth('27');
            $this->excel->getActiveSheet()->getColumnDimension('T')->setWidth('100');

            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Requisiciones as $Item) {
                if($Item->tipo==0){
                    $Tiporeq = "LLANTAS";
                }else{
                    $Tiporeq = "VARIOS";
                }

                $Numeroreq = $Item->numero;
                $Almacenreq = $Item->almacen;
                $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
                $Fechareq = $Item->fecha_ini;
                $Usrsolicita = $Item->usuario;
                $Empresareq = $Item->to_empresa;
                $Nombrereq = $Item->to_nombre;
                $Direccreq = $Item->to_direcc;
                $Telreq = $Item->to_tel;
                $Paquetereq = $Item->to_paquete;
                $Gerentereq = $Item->gerente;
                $Observareq = $Item->observa;

                if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->fecha_ini);
                    $Fechareq=date_format($date, 'd/m/Y');
                }else{
                    $Fechareq='';
                }

                if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                    $date = date_create($Item->revision_gte);
                    $Fechagte=date_format($date, 'd/m/Y');
                }else{
                    $Fechagte='';
                }

                $date = date_create($Item->fecha_sr3);
                $Fechacom=date_format($date, 'd/m/Y');

                $Details = $this->Req_deta_model->ObtenerListaPendientesSurtireo($Numeroreq);
                foreach($Details as $Item2) {
                    //
                    // Obtenemos el total de piezas surtidas de la requisicion y partida
                    //                    
                    $Surtapoyo = $this->Req_soo_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                    //
                    if ($Item2->cantapoy > $Surtapoyo){
                        $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Tiporeq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Numeroreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Fechareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Fechagte, PHPExcel_Cell_DataType::TYPE_STRING);

                        $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Almacenreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item2->partida, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item2->articulo, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item2->articulo_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                        // $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, '', PHPExcel_Cell_DataType::TYPE_STRING);

                        $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item2->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item2->cantapoy, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Surtapoyo, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('L'.$row, $Item2->cantapoy-$Surtapoyo, PHPExcel_Cell_DataType::TYPE_NUMERIC);
                        $this->excel->getActiveSheet()->setCellValueExplicit('M'.$row, $Usrsolicita, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('N'.$row, $Empresareq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('O'.$row, $Nombrereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('P'.$row, $Direccreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('Q'.$row, $Telreq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('R'.$row, $Paquetereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('S'.$row, $Gerentereq, PHPExcel_Cell_DataType::TYPE_STRING);
                        $this->excel->getActiveSheet()->setCellValueExplicit('T'.$row, $Item2->observapoy, PHPExcel_Cell_DataType::TYPE_STRING);
                    $row++;
                    }
                }

            }
             
            $filename='ReportePendientesSurtir_oo.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfReportePensuroo() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
               
        $ClaveAlmacenI = $this->input->post("ClavealmacenI");
        $ClaveAlmacenF = $this->input->post("ClavealmacenF");
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Requisiciones = $this->Req_head_model->ReportePensureo($ClaveAlmacenI,$ClaveAlmacenF,$ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=19;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=20;

        foreach($Requisiciones as $Item) {

            if($Item->tipo==0){
                $Tiporeq = "LLANTAS";
            }else{
                $Tiporeq = "VARIOS";
            }

            $Numeroreq = $Item->numero;
            $Almacenreq = $Item->almacen;
            $Almacennom = $this->Almacenes_model->GetNombreByClave($Almacenreq);
            $Fechareq = $Item->fecha_ini;
            $Usrsolicita = $Item->usuario;
            $Empresareq = replacecharsp($Item->to_empresa);
            $Nombrereq = replacecharsp($Item->to_nombre);
            $Direccreq = replacecharsp($Item->to_direcc);
            $Telreq = $Item->to_tel;
            $Paquetereq = replacecharsp($Item->to_paquete);
            $Gerentereq = replacecharsp($Item->gerente);
            $Observareq = replacecharsp($Item->observa);

            if($Item->fecha_ini !== '0000-00-00 00:00:00' && $Item->fecha_ini !== '1753-01-01 00:00:00'){
                $date = date_create($Item->fecha_ini);
                $Fechareq=date_format($date, 'd/m/Y');
            }else{
                $Fechareq='';
            }

            if($Item->revision_gte !== '0000-00-00 00:00:00' && $Item->revision_gte !== '1753-01-01 00:00:00'){
                $date = date_create($Item->revision_gte);
                $Fechagte=date_format($date, 'd/m/Y');
            }else{
                $Fechagte='';
            }

            $date = date_create($Item->fecha_sr3);
            $Fechacom=date_format($date, 'd/m/Y');

            $Usrsolicita = $Item->usuario;
            $Details = $this->Req_deta_model->ObtenerListaPendientesSurtireo($Numeroreq);
            foreach($Details as $Item2) {
                if ($AcumulaRenglones > $MaximoRenglones){
                    $pdf->SetFontSize(10);
                    $pdf->Write(5,$Parametros->razon_soc, $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                    $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                    $pdf->Write(5,"PENDIENTES DE SURTIR OTRAS OFICINAS", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);        
                    $pdf->SetFontSize(9);
                    $pdf->Write(5,"De la oficina apoyo: ".$ClaveOficinaI." a la oficina apoyo: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"Del almacen: ".$ClaveAlmacenI." al almacen: ".$ClaveAlmacenF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);

                    $pdf->SetFontSize(7);

                    // $header = array('Tipo','No.Req.','Fecha','Alm.','Prt','Articulo', 'Articulo Eq.','Descripcion','Cant.','Surt','Pend','Usr','Empresa','Nombre','Direccion','Paqueteria','Gerente','Observaciones');
                    $header = array('Tipo','No.Req.','Fecha','Autorizada','Alm.','Prt','Articulo', 'Descripcion','Cant.','Surt','Pend','Usr','Empresa','Nombre','Direccion','Paqueteria','Gerente','Observaciones');
                    
                    $pdf->SetFillColor(77, 77, 255);
                    $pdf->SetTextColor(255);
                    $pdf->SetDrawColor(0, 0, 0);
                    $pdf->SetLineWidth(0.3);
                    $pdf->SetFont('', 'B');
                   
                    // $w = array(10, 10, 15, 10, 7, 20, 20, 25, 9, 9, 9, 7, 21, 21, 21, 21, 21, 30);
                    $w = array(10, 10, 15, 15, 10, 7, 20, 25, 9, 9, 9, 7, 21, 21, 21, 21, 21, 30);
                    $num_headers = count($header);
                    
                    for($i = 0; $i < $num_headers; ++$i) {
                        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                    }

                    $pdf->Ln();
                    
                    $pdf->SetFillColor(224, 235, 255);
                    $pdf->SetTextColor(0);
                    $pdf->SetFont('');
                    $AcumulaRenglones=0;
                }
                //
                // Obtenemos el total de piezas surtidas de la requisicion y partida
                //
                $Surtapoyo = $this->Req_soo_model->ObtenerSurtidoRequisicionPartida($Numeroreq,$Item2->partida);
                //         
                if ($Item2->cantapoy > $Surtapoyo){
                    $pdf->Cell($w[0], 6, $Tiporeq, 0, 0, 'C', 0);
                    $pdf->Cell($w[1], 6, $Numeroreq, 0, 0, 'C', 0);
                    $pdf->Cell($w[2], 6, $Fechareq, 0, 0, 'C', 0);
                    $pdf->Cell($w[3], 6, $Fechagte, 0, 0, 'C', 0);
                    $pdf->Cell($w[4], 6, $Almacenreq, 0, 0, '', 0);
                    $pdf->Cell($w[5], 6, $Item2->partida, 0, 0, 'C', 0);
                    $pdf->Cell($w[6], 6, $Item2->articulo, 0, 0, 'C', 0);
                    //$pdf->Cell($w[6], 6, $Item2->articulo_eq, 0, 0, 'C', 0);
                    // $pdf->Cell($w[6], 6, '', 0, 0, 'C', 0);
                    $pdf->Cell($w[7], 6, substr(replacecharsp($Item2->descrip),0,15), 0, 0, '', 0);
                    $pdf->Cell($w[8], 6, $Item2->cantapoy, 0, 0, 'C', 0);
                    $pdf->Cell($w[9], 6, $Surtapoyo, 0, 0, 'C', 0);
                    $pdf->Cell($w[10], 6, $Item2->cantapoy-$Surtapoyo, 0, 0, 'C', 0);
                    $pdf->Cell($w[11], 6, $Usrsolicita, 0, 0, '', 0);
                    $pdf->Cell($w[12], 6, substr($Empresareq,0,12), 0, 0, 'L', 0);
                    $pdf->Cell($w[13], 6, substr($Nombrereq,0,11), 0, 0, 'L', 0);
                    $pdf->Cell($w[14], 6, substr($Direccreq,0,11), 0, 0, 'L', 0);
                    $pdf->Cell($w[15], 6, substr($Paquetereq,0,11), 0, 0, 'L', 0);
                    $pdf->Cell($w[16], 6, substr($Gerentereq,0,11), 0, 0, 'L', 0);
                    $pdf->Cell($w[17], 6, substr(replacecharsp($Item2->observapoy),0,20), 0, 0, 'L', 0);
                    $AcumulaRenglones++;
                    $pdf->Ln();
                }
                
            }
        }
        $nombre_archivo = utf8_decode("ReportePendientesSurtir_oo.pdf");
        $pdf->Output($nombre_archivo, 'D');

    }
}