<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Parametros extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Details($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Parametros", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $Parametros = $this->Parametros_model->GetUnique();
        if(!$Parametros){
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }
        $Data["UpdatedBy"] = $this->Users_model->GetByUserName($Parametros->UpdatedBy)->Name;
        $Data['title'] = "Detalles de parametros";
        $Data['Parametros'] = $Parametros;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Parametros/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit(){
        if(!VerificarPermisos($this->session->UID, "Parametros", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $Parametros = $this->Parametros_model->GetUnique();

        if(!$Parametros)
        {
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }

        $Data["UpdatedBy"] = $this->Users_model->GetByUserName($Parametros->UpdatedBy)->Name;
        $Data['title'] = "Editar parametros";
        $Data['Parametros'] = $Parametros;

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Parametros/Edit', $Data);
        $this->load->view('layouts/footer');

    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Parametros", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $OriginalParametros = $this->Parametros_model->GetUnique();
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $EditParametros = array(
                "Clave" => 1,
                "razon_soc" => $this->input->post("Nombreempresa"),
                "direccion" => $this->input->post("Direccion"),
                "rfc" => $this->input->post("RFC"),
                "UpdatedBy" => $LoggedUserId,
                "UpdatedDate" => $TodayDate
            );

            $result = $this->Parametros_model->Update($EditParametros);
            if($result){
                $this->session->set_flashdata('message_details', 'Se modificaron exitosamente los parametros.');
                $this->session->set_flashdata('class', 'success');
                redirect("Parametros/Details");
            }else{
                $this->session->set_flashdata('message_edit', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
        }
        $Data["UpdatedBy"] = $this->Users_model->GetByUserName($OriginalParametros->UpdatedBy)->Name;
        $Data['title'] = "Editar parametros";
        $Data['Parametros'] = $OriginalParametros;
        set_value("Nombreempresa","Direccion", "Telefono", "RFC");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Parametros/Edit', $Data);
        $this->load->view('layouts/footer');
    }

}
