<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Oficinas extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index()
    {
        if(!VerificarPermisos($this->session->UID, "Oficinas", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Page = 1;
        $Clave = "";
        $Nombre = "";
        if($this->input->post()){
            $Clave = $this->input->post('Clave');
            $Nombre = $this->input->post('Nombre');
            $Page = $this->input->post("Page");
        }
        set_value("Clave", "Nombre");
        $Pages = $this->Oficinas_model->GetPages($Page, $Clave, $Nombre);
        if( $Pages <= 1){
            $Page = 1;
        }
        $Oficinas = $this->Oficinas_model->GetAll($Page, $Clave, $Nombre);
        $Data['title'] = "Oficinas";
        $Data['Oficinas'] = $Oficinas;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Oficinas/Index', $Data);
        $this->load->view('layouts/footer');
    }

    function Create(){
        if(!VerificarPermisos($this->session->UID, "Oficinas", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Data['title'] = "Crear nueva oficina";
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Oficinas/Create', $Data);
        $this->load->view('layouts/footer');
    }

    function CreatePost(){
        if(!VerificarPermisos($this->session->UID, "Oficinas", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Exists = $this->Oficinas_model->CheckIfExists($this->input->post("Clave"));
            if($Exists){
                $this->session->set_flashdata('message_create', 'Ya existe una oficina con la misma clave');
                $this->session->set_flashdata('class', 'danger');
            }else{
                $TodayDate = unix_to_human(time(), TRUE, 'mx');
                $LoggedUserId = $this->session->UID;
                $NewOficina = array(
                    "Clave" => $this->input->post("Clave"),
                    "Nombre" => $this->input->post("Nombre"),
                    "Active" => 1,
                    "CreatedBy" => $LoggedUserId,
                    "CreatedDate" => $TodayDate,
                    "UpdatedBy" => $LoggedUserId,
                    "UpdatedDate" => $TodayDate
                );
                $result = $this->Oficinas_model->Create($NewOficina);
                if($result){
                    $this->session->set_flashdata('message_index', 'Se guardo exitosamente el registro');
                    $this->session->set_flashdata('class', 'success');
                    redirect("Oficinas");
                }else{
                    $this->session->set_flashdata('message_create', 'Hubo un error al registrar');
                    $this->session->set_flashdata('class', 'danger');
                }
            }
            $Data['title'] = "Crear nueva oficina";
            set_value("Clave", "Nombre");
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Oficinas/Create', $Data);
            $this->load->view('layouts/footer');
        }
    }

    function Details($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Oficinas", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Oficina = $this->Oficinas_model->GetByClave($Id);
        if(!$Oficina){
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }

        $Data["Createdby"] = $this->Users_model->GetByUserName($Oficina->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Oficina->UpdatedBy)->Name;
        $Data['title'] = "Detalles de oficinas";
        $Data['Oficina'] = $Oficina;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Oficinas/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Oficinas", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Oficina = $this->Oficinas_model->GetByClave($Id);

        if(!$Oficina)
        {
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }
        $Data["Createdby"] = $this->Users_model->GetByUserName($Oficina->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Oficina->UpdatedBy)->Name;
        $Data['title'] = "Editar oficina";
        $Data['Oficina'] = $Oficina;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Oficinas/Edit', $Data);
        $this->load->view('layouts/footer');

    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Oficinas", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $OriginalOficina = $this->Oficinas_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $EditOficina = array(
                "Clave" => $this->input->post("Clave"),
                "Nombre" => $this->input->post("Nombre"),
                "Updatedby" => $LoggedUserId,
                "Updateddate" => $TodayDate
            );
          
            $result = $this->Oficinas_model->Update($EditOficina);
            if($result){
                $this->session->set_flashdata('message_index', 'Se modifico exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Oficinas");
            }else{
                $this->session->set_flashdata('message_edit', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
        }
        $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalOficina->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalOficina->UpdatedBy)->Name;
        $Data['title'] = "Editar oficina";
        $Data['Oficina'] = $OriginalOficina;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Oficinas/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function Delete(){
        if(!VerificarPermisos($this->session->UID, "Oficinas", "Delete")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post())
        {
            $OriginalOficina = $this->Oficinas_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $DeleteOficina = array(
                "Clave" => $this->input->post("Clave"),
                "Active" => false,
                "DeletedBy" => $LoggedUserId,
                "DeletedDate" => $TodayDate
            );
          
            $result = $this->Oficinas_model->Update($DeleteOficina);
            if($result){
                $this->session->set_flashdata('message_index', 'Se elimino exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Oficinas");
            }else{
                $this->session->set_flashdata('message_details', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
            $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalOficina->CreatedBy)->Name;
            $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalOficina->UpdatedBy)->Name;
            $Data['title'] = "Detalles de la oficina";
            $Data['Oficina'] = $OriginalOficina;
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Oficinas/Details', $Data);
            $this->load->view('layouts/footer');   
        }
    }

    function AutocompleteClave(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Oficinas_model->SearchByClave($term);
        echo json_encode($result);
    }

    function AutocompleteNombre(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Oficinas_model->SearchByNombre($term);
        echo json_encode($result);
    }

    function GetByClave(){
        $ClaveOficina = strtolower($this->input->get("ClaveOficina"));
        $result = $this->Oficinas_model->GetByClave($ClaveOficina);
        if($result && !$result->Active)
        {
            $result = null;
        }
        echo json_encode($result);
    }

    function Exportxls()
    {
            //
            // Tomamos los registros de la tabla
            // 
            
            $Registros = $this->Oficinas_model->GetAllToExport();

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Oficinas");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Clave');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Creado por');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Fecha creacion');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Modificado por');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Fecha modif.');
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('30');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('20');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Registros as $Item) {

                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->clave, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->nombre, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->CreatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->CreatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->UpdatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->UpdatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
             
            $filename='CatalogoOficinas.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');

            // $this->session->set_flashdata('message_index', 'Se exportó exitosamente el catalago en el archivo: '.$filename,);
            // $this->session->set_flashdata('class', 'success');
            redirect("Oficinas");
    }

}
