<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Misreqoo extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index()
    {
        if(!VerificarPermisos($this->session->UID, "Misreqoo", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $Page = 1;
        $Folio = "";
        if($this->input->post()){
            $Folio = $this->input->post('Folio');
            $Page = $this->input->post("Page");
        }
        set_value("Folio");
        $Pages = $this->Req_head_model->GetPagesMisreqoo($Page, $Folio, $this->session->Oficina);
        if( $Pages <= 1){
            $Page = 1;
        }

        $CabezaRequisiciones = $this->Req_head_model->GetAllMisreqoo($Page, $Folio, $this->session->Oficina);
        $Data['title'] = "Consultar mis requisiciones a otras oficinas";
        $Data['CabezaRequisiciones'] = $CabezaRequisiciones;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Misreqoo/Index', $Data);
        $this->load->view('layouts/footer');
    }
    
    function Details($numero = null)
    {
        if(!VerificarPermisos($this->session->UID, "Misreqoo", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $BitacoraMovimientos = $this->Req_logs_model->ObtenerListaPorFolio($numero);

        foreach($BitacoraMovimientos as $Bitacora)
        {
            $Bitacora->Usuario = $this->Users_model->GetByUserName($Bitacora->log_usuario);
        }

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        $Adjuntos = $this->Req_adjuntosurl_model->ObtenerListaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 
        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Data["Solicitante"] = $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['BitacoraMovimientos'] = $BitacoraMovimientos;
        $Data['title'] = "Consulta mis requisiciones otras oficinas";
        $Data['numero'] = $numero;
        $Data['Tipopdto'] = $Tipopdto;
        $Data['Observaciones'] = $Observaciones;
        $Data['Cabeza'] = $Cabeza;
        $Data["Detalles"] = $Detalles;
        $Data["Adjuntos"] = $Adjuntos;
        $Data["Surtidoreq"] = $this->Req_soo_model->ObtenerListaPorFolio($numero);
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Misreqoo/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function AutocompleteFolio(){
        $term = strtolower($this->input->get("term"));
        $Sorteo = $this->session->Sorteo;
        $result = $this->Req_head_model->SearchByFolio($term);
        echo json_encode($result);
    }

    function GenerarPdf() {
        $this->load->library('Pdf');
        $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('CONTROL DE REQUISICIONES');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "REQUISICION", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 0, 0), $lc = array(0, 0, 0));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage();

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));

        $numero = $this->input->post("FolioRecibo");

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 

        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Solicitantenom= $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Gerenteproynom = $Gerenteproyrec->Name;
        }else{
            $Gerenteproynom = "";
        }

        $Observaciones = count($Cabeza) > 0 ? $Cabeza[0]->observa : "";

        $FechaHoraOriginal = $Cabeza[0]->fecha_ini;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechaelab = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4)." ".$Hora;

        $FechaHoraOriginal = $Cabeza[0]->fecha_compromiso;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechacomp = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));

        //$pdf->SetFontSize(11);
        if($Cabeza[0]->status ==9){
            $pdf->SetFont('Helvetica', 'B', 14, '', true);
            $pdf->Write(5,"C A N C E L A D A", $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        }
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Requisicion: ".$numero." Tipo: ".$Tipopdto."      Almacen destino: ".$Cabeza[0]->almacen, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->SetFont('Helvetica', '', 11, '', true);
        $pdf->Write(5,"Fecha: ". $FormatoFechaelab, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);
        $pdf->SetFontSize(9);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"Cotizacion: ".$Cabeza[0]->cotizacion, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"OC/Pedido cliente: ".$Cabeza[0]->oc_pedidocliente, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Pedido por: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Solicitante: ".$Solicitantenom, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Gerente/Supervisor: ".$Gerenteproynom, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Enviar a: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Nombre: ".$Cabeza[0]->to_nombre, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Proyecto: ".$Cabeza[0]->depto, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"Empresa: ".$Cabeza[0]->to_empresa, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Direccion: ".$Cabeza[0]->to_direcc, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Telefono: ".$Cabeza[0]->to_tel, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Paqueteria sugerida: ".$Cabeza[0]->to_paquete, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Line(10,93,205,93);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
       
        $pdf->SetFontSize(8);
        $header = array('Partida','Articulo','Descripcion','Marca','Cantidad');
        
        $pdf->SetFillColor(77, 77, 255);
        $pdf->SetTextColor(255);
        $pdf->SetDrawColor(0, 0, 0);
        $pdf->SetLineWidth(0.3);
        $pdf->SetFont('', 'B');
       
        $w = array(12, 30, 100, 30, 15);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $pdf->Ln();
        
        $pdf->SetFillColor(224, 235, 255);
        $pdf->SetTextColor(0);
        $pdf->SetFont('');
       
        $fill = 0;
        $TotalArticulos = 0;
        foreach($Detalles as $Item) {
            $pdf->Cell($w[0], 6, $Item->partida, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[1], 6, $Item->articulo, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[2], 6, $Item->descrip, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[3], 6, $Item->marca, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[4], 6, $Item->cantidad, 'LR', 0, 'C', $fill);
            $pdf->Ln();
            $fill=!$fill;
            $TotalArticulos+= $Item->cantidad;
        }
        // Línea de cierre
        $pdf->Cell(array_sum($w),0,'','T');

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES:", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,$Observaciones, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);

        $nombre_archivo = utf8_decode("Requisicion_".$numero.".pdf");
        $pdf->Output($nombre_archivo, 'D');
    }
}