<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Exportaciones extends CI_Controller {
    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");
        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }
    //
    // Exportacion de bitacora
    //
    function ExportarBitacora()
    {
        if(!VerificarPermisos($this->session->UID, "Exportaciones", "ExportarBitacora")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $Oficinaactual = $this->session->Oficina;
        $Oficinas = $this->Oficinas_model->GetList();
        //
        // Se ponen los valores por default para los criterios del reporte
        //

        $ClaveOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->clave;
        $ClaveOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->clave;
        $NombreOficinaPrimero = $this->Oficinas_model->ObtenerPrimero()->nombre;
        $NombreOficinaUltimo = $this->Oficinas_model->ObtenerUltimo()->nombre;

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y");

        $Data['Oficinas'] = $Oficinas;
        $Data['Claveoficinaprimero'] = $ClaveOficinaPrimero;
        $Data['Claveoficinaultimo'] = $ClaveOficinaUltimo;
        $Data['Nombreoficinaprimero'] = $NombreOficinaPrimero;
        $Data['Nombreoficinaultimo'] = $NombreOficinaUltimo;
        $Data['Oficinaactual'] = $Oficinaactual;
        $Data['Usuarioactual'] = $this->session->UID;
        $Data['Fechadefault'] = $TodayDate;
        $Data['title'] = "Exportacion de bitacora";

        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Exportaciones/Exportarbitacora', $Data);
        $this->load->view('layouts/footer');
    }

    function ExcelExportarBitacora()
    {
        if($this->input->post())
        {
            //
            // Tomamos los rangos de las variables del post y obtenemosla informacion de la
            // tabla
            //
            $Parametros = $this->Parametros_model->GetUnique();
                       
            $ClaveOficinaI = $this->input->post("ClaveoficinaI");
            $ClaveOficinaF = $this->input->post("ClaveoficinaF");
            $FechaFtmpI = $this->input->post("FechaInicial");
            $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

            $FechaFtmpF = $this->input->post("FechaFinal");
            $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

            $Movimientos = $this->Req_logs_model->ObtenerListaPorRangoOficinasFechas($ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Bitacora");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Oficina');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Usuario');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Fecha-Hora');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Evento');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Requisicion');
            
            $this->excel->getActiveSheet()->getStyle('A1:E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('100');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('12');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Movimientos as $Item) {
                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->log_ofna, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->log_usuario, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->log_fecha, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->log_evento, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->numero, PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
             
            $filename='Bitacora.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');
        }
    }

    function PdfExportarBitacora() {
        $this->load->library('Pdf');
        $pdf = new Pdf('L', 'mm', 'LETTER', true, 'UTF-8', false);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('KALTIRE');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "KALTIRE", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 64, 0), $lc = array(0, 64, 128));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage('L', 'A4');

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));
        
        $Parametros = $this->Parametros_model->GetUnique();
        
        $Titulo = $this->input->post("Title");
       
        $ClaveOficinaI = $this->input->post("ClaveoficinaI");
        $ClaveOficinaF = $this->input->post("ClaveoficinaF");
        $FechaFtmpI = $this->input->post("FechaInicial");
        $FechaI = substr($FechaFtmpI,6,4)."-".substr($FechaFtmpI,3,2)."-".substr($FechaFtmpI,0,2);

        $FechaFtmpF = $this->input->post("FechaFinal");
        $FechaF = substr($FechaFtmpF,6,4)."-".substr($FechaFtmpF,3,2)."-".substr($FechaFtmpF,0,2)." 23:59:59";

        $Movimientos = $this->Req_logs_model->ObtenerListaPorRangoOficinasFechas($ClaveOficinaI,$ClaveOficinaF,$FechaI,$FechaF);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));
        //
        // Variable que establece el maximo de renglones por hoja de cada reporte
        // modificar de ser necesario dependiendo del tipo y tamaño de letra usado en cada informe
        //
        $MaximoRenglones=21;
        // 
        // esta variable se inicializa con un valor mayor al MaximoRenglones para asegurar la impresion
        // del encabezado de la primer hoja
        //
        $AcumulaRenglones=22;

            foreach($Movimientos as $Item) {
                if ($AcumulaRenglones > $MaximoRenglones){
                    $pdf->SetFontSize(10);
                    $pdf->Write(5,"REPORTE DE BITACORA", $enlace="", $fondo=false, $alineacion="", $nueva_linea=false);
                    $pdf->Write(5,"Fecha: ".$TodayDate, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);  
                    $pdf->SetFontSize(9);
                    $pdf->Write(5,"De la oficina: ".$ClaveOficinaI." a la oficina: ".$ClaveOficinaF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
                    $pdf->Write(5,"De la fecha: ".$FechaFtmpI." A la fecha: ".$FechaFtmpF, $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);

                    $pdf->SetFontSize(8);
                    $header = array('Ofna','Usr','Fecha-Hora','Evento','Req.');
                    
                    $pdf->SetFillColor(77, 77, 255);
                    $pdf->SetTextColor(255);
                    $pdf->SetDrawColor(0, 0, 0);
                    $pdf->SetLineWidth(0.3);
                    $pdf->SetFont('', 'B');
                   
                    $w = array(8, 8, 30, 215, 12);
                    $num_headers = count($header);
                    
                    for($i = 0; $i < $num_headers; ++$i) {
                        $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
                    }

                    $pdf->Ln();
                    
                    $pdf->SetFillColor(224, 235, 255);
                    $pdf->SetTextColor(0);
                    $pdf->SetFont('');
                    $AcumulaRenglones=0;
                }
                $pdf->Cell($w[0], 6, $Item->log_ofna, 0, 0, '', 0);
                $pdf->Cell($w[1], 6, $Item->log_usuario, 0, 0, 'C', 0);
                $pdf->Cell($w[2], 6, $Item->log_fecha, 0, 0, '', 0);
                $pdf->Cell($w[3], 6, substr($Item->log_evento,0,110), 0, 0, '', 0);
                $pdf->Cell($w[4], 6, $Item->numero, 0, 0, 'C', 0);
                $AcumulaRenglones++;
                $pdf->Ln();
            }
            $nombre_archivo = utf8_decode("Bitacora.pdf");
            $pdf->Output($nombre_archivo, 'D');

    }

    //
    // Respaldo de la base de datos
    //
    function Respaldo()
    {
        if(!VerificarPermisos($this->session->UID, "Exportaciones", "ExportarBitacora")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        //$TodayDate = unix_to_human(time(), TRUE, 'us');
        // $TodayDate = date("d/m/Y");
        $TodayDate = time();
        $anio = date("Y", $TodayDate);
        $mes = date("m", $TodayDate);
        $dia = date("d", $TodayDate);
        $Nombredefault = "Respaldo_Requi_".$anio.$mes.$dia;

        $Data['title'] = "Respaldo de la base de datos";
        $Data['Nombredefault'] = $Nombredefault;

        $this->load->view('layouts/_menu');
        $this->load->view('Exportaciones/Respaldo', $Data);
        $this->load->view('layouts/footer');
    }

    function RespaldoPost()
    {
        if(!VerificarPermisos($this->session->UID, "Exportaciones", "ExportarBitacora")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        if($this->input->post())
        {
            $Archivo = $this->input->post("NombreArchivo");
            $Archivo = trim($Archivo).'.sql.gz';

            //************ RUTINA USANDO UN  MODELO DE CI
            // $this->load->model('databasebackup_model');
            // $backup = $this->databasebackup_model->backup();
            // write_file($Archivo, $backup);
            // $this->load->helper('download');
            // force_download($Archivo, $backup);            


            //************ RUTINA USANDO LA FUNCION DBUTIL DE CI

            $this->load->dbutil();
            $backup = $this->dbutil->backup();
            $this->load->helper('file');
            write_file($Archivo, $backup);
            $this->load->helper('download');
            force_download($Archivo, $backup);            

            //************ RUTINA USANDO MYSQLDUMP
            //Introduzca aquí la información de su base de datos en servidor y el nombre del archivo de copia de seguridad.
            // $mysqlDatabaseName ='requis_kaltirecom849043';
            // $mysqlUserName ='kaltirecom849043';
            // $mysqlPassword ='BdKt.2020';
            // $mysqlHostName ='sql5c75c.carrierzone.com';
            // $mysqlExportPath =$Archivo;

            // Introduzca aquí la información local de su base de datos y el nombre del archivo de copia de seguridad.
            // $mysqlDatabaseName ='aqex4240_kaltire_com_mx';
            // $mysqlUserName ='root';
            // $mysqlPassword ='';
            // $mysqlHostName ='localhost';
            // $mysqlExportPath =$Archivo;

            // Por favor, no haga ningún cambio en los siguientes puntos
            // Exportación de la base de datos y salida del status
            // $command='mysqldump -h ' .$mysqlHostName .' -u ' .$mysqlUserName .' -p' .$mysqlPassword .' ' .$mysqlDatabaseName .' > ' .$mysqlExportPath;
            // $command='\xampp\mysql\bin\mysqldump --opt -h' .$mysqlHostName .' -u' .$mysqlUserName .' '.$mysqlDatabaseName .' > ' .$mysqlExportPath;
            // exec($command,$output,$worked);
            // if($worked == 0){
                //Descargar y eliminar el archivo .sql
            // }

            // switch($worked){
            //     case 0:
            //         echo 'La base de datos <b>' .$mysqlDatabaseName .'</b> se ha almacenado correctamente en la siguiente ruta '.getcwd().'/' .$mysqlExportPath .'</b>';
            //         break;
            //     case 1:
            //         echo 'Se ha producido un error al exportar <b>' .$mysqlDatabaseName .'</b> a '.getcwd().'/' .$mysqlExportPath .'</b>';
            //         break;
            //     case 2:
            //         echo 'Se ha producido un error de exportación, compruebe la siguiente información: <br/><br/><table><tr><td>Nombre de la base de datos MySQL:</td><td><b>' .$mysqlDatabaseName .'</b></td></tr><tr><td>Nombre de usuario MySQL:</td><td><b>' .$mysqlUserName .'</b></td></tr><tr><td>Contraseña MySQL:</td><td><b>NOTSHOWN</b></td></tr><tr><td>Nombre de host MySQL:</td><td><b>' .$mysqlHostName .'</b></td></tr></table>';
            //         break;
            // }
            
        }
    }

}