<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Comprasoo extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index($Startpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "Comprasoo", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($Startpage != null && $Startpage > 0){
            $Page = $Startpage;
        }else{
            $Page = 1;
        }
        $Folio = "";
        if($this->input->post()){
            $Folio = $this->input->post('Folio');
            $Page = $this->input->post("Page");
        }
        set_value("Folio");
        $Pages = $this->Req_head_model->GetPagesComoo($Page, $Folio, $this->session->Oficina);
        if( $Pages <= 1){
            $Page = 1;
        }

        $CabezaRequisiciones = $this->Req_head_model->GetAllComoo($Page, $Folio, $this->session->Oficina);
        $Nuevascomoo = $this->Req_head_model->GetNewComoo($this->session->Oficina);
        $Data['title'] = "Compras otras oficinas";
        $Data['CabezaRequisiciones'] = $CabezaRequisiciones;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $Data['Nuevas'] = $Nuevascomoo;        
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Comprasoo/Index', $Data);
        $this->load->view('layouts/footer');
    }
    
    function Details($numero = null, $actualpage = null)
    {
        if(!VerificarPermisos($this->session->UID, "Comprasoo", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        $BitacoraMovimientos = $this->Req_logs_model->ObtenerListaPorFolio($numero);

        foreach($BitacoraMovimientos as $Bitacora)
        {
            $Bitacora->Usuario = $this->Users_model->GetByUserName($Bitacora->log_usuario);
        }

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolioParacomprasoo($numero,$this->session->Oficina);
        $UIDcomprador= $this->Req_order_model->ObtenerCompradorPorFolio($numero);
        if($UIDcomprador !=""){
            $Nombrecomprador= $this->Users_model->GetName($UIDcomprador);
        }else{
            $Nombrecomprador= "";
        }
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 
        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Data["Solicitante"] = $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['BitacoraMovimientos'] = $BitacoraMovimientos;
        $Data['title'] = "Consulta por compras";
        $Data['numero'] = $numero;
        $Data['actualpage'] = $actualpage;
        $Data['Tipopdto'] = $Tipopdto;
        $Data['Observaciones'] = $Observaciones;
        $Data['Cabeza'] = $Cabeza;
        $Data["Detalles"] = $Detalles;
        $Data["UIDcomprador"] = $UIDcomprador;
        $Data["Nombrecomprador"] = $Nombrecomprador;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Comprasoo/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit()
    {
        if(!VerificarPermisos($this->session->UID, "Comprasoo", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }

        $numero = $this->input->post("EditarFolio");
        $actualpage = $this->input->post("ActualPage");
        $LoggedUserId = $this->session->UID;

        // Bloqueamos la requisicion
        $CabezaRequisiciones = array(
            "numero" => $numero,
            "usuarioblq" => $LoggedUserId
        );

        $result = $this->Req_head_model->Update($CabezaRequisiciones);

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy);
                
        $Almacenes = $this->Almacenes_model->GetList();
        $Clientes = $this->Clientes_model->GetList();
        $Proyectos = $this->Proyectos_model->GetList();

        if($Gerenteproyrec){
            $Data["Gerenteproy"] = $Gerenteproyrec->Name;
        }else{
            $Data["Gerenteproy"] = "";
        }
        $Data['Almacenes'] = $Almacenes;
        $Data['Clientes'] = $Clientes;
        $Data['Proyectos'] = $Proyectos;

        $Data["Solicitante"] = $Solicitanterec->Name;
        $Data["Emailsol"] = $Solicitanterec->email;
        $Data["Almacen"] = $Almacenrec->nombre;
        $Data['title'] = "Compras otras oficinas";
        $Data['numero'] = $numero;
        $Data['actualpage'] = $actualpage;
        $Data["Cabeza"] = $Cabeza;
        $Data["Detalles"] = $this->Req_deta_model->ObtenerListaPorFolioParacomprasoo($numero,$this->session->Oficina);
        $Data["UIDcomprador"] = $this->Req_order_model->ObtenerCompradorPorFolio($numero);
        $Data["Compradores"] = $this->Users_model->ObtenerListaCompradores($this->session->Oficina);
        $Data['Enurl'] = base_url();
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Comprasoo/Edit', $Data);
        //$this->load->view('layouts/footer');
    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Comprasoo", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Folio = $this->input->post("hdNumero");
            $ActualPage = $this->input->post("hdActualPage");
            if(!VerificarBloqueoUsuarioFolio($this->session->UID, $Folio )){
                $this->session->set_flashdata('logged-message', 'Error: no se pudo guardar debido a que otro usuario tiene bloqueada la requisicion.');
                redirect("");
            }

            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Fechainicompras= $this->input->post("Fechacom");

            $Detalle = $this->input->post("lstDetalle");
            $Observaciones = strtoupper($this->input->post("Observaciones"));

            //
            // Tomamos los correos de los responsables de almacen de la oficina que solicito el apoyo
            //
            $Oficinaoriginal = $this->input->post("Claveoficina");
            $Emailalmaorig = $this->Users_model->ObtenerMailsAlmacenPorOficina($Oficinaoriginal);
            if($Emailalmaorig)
            {
                $Cadenaalmapy = "";
                foreach($Emailalmaorig as $Almacenista)
                {
                    $Cadenaalmapy = $Cadenaalmapy.trim(strtolower($Almacenista->email)).",";
                }
                $Emailalmapy = substr($Cadenaalmapy,0,-1);
            }else{
                $Emailalmapy = "cotaemilio@hotmail.com";
            }

            //
            // Tomamos los correos de los responsables de almacen de la oficina actual
            //            
            $Claveoficina = $this->session->Oficina;
            $Oficinaactual = $this->session->Oficina;
            $Datosoficina = $this->Oficinas_model->GetByClave($Oficinaactual);
            $Emailalmacenistas = $this->Users_model->ObtenerMailsAlmacenPorOficina($Oficinaactual);
            if($Emailalmacenistas)
            {
                $Cadenaalm = "";
                foreach($Emailalmacenistas as $Almacenista)
                {
                    $Cadenaalm = $Cadenaalm.trim(strtolower($Almacenista->email)).",";
                }
                $Emailalm = substr($Cadenaalm,0,-1);
            }else{
                $Emailalm = "cotaemilio@hotmail.com";
            }
            //
            // Valor de los checkbox para saber que correos enviar
            //
            $Mailconfirma = $this->input->post("chkConfir");
            $Mailaviso = $this->input->post("chkAviso");

            $TotalMovimientosAgregados = 0;

            //modificar el req_head solo si es la primer vez que lo toma almacen

            if($Fechainicompras == "00/00/0000 00:00:00")
            {
                $CabezaComprasoo = array(
                    "numero" => $Folio,
                    "fecha_sr3" => $TodayDate,
                    "usuarioblq" => "",
                    "Updatedby" => $LoggedUserId,
                    "Updateddate" => $TodayDate
                );

                $result = $this->Req_head_model->Update($CabezaComprasoo);
            }
            //
            // Eliminamos los registros anteriores del req_order
            //
            $delresult = $this->Req_order_model->BorrarPorFolio($Folio);

            // actualizamos los registros del detalle
            $TotalMovimientosCompras = 0;
            $Detallesorders = "";
            foreach($Detalle as $Item)
            {
                if($Item["Active"] == "true" || $Item["Active"] == 1)
                {    
                    //Convertimos las fechas al formato de mysql validando que no esten vacias
                    if($Item["Fechapp"] != "" && $Item["Fechapp"] != "//"){
                        $Fechaorig= $Item["Fechapp"];
                    }else{
                        $Fechaorig= "01/01/1753";
                    }
                    $FechaExplode = explode("/", $Fechaorig);
                    $Fechapp = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);

                    if($Item["Fechaetaprov"] != "" && $Item["Fechaetaprov"] != "//"){
                        $Fechaorig= $Item["Fechaetaprov"];
                    }else{
                        $Fechaorig= "01/01/1753";
                    }

                    if($Item["Fechaetaprov"] != "" && $Item["Fechaetaprov"] != "//" && $Item["Fechaetaprov"] != "00/00/0000"){
                        $Fechaorig= $Item["Fechaetaprov"];
                        $Fechaetaprovmail= $Item["Fechaetaprov"];
                    }else{
                        $Fechaorig= "01/01/1753";
                        $Fechaetaprovmail= "";
                    }

                    $FechaExplode = explode("/", $Fechaorig);
                    $Fechaetaprov = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);

                    if($Item["Fechaetareal"] != "" && $Item["Fechaetareal"] != "//"){
                        $Fechaorig= $Item["Fechaetareal"];
                    }else{
                        $Fechaorig= "01/01/1753";
                    }
                    $FechaExplode = explode("/", $Fechaorig);
                    $Fechaetareal = new DateTime($FechaExplode[2]."-".$FechaExplode[1]."-".$FechaExplode[0]);
                    //
                    // Tomamos los datos del comprador asignado a la partida
                    //
                    $Clavecomprador = $Item["Compradet"];
                    $Nombrecomprador = $this->Users_model->GetName($Clavecomprador);

                    $articuloeq = $Item["Clave_eq"];
                    if (is_null($articuloeq))
                    {
                        $articuloeq = "";
                    }

                    //Armamos el arreglo con el registro del req_order
                        $DetalleComprasoo = array(
                            "numero" => $Folio,
                            "partida" => $Item["Partida"],
                            "articulo" => $Item["Clavearticulo"],
                            "articulo_eq" => $articuloeq,
                            "pend_orig" => $Item["Pedido"],
                            "pedido" => 0,
                            "tip_solic" => $Item["Tipsolic"],
                            "usuario" => $Clavecomprador,
                            "comprador" => $Nombrecomprador,
                            "proveedor" => strtoupper($Item["Proveedor"]),
                            "fecha_pp" => $Fechapp->format("Y-m-d"),
                            "orden" => strtoupper($Item["Orden"]),
                            "status1" => $Item["Estatus"],
                            "eta_prov" => $Fechaetaprov->format("Y-m-d"),
                            "eta_real" => $Fechaetareal->format("Y-m-d"),
                            "fecha_srv" => $TodayDate,
                            "observa" => strtoupper($Item["Observa"])
                        );

                    $TotalMovimientosCompras++;
                    $result = $this->Req_order_model->Create($DetalleComprasoo);
                    //$Detallesorders =  $Detallesorders."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Pedido"]. "</td> <td style='text-align: center;'>" .$Item["Estatus"]. "</td>  <td style='text-align: center;'>" .$Fechaetaprovmail. "</td> </tr>";
                    $Detallesorders =  $Detallesorders."<tr> <td style='text-align: center;'>" .$Item["Partida"]. "</td> <td style='text-align: center;'>" .$Item["Clavearticulo"]. "</td> <td style='text-align: center;'>" .$Item["Clave_eq"]. "</td> <td style='text-align: center;'>" .$Item["Descripcion"]. "</td> <td style='text-align: center;'>" .$Item["Pedido"]. "</td> <td style='text-align: center;'>" .$Item["Estatus"]. "</td>  <td style='text-align: center;'>" .$Fechaetaprovmail. "</td> </tr>";

                //Actualizamos la fecha eta en el req_deta
                    $DetalleSeguimientoalm = array(
                    "numero" => $Folio,
                    "partida" => $Item["Partida"],
                    "fecha_est" => $Fechaetaprov->format("Y-m-d")
                    );

                    $result = $this->Req_deta_model->Update($DetalleSeguimientoalm);

                }
            }
            // Desbloqueamos la requi
            $CabezaSeguimiento = array(
                "numero" => $Folio,
                "usuarioblq" => ""
            );
            $result = $this->Req_head_model->Update($CabezaSeguimiento);

            //Agregar movimiento a bitacora
            $BitacoraMovimiento = array(
                "log_ofna" => $Claveoficina,
                "log_usuario" => $LoggedUserId,
                "log_fecha" => $TodayDate,
                "log_evento" => "COMPRAS PROCESO LA REQUISICION (OTRAS OFICINAS) ".$Folio." CON ".$TotalMovimientosCompras." PARTIDAS",
                "numero" => $Folio,
            );
            $result = $this->Req_logs_model->Create($BitacoraMovimiento);
            
            // ENVIAR CORREO ELECTRONICO CON EL AVISO DE ESTATUS SI MARCARON LA CASILLA
            if($Mailaviso == "1"){
                // Se arma el cuerpo del correo (mensaje) en 3 variables usando un modelo de tabla html
                $cabeza = '
                   <html>
                   <head>
                     <title>Aviso de estatus</title>
                   </head>
                   <body>
                     <p> El area de compras de la oficina: <b>'.$Datosoficina->nombre.'</b></p>
                     <p> Le informa el estatus  de la requisicion: <b>'.$Folio.' en apoyo a su oficina</b></p>
                     <table>
                       <tr>
                         <th> Partida </th> <th> Articulo </th> <th> Articulo_eq </th> <th> Descripcion </th> <th> Cantidad </th>  <th> Estatus </th> <th> Fecha ETA </th>
                       </tr>';

                // El detalle de los items se formo en la rutina de grabacion de los registros en la variable $Detallesorders
                           
                $pie = '
                     </table>
                     <p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                   </body>
                   </html>
                   ';

                // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                // Solicitamos que en caso de errores estos se muestren en pantalla
                // ini_set( 'display_errors', 1 );
                // error_reporting( E_ALL );
                ini_set( 'display_errors', 0 );
                error_reporting( 0 );
                // Definimos la cuenta que aparecera como remitente
                $from = "adminrequi@kaltire.com";
                // Cuenta de correo del destintario
                $to = $Emailalmapy;
                //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                if (!empty($to)){
                    // Asunto del correo
                    $subject = "Requisicion: ".$Folio." estatus de compras en apoyo";
                    // Se concatenan las 3 variables  del mensaje
                    $message = $cabeza.$Detallesorders.$pie;
                    // Se concatenan las cabeceras con el from
                    $headers = $cabeceras;
                    // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                    @mail($to,$subject,$message, $headers);
                }
            }

            // ENVIAR CORREO ELECTRONICO CON LA CONFIRMACION AL ALMACEN SI MARCARON LA CASILLA
            if($Mailconfirma == "1"){
                // Se arma el cuerpo del correo (mensaje)
                $cabeza = '
                   <html>
                   <head>
                     <title>Confirmacion de recibido</title>
                   </head>
                   <body>
                     <p> El area de compras de la oficina: <b>'.$Datosoficina->nombre.'</b></p>
                     <p> Confirma de recibida la requisicion no.: <b>'.$Folio.' en apoyo</b></p>
                     <p> Se inicia el proceso de compras. </p>';

                $pie = '<p> Para mas informacion consulte la requisicion <a href="'.base_url().'"> Aqui </a> </p>
                   </body>
                   </html>
                   ';

                // Para enviar un correo HTML, debe establecerse la cabecera Content-type
                $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
                $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                // Solicitamos que en caso de errores estos se muestren en pantalla
                // ini_set( 'display_errors', 1 );
                // error_reporting( E_ALL );
                ini_set( 'display_errors', 0 );
                error_reporting( 0 );
                // Definimos la cuenta que aparecera como remitente
                $from = "adminrequi@kaltire.com";
                // Cuenta de correo del destintario
                $to = $Emailalm;
                //$to = "cotaemilio@hotmail.com, cotaemilio70@gmail.com";
                // Asunto del correo
                if (!empty($to)){
                    $subject = "Requisicion: ".$Folio." recibida por compras en apoyo";
                    // Se concatenan las 3 variables  del mensaje
                    $message = $cabeza.$pie;
                    // Se concatenan las cabeceras con el from
                    $headers = $cabeceras;
                    // Se envia el correo con la funcion mail de php y se le pasan las variables como parametro
                    @mail($to,$subject,$message, $headers);
                }
            }

            $this->session->set_flashdata('Folio', $Folio);
            $this->session->set_flashdata('message_index', 'Se guardo exitosamente la requisicion con el folio: '.$Folio);
            $this->session->set_flashdata('class', 'success');
            redirect("Comprasoo/Index/".$ActualPage);
        }
    }

    function Cancel()
    {
        if($this->input->post()){
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Folio = $this->input->post("Folio");
            $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($Folio);
            //
            // Cancelar el head de la requisicion
            //
            foreach($Cabeza as $ItemC)
            {
                $CancelarCabeza = array(
                    "numero" => $ItemC->numero,
                    "status" => 9,
                    "Active" => false,
                    "DeletedBy" => $LoggedUserId,
                    "DeletedDate" => $TodayDate
                );

                $result = $this->Req_head_model->Update($CancelarCabeza);
            }

            //
            // Cancelar el detail de la requisicion
            //
            $Detalles = $this->Req_deta_model->ObtenerListaPorFolioParaCancelar($Folio);              
            foreach($Detalles as $Item)
            {
                $CancelarDetalles = array(
                    "numero" => $Item->numero,
                    "partida" => $Item->partida,
                    "cantidad" => 0,
                    "cancelada" => 1,
                    "observa" => "CANCELADA"
                );

                $result = $this->Req_deta_model->Update($CancelarDetalles);
            }

            //
            // Cancelar los registros del req_order de la requisicion
            //
/*            $Detalles = $this->Req_order_model->ObtenerListaPorFolioParaCancelar($Folio);              
            foreach($Detalles as $Item)
            {
                $CancelarDetalles = array(
                    "numero" => $Item->numero,
                    "partida" => $Item->partida,
                    "pend_orig" => 0,
                    "status1" => "CANCELADO"
                );

                $result = $this->Req_order_model->Update($CancelarDetalles);
            }*/

            //Agregar movimiento a bitacora
            $AutorizadoPor = $this->input->post("AutorizadoPor");
            $UsuarioAutorizacion = $this->Users_model->GetByUserName($AutorizadoPor);
            $BitacoraMovimiento = array(
                "log_ofna" => $Claveoficina,
                "log_usuario" => $LoggedUserId,
                "log_fecha" => $TodayDate,
                "log_evento" => "SE CANCELO LA REQUISICION ".$Folio." AUTORIZADO POR ".$AutorizadoPor."-".$UsuarioAutorizacion->Name,
                "numero" => $Folio,
            );
            $result = $this->Req_logs_model->Create($BitacoraMovimiento);

            $this->session->set_flashdata('message_index', 'Se cancelo exitosamente la requisicion con folio '.$Folio.' .');
            $this->session->set_flashdata('class', 'success');
            redirect("Comprasoo/");
        }
    }

    function AutocompleteFolio(){
        $term = strtolower($this->input->get("term"));
        $Sorteo = $this->session->Sorteo;
        $result = $this->Req_head_model->SearchByFolio($term);
        echo json_encode($result);
    }

    function GenerarPdf() {
        $this->load->library('Pdf');
        $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->setData($this->session->Empresa, $this->session->Rfc);
        $pdf->SetCreator('');
        $pdf->SetAuthor('KALTIRE');
        $pdf->SetTitle('KALTIRE');
        $pdf->SetSubject('CONTROL DE REQUISICIONES');
        $pdf->SetKeywords('');
 
        $pdf->SetHeaderData("logo1.png", 15, "KALTIRE", "REQUISICION", array(0,0,0), array(0,0,0));
        $pdf->setFooterData($tc = array(0, 0, 0), $lc = array(0, 0, 0));

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
 
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
 
 
        $pdf->setFontSubsetting(true);
 
        $pdf->SetFont('Helvetica', '', 14, '', true);
 
        $pdf->AddPage();

        $pdf->setTextShadow(array('enabled' => true, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));

        $numero = $this->input->post("FolioRecibo");

        $Cabeza = $this->Req_head_model->ObtenerCabezaPorFolio($numero);
        $Detalles = $this->Req_deta_model->ObtenerListaPorFolioAutorizadasNocanceladas($numero);
        
        $Solicitanterec = $this->Users_model->GetByUserName($Cabeza[0]->usuario); 
        $Almacenrec = $this->Almacenes_model->GetByClave($Cabeza[0]->almacen);
        $Gerenteproyrec = $this->Users_model->GetByUserName($Cabeza[0]->gerente_proy); 

        $Observaciones = $Cabeza[0]->observa; 

        if($Cabeza[0]->tipo == 0){
            $Tipopdto = "LLANTAS";
        }else{
            $Tipopdto = "VARIOS";
        }

        $Solicitantenom= $Solicitanterec->Name;
        if($Gerenteproyrec){
            $Gerenteproynom = $Gerenteproyrec->Name;
        }else{
            $Gerenteproynom = "";
        }

        $Observaciones = count($Cabeza) > 0 ? $Cabeza[0]->observa : "";

        $FechaHoraOriginal = $Cabeza[0]->fecha_ini;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechaelab = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4)." ".$Hora;

        $FechaHoraOriginal = $Cabeza[0]->fecha_compromiso;
        $Hora = substr($FechaHoraOriginal,11,8);
        $FormatoFechacomp = substr($FechaHoraOriginal,8,2)."/".substr($FechaHoraOriginal,5,2)."/".substr($FechaHoraOriginal,0,4);

        $TodayDate = unix_to_human(time(), TRUE, 'us');
        $TodayDate = date("d/m/Y H:i:s A", strtotime($TodayDate));

        //$pdf->SetFontSize(11);
        if($Cabeza[0]->status ==9){
            $pdf->SetFont('Helvetica', 'B', 14, '', true);
            $pdf->Write(5,"C A N C E L A D A", $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        }
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Requisicion: ".$numero." Tipo: ".$Tipopdto."      Almacen destino: ".$Cabeza[0]->almacen, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->SetFont('Helvetica', '', 11, '', true);
        $pdf->Write(5,"Fecha: ". $FormatoFechaelab, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);
        $pdf->SetFontSize(9);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->Write(5,"Fecha compromiso: ".$FormatoFechacomp."            Cotizacion: ".$Cabeza[0]->cotizacion, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"OC/Pedido cliente: ".$Cabeza[0]->oc_pedidocliente, $enlace="", $fondo=false, $alineacion="R", $nueva_linea=true);
        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Pedido por: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Solicitante: ".$Solicitantenom, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Gerente/Supervisor: ".$Cabeza[0]->gerente, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
        $pdf->SetFont('Helvetica', 'B', 11, '', true);
        $pdf->Write(5,"Enviar a: ", $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->SetFont('Helvetica', '', 9, '', true);
        $pdf->Write(5,"Nombre: ".$Cabeza[0]->to_nombre, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=false);
        $pdf->Write(5,"Proyecto: ".$Cabeza[0]->depto, $enlace="", $fondo=false, $alineacion="C", $nueva_linea=true);
        $pdf->Write(5,"Empresa: ".$Cabeza[0]->to_empresa, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Direccion: ".substr($Cabeza[0]->to_direcc,0,90), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Telefono: ".$Cabeza[0]->to_tel, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"Paqueteria sugerida: ".$Cabeza[0]->to_paquete, $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        $pdf->Write(5,"OBSERVACIONES: ".substr($Cabeza[0]->observa,0,255), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);
        //$pdf->Write(5,substr($Cabeza[0]->observa,81,100), $enlace="", $fondo=false, $alineacion="L", $nueva_linea=true);

        $pdf->Write(5,"", $enlace="", $fondo=false, $alineacion="", $nueva_linea=true);
       
        $pdf->SetFontSize(8);
        //$header = array('Partida','Articulo','Descripcion','Marca','Cantidad');
        $header = array('Prt','Articulo','Articulo eq.','Descripcion','Marca','Cant.');
        
        $pdf->SetFillColor(77, 77, 255);
        $pdf->SetTextColor(255);
        $pdf->SetDrawColor(0, 0, 0);
        $pdf->SetLineWidth(0.3);
        $pdf->SetFont('', 'B');
       
        $w = array(8, 29, 31, 85, 20, 14);
        $num_headers = count($header);
        for($i = 0; $i < $num_headers; ++$i) {
            $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
        }
        $pdf->Ln();
        
        $pdf->SetFillColor(224, 235, 255);
        $pdf->SetTextColor(0);
        $pdf->SetFont('');
       
        $fill = 0;
        $TotalArticulos = 0;
        foreach($Detalles as $Item) {
            $pdf->Cell($w[0], 6, $Item->partida, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[1], 6, $Item->articulo, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[2], 6, $Item->articulo_eq, 'LR', 0, 'C', $fill);
            $pdf->Cell($w[3], 6, substr($Item->descrip,0,45), 'LR', 0, 'L', $fill);
            $pdf->Cell($w[4], 6, $Item->marca, 'LR', 0, 'L', $fill);
            $pdf->Cell($w[5], 6, $Item->cantidad, 'LR', 0, 'C', $fill);
            $pdf->Ln();
            $fill=!$fill;
            $TotalArticulos+= $Item->cantidad;
        }
        // Línea de cierre
        $pdf->Cell(array_sum($w),0,'','T');

        $nombre_archivo = utf8_decode("Requisicion_".$numero.".pdf");
        $pdf->Output($nombre_archivo, 'D');
    }
}