<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clientes extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index()
    {
        if(!VerificarPermisos($this->session->UID, "Clientes", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Page = 1;
        $Clave = "";
        $Nombre = "";
        if($this->input->post()){
            $Clave = $this->input->post('Clave');
            $Nombre = $this->input->post('Nombre');
            $Page = $this->input->post("Page");
        }
        set_value("Clave", "Nombre");
        $Pages = $this->Clientes_model->GetPages($Page, $Clave, $Nombre);
        if( $Pages <= 1){
            $Page = 1;
        }
        $Clientes = $this->Clientes_model->GetAll($Page, $Clave, $Nombre);
        $Data['title'] = "Clientes";
        $Data['Clientes'] = $Clientes;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Clientes/Index', $Data);
        $this->load->view('layouts/footer');
    }

    function Create(){
        if(!VerificarPermisos($this->session->UID, "Clientes", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Data['title'] = "Crear nuevo cliente";
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Clientes/Create', $Data);
        $this->load->view('layouts/footer');
    }

    function CreatePost(){
        if(!VerificarPermisos($this->session->UID, "Clientes", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Exists = $this->Clientes_model->CheckIfExists($this->input->post("Clave"));
            if($Exists){
                $this->session->set_flashdata('message_create', 'Ya existe un cliente con la misma clave');
                $this->session->set_flashdata('class', 'danger');
            }else{
                $TodayDate = unix_to_human(time(), TRUE, 'mx');
                $LoggedUserId = $this->session->UID;
                $NewCliente = array(
                    "Clave" => $this->input->post("Clave"),
                    "Nombre" => $this->input->post("Nombre"),
                    "Active" => 1,
                    "CreatedBy" => $LoggedUserId,
                    "CreatedDate" => $TodayDate,
                    "UpdatedBy" => $LoggedUserId,
                    "UpdatedDate" => $TodayDate
                );
                $result = $this->Clientes_model->Create($NewCliente);
                if($result){
                    $this->session->set_flashdata('message_index', 'Se guardo exitosamente el registro');
                    $this->session->set_flashdata('class', 'success');
                    redirect("Clientes");
                }else{
                    $this->session->set_flashdata('message_create', 'Hubo un error al registrar');
                    $this->session->set_flashdata('class', 'danger');
                }
            }
            $Data['title'] = "Crear nuevo cliente";
            set_value("Clave", "Nombre");
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Clientes/Create', $Data);
            $this->load->view('layouts/footer');
        }
    }

    function Details($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Clientes", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Cliente = $this->Clientes_model->GetByClave($Id);
        if(!$Cliente){
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }

        $Data["Createdby"] = $this->Users_model->GetByUserName($Cliente->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Cliente->UpdatedBy)->Name;
        $Data['title'] = "Detalles de clientes";
        $Data['Cliente'] = $Cliente;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Clientes/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Clientes", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Cliente = $this->Clientes_model->GetByClave($Id);

        if(!$Cliente)
        {
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }
        $Data["Createdby"] = $this->Users_model->GetByUserName($Cliente->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Cliente->UpdatedBy)->Name;
        $Data['title'] = "Editar cliente";
        $Data['Cliente'] = $Cliente;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Clientes/Edit', $Data);
        $this->load->view('layouts/footer');

    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Clientes", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $OriginalCliente = $this->Clientes_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $EditCliente = array(
                "Clave" => $this->input->post("Clave"),
                "Nombre" => $this->input->post("Nombre"),
                "Updatedby" => $LoggedUserId,
                "Updateddate" => $TodayDate
            );
          
            $result = $this->Clientes_model->Update($EditCliente);
            if($result){
                $this->session->set_flashdata('message_index', 'Se modifico exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Clientes");
            }else{
                $this->session->set_flashdata('message_edit', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
        }
        $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalCliente->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalCliente->UpdatedBy)->Name;
        $Data['title'] = "Editar cliente";
        $Data['Cliente'] = $OriginalCliente;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Clientes/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function Delete(){
        if(!VerificarPermisos($this->session->UID, "Clientes", "Delete")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post())
        {
            $OriginalCliente = $this->Clientes_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $DeleteCliente = array(
                "Clave" => $this->input->post("Clave"),
                "Active" => false,
                "DeletedBy" => $LoggedUserId,
                "DeletedDate" => $TodayDate
            );
          
            $result = $this->Clientes_model->Update($DeleteCliente);
            if($result){
                $this->session->set_flashdata('message_index', 'Se elimino exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Clientes");
            }else{
                $this->session->set_flashdata('message_details', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
            $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalCliente->CreatedBy)->Name;
            $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalCliente->UpdatedBy)->Name;
            $Data['title'] = "Detalles del cliente";
            $Data['Cliente'] = $OriginalCliente;
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Clientes/Details', $Data);
            $this->load->view('layouts/footer');   
        }
    }

    function AutocompleteClave(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Clientes_model->SearchByClave($term);
        echo json_encode($result);
    }

    function AutocompleteNombre(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Clientes_model->SearchByNombre($term);
        echo json_encode($result);
    }

    function GetByClave(){
        $ClaveCliente = $this->input->get("ClaveCliente");
        $result = $this->Clientes_model->GetByClave($ClaveCliente);
        if($result && !$result->Active)
        {
            $result = null;
        }
        echo json_encode($result);
    }

    function Exportxls()
    {
            //
            // Tomamos los registros de la tabla
            // 
            
            $Registros = $this->Clientes_model->GetAllToExport();

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Clientes");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Clave');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Creado por');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Fecha creacion');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Modificado por');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Fecha modif.');
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('30');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('20');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Registros as $Item) {

                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->clave, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->nombre, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->CreatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->CreatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->UpdatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->UpdatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
             
            $filename='CatalogoClientes.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');

            // $this->session->set_flashdata('message_index', 'Se exportó exitosamente el catalago en el archivo: '.$filename,);
            // $this->session->set_flashdata('class', 'success');
            redirect("Clientes");
    }

}
