<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Categorias extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index()
    {
        if(!VerificarPermisos($this->session->UID, "Categorias", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Page = 1;
        $Clave = "";
        $Nombre = "";
        if($this->input->post()){
            $Clave = $this->input->post('Clave');
            $Nombre = $this->input->post('Nombre');
            $Page = $this->input->post("Page");
        }
        set_value("Clave", "Nombre");
        $Pages = $this->Categorias_model->GetPages($Page, $Clave, $Nombre);
        if( $Pages <= 1){
            $Page = 1;
        }
        $Categorias = $this->Categorias_model->GetAll($Page, $Clave, $Nombre);
        $Data['title'] = "Categorias";
        $Data['Categorias'] = $Categorias;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Categorias/Index', $Data);
        $this->load->view('layouts/footer');
    }

    function Create(){
        if(!VerificarPermisos($this->session->UID, "Categorias", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Data['title'] = "Crear nueva categoria";
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Categorias/Create', $Data);
        $this->load->view('layouts/footer');
    }

    function CreatePost(){
        if(!VerificarPermisos($this->session->UID, "Categorias", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Exists = $this->Categorias_model->CheckIfExists($this->input->post("Clave"));
            if($Exists){
                $this->session->set_flashdata('message_create', 'Ya existe una categoria con la misma clave');
                $this->session->set_flashdata('class', 'danger');
            }else{
                $TodayDate = unix_to_human(time(), TRUE, 'mx');
                $LoggedUserId = $this->session->UID;
                $NewCategoria = array(
                    "Clave" => $this->input->post("Clave"),
                    "Nombre" => $this->input->post("Nombre"),
                    "Tipo" => $this->input->post("Tipo"),
                    "Active" => 1,
                    "CreatedBy" => $LoggedUserId,
                    "CreatedDate" => $TodayDate,
                    "UpdatedBy" => $LoggedUserId,
                    "UpdatedDate" => $TodayDate
                );
                $result = $this->Categorias_model->Create($NewCategoria);
                if($result){
                    $this->session->set_flashdata('message_index', 'Se guardo exitosamente el registro');
                    $this->session->set_flashdata('class', 'success');
                    redirect("Categorias");
                }else{
                    $this->session->set_flashdata('message_create', 'Hubo un error al registrar');
                    $this->session->set_flashdata('class', 'danger');
                }
            }
            $Data['title'] = "Crear nueva categoria";
            set_value("Clave", "Nombre");
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Categorias/Create', $Data);
            $this->load->view('layouts/footer');
        }
    }

    function Details($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Categorias", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Categoria = $this->Categorias_model->GetByClave($Id);
        if(!$Categoria){
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }

        $Data["Createdby"] = $this->Users_model->GetByUserName($Categoria->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Categoria->UpdatedBy)->Name;
        $Data['title'] = "Detalles de categorias";
        $Data['Categoria'] = $Categoria;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Categorias/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Categorias", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Categoria = $this->Categorias_model->GetByClave($Id);

        if(!$Categoria)
        {
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }
        $Data["Createdby"] = $this->Users_model->GetByUserName($Categoria->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Categoria->UpdatedBy)->Name;
        $Data['title'] = "Editar categoria";
        $Data['Categoria'] = $Categoria;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Categorias/Edit', $Data);
        $this->load->view('layouts/footer');

    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Categorias", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $OriginalCategoria = $this->Categorias_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $EditCategoria = array(
                "Clave" => $this->input->post("Clave"),
                "Nombre" => $this->input->post("Nombre"),
                "Tipo" => $this->input->post("Tipo"),
                "Updatedby" => $LoggedUserId,
                "Updateddate" => $TodayDate
            );
          
            $result = $this->Categorias_model->Update($EditCategoria);
            if($result){
                $this->session->set_flashdata('message_index', 'Se modifico exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Categorias");
            }else{
                $this->session->set_flashdata('message_edit', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
        }
        $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalCategoria->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalCategoria->UpdatedBy)->Name;
        $Data['title'] = "Editar categoria";
        $Data['Categoria'] = $OriginalCategoria;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Categorias/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function Delete(){
        if(!VerificarPermisos($this->session->UID, "Categorias", "Delete")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post())
        {
            $OriginalCategoria = $this->Categorias_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $DeleteCategoria = array(
                "Clave" => $this->input->post("Clave"),
                "Active" => false,
                "DeletedBy" => $LoggedUserId,
                "DeletedDate" => $TodayDate
            );
          
            $result = $this->Categorias_model->Update($DeleteCategoria);
            if($result){
                $this->session->set_flashdata('message_index', 'Se elimino exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Categorias");
            }else{
                $this->session->set_flashdata('message_details', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
            $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalCategoria->CreatedBy)->Name;
            $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalCategoria->UpdatedBy)->Name;
            $Data['title'] = "Detalles de la categoria";
            $Data['Categoria'] = $OriginalCategoria;
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Categorias/Details', $Data);
            $this->load->view('layouts/footer');   
        }
    }

    function AutocompleteClave(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Categorias_model->SearchByClave($term);
        echo json_encode($result);
    }

    function AutocompleteNombre(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Categorias_model->SearchByNombre($term);
        echo json_encode($result);
    }

    function GetByClave(){
        $ClaveCategoria = strtolower($this->input->get("ClaveCategoria"));
        $result = $this->Categorias_model->GetByClave($ClaveCategoria);
        if($result && !$result->Active)
        {
            $result = null;
        }
        echo json_encode($result);
    }

    function Exportxls()
    {
            //
            // Tomamos los registros de la tabla
            // 
            
            $Registros = $this->Categorias_model->GetAllToExport();

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Categorias");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Clave');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Tipo');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Creado por');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Fecha creacion');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Modificado por');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Fecha modif.');
            
            $this->excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('30');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('20');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Registros as $Item) {

                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->clave, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->nombre, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->tipo, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->CreatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->CreatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->UpdatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item->UpdatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
             
            $filename='CatalogoCategorias.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');

            // $this->session->set_flashdata('message_index', 'Se exportó exitosamente el catalago en el archivo: '.$filename,);
            // $this->session->set_flashdata('class', 'success');
            redirect("Categorias");
    }

}
