<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Articulos extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index()
    {
        if(!VerificarPermisos($this->session->UID, "Articulos", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Page = 1;
        $Clave = "";
        $descrip = "";
        if($this->input->post()){
            $Clave = $this->input->post('Clave');
            $descrip = $this->input->post('descrip');
            $Page = $this->input->post("Page");
        }
        set_value("Clave", "descrip");
        $Pages = $this->Articulos_model->GetPages($Page, $Clave, $descrip);
        if( $Pages <= 1){
            $Page = 1;
        }
        $Articulos = $this->Articulos_model->GetAll($Page, $Clave, $descrip);
        $Data['title'] = "Articulos";
        $Data['Articulos'] = $Articulos;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Articulos/Index', $Data);
        $this->load->view('layouts/footer');
    }

    function Create(){
        if(!VerificarPermisos($this->session->UID, "Articulos", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Categorias = $this->Categorias_model->GetList();
        $Data['title'] = "Crear nuevo articulo";
        $Data['Categorias'] = $Categorias;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Articulos/Create', $Data);
        $this->load->view('layouts/footer');
    }

    function CreatePost(){
        if(!VerificarPermisos($this->session->UID, "Articulos", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Exists = $this->Articulos_model->CheckIfExists($this->input->post("Clave"));
            $Existseq = $this->Articulos_model->CheckIfExistsEq($this->input->post("Claveeq"));
            if($Exists || $Existseq){
                $this->session->set_flashdata('message_create', 'Ya existe una articulo con la misma clave o la misma clave equivalente');
                $this->session->set_flashdata('class', 'danger');
            }else{
                $TodayDate = unix_to_human(time(), TRUE, 'mx');
                $LoggedUserId = $this->session->UID;
                $NewArticulo = array(
                    "Clave" => $this->input->post("Clave"),
                    "Clave_eq" => $this->input->post("Claveeq"),
                    "descrip" => $this->input->post("Nombre"),
                    "marca" => $this->input->post("Marca"),
                    "umed" => $this->input->post("Umed"),
                    "categoria" => $this->input->post("Clavecategoria"),
                    "tipo" => $this->input->post("Tipo"),
                    "Active" => 1,
                    "CreatedBy" => $LoggedUserId,
                    "CreatedDate" => $TodayDate,
                    "UpdatedBy" => $LoggedUserId,
                    "UpdatedDate" => $TodayDate
                );
                $result = $this->Articulos_model->Create($NewArticulo);
                if($result){
                    $this->session->set_flashdata('message_index', 'Se guardo exitosamente el registro');
                    $this->session->set_flashdata('class', 'success');
                    redirect("Articulos");
                }else{
                    $this->session->set_flashdata('message_create', 'Hubo un error al registrar');
                    $this->session->set_flashdata('class', 'danger');
                }
            }
            $Oficinas = $this->Oficinas_model->GetList();
            $Categorias = $this->Categorias_model->GetList();
            $Data['Categorias'] = $Categorias;
            $Data['title'] = "Crear nueva articulo";
            set_value("Clave", "Nombre", "Marca", "Umed", "Clavecategoria", "Tipo");
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Articulos/Create', $Data);
            $this->load->view('layouts/footer');
        }
    }

    function Details($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Articulos", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Articulo = $this->Articulos_model->GetByClave($Id);
        if(!$Articulo){
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }

        $DatosCategoria = $this->Categorias_model->GetByClave($Articulo->categoria);
        $NombreCategoria = $DatosCategoria->nombre;
        $Data["Createdby"] = $this->Users_model->GetByUserName($Articulo->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Articulo->UpdatedBy)->Name;
        $Data['title'] = "Detalles de articulo";
        $Data['Articulo'] = $Articulo;
        $Data['NombreCategoria'] = $NombreCategoria;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Articulos/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Articulos", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Articulo = $this->Articulos_model->GetByClave($Id);

        if(!$Articulo)
        {
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }
        $Categorias = $this->Categorias_model->GetList();
        $Data['Categorias'] = $Categorias;
        $Data["Createdby"] = $this->Users_model->GetByUserName($Articulo->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Articulo->UpdatedBy)->Name;
        $Data['title'] = "Editar articulo";
        $Data['Articulo'] = $Articulo;
        set_value("Clave", "descrip");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Articulos/Edit', $Data);
        $this->load->view('layouts/footer');

    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Articulos", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $OriginalArticulo = $this->Articulos_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $EditArticulo = array(
                "clave" => $this->input->post("Clave"),
                "descrip" => $this->input->post("Nombre"),
                "marca" => $this->input->post("Marca"),
                "umed" => $this->input->post("Umed"),
                "categoria" => $this->input->post("Clavecategoria"),
                "tipo" => $this->input->post("Tipo"),
                "Updatedby" => $LoggedUserId,
                "Updateddate" => $TodayDate
            );
          
            $result = $this->Articulos_model->Update($EditArticulo);
            if($result){
                $this->session->set_flashdata('message_index', 'Se modifico exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Articulos");
            }else{
                $this->session->set_flashdata('message_edit', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
        }
        $Categorias = $this->Categorias_model->GetList();
        $Data['Categorias'] = $Categorias;
        $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalArticulo->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalArticulo->UpdatedBy)->Name;
        $Data['title'] = "Editar articulo";
        $Data['Articulo'] = $OriginalArticulo;
        set_value("Clave", "descrip");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Articulos/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function Delete(){
        if(!VerificarPermisos($this->session->UID, "Articulos", "Delete")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post())
        {
            $OriginalArticulo = $this->Articulos_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $DeleteArticulo = array(
                "Clave" => $this->input->post("Clave"),
                "Active" => false,
                "DeletedBy" => $LoggedUserId,
                "DeletedDate" => $TodayDate
            );
          
            $result = $this->Articulos_model->Update($DeleteArticulo);
            if($result){
                $this->session->set_flashdata('message_index', 'Se elimino exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Articulos");
            }else{
                $this->session->set_flashdata('message_details', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
            $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalArticulo->CreatedBy)->Name;
            $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalArticulo->UpdatedBy)->Name;
            $Data['title'] = "Detalles de la articulo";
            $Data['Articulo'] = $OriginalArticulo;
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Articulos/Details', $Data);
            $this->load->view('layouts/footer');   
        }
    }

    function ImportarArticulos()
    {
        if(!VerificarPermisos($this->session->UID, "Articulos", "ImportarArticulos")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a esta opcion. Contacte al administrador.');
            redirect("");
        }
        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }

        $Data['title'] = "Importar articulos";
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Articulos/Importararticulos', $Data);
        $this->load->view('layouts/footer');
    }

    function ImportarArticulosPost()
    {
        if(!VerificarPermisos($this->session->UID, "Articulos", "ImportarArticulos")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }        

        if($this->input->post())
        {
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;
            $Claveoficina = $this->session->Oficina;

            $this->load->library('Excel');
            $name   = $_FILES['Archivo']['name'];
            $tname  = $_FILES['Archivo']['tmp_name'];
            $obj_excel = PHPExcel_IOFactory::load($tname);       
            $sheetData = $obj_excel->getActiveSheet()->toArray(null,true,true,true);
            $count = 0;
            $errordecat = false;

            foreach ($sheetData as $index => $value) {            
                if($count > 0)
                {
                    $Clave = substr($value["A"],0,16);
                    $Descripcion = $value["B"];
                    $Marca = $value["C"];
                    $Umed = $value["D"];
                    $Categoria = $value["E"];
                    $Clave_eq = $value["F"];

                    //
                    // Tomar el tipo del catalogo de categorias y generar bitacora si hay errores
                    //
                    $Catexist = $this->Categorias_model->CheckIfExists($Categoria);
                    if($Catexist){
                        $Tipoart = $Catexist->tipo;
                    }else{
                        $errordecat = true;
                        $Tipoart = "";
                        //Agregar movimiento de error a la bitacora
                        $Logs = array(
                            "log_ofna" => $Claveoficina,
                            "log_usuario" => $LoggedUserId,
                            "log_fecha" => $TodayDate,
                            "log_evento" => "NO SE PUDO DEFINIR EL TIPO (VARIOS O LLANTAS) DEL ARTICULO ".$Clave.", PORQUE LA CATEGORIA  ".$Categoria." NO ESTA REGISTRADA, DEBERA REGISTRARLA Y EDITAR EL ARTICULO.",
                            "numero" => 0,
                        );
                        $result = $this->Req_logs_model->Create($Logs);

                    }

                    //
                    // Validar si ya existe la clave del articulo
                    // si ya existe se manda un update si no, se manda un create
                    //
                    $Exists = $this->Articulos_model->CheckIfExists($Clave);

                    if(!$Exists){
                        $NuevoArt = array(
                            "clave" => $Clave,
                            "clave_eq" => $Clave_eq,
                            "descrip" => $Descripcion,
                            "marca" => $Marca,
                            "umed" => $Umed,
                            "categoria" => $Categoria,
                            "tipo" => $Tipoart,
                            "Active" => 1,
                            "CreatedBy" => $LoggedUserId,
                            "CreatedDate" => $TodayDate,
                            "UpdatedBy" => $LoggedUserId,
                            "UpdatedDate" => $TodayDate                            
                        );
                        $result = $this->Articulos_model->Create($NuevoArt);
                    }else{
                        $ModifArt = array(
                            "clave" => $Clave,
                            "clave_eq" => $Clave_eq,
                            "descrip" => $Descripcion,
                            "marca" => $Marca,
                            "umed" => $Umed,
                            "categoria" => $Categoria,
                            "tipo" => $Tipoart,
                            "UpdatedBy" => $LoggedUserId,
                            "UpdatedDate" => $TodayDate                            
                        );
                        $result = $this->Articulos_model->Update($ModifArt);
                    }
                }
                $count++;
            }
            $count--;

            if(!$errordecat){
                $this->session->set_flashdata('message_create', 'Se importaron y actualizaron '.$count.' registros.');
                $this->session->set_flashdata('class', 'success');
                redirect("Articulos/ImportarArticulos");
            }else{
                $this->session->set_flashdata('message_create', 'Se importaron los articulos, pero hubo errores en las categorias, revise la bitacora del dia.');
                $this->session->set_flashdata('class', 'danger');
                redirect("Articulos/ImportarArticulos");
            }
        }

        $Data['title'] = "Importar articulos";
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Articulos/Importararticulos', $Data);
        $this->load->view('layouts/footer');

    }

    function AutocompleteClave(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Articulos_model->SearchByClave($term);
        echo json_encode($result);
    }

    function AutocompleteNombre(){
        $term = strtolower($this->input->get("term"));
        $marca = strtolower($this->input->get("marca"));
        $result = $this->Articulos_model->SearchByNombre($term,$marca);
        echo json_encode($result);
    }

    function AutocompleteMarca(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Articulos_model->SearchMarca($term);
        echo json_encode($result);
    }

    function GetByClave(){
        $ClaveArticulo = strtolower($this->input->get("ClaveArticulo"));
        $result = $this->Articulos_model->GetByClave($ClaveArticulo);
        if($result && !$result->Active)
        {
            $result = null;
        }
        echo json_encode($result);
    }

    function GetByClaveEq(){
        $ClaveArticulo = strtolower($this->input->get("ClaveArticulo"));
        $result = $this->Articulos_model->GetByClaveEq($ClaveArticulo);
        if($result && !$result->Active)
        {
            $result = null;
        }
        echo json_encode($result);
    }

    function Exportxls()
    {
            //
            // Tomamos los registros de la tabla
            // 
            
            $Registros = $this->Articulos_model->GetAllToExport();

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Articulos");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Clave');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Clave eq');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Descripcion');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Marca');
            $this->excel->getActiveSheet()->setCellValue('E1', 'U. medida');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Categoria');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Tipo');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Creado por');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Fecha creacion');
            $this->excel->getActiveSheet()->setCellValue('J1', 'Modificado por');
            $this->excel->getActiveSheet()->setCellValue('K1', 'Fecha modif.');
            
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('18');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('18');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('65');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('12');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('14');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('J')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('K')->setWidth('20');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Registros as $Item) {

                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->clave, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->clave_eq, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->descrip, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->marca, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->umed, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->categoria, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item->tipo, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item->CreatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item->CreatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('J'.$row, $Item->UpdatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('K'.$row, $Item->UpdatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
             
            $filename='CatalogoArticulos.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');

            // $this->session->set_flashdata('message_index', 'Se exportó exitosamente el catalago en el archivo: '.$filename,);
            // $this->session->set_flashdata('class', 'success');
            redirect("Articulos");
    }

}
