<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Almacenes extends CI_Controller {

    function __construct(){
        parent::__construct();
        date_default_timezone_set("US/Arizona");

        if(!$this->session->Logged){
            $this->session->set_flashdata('error', 'Autenticarse para entrar al sistema');
            redirect("Users/LogIn");
        }
    }

    function Index()
    {
        if(!VerificarPermisos($this->session->UID, "Almacenes", "Index")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Page = 1;
        $Clave = "";
        $Nombre = "";
        if($this->input->post()){
            $Clave = $this->input->post('Clave');
            $Nombre = $this->input->post('Nombre');
            $Page = $this->input->post("Page");
        }
        set_value("Clave", "Nombre");
        $Pages = $this->Almacenes_model->GetPages($Page, $Clave, $Nombre);
        if( $Pages <= 1){
            $Page = 1;
        }
        $Almacenes = $this->Almacenes_model->GetAll($Page, $Clave, $Nombre);
        $Data['title'] = "Almacenes";
        $Data['Almacenes'] = $Almacenes;
        $Data['Pages'] = $Pages;
        $Data['ActualPage'] = $Page;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Almacenes/Index', $Data);
        $this->load->view('layouts/footer');
    }

    function Create(){
        if(!VerificarPermisos($this->session->UID, "Almacenes", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Oficinas = $this->Oficinas_model->GetList();
        $Data['title'] = "Crear nuevo almacen";
        $Data['Oficinas'] = $Oficinas;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Almacenes/Create', $Data);
        $this->load->view('layouts/footer');
    }

    function CreatePost(){
        if(!VerificarPermisos($this->session->UID, "Almacenes", "Create")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $Exists = $this->Almacenes_model->CheckIfExists($this->input->post("Clave"));
            if($Exists){
                $this->session->set_flashdata('message_create', 'Ya existe una almacen con la misma clave');
                $this->session->set_flashdata('class', 'danger');
            }else{
                $TodayDate = unix_to_human(time(), TRUE, 'mx');
                $LoggedUserId = $this->session->UID;
                $NewAlmacen = array(
                    "Clave" => $this->input->post("Clave"),
                    "Nombre" => $this->input->post("Nombre"),
                    "ofna" => $this->input->post("Claveoficina"),
                    "ofna2" => $this->input->post("Claveoficina2"),
                    "Active" => 1,
                    "CreatedBy" => $LoggedUserId,
                    "CreatedDate" => $TodayDate,
                    "UpdatedBy" => $LoggedUserId,
                    "UpdatedDate" => $TodayDate
                );
                $result = $this->Almacenes_model->Create($NewAlmacen);
                if($result){
                    $this->session->set_flashdata('message_index', 'Se guardo exitosamente el registro');
                    $this->session->set_flashdata('class', 'success');
                    redirect("Almacenes");
                }else{
                    $this->session->set_flashdata('message_create', 'Hubo un error al registrar');
                    $this->session->set_flashdata('class', 'danger');
                }
            }
            $Oficinas = $this->Oficinas_model->GetList();
            $Data['title'] = "Crear nuevo almacen";
            $Data['Oficinas'] = $Oficinas;
            set_value("Clave", "Nombre");
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Almacenes/Create', $Data);
            $this->load->view('layouts/footer');
        }
    }

    function Details($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Almacenes", "Details")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Almacen = $this->Almacenes_model->GetByClave($Id);
        if(!$Almacen){
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }

        $DatosOficina = $this->Oficinas_model->GetByClave($Almacen->ofna);
        $NombreOficina = $DatosOficina->nombre;
        $DatosOficina2 = $this->Oficinas_model->GetByClave($Almacen->ofna2);
        $NombreOficina2 = $DatosOficina2->nombre;
        $Data["Createdby"] = $this->Users_model->GetByUserName($Almacen->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Almacen->UpdatedBy)->Name;
        $Data['title'] = "Detalles de almacen";
        $Data['Almacen'] = $Almacen;
        $Data['NombreOficina'] = $NombreOficina;
        $Data['NombreOficina2'] = $NombreOficina2;
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Almacenes/Details', $Data);
        $this->load->view('layouts/footer');
    }

    function Edit($Id = 0){
        if(!VerificarPermisos($this->session->UID, "Almacenes", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        $Almacen = $this->Almacenes_model->GetByClave($Id);

        if(!$Almacen)
        {
            $Data['heading'] = "Page Not Found";
            $Data['message'] = "The page you requested was not found.";
            $this->load->view('errors/html/error_general', $Data);
            return;
        }
        $Oficinas = $this->Oficinas_model->GetList();
        $Data["Createdby"] = $this->Users_model->GetByUserName($Almacen->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($Almacen->UpdatedBy)->Name;
        $Data['title'] = "Editar almacen";
        $Data['Oficinas'] = $Oficinas;
        $Data['Almacen'] = $Almacen;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Almacenes/Edit', $Data);
        $this->load->view('layouts/footer');

    }

    function EditPost(){
        if(!VerificarPermisos($this->session->UID, "Almacenes", "Edit")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post()){
            $OriginalAlmacen = $this->Almacenes_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $EditAlmacen = array(
                "Clave" => $this->input->post("Clave"),
                "Nombre" => $this->input->post("Nombre"),
                "ofna" => $this->input->post("Claveoficina"),
                "ofna2" => $this->input->post("Claveoficina2"),
                "Updatedby" => $LoggedUserId,
                "Updateddate" => $TodayDate
            );
          
            $result = $this->Almacenes_model->Update($EditAlmacen);
            if($result){
                $this->session->set_flashdata('message_index', 'Se modifico exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Almacenes");
            }else{
                $this->session->set_flashdata('message_edit', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
        }
        $Oficinas = $this->Oficinas_model->GetList();
        $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalAlmacen->CreatedBy)->Name;
        $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalAlmacen->UpdatedBy)->Name;
        $Data['title'] = "Editar almacen";
        $Data['Oficinas'] = $Oficinas;
        $Data['Almacen'] = $OriginalAlmacen;
        set_value("Clave", "Nombre");
        $this->load->view('layouts/_menu', $Data);
        $this->load->view('Almacenes/Edit', $Data);
        $this->load->view('layouts/footer');
    }

    function Delete(){
        if(!VerificarPermisos($this->session->UID, "Almacenes", "Delete")){
            $this->session->set_flashdata('logged-message', 'No tiene permisos para entrar a este catalogo. Contacte al administrador.');
            redirect("");
        }
        if($this->input->post())
        {
            $OriginalAlmacen = $this->Almacenes_model->GetByClave($this->input->post("Clave"));
            $TodayDate = unix_to_human(time(), TRUE, 'mx');
            $LoggedUserId = $this->session->UID;

            $DeleteAlmacen = array(
                "Clave" => $this->input->post("Clave"),
                "Active" => false,
                "DeletedBy" => $LoggedUserId,
                "DeletedDate" => $TodayDate
            );
          
            $result = $this->Almacenes_model->Update($DeleteAlmacen);
            if($result){
                $this->session->set_flashdata('message_index', 'Se elimino exitosamente el registro');
                $this->session->set_flashdata('class', 'success');
                redirect("Almacenes");
            }else{
                $this->session->set_flashdata('message_details', 'Hubo un error al registrar');
                $this->session->set_flashdata('class', 'danger');
            }
            $Data["Createdby"] = $this->Users_model->GetByUserName($OriginalAlmacen->CreatedBy)->Name;
            $Data["Updatedby"] = $this->Users_model->GetByUserName($OriginalAlmacen->UpdatedBy)->Name;
            $Data['title'] = "Detalles de la almacen";
            $Data['Almacen'] = $OriginalAlmacen;
            $this->load->view('layouts/_menu', $Data);
            $this->load->view('Almacenes/Details', $Data);
            $this->load->view('layouts/footer');   
        }
    }

    function AutocompleteClave(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Almacenes_model->SearchByClave($term);
        echo json_encode($result);
    }

    function AutocompleteNombre(){
        $term = strtolower($this->input->get("term"));
        $result = $this->Almacenes_model->SearchByNombre($term);
        echo json_encode($result);
    }

    function GetByClave(){
        $ClaveAlmacen = $this->input->get("ClaveAlmacen");
        $result = $this->Almacenes_model->GetByClave($ClaveAlmacen);
        if($result && !$result->Active)
        {
            $result = null;
        }
        echo json_encode($result);
    }

    function Exportxls()
    {
            //
            // Tomamos los registros de la tabla
            // 
            
            $Registros = $this->Almacenes_model->GetAllToExport();

            // Starting the PHPExcel library
            $this->load->library('Excel');
     
            $this->excel->setActiveSheetIndex(0);
            //name the worksheet
            $this->excel->getActiveSheet()->setTitle("Almacenes");
            //set cell A1 content with some text
            $this->excel->getActiveSheet()->setCellValue('A1', 'Clave');
            $this->excel->getActiveSheet()->setCellValue('B1', 'Nombre');
            $this->excel->getActiveSheet()->setCellValue('C1', 'Proyecto');
            $this->excel->getActiveSheet()->setCellValue('D1', 'Oficina');
            $this->excel->getActiveSheet()->setCellValue('E1', 'Oficina 2');
            $this->excel->getActiveSheet()->setCellValue('F1', 'Creado por');
            $this->excel->getActiveSheet()->setCellValue('G1', 'Fecha creacion');
            $this->excel->getActiveSheet()->setCellValue('H1', 'Modificado por');
            $this->excel->getActiveSheet()->setCellValue('I1', 'Fecha modif.');
            
            $this->excel->getActiveSheet()->getStyle('A1:I1')->getFont()->setSize(12);
            $this->excel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true);

            $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth('50');
            $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth('50');
            $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth('10');
            $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth('10');            
            $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth('20');
            $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth('05');
            $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth('20');
            //
            // Inicamos en el renglon 2 y barremos el arreglo generando cada registro en la tabla de Excel
            //
            $row = 2;
            foreach($Registros as $Item) {

                $this->excel->getActiveSheet()->setCellValueExplicit('A'.$row, $Item->clave, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('B'.$row, $Item->nombre, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('C'.$row, $Item->proyecto, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('D'.$row, $Item->ofna, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('E'.$row, $Item->ofna2, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('F'.$row, $Item->CreatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('G'.$row, $Item->CreatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('H'.$row, $Item->UpdatedBy, PHPExcel_Cell_DataType::TYPE_STRING);
                $this->excel->getActiveSheet()->setCellValueExplicit('I'.$row, $Item->UpdatedDate, PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
             
            $filename='CatalogoAlmacenes.xls'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
                         
            //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
            //if you want to save it as .XLSX Excel 2007 format
            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
            //force user to download the Excel file without writing it to server's HD
            $objWriter->save('php://output');

            // $this->session->set_flashdata('message_index', 'Se exportó exitosamente el catalago en el archivo: '.$filename,);
            // $this->session->set_flashdata('class', 'success');
            redirect("Almacenes");
    }

}
